/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite;

import java.util.concurrent.atomic.AtomicBoolean;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoCamera;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;
import zombie.popman.ObjectPool;

public final class IsoSpriteInstance {
    public static final ObjectPool<IsoSpriteInstance> pool = new ObjectPool<IsoSpriteInstance>(IsoSpriteInstance::new);
    private static final AtomicBoolean lock = new AtomicBoolean(false);
    public IsoSprite parentSprite;
    public float tintb = 1.0f;
    public float tintg = 1.0f;
    public float tintr = 1.0f;
    public float Frame = 0.0f;
    public float alpha = 1.0f;
    public float targetAlpha = 1.0f;
    public boolean bCopyTargetAlpha = true;
    public boolean bMultiplyObjectAlpha = false;
    public boolean Flip;
    public float offZ = 0.0f;
    public float offX = 0.0f;
    public float offY = 0.0f;
    public float AnimFrameIncrease = 1.0f;
    static float multiplier = 1.0f;
    public boolean Looped = true;
    public boolean Finished = false;
    public boolean NextFrame;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;

    public static IsoSpriteInstance get(IsoSprite isoSprite) {
        while (true) {
            if (lock.compareAndSet(false, true)) break;
            Thread.onSpinWait();
        }
        IsoSpriteInstance isoSpriteInstance = pool.alloc();
        lock.set(false);
        isoSpriteInstance.parentSprite = isoSprite;
        isoSpriteInstance.reset();
        return isoSpriteInstance;
    }

    private void reset() {
        this.tintb = 1.0f;
        this.tintg = 1.0f;
        this.tintr = 1.0f;
        this.Frame = 0.0f;
        this.alpha = 1.0f;
        this.targetAlpha = 1.0f;
        this.bCopyTargetAlpha = true;
        this.bMultiplyObjectAlpha = false;
        this.Flip = false;
        this.offZ = 0.0f;
        this.offX = 0.0f;
        this.offY = 0.0f;
        this.AnimFrameIncrease = 1.0f;
        multiplier = 1.0f;
        this.Looped = true;
        this.Finished = false;
        this.NextFrame = false;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
    }

    public IsoSpriteInstance() {
    }

    public void setFrameSpeedPerFrame(float f) {
        this.AnimFrameIncrease = f * multiplier;
    }

    public int getID() {
        return this.parentSprite.ID;
    }

    public String getName() {
        return this.parentSprite.getName();
    }

    public IsoSprite getParentSprite() {
        return this.parentSprite;
    }

    public IsoSpriteInstance(IsoSprite isoSprite) {
        this.parentSprite = isoSprite;
    }

    public float getTintR() {
        return this.tintr;
    }

    public float getTintG() {
        return this.tintg;
    }

    public float getTintB() {
        return this.tintb;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getTargetAlpha() {
        return this.targetAlpha;
    }

    public boolean isCopyTargetAlpha() {
        return this.bCopyTargetAlpha;
    }

    public boolean isMultiplyObjectAlpha() {
        return this.bMultiplyObjectAlpha;
    }

    public void render(IsoObject isoObject, float f, float f2, float f3, IsoDirections isoDirections, float f4, float f5, ColorInfo colorInfo) {
        this.parentSprite.render(this, isoObject, f, f2, f3, isoDirections, f4, f5, colorInfo, true);
    }

    public void SetAlpha(float f) {
        this.alpha = f;
        this.bCopyTargetAlpha = false;
    }

    public void SetTargetAlpha(float f) {
        this.targetAlpha = f;
        this.bCopyTargetAlpha = false;
    }

    public void update() {
    }

    protected void renderprep(IsoObject isoObject) {
        if (isoObject != null && this.bCopyTargetAlpha) {
            this.targetAlpha = isoObject.getTargetAlpha(IsoCamera.frameState.playerIndex);
            this.alpha = isoObject.getAlpha(IsoCamera.frameState.playerIndex);
            return;
        }
        if (this.bMultiplyObjectAlpha) {
            return;
        }
        if (this.alpha < this.targetAlpha) {
            this.alpha += IsoSprite.alphaStep;
            if (this.alpha > this.targetAlpha) {
                this.alpha = this.targetAlpha;
            }
        } else if (this.alpha > this.targetAlpha) {
            this.alpha -= IsoSprite.alphaStep;
            if (this.alpha < this.targetAlpha) {
                this.alpha = this.targetAlpha;
            }
        }
        if (this.alpha < 0.0f) {
            this.alpha = 0.0f;
        }
        if (this.alpha > 1.0f) {
            this.alpha = 1.0f;
        }
    }

    public float getFrame() {
        return this.Frame;
    }

    public boolean isFinished() {
        return this.Finished;
    }

    public void Dispose() {
    }

    public void RenderGhostTileColor(int n, int n2, int n3, float f, float f2, float f3, float f4) {
        if (this.parentSprite == null) {
            return;
        }
        IsoSpriteInstance isoSpriteInstance = IsoSpriteInstance.get(this.parentSprite);
        isoSpriteInstance.Frame = this.Frame;
        isoSpriteInstance.tintr = f;
        isoSpriteInstance.tintg = f2;
        isoSpriteInstance.tintb = f3;
        isoSpriteInstance.alpha = isoSpriteInstance.targetAlpha = f4;
        IsoGridSquare.getDefColorInfo().a = 1.0f;
        IsoGridSquare.getDefColorInfo().b = 1.0f;
        IsoGridSquare.getDefColorInfo().g = 1.0f;
        IsoGridSquare.getDefColorInfo().r = 1.0f;
        this.parentSprite.render(isoSpriteInstance, null, (float)n, (float)n2, n3, IsoDirections.N, 0.0f, -144.0f, IsoGridSquare.getDefColorInfo(), true);
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void scaleAspect(float f, float f2, float f3, float f4) {
        if (f > 0.0f && f2 > 0.0f && f3 > 0.0f && f4 > 0.0f) {
            boolean bl;
            float f5 = f4 * f / f2;
            float f6 = f3 * f2 / f;
            boolean bl2 = bl = f5 <= f3;
            if (bl) {
                f3 = f5;
            } else {
                f4 = f6;
            }
            this.scaleX = f3 / f;
            this.scaleY = f4 / f2;
        }
    }

    public static void add(IsoSpriteInstance isoSpriteInstance) {
        isoSpriteInstance.reset();
        while (true) {
            if (lock.compareAndSet(false, true)) break;
            Thread.onSpinWait();
        }
        pool.release(isoSpriteInstance);
        lock.set(false);
    }
}

