/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite;

import zombie.iso.sprite.IsoSprite;

public final class IsoSpriteGrid {
    private IsoSprite[] sprites;
    private int width;
    private int height;

    public IsoSpriteGrid(int n, int n2) {
        this.sprites = new IsoSprite[n * n2];
        this.width = n;
        this.height = n2;
    }

    public IsoSprite getAnchorSprite() {
        return this.sprites.length > 0 ? this.sprites[0] : null;
    }

    public IsoSprite getSprite(int n, int n2) {
        return this.getSpriteFromIndex(n2 * this.width + n);
    }

    public void setSprite(int n, int n2, IsoSprite isoSprite) {
        this.sprites[n2 * this.width + n] = isoSprite;
    }

    public int getSpriteIndex(IsoSprite isoSprite) {
        for (int i = 0; i < this.sprites.length; ++i) {
            IsoSprite isoSprite2 = this.sprites[i];
            if (isoSprite2 == null || isoSprite2 != isoSprite) continue;
            return i;
        }
        return -1;
    }

    public int getSpriteGridPosX(IsoSprite isoSprite) {
        int n = this.getSpriteIndex(isoSprite);
        if (n >= 0) {
            return n % this.width;
        }
        return -1;
    }

    public int getSpriteGridPosY(IsoSprite isoSprite) {
        int n = this.getSpriteIndex(isoSprite);
        if (n >= 0) {
            return n / this.width;
        }
        return -1;
    }

    public IsoSprite getSpriteFromIndex(int n) {
        if (n >= 0 && n < this.sprites.length) {
            return this.sprites[n];
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean validate() {
        for (int i = 0; i < this.sprites.length; ++i) {
            if (this.sprites[i] != null) continue;
            return false;
        }
        return true;
    }

    public int getSpriteCount() {
        return this.sprites.length;
    }

    public IsoSprite[] getSprites() {
        return this.sprites;
    }
}

