/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.CharacterModelCamera;
import zombie.core.properties.PropertyContainer;
import zombie.core.skinnedmodel.ModelCameraRenderData;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Mask;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.iso.IsoCamera;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWater;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.Vector3;
import zombie.iso.WorldConverter;
import zombie.iso.sprite.IsoAnim;
import zombie.iso.sprite.IsoDirectionFrame;
import zombie.iso.sprite.IsoSpriteGrid;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.util.StringUtils;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleModelCamera;

public final class IsoSprite {
    public static int maxCount = 0;
    public static float alphaStep = 0.05f;
    public static float globalOffsetX = -1.0f;
    public static float globalOffsetY = -1.0f;
    private static final ColorInfo info = new ColorInfo();
    private static final HashMap<String, Object[]> AnimNameSet = new HashMap();
    public int firerequirement;
    public String burntTile;
    public boolean forceAmbient;
    public boolean solidfloor;
    public boolean canBeRemoved;
    public boolean attachedFloor;
    public boolean cutW;
    public boolean cutN;
    public boolean solid;
    public boolean solidTrans;
    public boolean invisible;
    public boolean alwaysDraw;
    public boolean forceRender;
    public boolean moveWithWind = false;
    public boolean isBush = false;
    public static final byte RL_DEFAULT = 0;
    public static final byte RL_FLOOR = 1;
    public byte renderLayer = 0;
    public int windType = 1;
    public boolean Animate = true;
    public IsoAnim CurrentAnim = null;
    public boolean DeleteWhenFinished = false;
    public boolean Loop = true;
    public short soffX = 0;
    public short soffY = 0;
    public final PropertyContainer Properties = new PropertyContainer();
    public final ColorInfo TintMod = new ColorInfo(1.0f, 1.0f, 1.0f, 1.0f);
    public final HashMap<String, IsoAnim> AnimMap = new HashMap(2);
    public final ArrayList<IsoAnim> AnimStack = new ArrayList(1);
    public String name;
    public int tileSheetIndex = 0;
    public int ID = 20000000;
    public IsoSpriteInstance def;
    public ModelManager.ModelSlot modelSlot;
    IsoSpriteManager parentManager;
    private IsoObjectType type = IsoObjectType.MAX;
    private String parentObjectName = null;
    private IsoSpriteGrid spriteGrid;
    public boolean treatAsWallOrder = false;
    private boolean hideForWaterRender = false;

    public void setHideForWaterRender() {
        this.hideForWaterRender = true;
    }

    public IsoSprite() {
        this.parentManager = IsoSpriteManager.instance;
        this.def = IsoSpriteInstance.get(this);
    }

    public IsoSprite(IsoSpriteManager isoSpriteManager) {
        this.parentManager = isoSpriteManager;
        this.def = IsoSpriteInstance.get(this);
    }

    public static IsoSprite CreateSprite(IsoSpriteManager isoSpriteManager) {
        IsoSprite isoSprite = new IsoSprite(isoSpriteManager);
        return isoSprite;
    }

    public static IsoSprite CreateSpriteUsingCache(String string, String string2, int n) {
        IsoSprite isoSprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        return isoSprite.setFromCache(string, string2, n);
    }

    public static IsoSprite getSprite(IsoSpriteManager isoSpriteManager, int n) {
        if (WorldConverter.instance.TilesetConversions != null && !WorldConverter.instance.TilesetConversions.isEmpty() && WorldConverter.instance.TilesetConversions.containsKey(n)) {
            n = WorldConverter.instance.TilesetConversions.get(n);
        }
        if (isoSpriteManager.IntMap.containsKey(n)) {
            return (IsoSprite)isoSpriteManager.IntMap.get(n);
        }
        return null;
    }

    public static void setSpriteID(IsoSpriteManager isoSpriteManager, int n, IsoSprite isoSprite) {
        if (isoSpriteManager.IntMap.containsKey(isoSprite.ID)) {
            isoSpriteManager.IntMap.remove(isoSprite.ID);
            isoSprite.ID = n;
            isoSpriteManager.IntMap.put(n, (Object)isoSprite);
        }
    }

    public static IsoSprite getSprite(IsoSpriteManager isoSpriteManager, IsoSprite isoSprite, int n) {
        if (isoSprite.name.contains("_")) {
            String[] stringArray = isoSprite.name.split("_");
            int n2 = Integer.parseInt(stringArray[stringArray.length - 1].trim());
            return isoSpriteManager.NamedMap.get(isoSprite.name.substring(0, isoSprite.name.lastIndexOf("_")) + "_" + (n2 += n));
        }
        return null;
    }

    public static IsoSprite getSprite(IsoSpriteManager isoSpriteManager, String string, int n) {
        IsoSprite isoSprite = isoSpriteManager.NamedMap.get(string);
        String string2 = isoSprite.name.substring(0, isoSprite.name.lastIndexOf(95));
        String string3 = isoSprite.name.substring(isoSprite.name.lastIndexOf(95) + 1);
        if (isoSprite.name.contains("_")) {
            int n2 = Integer.parseInt(string3.trim());
            return isoSpriteManager.getSprite(string2 + "_" + (n2 += n));
        }
        return null;
    }

    public static void DisposeAll() {
        AnimNameSet.clear();
    }

    public static boolean HasCache(String string) {
        return AnimNameSet.containsKey(string);
    }

    public IsoSpriteInstance newInstance() {
        return IsoSpriteInstance.get(this);
    }

    public PropertyContainer getProperties() {
        return this.Properties;
    }

    public String getParentObjectName() {
        return this.parentObjectName;
    }

    public void setParentObjectName(String string) {
        this.parentObjectName = string;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        GameWindow.WriteString(dataOutputStream, this.name);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.name = GameWindow.ReadString(dataInputStream);
        this.LoadFramesNoDirPageSimple(this.name);
    }

    public void Dispose() {
        for (IsoAnim isoAnim : this.AnimMap.values()) {
            isoAnim.Dispose();
        }
        this.AnimMap.clear();
        this.AnimStack.clear();
        this.CurrentAnim = null;
    }

    public boolean isMaskClicked(IsoDirections isoDirections, int n, int n2) {
        try {
            Texture texture = this.CurrentAnim.Frames.get((int)((int)this.def.Frame)).directions[isoDirections.index()];
            if (texture == null) {
                return false;
            }
            Mask mask = texture.getMask();
            if (mask == null) {
                return false;
            }
            n = (int)((float)n - texture.offsetX);
            n2 = (int)((float)n2 - texture.offsetY);
            return mask.get(n, n2);
        }
        catch (Exception exception) {
            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
            return true;
        }
    }

    public boolean isMaskClicked(IsoDirections isoDirections, int n, int n2, boolean bl) {
        if (this.CurrentAnim == null) {
            return false;
        }
        this.initSpriteInstance();
        try {
            if (this.CurrentAnim == null || this.CurrentAnim.Frames == null || this.def.Frame >= (float)this.CurrentAnim.Frames.size()) {
                return false;
            }
            Texture texture = this.CurrentAnim.Frames.get((int)((int)this.def.Frame)).directions[isoDirections.index()];
            if (texture == null) {
                return false;
            }
            Mask mask = texture.getMask();
            if (mask == null) {
                return false;
            }
            if (bl) {
                n = (int)((float)n - ((float)(texture.getWidthOrig() - texture.getWidth()) - texture.offsetX));
                n2 = (int)((float)n2 - texture.offsetY);
                n = texture.getWidth() - n;
            } else {
                n = (int)((float)n - texture.offsetX);
                n2 = (int)((float)n2 - texture.offsetY);
            }
            if (n < 0 || n2 < 0 || n > texture.getWidth() || n2 > texture.getHeight()) {
                return false;
            }
            return mask.get(n, n2);
        }
        catch (Exception exception) {
            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
            return true;
        }
    }

    public float getMaskClickedY(IsoDirections isoDirections, int n, int n2, boolean bl) {
        try {
            Texture texture = this.CurrentAnim.Frames.get((int)((int)this.def.Frame)).directions[isoDirections.index()];
            if (texture == null) {
                return 10000.0f;
            }
            Mask mask = texture.getMask();
            if (mask == null) {
                return 10000.0f;
            }
            if (bl) {
                n = (int)((float)n - ((float)(texture.getWidthOrig() - texture.getWidth()) - texture.offsetX));
                n2 = (int)((float)n2 - texture.offsetY);
                n = texture.getWidth() - n;
            } else {
                n = (int)((float)n - texture.offsetX);
                n2 = (int)((float)n2 - texture.offsetY);
                n = texture.getWidth() - n;
            }
            return n2;
        }
        catch (Exception exception) {
            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
            return 10000.0f;
        }
    }

    public Texture LoadFrameExplicit(String string) {
        this.CurrentAnim = new IsoAnim();
        this.AnimMap.put("default", this.CurrentAnim);
        this.CurrentAnim.ID = this.AnimStack.size();
        this.AnimStack.add(this.CurrentAnim);
        return this.CurrentAnim.LoadFrameExplicit(string);
    }

    public void LoadFrames(String string, String string2, int n) {
        if (this.AnimMap.containsKey(string2)) {
            return;
        }
        this.CurrentAnim = new IsoAnim();
        this.AnimMap.put(string2, this.CurrentAnim);
        this.CurrentAnim.ID = this.AnimStack.size();
        this.AnimStack.add(this.CurrentAnim);
        this.CurrentAnim.LoadFrames(string, string2, n);
    }

    public void LoadFramesReverseAltName(String string, String string2, String string3, int n) {
        if (this.AnimMap.containsKey(string3)) {
            return;
        }
        this.CurrentAnim = new IsoAnim();
        this.AnimMap.put(string3, this.CurrentAnim);
        this.CurrentAnim.ID = this.AnimStack.size();
        this.AnimStack.add(this.CurrentAnim);
        this.CurrentAnim.LoadFramesReverseAltName(string, string2, string3, n);
    }

    public void LoadFramesNoDirPage(String string, String string2, int n) {
        this.CurrentAnim = new IsoAnim();
        this.AnimMap.put(string2, this.CurrentAnim);
        this.CurrentAnim.ID = this.AnimStack.size();
        this.AnimStack.add(this.CurrentAnim);
        this.CurrentAnim.LoadFramesNoDirPage(string, string2, n);
    }

    public void LoadFramesNoDirPageDirect(String string, String string2, int n) {
        this.CurrentAnim = new IsoAnim();
        this.AnimMap.put(string2, this.CurrentAnim);
        this.CurrentAnim.ID = this.AnimStack.size();
        this.AnimStack.add(this.CurrentAnim);
        this.CurrentAnim.LoadFramesNoDirPageDirect(string, string2, n);
    }

    public void LoadFramesNoDirPageSimple(String string) {
        if (this.AnimMap.containsKey("default")) {
            IsoAnim isoAnim = this.AnimMap.get("default");
            this.AnimStack.remove(isoAnim);
            this.AnimMap.remove("default");
        }
        this.CurrentAnim = new IsoAnim();
        this.AnimMap.put("default", this.CurrentAnim);
        this.CurrentAnim.ID = this.AnimStack.size();
        this.AnimStack.add(this.CurrentAnim);
        this.CurrentAnim.LoadFramesNoDirPage(string);
    }

    public void ReplaceCurrentAnimFrames(String string) {
        if (this.CurrentAnim == null) {
            return;
        }
        this.CurrentAnim.Frames.clear();
        this.CurrentAnim.LoadFramesNoDirPage(string);
    }

    public void LoadFramesPageSimple(String string, String string2, String string3, String string4) {
        this.CurrentAnim = new IsoAnim();
        this.AnimMap.put("default", this.CurrentAnim);
        this.CurrentAnim.ID = this.AnimStack.size();
        this.AnimStack.add(this.CurrentAnim);
        this.CurrentAnim.LoadFramesPageSimple(string, string2, string3, string4);
    }

    public void LoadFramesPcx(String string, String string2, int n) {
        if (this.AnimMap.containsKey(string2)) {
            return;
        }
        this.CurrentAnim = new IsoAnim();
        this.AnimMap.put(string2, this.CurrentAnim);
        this.CurrentAnim.ID = this.AnimStack.size();
        this.AnimStack.add(this.CurrentAnim);
        this.CurrentAnim.LoadFramesPcx(string, string2, n);
    }

    public void PlayAnim(IsoAnim isoAnim) {
        if (this.CurrentAnim == null || this.CurrentAnim != isoAnim) {
            this.CurrentAnim = isoAnim;
        }
    }

    public void PlayAnim(String string) {
        if ((this.CurrentAnim == null || !this.CurrentAnim.name.equals(string)) && this.AnimMap.containsKey(string)) {
            this.CurrentAnim = this.AnimMap.get(string);
        }
    }

    public void PlayAnimUnlooped(String string) {
        if (this.AnimMap.containsKey(string)) {
            if (this.CurrentAnim == null || !this.CurrentAnim.name.equals(string)) {
                this.CurrentAnim = this.AnimMap.get(string);
            }
            this.CurrentAnim.looped = false;
        }
    }

    public void ChangeTintMod(ColorInfo colorInfo) {
        this.TintMod.r = colorInfo.r;
        this.TintMod.g = colorInfo.g;
        this.TintMod.b = colorInfo.b;
        this.TintMod.a = colorInfo.a;
    }

    public void RenderGhostTile(int n, int n2, int n3) {
        IsoSpriteInstance isoSpriteInstance = IsoSpriteInstance.get(this);
        isoSpriteInstance.targetAlpha = 0.6f;
        isoSpriteInstance.alpha = 0.6f;
        this.render(isoSpriteInstance, null, (float)n, (float)n2, n3, IsoDirections.N, (float)(32 * Core.TileScale), 96 * Core.TileScale, IsoGridSquare.getDefColorInfo(), true);
    }

    public void RenderGhostTileRed(int n, int n2, int n3) {
        IsoSpriteInstance isoSpriteInstance = IsoSpriteInstance.get(this);
        isoSpriteInstance.tintr = 0.65f;
        isoSpriteInstance.tintg = 0.2f;
        isoSpriteInstance.tintb = 0.2f;
        isoSpriteInstance.targetAlpha = 0.6f;
        isoSpriteInstance.alpha = 0.6f;
        this.render(isoSpriteInstance, null, (float)n, (float)n2, n3, IsoDirections.N, (float)(32 * Core.TileScale), 96 * Core.TileScale, IsoGridSquare.getDefColorInfo(), true);
    }

    public void RenderGhostTileColor(int n, int n2, int n3, float f, float f2, float f3, float f4) {
        this.RenderGhostTileColor(n, n2, n3, 0.0f, 0.0f, f, f2, f3, f4);
    }

    public void RenderGhostTileColor(int n, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6) {
        IsoSpriteInstance isoSpriteInstance = IsoSpriteInstance.get(this);
        isoSpriteInstance.tintr = f3;
        isoSpriteInstance.tintg = f4;
        isoSpriteInstance.tintb = f5;
        isoSpriteInstance.alpha = isoSpriteInstance.targetAlpha = f6;
        IsoGridSquare.getDefColorInfo().a = 1.0f;
        IsoGridSquare.getDefColorInfo().b = 1.0f;
        IsoGridSquare.getDefColorInfo().g = 1.0f;
        IsoGridSquare.getDefColorInfo().r = 1.0f;
        int n4 = Core.TileScale;
        this.render(isoSpriteInstance, null, (float)n, (float)n2, n3, IsoDirections.N, (float)(32 * n4) + f, (float)(96 * n4) + f2, IsoGridSquare.getDefColorInfo(), true);
    }

    public boolean hasActiveModel() {
        if (!ModelManager.instance.bDebugEnableModels) {
            return false;
        }
        if (!ModelManager.instance.isCreated()) {
            return false;
        }
        return this.modelSlot != null && this.modelSlot.active;
    }

    public void renderVehicle(IsoSpriteInstance isoSpriteInstance, IsoObject isoObject, float f, float f2, float f3, float f4, float f5, ColorInfo colorInfo, boolean bl) {
        if (isoSpriteInstance == null) {
            return;
        }
        if (this.hasActiveModel()) {
            SpriteRenderer.instance.drawGeneric(ModelCameraRenderData.s_pool.alloc().init(VehicleModelCamera.instance, this.modelSlot));
            SpriteRenderer.instance.drawModel(this.modelSlot);
            if (!BaseVehicle.RENDER_TO_TEXTURE) {
                return;
            }
        }
        IsoSprite.info.r = colorInfo.r;
        IsoSprite.info.g = colorInfo.g;
        IsoSprite.info.b = colorInfo.b;
        IsoSprite.info.a = colorInfo.a;
        try {
            if (bl) {
                isoSpriteInstance.renderprep(isoObject);
            }
            float f6 = 0.0f;
            float f7 = 0.0f;
            if (globalOffsetX == -1.0f) {
                globalOffsetX = -IsoCamera.frameState.OffX;
                globalOffsetY = -IsoCamera.frameState.OffY;
            }
            if (isoObject == null || isoObject.sx == 0.0f || isoObject instanceof IsoMovingObject) {
                f6 = IsoUtils.XToScreen(f + isoSpriteInstance.offX, f2 + isoSpriteInstance.offY, f3 + isoSpriteInstance.offZ, 0);
                f7 = IsoUtils.YToScreen(f + isoSpriteInstance.offX, f2 + isoSpriteInstance.offY, f3 + isoSpriteInstance.offZ, 0);
                f6 -= f4;
                f7 -= f5;
                if (isoObject != null) {
                    isoObject.sx = f6;
                    isoObject.sy = f7;
                }
            }
            if (isoObject != null) {
                f6 = isoObject.sx + globalOffsetX;
                f7 = isoObject.sy + globalOffsetY;
                f6 += (float)this.soffX;
                f7 += (float)this.soffY;
            } else {
                f6 += globalOffsetX;
                f7 += globalOffsetY;
                f6 += (float)this.soffX;
                f7 += (float)this.soffY;
            }
            if (bl) {
                if (isoSpriteInstance.tintr != 1.0f || isoSpriteInstance.tintg != 1.0f || isoSpriteInstance.tintb != 1.0f) {
                    IsoSprite.info.r *= isoSpriteInstance.tintr;
                    IsoSprite.info.g *= isoSpriteInstance.tintg;
                    IsoSprite.info.b *= isoSpriteInstance.tintb;
                }
                IsoSprite.info.a = isoSpriteInstance.alpha;
            }
            if (!(this.hasActiveModel() || this.TintMod.r == 1.0f && this.TintMod.g == 1.0f && this.TintMod.b == 1.0f)) {
                IsoSprite.info.r *= this.TintMod.r;
                IsoSprite.info.g *= this.TintMod.g;
                IsoSprite.info.b *= this.TintMod.b;
            }
            if (this.hasActiveModel()) {
                float f8 = isoSpriteInstance.getScaleX() * (float)Core.TileScale;
                float f9 = -isoSpriteInstance.getScaleY() * (float)Core.TileScale;
                float f10 = 0.666f;
                int n = ModelManager.instance.bitmap.getTexture().getWidth();
                int n2 = ModelManager.instance.bitmap.getTexture().getHeight();
                f6 -= (float)n * (f8 /= 4.0f * f10) / 2.0f;
                f7 -= (float)n2 * (f9 /= 4.0f * f10) / 2.0f;
                float f11 = ((BaseVehicle)isoObject).jniTransform.origin.y / 2.46f;
                f7 += 96.0f * f11 / f9 / f10;
                f7 += 27.84f / f9 / f10;
                if (Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null) {
                    SpriteRenderer.instance.render((Texture)ModelManager.instance.bitmap.getTexture(), f6, f7, (float)n * f8, (float)n2 * f9, 1.0f, 1.0f, 1.0f, IsoSprite.info.a, null);
                } else {
                    SpriteRenderer.instance.render((Texture)ModelManager.instance.bitmap.getTexture(), f6, f7, (float)n * f8, (float)n2 * f9, IsoSprite.info.r, IsoSprite.info.g, IsoSprite.info.b, IsoSprite.info.a, null);
                }
                if (Core.bDebug && DebugOptions.instance.ModelRenderBounds.getValue()) {
                    LineDrawer.drawRect(f6, f7, (float)n * f8, (float)n2 * f9, 1.0f, 1.0f, 1.0f, 1.0f, 1);
                }
            }
            IsoSprite.info.r = 1.0f;
            IsoSprite.info.g = 1.0f;
            IsoSprite.info.b = 1.0f;
        }
        catch (Exception exception) {
            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    private IsoSpriteInstance getSpriteInstance() {
        this.initSpriteInstance();
        return this.def;
    }

    private void initSpriteInstance() {
        if (this.def == null) {
            this.def = IsoSpriteInstance.get(this);
        }
    }

    public final void render(IsoObject isoObject, float f, float f2, float f3, IsoDirections isoDirections, float f4, float f5, ColorInfo colorInfo, boolean bl) {
        this.render(isoObject, f, f2, f3, isoDirections, f4, f5, colorInfo, bl, null);
    }

    public final void render(IsoObject isoObject, float f, float f2, float f3, IsoDirections isoDirections, float f4, float f5, ColorInfo colorInfo, boolean bl, Consumer<TextureDraw> consumer) {
        this.render(this.getSpriteInstance(), isoObject, f, f2, f3, isoDirections, f4, f5, colorInfo, bl, consumer);
    }

    public final void render(IsoSpriteInstance isoSpriteInstance, IsoObject isoObject, float f, float f2, float f3, IsoDirections isoDirections, float f4, float f5, ColorInfo colorInfo, boolean bl) {
        this.render(isoSpriteInstance, isoObject, f, f2, f3, isoDirections, f4, f5, colorInfo, bl, null);
    }

    public void render(IsoSpriteInstance isoSpriteInstance, IsoObject isoObject, float f, float f2, float f3, IsoDirections isoDirections, float f4, float f5, ColorInfo colorInfo, boolean bl, Consumer<TextureDraw> consumer) {
        if (this.hasActiveModel()) {
            this.renderActiveModel();
        } else {
            this.renderCurrentAnim(isoSpriteInstance, isoObject, f, f2, f3, isoDirections, f4, f5, colorInfo, bl, consumer);
        }
    }

    public void renderCurrentAnim(IsoSpriteInstance isoSpriteInstance, IsoObject isoObject, float f, float f2, float f3, IsoDirections isoDirections, float f4, float f5, ColorInfo colorInfo, boolean bl, Consumer<TextureDraw> consumer) {
        if (!DebugOptions.instance.IsoSprite.RenderSprites.getValue()) {
            return;
        }
        if (this.CurrentAnim == null || this.CurrentAnim.Frames.isEmpty()) {
            return;
        }
        float f6 = this.getCurrentSpriteFrame(isoSpriteInstance);
        info.set(colorInfo);
        Vector3 vector3 = l_renderCurrentAnim.colorInfoBackup.set(IsoSprite.info.r, IsoSprite.info.g, IsoSprite.info.b);
        Vector2 vector22 = l_renderCurrentAnim.spritePos.set(0.0f, 0.0f);
        this.prepareToRenderSprite(isoSpriteInstance, isoObject, f, f2, f3, isoDirections, f4, f5, bl, (int)f6, vector22);
        this.performRenderFrame(isoSpriteInstance, isoObject, isoDirections, (int)f6, vector22.x, vector22.y, consumer);
        IsoSprite.info.r = vector3.x;
        IsoSprite.info.g = vector3.y;
        IsoSprite.info.b = vector3.z;
    }

    private float getCurrentSpriteFrame(IsoSpriteInstance isoSpriteInstance) {
        float f;
        if (this.CurrentAnim.FramesArray == null) {
            this.CurrentAnim.FramesArray = this.CurrentAnim.Frames.toArray(new IsoDirectionFrame[0]);
        }
        if (this.CurrentAnim.FramesArray.length != this.CurrentAnim.Frames.size()) {
            this.CurrentAnim.FramesArray = this.CurrentAnim.Frames.toArray(this.CurrentAnim.FramesArray);
        }
        if (isoSpriteInstance.Frame >= (float)this.CurrentAnim.Frames.size()) {
            f = this.CurrentAnim.FramesArray.length - 1;
        } else if (isoSpriteInstance.Frame < 0.0f) {
            isoSpriteInstance.Frame = 0.0f;
            f = 0.0f;
        } else {
            f = isoSpriteInstance.Frame;
        }
        return f;
    }

    private void prepareToRenderSprite(IsoSpriteInstance isoSpriteInstance, IsoObject isoObject, float f, float f2, float f3, IsoDirections isoDirections, float f4, float f5, boolean bl, int n, Vector2 vector22) {
        if (bl) {
            isoSpriteInstance.renderprep(isoObject);
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (globalOffsetX == -1.0f) {
            globalOffsetX = -IsoCamera.frameState.OffX;
            globalOffsetY = -IsoCamera.frameState.OffY;
        }
        if (isoObject == null || isoObject.sx == 0.0f || isoObject instanceof IsoMovingObject) {
            f6 = IsoUtils.XToScreen(f + isoSpriteInstance.offX, f2 + isoSpriteInstance.offY, f3 + isoSpriteInstance.offZ, 0);
            f7 = IsoUtils.YToScreen(f + isoSpriteInstance.offX, f2 + isoSpriteInstance.offY, f3 + isoSpriteInstance.offZ, 0);
            f6 -= f4;
            f7 -= f5;
            if (isoObject != null) {
                isoObject.sx = f6;
                isoObject.sy = f7;
            }
            f6 += globalOffsetX;
            f7 += globalOffsetY;
            f6 += (float)this.soffX;
            f7 += (float)this.soffY;
        } else if (isoObject != null) {
            f6 = isoObject.sx + globalOffsetX;
            f7 = isoObject.sy + globalOffsetY;
            f6 += (float)this.soffX;
            f7 += (float)this.soffY;
        } else {
            f6 += globalOffsetX;
            f7 += globalOffsetY;
            f6 += (float)this.soffX;
            f7 += (float)this.soffY;
        }
        if (isoObject instanceof IsoMovingObject && this.CurrentAnim != null && this.CurrentAnim.FramesArray[n].getTexture(isoDirections) != null) {
            f6 -= (float)(this.CurrentAnim.FramesArray[n].getTexture(isoDirections).getWidthOrig() / 2) * isoSpriteInstance.getScaleX();
            f7 -= (float)this.CurrentAnim.FramesArray[n].getTexture(isoDirections).getHeightOrig() * isoSpriteInstance.getScaleY();
        }
        if (bl) {
            if (isoSpriteInstance.tintr != 1.0f || isoSpriteInstance.tintg != 1.0f || isoSpriteInstance.tintb != 1.0f) {
                IsoSprite.info.r *= isoSpriteInstance.tintr;
                IsoSprite.info.g *= isoSpriteInstance.tintg;
                IsoSprite.info.b *= isoSpriteInstance.tintb;
            }
            IsoSprite.info.a = isoSpriteInstance.alpha;
            if (isoSpriteInstance.bMultiplyObjectAlpha && isoObject != null) {
                IsoSprite.info.a *= isoObject.getAlpha(IsoCamera.frameState.playerIndex);
            }
        }
        if (this.TintMod.r != 1.0f || this.TintMod.g != 1.0f || this.TintMod.b != 1.0f) {
            IsoSprite.info.r *= this.TintMod.r;
            IsoSprite.info.g *= this.TintMod.g;
            IsoSprite.info.b *= this.TintMod.b;
        }
        vector22.set(f6, f7);
    }

    private void performRenderFrame(IsoSpriteInstance isoSpriteInstance, IsoObject isoObject, IsoDirections isoDirections, int n, float f, float f2, Consumer<TextureDraw> consumer) {
        if (n >= this.CurrentAnim.FramesArray.length) {
            return;
        }
        IsoDirectionFrame isoDirectionFrame = this.CurrentAnim.FramesArray[n];
        Texture texture = isoDirectionFrame.getTexture(isoDirections);
        if (texture == null) {
            return;
        }
        if (Core.TileScale == 2 && texture.getWidthOrig() == 64 && texture.getHeightOrig() == 128) {
            isoSpriteInstance.setScale(2.0f, 2.0f);
        }
        if (Core.TileScale == 2 && isoSpriteInstance.scaleX == 2.0f && isoSpriteInstance.scaleY == 2.0f && texture.getWidthOrig() == 128 && texture.getHeightOrig() == 256) {
            isoSpriteInstance.setScale(1.0f, 1.0f);
        }
        if (isoSpriteInstance.scaleX <= 0.0f || isoSpriteInstance.scaleY <= 0.0f) {
            return;
        }
        float f3 = texture.getWidth();
        float f4 = texture.getHeight();
        float f5 = isoSpriteInstance.scaleX;
        float f6 = isoSpriteInstance.scaleY;
        if (f5 != 1.0f) {
            f += texture.getOffsetX() * (f5 - 1.0f);
            f3 *= f5;
        }
        if (f6 != 1.0f) {
            f2 += texture.getOffsetY() * (f6 - 1.0f);
            f4 *= f6;
        }
        if (DebugOptions.instance.IsoSprite.MovingObjectEdges.getValue() && isoObject instanceof IsoMovingObject) {
            this.renderSpriteOutline(f, f2, texture, f5, f6);
        }
        if (DebugOptions.instance.IsoSprite.DropShadowEdges.getValue() && StringUtils.equals(texture.getName(), "dropshadow")) {
            this.renderSpriteOutline(f, f2, texture, f5, f6);
        }
        if (!this.hideForWaterRender || !IsoWater.getInstance().getShaderEnable()) {
            if (isoObject != null && isoObject.getObjectRenderEffectsToApply() != null) {
                isoDirectionFrame.render(isoObject.getObjectRenderEffectsToApply(), f, f2, f3, f4, isoDirections, info, isoSpriteInstance.Flip, consumer);
            } else {
                isoDirectionFrame.render(f, f2, f3, f4, isoDirections, info, isoSpriteInstance.Flip, consumer);
            }
        }
        if (n < this.CurrentAnim.FramesArray.length && IsoObjectPicker.Instance.wasDirty && IsoCamera.frameState.playerIndex == 0 && isoObject != null) {
            boolean bl;
            boolean bl2 = bl = isoDirections == IsoDirections.W || isoDirections == IsoDirections.SW || isoDirections == IsoDirections.S;
            if (isoSpriteInstance.Flip) {
                bl = !bl;
            }
            f = isoObject.sx + globalOffsetX;
            f2 = isoObject.sy + globalOffsetY;
            if (isoObject instanceof IsoMovingObject) {
                f -= (float)(texture.getWidthOrig() / 2) * f5;
                f2 -= (float)texture.getHeightOrig() * f6;
            }
            IsoObjectPicker.Instance.Add((int)f, (int)f2, (int)((float)texture.getWidthOrig() * f5), (int)((float)texture.getHeightOrig() * f6), isoObject.square, isoObject, bl, f5, f6);
        }
    }

    private void renderSpriteOutline(float f, float f2, Texture texture, float f3, float f4) {
        LineDrawer.drawRect(f, f2, (float)texture.getWidthOrig() * f3, (float)texture.getHeightOrig() * f4, 1.0f, 1.0f, 1.0f, 1.0f, 1);
        LineDrawer.drawRect(f + texture.getOffsetX() * f3, f2 + texture.getOffsetY() * f4, (float)texture.getWidth() * f3, (float)texture.getHeight() * f4, 1.0f, 1.0f, 1.0f, 1.0f, 1);
    }

    public void renderActiveModel() {
        if (!DebugOptions.instance.IsoSprite.RenderModels.getValue()) {
            return;
        }
        this.modelSlot.model.updateLights();
        SpriteRenderer.instance.drawGeneric(ModelCameraRenderData.s_pool.alloc().init(CharacterModelCamera.instance, this.modelSlot));
        SpriteRenderer.instance.drawModel(this.modelSlot);
    }

    public void renderBloodSplat(float f, float f2, float f3, ColorInfo colorInfo) {
        if (this.CurrentAnim == null || this.CurrentAnim.Frames.isEmpty()) {
            return;
        }
        int n = -8;
        int n2 = -228;
        n = 0;
        n2 = 0;
        try {
            if (globalOffsetX == -1.0f) {
                globalOffsetX = -IsoCamera.frameState.OffX;
                globalOffsetY = -IsoCamera.frameState.OffY;
            }
            float f4 = IsoUtils.XToScreen(f, f2, f3, 0);
            float f5 = IsoUtils.YToScreen(f, f2, f3, 0);
            f4 = (int)f4;
            f5 = (int)f5;
            f4 -= (float)n;
            f5 -= (float)n2;
            f5 += globalOffsetY;
            if ((f4 += globalOffsetX) >= (float)IsoCamera.frameState.OffscreenWidth || f4 + 64.0f <= 0.0f) {
                return;
            }
            if (f5 >= (float)IsoCamera.frameState.OffscreenHeight || f5 + 64.0f <= 0.0f) {
                return;
            }
            IsoSprite.info.r = colorInfo.r;
            IsoSprite.info.g = colorInfo.g;
            IsoSprite.info.b = colorInfo.b;
            IsoSprite.info.a = colorInfo.a;
            this.CurrentAnim.Frames.get(0).render(f4, f5, IsoDirections.N, info, false, null);
        }
        catch (Exception exception) {
            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void renderObjectPicker(IsoSpriteInstance isoSpriteInstance, IsoObject isoObject, IsoDirections isoDirections) {
        if (this.CurrentAnim == null) {
            return;
        }
        if (isoSpriteInstance == null) {
            return;
        }
        if (IsoPlayer.getInstance() != IsoPlayer.players[0]) {
            return;
        }
        if (this.CurrentAnim.Frames.isEmpty()) {
            return;
        }
        if (isoSpriteInstance.Frame >= (float)this.CurrentAnim.Frames.size()) {
            isoSpriteInstance.Frame = 0.0f;
        }
        if (this.CurrentAnim.Frames.get((int)isoSpriteInstance.Frame).getTexture(isoDirections) == null) {
            return;
        }
        float f = isoObject.sx + globalOffsetX;
        float f2 = isoObject.sy + globalOffsetY;
        if (isoObject instanceof IsoMovingObject) {
            f -= (float)(this.CurrentAnim.Frames.get((int)isoSpriteInstance.Frame).getTexture(isoDirections).getWidthOrig() / 2) * isoSpriteInstance.getScaleX();
            f2 -= (float)this.CurrentAnim.Frames.get((int)isoSpriteInstance.Frame).getTexture(isoDirections).getHeightOrig() * isoSpriteInstance.getScaleY();
        }
        if (isoSpriteInstance.Frame < (float)this.CurrentAnim.Frames.size() && IsoObjectPicker.Instance.wasDirty && IsoCamera.frameState.playerIndex == 0) {
            boolean bl;
            Texture texture = this.CurrentAnim.Frames.get((int)isoSpriteInstance.Frame).getTexture(isoDirections);
            boolean bl2 = bl = isoDirections == IsoDirections.W || isoDirections == IsoDirections.SW || isoDirections == IsoDirections.S;
            if (isoSpriteInstance.Flip) {
                bl = !bl;
            }
            IsoObjectPicker.Instance.Add((int)f, (int)f2, (int)((float)texture.getWidthOrig() * isoSpriteInstance.getScaleX()), (int)((float)texture.getHeightOrig() * isoSpriteInstance.getScaleY()), isoObject.square, isoObject, bl, isoSpriteInstance.getScaleX(), isoSpriteInstance.getScaleY());
        }
    }

    public Texture getTextureForFrame(int n, IsoDirections isoDirections) {
        if (this.CurrentAnim == null || this.CurrentAnim.Frames.isEmpty()) {
            return null;
        }
        if (this.CurrentAnim.FramesArray == null) {
            this.CurrentAnim.FramesArray = this.CurrentAnim.Frames.toArray(new IsoDirectionFrame[0]);
        }
        if (this.CurrentAnim.FramesArray.length != this.CurrentAnim.Frames.size()) {
            this.CurrentAnim.FramesArray = this.CurrentAnim.Frames.toArray(this.CurrentAnim.FramesArray);
        }
        if (n >= this.CurrentAnim.FramesArray.length) {
            n = this.CurrentAnim.FramesArray.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        return this.CurrentAnim.FramesArray[n].getTexture(isoDirections);
    }

    public Texture getTextureForCurrentFrame(IsoDirections isoDirections) {
        this.initSpriteInstance();
        return this.getTextureForFrame((int)this.def.Frame, isoDirections);
    }

    public void update() {
        this.update(this.def);
    }

    public void update(IsoSpriteInstance isoSpriteInstance) {
        if (isoSpriteInstance == null) {
            isoSpriteInstance = IsoSpriteInstance.get(this);
        }
        if (this.CurrentAnim == null) {
            return;
        }
        if (this.Animate && !isoSpriteInstance.Finished) {
            float f = isoSpriteInstance.Frame;
            if (!GameTime.isGamePaused()) {
                isoSpriteInstance.Frame += isoSpriteInstance.AnimFrameIncrease * (GameTime.instance.getMultipliedSecondsSinceLastUpdate() * 60.0f);
            }
            if ((int)isoSpriteInstance.Frame >= this.CurrentAnim.Frames.size() && this.Loop && isoSpriteInstance.Looped) {
                isoSpriteInstance.Frame = 0.0f;
            }
            if ((int)f != (int)isoSpriteInstance.Frame) {
                isoSpriteInstance.NextFrame = true;
            }
            if (!((int)isoSpriteInstance.Frame < this.CurrentAnim.Frames.size() || this.Loop && isoSpriteInstance.Looped)) {
                isoSpriteInstance.Finished = true;
                isoSpriteInstance.Frame = this.CurrentAnim.FinishUnloopedOnFrame;
                if (this.DeleteWhenFinished) {
                    this.Dispose();
                    this.Animate = false;
                }
            }
        }
    }

    public void CacheAnims(String string) {
        this.name = string;
        Stack<CallSite> stack = new Stack<CallSite>();
        for (int i = 0; i < this.AnimStack.size(); ++i) {
            IsoAnim isoAnim = this.AnimStack.get(i);
            String string2 = string + isoAnim.name;
            stack.add((CallSite)((Object)string2));
            if (IsoAnim.GlobalAnimMap.containsKey(string2)) continue;
            IsoAnim.GlobalAnimMap.put(string2, isoAnim);
        }
        AnimNameSet.put(string, stack.toArray());
    }

    public void LoadCache(String string) {
        Object[] objectArray = AnimNameSet.get(string);
        this.name = string;
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            IsoAnim isoAnim = IsoAnim.GlobalAnimMap.get(string2);
            this.AnimMap.put(isoAnim.name, isoAnim);
            this.AnimStack.add(isoAnim);
            this.CurrentAnim = isoAnim;
        }
    }

    public IsoSprite setFromCache(String string, String string2, int n) {
        String string3 = string + string2;
        if (IsoSprite.HasCache(string3)) {
            this.LoadCache(string3);
        } else {
            this.LoadFramesNoDirPage(string, string2, n);
            this.CacheAnims(string3);
        }
        return this;
    }

    public IsoObjectType getType() {
        return this.type;
    }

    public void setType(IsoObjectType isoObjectType) {
        this.type = isoObjectType;
    }

    public void AddProperties(IsoSprite isoSprite) {
        this.getProperties().AddProperties(isoSprite.getProperties());
    }

    public int getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ColorInfo getTintMod() {
        return this.TintMod;
    }

    public void setTintMod(ColorInfo colorInfo) {
        this.TintMod.set(colorInfo);
    }

    public void setAnimate(boolean bl) {
        this.Animate = bl;
    }

    public IsoSpriteGrid getSpriteGrid() {
        return this.spriteGrid;
    }

    public void setSpriteGrid(IsoSpriteGrid isoSpriteGrid) {
        this.spriteGrid = isoSpriteGrid;
    }

    public boolean isMoveWithWind() {
        return this.moveWithWind;
    }

    public int getSheetGridIdFromName() {
        if (this.name != null) {
            return IsoSprite.getSheetGridIdFromName(this.name);
        }
        return -1;
    }

    public static int getSheetGridIdFromName(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(95)) > 0 && n + 1 < string.length()) {
            return Integer.parseInt(string.substring(n + 1));
        }
        return -1;
    }

    private static class l_renderCurrentAnim {
        static final Vector3 colorInfoBackup = new Vector3();
        static final Vector2 spritePos = new Vector2();

        private l_renderCurrentAnim() {
        }
    }
}

