/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite;

import java.util.function.Consumer;
import org.lwjgl.opengl.GL11;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.input.Mouse;
import zombie.iso.IsoCamera;

public final class IsoCursor {
    private static IsoCursor instance = null;
    IsoCursorShader m_shader = null;

    public static IsoCursor getInstance() {
        if (instance == null) {
            instance = new IsoCursor();
        }
        return instance;
    }

    private IsoCursor() {
        RenderThread.invokeOnRenderContext(this::createShader);
        if (this.m_shader != null) {
            this.m_shader.m_textureCursor = Texture.getSharedTexture("media/ui/isocursor.png");
        }
    }

    private void createShader() {
        this.m_shader = new IsoCursorShader();
    }

    public void render(int n) {
        if (Core.getInstance().getOffscreenBuffer() == null) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer == null || isoPlayer.isDead() || !isoPlayer.isAiming() || isoPlayer.PlayerIndex != 0 || isoPlayer.JoypadBind != -1) {
            return;
        }
        if (GameTime.isGamePaused()) {
            return;
        }
        if (this.m_shader == null || !this.m_shader.isCompiled()) {
            return;
        }
        float f = 1.0f / Core.getInstance().getZoom(n);
        int n2 = (int)((float)(this.m_shader.m_textureCursor.getWidth() * Core.TileScale) / 2.0f * f);
        int n3 = (int)((float)(this.m_shader.m_textureCursor.getHeight() * Core.TileScale) / 2.0f * f);
        this.m_shader.m_screenX = Mouse.getXA() - n2 / 2;
        this.m_shader.m_screenY = Mouse.getYA() - n3 / 2;
        this.m_shader.width = n2;
        this.m_shader.height = n3;
        int n4 = IsoCamera.getScreenLeft(n);
        int n5 = IsoCamera.getScreenTop(n);
        int n6 = IsoCamera.getScreenWidth(n);
        int n7 = IsoCamera.getScreenHeight(n);
        SpriteRenderer.instance.StartShader(this.m_shader.getID(), n);
        SpriteRenderer.instance.renderClamped(this.m_shader.m_textureCursor, this.m_shader.m_screenX, this.m_shader.m_screenY, n2, n3, n4, n5, n6, n7, 1.0f, 1.0f, 1.0f, 1.0f, this.m_shader);
        SpriteRenderer.instance.EndShader();
    }

    private static class IsoCursorShader
    extends Shader
    implements Consumer<TextureDraw> {
        private float m_alpha = 1.0f;
        private Texture m_textureCursor;
        private Texture m_textureWorld;
        private int m_screenX;
        private int m_screenY;

        IsoCursorShader() {
            super("isocursor");
        }

        @Override
        public void startMainThread(TextureDraw textureDraw, int n) {
            this.m_alpha = this.calculateAlpha();
            this.m_textureWorld = Core.getInstance().OffscreenBuffer.getTexture(n);
        }

        @Override
        public void startRenderThread(TextureDraw textureDraw) {
            this.getProgram().setValue("u_alpha", this.m_alpha);
            this.getProgram().setValue("TextureCursor", this.m_textureCursor, 0);
            this.getProgram().setValue("TextureBackground", this.m_textureWorld, 1);
            SpriteRenderer.ringBuffer.shaderChangedTexture1();
            GL11.glEnable((int)3042);
        }

        @Override
        public void accept(TextureDraw textureDraw) {
            int n = 0;
            int n2 = (int)textureDraw.x0 - this.m_screenX;
            int n3 = (int)textureDraw.y0 - this.m_screenY;
            int n4 = this.m_screenX + this.width - (int)textureDraw.x2;
            int n5 = this.m_screenY + this.height - (int)textureDraw.y2;
            this.m_screenX += n2;
            this.m_screenY += n3;
            this.width -= n2 + n4;
            this.height -= n3 + n5;
            float f = this.m_textureWorld.getWidthHW();
            float f2 = this.m_textureWorld.getHeightHW();
            float f3 = IsoCamera.getScreenTop(n) + IsoCamera.getScreenHeight(n) - (this.m_screenY + this.height);
            textureDraw.tex1 = this.m_textureWorld;
            textureDraw.tex1_u0 = (float)this.m_screenX / f;
            textureDraw.tex1_v3 = f3 / f2;
            textureDraw.tex1_u1 = (float)(this.m_screenX + this.width) / f;
            textureDraw.tex1_v2 = f3 / f2;
            textureDraw.tex1_u2 = (float)(this.m_screenX + this.width) / f;
            textureDraw.tex1_v1 = (f3 + (float)this.height) / f2;
            textureDraw.tex1_u3 = (float)this.m_screenX / f;
            textureDraw.tex1_v0 = (f3 + (float)this.height) / f2;
        }

        float calculateAlpha() {
            float f = 0.05f;
            switch (Core.getInstance().getIsoCursorVisibility()) {
                case 0: {
                    f = 0.0f;
                    break;
                }
                case 1: {
                    f = 0.05f;
                    break;
                }
                case 2: {
                    f = 0.1f;
                    break;
                }
                case 3: {
                    f = 0.15f;
                    break;
                }
                case 4: {
                    f = 0.3f;
                    break;
                }
                case 5: {
                    f = 0.5f;
                    break;
                }
                case 6: {
                    f = 0.75f;
                }
            }
            return f;
        }
    }
}

