/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import fmod.fmod.Audio;
import java.util.ArrayList;
import java.util.Stack;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.characters.IsoPlayer;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.IsoRainSplash;
import zombie.iso.objects.IsoRaindrop;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameServer;

public class RainManager {
    public static boolean IsRaining = false;
    public static int NumActiveRainSplashes = 0;
    public static int NumActiveRaindrops = 0;
    public static int MaxRainSplashObjects = 500;
    public static int MaxRaindropObjects = 500;
    public static float RainSplashAnimDelay = 0.2f;
    public static int AddNewSplashesDelay;
    public static int AddNewSplashesTimer;
    public static float RaindropGravity;
    public static float GravModMin;
    public static float GravModMax;
    public static float RaindropStartDistance;
    public static IsoGridSquare[] PlayerLocation;
    public static IsoGridSquare[] PlayerOldLocation;
    public static boolean PlayerMoved;
    public static int RainRadius;
    public static Audio RainAmbient;
    public static Audio ThunderAmbient;
    public static ColorInfo RainSplashTintMod;
    public static ColorInfo RaindropTintMod;
    public static ColorInfo DarkRaindropTintMod;
    public static ArrayList<IsoRainSplash> RainSplashStack;
    public static ArrayList<IsoRaindrop> RaindropStack;
    public static Stack<IsoRainSplash> RainSplashReuseStack;
    public static Stack<IsoRaindrop> RaindropReuseStack;
    private static float RainChangeTimer;
    private static float RainChangeRate;
    private static float RainChangeRateMin;
    private static float RainChangeRateMax;
    public static float RainIntensity;
    public static float RainDesiredIntensity;
    private static int randRain;
    public static int randRainMin;
    public static int randRainMax;
    private static boolean stopRain;
    static Audio OutsideAmbient;
    static Audio OutsideNightAmbient;
    static ColorInfo AdjustedRainSplashTintMod;

    public static void reset() {
        RainSplashStack.clear();
        RaindropStack.clear();
        RaindropReuseStack.clear();
        RainSplashReuseStack.clear();
        NumActiveRainSplashes = 0;
        NumActiveRaindrops = 0;
        for (int i = 0; i < 4; ++i) {
            RainManager.PlayerLocation[i] = null;
            RainManager.PlayerOldLocation[i] = null;
        }
        RainAmbient = null;
        ThunderAmbient = null;
        IsRaining = false;
        stopRain = false;
    }

    public static void AddRaindrop(IsoRaindrop isoRaindrop) {
        if (NumActiveRaindrops < MaxRaindropObjects) {
            RaindropStack.add(isoRaindrop);
            ++NumActiveRaindrops;
        } else {
            IsoRaindrop isoRaindrop2 = null;
            int n = -1;
            for (int i = 0; i < RaindropStack.size(); ++i) {
                if (RainManager.RaindropStack.get((int)i).Life <= n) continue;
                n = RainManager.RaindropStack.get((int)i).Life;
                isoRaindrop2 = RaindropStack.get(i);
            }
            if (isoRaindrop2 != null) {
                RainManager.RemoveRaindrop(isoRaindrop2);
                RaindropStack.add(isoRaindrop);
                ++NumActiveRaindrops;
            }
        }
    }

    public static void AddRainSplash(IsoRainSplash isoRainSplash) {
        if (NumActiveRainSplashes < MaxRainSplashObjects) {
            RainSplashStack.add(isoRainSplash);
            ++NumActiveRainSplashes;
        } else {
            IsoRainSplash isoRainSplash2 = null;
            int n = -1;
            for (int i = 0; i < RainSplashStack.size(); ++i) {
                if (RainManager.RainSplashStack.get((int)i).Age <= n) continue;
                n = RainManager.RainSplashStack.get((int)i).Age;
                isoRainSplash2 = RainSplashStack.get(i);
            }
            RainManager.RemoveRainSplash(isoRainSplash2);
            RainSplashStack.add(isoRainSplash);
            ++NumActiveRainSplashes;
        }
    }

    public static void AddSplashes() {
        if (AddNewSplashesTimer > 0) {
            --AddNewSplashesTimer;
        } else {
            int n;
            AddNewSplashesTimer = (int)((float)AddNewSplashesDelay * ((float)PerformanceSettings.getLockFPS() / 30.0f));
            IsoGridSquare isoGridSquare = null;
            if (!stopRain) {
                int n2;
                if (PlayerMoved) {
                    IsoObject isoObject;
                    for (n = RainSplashStack.size() - 1; n >= 0; --n) {
                        isoObject = RainSplashStack.get(n);
                        if (RainManager.inBounds(isoObject.square)) continue;
                        RainManager.RemoveRainSplash(isoObject);
                    }
                    for (n = RaindropStack.size() - 1; n >= 0; --n) {
                        isoObject = RaindropStack.get(n);
                        if (RainManager.inBounds(((IsoRaindrop)isoObject).square)) continue;
                        RainManager.RemoveRaindrop((IsoRaindrop)isoObject);
                    }
                }
                n = 0;
                for (n2 = 0; n2 < IsoPlayer.numPlayers; ++n2) {
                    if (IsoPlayer.players[n2] == null) continue;
                    ++n;
                }
                n2 = RainRadius * 2 * RainRadius * 2;
                int n3 = n2 / (randRain + 1);
                n3 = Math.min(MaxRainSplashObjects, n3);
                while (NumActiveRainSplashes > n3 * n) {
                    RainManager.RemoveRainSplash(RainSplashStack.get(0));
                }
                while (NumActiveRaindrops > n3 * n) {
                    RainManager.RemoveRaindrop(RaindropStack.get(0));
                }
                IsoCell isoCell = IsoWorld.instance.CurrentCell;
                for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                    if (IsoPlayer.players[i] == null || PlayerLocation[i] == null) continue;
                    for (int j = 0; j < n3; ++j) {
                        int n4 = Rand.Next(-RainRadius, RainRadius);
                        int n5 = Rand.Next(-RainRadius, RainRadius);
                        isoGridSquare = isoCell.getGridSquare(PlayerLocation[i].getX() + n4, PlayerLocation[i].getY() + n5, 0);
                        if (isoGridSquare == null || !isoGridSquare.isSeen(i) || isoGridSquare.getProperties().Is(IsoFlagType.vegitation) || !isoGridSquare.getProperties().Is(IsoFlagType.exterior)) continue;
                        RainManager.StartRainSplash(isoCell, isoGridSquare, true);
                    }
                }
            }
            PlayerMoved = false;
            if (!stopRain) {
                if (--randRain < randRainMin) {
                    randRain = randRainMin;
                }
            } else if ((randRain = (int)((float)randRain - 1.0f * GameTime.instance.getMultiplier())) < randRainMin) {
                RainManager.removeAll();
                randRain = randRainMin;
            } else {
                for (n = RainSplashStack.size() - 1; n >= 0; --n) {
                    if (Rand.Next(randRain) != 0) continue;
                    IsoRainSplash isoRainSplash = RainSplashStack.get(n);
                    RainManager.RemoveRainSplash(isoRainSplash);
                }
                for (n = RaindropStack.size() - 1; n >= 0; --n) {
                    if (Rand.Next(randRain) != 0) continue;
                    IsoRaindrop isoRaindrop = RaindropStack.get(n);
                    RainManager.RemoveRaindrop(isoRaindrop);
                }
            }
        }
    }

    public static void RemoveRaindrop(IsoRaindrop isoRaindrop) {
        if (isoRaindrop.square != null) {
            isoRaindrop.square.getProperties().UnSet(IsoFlagType.HasRaindrop);
            isoRaindrop.square.setRainDrop(null);
            isoRaindrop.square = null;
        }
        RaindropStack.remove(isoRaindrop);
        --NumActiveRaindrops;
        RaindropReuseStack.push(isoRaindrop);
    }

    public static void RemoveRainSplash(IsoRainSplash isoRainSplash) {
        if (isoRainSplash.square != null) {
            isoRainSplash.square.getProperties().UnSet(IsoFlagType.HasRainSplashes);
            isoRainSplash.square.setRainSplash(null);
            isoRainSplash.square = null;
        }
        RainSplashStack.remove(isoRainSplash);
        --NumActiveRainSplashes;
        RainSplashReuseStack.push(isoRainSplash);
    }

    public static void SetPlayerLocation(int n, IsoGridSquare isoGridSquare) {
        RainManager.PlayerOldLocation[n] = PlayerLocation[n];
        RainManager.PlayerLocation[n] = isoGridSquare;
        if (PlayerOldLocation[n] != PlayerLocation[n]) {
            PlayerMoved = true;
        }
    }

    public static Boolean isRaining() {
        return ClimateManager.getInstance().isRaining();
    }

    public static void stopRaining() {
        stopRain = true;
        randRain = randRainMax;
        RainDesiredIntensity = 0.0f;
        if (GameServer.bServer) {
            GameServer.stopRain();
        }
        LuaEventManager.triggerEvent("OnRainStop");
    }

    public static void startRaining() {
    }

    public static void StartRaindrop(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl) {
        if (!isoGridSquare.getProperties().Is(IsoFlagType.HasRaindrop)) {
            IsoRaindrop isoRaindrop = null;
            if (!RaindropReuseStack.isEmpty()) {
                if (bl) {
                    if (isoGridSquare.getRainDrop() != null) {
                        return;
                    }
                    isoRaindrop = RaindropReuseStack.pop();
                    isoRaindrop.Reset(isoGridSquare, bl);
                    isoGridSquare.setRainDrop(isoRaindrop);
                }
            } else if (bl) {
                if (isoGridSquare.getRainDrop() != null) {
                    return;
                }
                isoRaindrop = new IsoRaindrop(isoCell, isoGridSquare, bl);
                isoGridSquare.setRainDrop(isoRaindrop);
            }
        }
    }

    public static void StartRainSplash(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl) {
    }

    public static void Update() {
        IsRaining = ClimateManager.getInstance().isRaining();
        float f = RainIntensity = IsRaining ? ClimateManager.getInstance().getPrecipitationIntensity() : 0.0f;
        if (IsoPlayer.getInstance() == null) {
            return;
        }
        if (IsoPlayer.getInstance().getCurrentSquare() == null) {
            return;
        }
        if (!GameServer.bServer) {
            RainManager.AddSplashes();
        }
    }

    public static void UpdateServer() {
    }

    public static void setRandRainMax(int n) {
        randRain = randRainMax = n;
    }

    public static void setRandRainMin(int n) {
        randRainMin = n;
    }

    public static boolean inBounds(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || PlayerLocation[i] == null) continue;
            if (isoGridSquare.getX() < PlayerLocation[i].getX() - RainRadius || isoGridSquare.getX() >= PlayerLocation[i].getX() + RainRadius) {
                return true;
            }
            if (isoGridSquare.getY() >= PlayerLocation[i].getY() - RainRadius && isoGridSquare.getY() < PlayerLocation[i].getY() + RainRadius) continue;
            return true;
        }
        return false;
    }

    public static void RemoveAllOn(IsoGridSquare isoGridSquare) {
        if (isoGridSquare.getRainDrop() != null) {
            RainManager.RemoveRaindrop(isoGridSquare.getRainDrop());
        }
        if (isoGridSquare.getRainSplash() != null) {
            RainManager.RemoveRainSplash(isoGridSquare.getRainSplash());
        }
    }

    public static float getRainIntensity() {
        return ClimateManager.getInstance().getPrecipitationIntensity();
    }

    private static void removeAll() {
        IsoObject isoObject;
        int n;
        for (n = RainSplashStack.size() - 1; n >= 0; --n) {
            isoObject = RainSplashStack.get(n);
            RainManager.RemoveRainSplash(isoObject);
        }
        for (n = RaindropStack.size() - 1; n >= 0; --n) {
            isoObject = RaindropStack.get(n);
            RainManager.RemoveRaindrop((IsoRaindrop)isoObject);
        }
        RaindropStack.clear();
        RainSplashStack.clear();
        NumActiveRainSplashes = 0;
        NumActiveRaindrops = 0;
    }

    private static boolean interruptSleep(IsoPlayer isoPlayer) {
        IsoObject isoObject;
        return isoPlayer.isAsleep() && isoPlayer.isOutside() && isoPlayer.getBed() != null && !isoPlayer.getBed().getName().equals("Tent") && ((isoObject = isoPlayer.getBed()).getCell().getGridSquare(isoObject.getX(), isoObject.getY(), isoObject.getZ() + 1.0f) == null || isoObject.getCell().getGridSquare(isoObject.getX(), isoObject.getY(), isoObject.getZ() + 1.0f).getFloor() == null);
    }

    static {
        AddNewSplashesTimer = AddNewSplashesDelay = 30;
        RaindropGravity = 0.065f;
        GravModMin = 0.28f;
        GravModMax = 0.5f;
        RaindropStartDistance = 850.0f;
        PlayerLocation = new IsoGridSquare[4];
        PlayerOldLocation = new IsoGridSquare[4];
        PlayerMoved = true;
        RainRadius = 18;
        ThunderAmbient = null;
        RainSplashTintMod = new ColorInfo(0.8f, 0.9f, 1.0f, 0.3f);
        RaindropTintMod = new ColorInfo(0.8f, 0.9f, 1.0f, 0.3f);
        DarkRaindropTintMod = new ColorInfo(0.8f, 0.9f, 1.0f, 0.3f);
        RainSplashStack = new ArrayList(1600);
        RaindropStack = new ArrayList(1600);
        RainSplashReuseStack = new Stack();
        RaindropReuseStack = new Stack();
        RainChangeTimer = 1.0f;
        RainChangeRate = 0.01f;
        RainChangeRateMin = 0.006f;
        RainChangeRateMax = 0.01f;
        RainIntensity = 1.0f;
        RainDesiredIntensity = 1.0f;
        randRain = 0;
        randRainMin = 0;
        randRainMax = 0;
        stopRain = false;
        OutsideAmbient = null;
        OutsideNightAmbient = null;
        AdjustedRainSplashTintMod = new ColorInfo();
    }
}

