/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.GameTime;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoCell;
import zombie.iso.IsoPhysicsObject;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSpriteInstance;

public class IsoZombieGiblets
extends IsoPhysicsObject {
    public float tintb = 1.0f;
    public float tintg = 1.0f;
    public float tintr = 1.0f;
    public float time = 0.0f;
    boolean invis = false;

    public IsoZombieGiblets(IsoCell isoCell) {
        super(isoCell);
    }

    @Override
    public boolean Serialize() {
        return false;
    }

    @Override
    public String getObjectName() {
        return "ZombieGiblets";
    }

    @Override
    public void update() {
        if (Rand.Next(Rand.AdjustForFramerate(12)) == 0 && this.getZ() > (float)((int)this.getZ()) && this.getCurrentSquare() != null && this.getCurrentSquare().getChunk() != null) {
            this.getCurrentSquare().getChunk().addBloodSplat(this.x, this.y, (int)this.z, Rand.Next(8));
        }
        if (Core.bLastStand && Rand.Next(Rand.AdjustForFramerate(15)) == 0 && this.getZ() > (float)((int)this.getZ()) && this.getCurrentSquare() != null && this.getCurrentSquare().getChunk() != null) {
            this.getCurrentSquare().getChunk().addBloodSplat(this.x, this.y, (int)this.z, Rand.Next(8));
        }
        super.update();
        this.time += GameTime.instance.getMultipliedSecondsSinceLastUpdate();
        if (this.velX == 0.0f && this.velY == 0.0f && this.getZ() == (float)((int)this.getZ())) {
            this.setCollidable(false);
            IsoWorld.instance.CurrentCell.getRemoveList().add(this);
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.invis) {
            return;
        }
        float f4 = colorInfo.r;
        float f5 = colorInfo.g;
        float f6 = colorInfo.b;
        colorInfo.r = 0.5f;
        colorInfo.g = 0.5f;
        colorInfo.b = 0.5f;
        this.sprite.def.targetAlpha = this.def.targetAlpha = 1.0f - this.time / 1.0f;
        this.setTargetAlpha(this.def.targetAlpha);
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
        if (Core.bDebug) {
            // empty if block
        }
        colorInfo.r = f4;
        colorInfo.g = f5;
        colorInfo.b = f6;
    }

    public IsoZombieGiblets(GibletType gibletType, IsoCell isoCell, float f, float f2, float f3, float f4, float f5) {
        super(isoCell);
        this.velX = f4;
        this.velY = f5;
        float f6 = (float)Rand.Next(4000) / 10000.0f;
        float f7 = (float)Rand.Next(4000) / 10000.0f;
        this.velX += (f6 -= 0.2f);
        this.velY += (f7 -= 0.2f);
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.nx = f;
        this.ny = f2;
        this.setAlpha(0.2f);
        this.def = IsoSpriteInstance.get(this.sprite);
        this.def.alpha = 0.2f;
        this.sprite.def.alpha = 0.4f;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        if (Rand.Next(3) != 0) {
            this.def.alpha = 0.0f;
            this.sprite.def.alpha = 0.0f;
            this.invis = true;
        }
        switch (gibletType) {
            case A: {
                this.sprite.setFromCache("Giblet", "00", 3);
                break;
            }
            case B: {
                this.sprite.setFromCache("Giblet", "01", 3);
                break;
            }
            case Eye: {
                this.sprite.setFromCache("Eyeball", "00", 1);
            }
        }
    }

    public static enum GibletType {
        A,
        B,
        Eye;

    }
}

