/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.network.GameServer;

public class IsoWindowFrame {
    private static Direction getDirection(IsoObject isoObject) {
        if (isoObject instanceof IsoWindow || isoObject instanceof IsoThumpable) {
            return Direction.INVALID;
        }
        if (isoObject == null || isoObject.getProperties() == null || isoObject.getObjectIndex() == -1) {
            return Direction.INVALID;
        }
        if (isoObject.getProperties().Is(IsoFlagType.WindowN)) {
            return Direction.NORTH;
        }
        if (isoObject.getProperties().Is(IsoFlagType.WindowW)) {
            return Direction.WEST;
        }
        return Direction.INVALID;
    }

    public static boolean isWindowFrame(IsoObject isoObject) {
        return IsoWindowFrame.getDirection(isoObject).isValid();
    }

    public static boolean isWindowFrame(IsoObject isoObject, boolean bl) {
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        return bl && direction == Direction.NORTH || !bl && direction == Direction.WEST;
    }

    public static int countAddSheetRope(IsoObject isoObject) {
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        return direction.isValid() ? IsoWindow.countAddSheetRope(isoObject.getSquare(), direction == Direction.NORTH) : 0;
    }

    public static boolean canAddSheetRope(IsoObject isoObject) {
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        return direction.isValid() && IsoWindow.canAddSheetRope(isoObject.getSquare(), direction == Direction.NORTH);
    }

    public static boolean haveSheetRope(IsoObject isoObject) {
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        return direction.isValid() && IsoWindow.isTopOfSheetRopeHere(isoObject.getSquare(), direction == Direction.NORTH);
    }

    public static boolean addSheetRope(IsoObject isoObject, IsoPlayer isoPlayer, String string) {
        if (!IsoWindowFrame.canAddSheetRope(isoObject)) {
            return false;
        }
        return IsoWindow.addSheetRope(isoPlayer, isoObject.getSquare(), IsoWindowFrame.getDirection(isoObject) == Direction.NORTH, string);
    }

    public static boolean removeSheetRope(IsoObject isoObject, IsoPlayer isoPlayer) {
        if (!IsoWindowFrame.haveSheetRope(isoObject)) {
            return false;
        }
        return IsoWindow.removeSheetRope(isoPlayer, isoObject.getSquare(), IsoWindowFrame.getDirection(isoObject) == Direction.NORTH);
    }

    public static IsoGridSquare getOppositeSquare(IsoObject isoObject) {
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        if (!direction.isValid()) {
            return null;
        }
        boolean bl = direction == Direction.NORTH;
        return isoObject.getSquare().getAdjacentSquare(bl ? IsoDirections.N : IsoDirections.W);
    }

    public static IsoGridSquare getIndoorSquare(IsoObject isoObject) {
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        if (!direction.isValid()) {
            return null;
        }
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (isoGridSquare.getRoom() != null) {
            return isoGridSquare;
        }
        IsoGridSquare isoGridSquare2 = IsoWindowFrame.getOppositeSquare(isoObject);
        if (isoGridSquare2 != null && isoGridSquare2.getRoom() != null) {
            return isoGridSquare2;
        }
        return null;
    }

    public static IsoCurtain getCurtain(IsoObject isoObject) {
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        if (!direction.isValid()) {
            return null;
        }
        boolean bl = direction == Direction.NORTH;
        IsoCurtain isoCurtain = isoObject.getSquare().getCurtain(bl ? IsoObjectType.curtainN : IsoObjectType.curtainW);
        if (isoCurtain != null) {
            return isoCurtain;
        }
        IsoGridSquare isoGridSquare = IsoWindowFrame.getOppositeSquare(isoObject);
        return isoGridSquare == null ? null : isoGridSquare.getCurtain(bl ? IsoObjectType.curtainS : IsoObjectType.curtainE);
    }

    public static IsoGridSquare getAddSheetSquare(IsoObject isoObject, IsoGameCharacter isoGameCharacter) {
        boolean bl;
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        if (!direction.isValid()) {
            return null;
        }
        boolean bl2 = bl = direction == Direction.NORTH;
        if (isoGameCharacter == null || isoGameCharacter.getCurrentSquare() == null) {
            return null;
        }
        IsoGridSquare isoGridSquare = isoGameCharacter.getCurrentSquare();
        IsoGridSquare isoGridSquare2 = isoObject.getSquare();
        if (bl) {
            if (isoGridSquare.getY() < isoGridSquare2.getY()) {
                return isoGridSquare2.getAdjacentSquare(IsoDirections.N);
            }
        } else if (isoGridSquare.getX() < isoGridSquare2.getX()) {
            return isoGridSquare2.getAdjacentSquare(IsoDirections.W);
        }
        return isoGridSquare2;
    }

    public static void addSheet(IsoObject isoObject, IsoGameCharacter isoGameCharacter) {
        IsoObjectType isoObjectType;
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        if (!direction.isValid()) {
            return;
        }
        boolean bl = direction == Direction.NORTH;
        IsoGridSquare isoGridSquare = IsoWindowFrame.getIndoorSquare(isoObject);
        if (isoGridSquare == null) {
            isoGridSquare = isoObject.getSquare();
        }
        if (isoGameCharacter != null) {
            isoGridSquare = IsoWindowFrame.getAddSheetSquare(isoObject, isoGameCharacter);
        }
        if (isoGridSquare == null) {
            return;
        }
        if (isoGridSquare == isoObject.getSquare()) {
            isoObjectType = bl ? IsoObjectType.curtainN : IsoObjectType.curtainW;
        } else {
            IsoObjectType isoObjectType2 = isoObjectType = bl ? IsoObjectType.curtainS : IsoObjectType.curtainE;
        }
        if (isoGridSquare.getCurtain(isoObjectType) != null) {
            return;
        }
        int n = 16;
        if (isoObjectType == IsoObjectType.curtainE) {
            ++n;
        }
        if (isoObjectType == IsoObjectType.curtainS) {
            n += 3;
        }
        if (isoObjectType == IsoObjectType.curtainN) {
            n += 2;
        }
        IsoCurtain isoCurtain = new IsoCurtain(isoObject.getCell(), isoGridSquare, "fixtures_windows_curtains_01_" + (n += 4), bl);
        isoGridSquare.AddSpecialTileObject(isoCurtain);
        if (GameServer.bServer) {
            isoCurtain.transmitCompleteItemToClients();
            if (isoGameCharacter != null) {
                isoGameCharacter.sendObjectChange("removeOneOf", "type", "Sheet");
            }
        } else if (isoGameCharacter != null) {
            isoGameCharacter.getInventory().RemoveOneOf("Sheet");
        }
    }

    public static boolean canClimbThrough(IsoObject isoObject, IsoGameCharacter isoGameCharacter) {
        Direction direction = IsoWindowFrame.getDirection(isoObject);
        if (!direction.isValid()) {
            return false;
        }
        if (isoObject.getSquare() == null) {
            return false;
        }
        IsoWindow isoWindow = isoObject.getSquare().getWindow(direction == Direction.NORTH);
        if (isoWindow != null && isoWindow.isBarricaded()) {
            return false;
        }
        if (isoGameCharacter != null) {
            IsoGridSquare isoGridSquare = direction == Direction.NORTH ? isoObject.getSquare().nav[IsoDirections.N.index()] : isoObject.getSquare().nav[IsoDirections.W.index()];
            if (!IsoWindow.canClimbThroughHelper(isoGameCharacter, isoObject.getSquare(), isoGridSquare, direction == Direction.NORTH)) {
                return false;
            }
        }
        return true;
    }

    private static enum Direction {
        INVALID,
        NORTH,
        WEST;


        public boolean isValid() {
            return this != INVALID;
        }
    }
}

