/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.WorldSoundManager;
import zombie.audio.BaseSoundEmitter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.math.PZMath;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameServer;
import zombie.util.StringUtils;

public class IsoTrap
extends IsoObject {
    private int timerBeforeExplosion = 0;
    private int FPS;
    private int sensorRange = 0;
    private int firePower = 0;
    private int fireRange = 0;
    private int explosionPower = 0;
    private int explosionRange = 0;
    private int smokeRange = 0;
    private int noiseRange = 0;
    private int noiseDuration = 0;
    private float noiseStartTime = 0.0f;
    private float lastWorldSoundTime = 0.0f;
    private float extraDamage = 0.0f;
    private int remoteControlID = -1;
    private String countDownSound = null;
    private String explosionSound = null;
    private int lastBeep = 0;
    private HandWeapon weapon;
    private boolean instantExplosion;

    public IsoTrap(IsoCell isoCell) {
        super(isoCell);
        this.FPS = GameServer.bServer ? 10 : PerformanceSettings.getLockFPS();
    }

    public IsoTrap(HandWeapon handWeapon, IsoCell isoCell, IsoGridSquare isoGridSquare) {
        this.square = isoGridSquare;
        this.initSprite(handWeapon);
        this.setSensorRange(handWeapon.getSensorRange());
        this.setFireRange(handWeapon.getFireRange());
        this.setFirePower(handWeapon.getFirePower());
        this.setExplosionPower(handWeapon.getExplosionPower());
        this.setExplosionRange(handWeapon.getExplosionRange());
        this.setSmokeRange(handWeapon.getSmokeRange());
        this.setNoiseRange(handWeapon.getNoiseRange());
        this.setNoiseDuration(handWeapon.getNoiseDuration());
        this.setExtraDamage(handWeapon.getExtraDamage());
        this.setRemoteControlID(handWeapon.getRemoteControlID());
        this.setCountDownSound(handWeapon.getCountDownSound());
        this.setExplosionSound(handWeapon.getExplosionSound());
        int n = this.FPS = GameServer.bServer ? 10 : PerformanceSettings.getLockFPS();
        if (handWeapon.getExplosionTimer() > 0) {
            this.timerBeforeExplosion = handWeapon.getExplosionTimer() * this.FPS - 1;
        } else if (!handWeapon.canBeRemote()) {
            this.timerBeforeExplosion = 1;
        }
        if (handWeapon.canBePlaced()) {
            this.weapon = handWeapon;
        }
        this.instantExplosion = handWeapon.isInstantExplosion();
    }

    private void initSprite(HandWeapon handWeapon) {
        if (handWeapon == null) {
            return;
        }
        String string = handWeapon.getPlacedSprite() != null && !handWeapon.getPlacedSprite().isEmpty() ? handWeapon.getPlacedSprite() : (handWeapon.getTex() != null && handWeapon.getTex().getName() != null ? handWeapon.getTex().getName() : "media/inventory/world/WItem_Sack.png");
        this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        Texture texture = this.sprite.LoadFrameExplicit(string);
        if (string.startsWith("Item_") && texture != null) {
            if (handWeapon.getScriptItem() == null) {
                this.sprite.def.scaleAspect(texture.getWidthOrig(), texture.getHeightOrig(), 16 * Core.TileScale, 16 * Core.TileScale);
            } else {
                float f = handWeapon.getScriptItem().ScaleWorldIcon * ((float)Core.TileScale / 2.0f);
                this.sprite.def.setScale(f, f);
            }
        }
    }

    @Override
    public void update() {
        if (this.timerBeforeExplosion > 0) {
            if (this.timerBeforeExplosion / this.FPS + 1 != this.lastBeep) {
                this.lastBeep = this.timerBeforeExplosion / this.FPS + 1;
                if (!GameServer.bServer && this.getObjectIndex() != -1) {
                    this.getOrCreateEmitter();
                    if (!StringUtils.isNullOrWhitespace(this.getCountDownSound())) {
                        this.emitter.playSound(this.getCountDownSound());
                    } else if (this.lastBeep == 1) {
                        this.emitter.playSound("TrapTimerExpired");
                    } else {
                        this.emitter.playSound("TrapTimerLoop");
                    }
                }
            }
            --this.timerBeforeExplosion;
            if (this.timerBeforeExplosion == 0) {
                this.triggerExplosion(this.getSensorRange() > 0);
            }
        }
        this.updateSounds();
    }

    private void updateSounds() {
        if (this.noiseStartTime > 0.0f) {
            float f = (float)GameTime.getInstance().getWorldAgeHours();
            this.noiseStartTime = PZMath.min(this.noiseStartTime, f);
            this.lastWorldSoundTime = PZMath.min(this.lastWorldSoundTime, f);
            float f2 = 60.0f / (float)SandboxOptions.getInstance().getDayLengthMinutes();
            float f3 = 60.0f;
            if (f - this.noiseStartTime > (float)this.getNoiseDuration() / f3 * f2) {
                this.noiseStartTime = 0.0f;
                if (this.emitter != null) {
                    this.emitter.stopAll();
                }
            } else {
                BaseSoundEmitter baseSoundEmitter;
                if (!(GameServer.bServer || this.emitter != null && this.emitter.isPlaying(this.getExplosionSound()) || (baseSoundEmitter = this.getOrCreateEmitter()) == null)) {
                    baseSoundEmitter.playSound(this.getExplosionSound());
                }
                if (f - this.lastWorldSoundTime > 1.0f / f3 * f2 && this.getObjectIndex() != -1) {
                    this.lastWorldSoundTime = f;
                    WorldSoundManager.instance.addSoundRepeating(null, this.getSquare().getX(), this.getSquare().getY(), this.getSquare().getZ(), this.getNoiseRange(), 1, true);
                }
            }
        }
        if (this.emitter != null) {
            this.emitter.tick();
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.sprite.CurrentAnim == null || this.sprite.CurrentAnim.Frames.isEmpty()) {
            return;
        }
        Texture texture = this.sprite.CurrentAnim.Frames.get(0).getTexture(this.dir);
        if (texture == null) {
            return;
        }
        if (texture.getName().startsWith("Item_")) {
            float f4 = (float)texture.getWidthOrig() * this.sprite.def.getScaleX() / 2.0f;
            float f5 = (float)texture.getHeightOrig() * this.sprite.def.getScaleY() * 3.0f / 4.0f;
            this.setAlphaAndTarget(1.0f);
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.sx = 0.0f;
            this.sprite.render(this, f + 0.5f, f2 + 0.5f, f3, this.dir, this.offsetX + f4, this.offsetY + f5, colorInfo, true);
        } else {
            this.offsetX = 32 * Core.TileScale;
            this.offsetY = 96 * Core.TileScale;
            this.sx = 0.0f;
            super.render(f, f2, f3, colorInfo, bl, bl2, shader);
        }
    }

    public void triggerExplosion(boolean bl) {
        LuaEventManager.triggerEvent("OnThrowableExplode", this, this.square);
        if (bl) {
            if (this.getSensorRange() > 0) {
                this.square.setTrapPositionX(this.square.getX());
                this.square.setTrapPositionY(this.square.getY());
                this.square.setTrapPositionZ(this.square.getZ());
                this.square.drawCircleExplosion(this.getSensorRange(), this, ExplosionMode.Sensor);
            }
        } else {
            if (this.getExplosionSound() != null) {
                this.playExplosionSound();
            }
            if (this.getNoiseRange() > 0) {
                WorldSoundManager.instance.addSound(null, (int)this.getX(), (int)this.getY(), (int)this.getZ(), this.getNoiseRange(), 1);
            } else if (this.getExplosionSound() != null) {
                WorldSoundManager.instance.addSound(null, (int)this.getX(), (int)this.getY(), (int)this.getZ(), 50, 1);
            }
            if (this.getExplosionRange() > 0) {
                this.square.drawCircleExplosion(this.getExplosionRange(), this, ExplosionMode.Explosion);
            }
            if (this.getFireRange() > 0) {
                this.square.drawCircleExplosion(this.getFireRange(), this, ExplosionMode.Fire);
            }
            if (this.getSmokeRange() > 0) {
                this.square.drawCircleExplosion(this.getSmokeRange(), this, ExplosionMode.Smoke);
            }
            if (this.weapon == null || !this.weapon.canBeReused()) {
                if (GameServer.bServer) {
                    GameServer.RemoveItemFromMap(this);
                } else {
                    this.removeFromWorld();
                    this.removeFromSquare();
                }
            }
        }
    }

    private BaseSoundEmitter getOrCreateEmitter() {
        if (this.getObjectIndex() == -1) {
            return null;
        }
        if (this.emitter == null) {
            this.emitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, this.getZ());
            IsoWorld.instance.takeOwnershipOfEmitter(this.emitter);
        }
        return this.emitter;
    }

    public void playExplosionSound() {
        if (StringUtils.isNullOrWhitespace(this.getExplosionSound())) {
            return;
        }
        if (this.getObjectIndex() == -1) {
            return;
        }
        if (this.getNoiseRange() > 0 && (float)this.getNoiseDuration() > 0.0f) {
            this.noiseStartTime = (float)GameTime.getInstance().getWorldAgeHours();
        }
        if (GameServer.bServer) {
            return;
        }
        this.getOrCreateEmitter();
        if (!this.emitter.isPlaying(this.getExplosionSound())) {
            this.emitter.playSoundImpl(this.getExplosionSound(), (IsoObject)null);
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.sensorRange = byteBuffer.getInt();
        this.firePower = byteBuffer.getInt();
        this.fireRange = byteBuffer.getInt();
        this.explosionPower = byteBuffer.getInt();
        this.explosionRange = byteBuffer.getInt();
        this.smokeRange = byteBuffer.getInt();
        this.noiseRange = byteBuffer.getInt();
        if (n >= 180) {
            this.noiseDuration = byteBuffer.getInt();
            this.noiseStartTime = byteBuffer.getFloat();
        }
        this.extraDamage = byteBuffer.getFloat();
        this.remoteControlID = byteBuffer.getInt();
        if (n >= 78) {
            this.timerBeforeExplosion = byteBuffer.getInt() * this.FPS;
            this.countDownSound = GameWindow.ReadStringUTF(byteBuffer);
            this.explosionSound = GameWindow.ReadStringUTF(byteBuffer);
            if ("bigExplosion".equals(this.explosionSound)) {
                this.explosionSound = "BigExplosion";
            }
            if ("smallExplosion".equals(this.explosionSound)) {
                this.explosionSound = "SmallExplosion";
            }
            if ("feedback".equals(this.explosionSound)) {
                this.explosionSound = "NoiseTrapExplosion";
            }
        }
        if (n >= 82) {
            InventoryItem inventoryItem;
            boolean bl2;
            boolean bl3 = bl2 = byteBuffer.get() == 1;
            if (bl2 && (inventoryItem = InventoryItem.loadItem(byteBuffer, n)) instanceof HandWeapon) {
                this.weapon = (HandWeapon)inventoryItem;
                this.initSprite(this.weapon);
            }
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.putInt(this.sensorRange);
        byteBuffer.putInt(this.firePower);
        byteBuffer.putInt(this.fireRange);
        byteBuffer.putInt(this.explosionPower);
        byteBuffer.putInt(this.explosionRange);
        byteBuffer.putInt(this.smokeRange);
        byteBuffer.putInt(this.noiseRange);
        byteBuffer.putInt(this.noiseDuration);
        byteBuffer.putFloat(this.noiseStartTime);
        byteBuffer.putFloat(this.extraDamage);
        byteBuffer.putInt(this.remoteControlID);
        byteBuffer.putInt(this.timerBeforeExplosion > 1 ? Math.max(this.timerBeforeExplosion / this.FPS, 1) : 0);
        GameWindow.WriteStringUTF(byteBuffer, this.countDownSound);
        GameWindow.WriteStringUTF(byteBuffer, this.explosionSound);
        if (this.weapon != null) {
            byteBuffer.put((byte)1);
            this.weapon.saveWithSize(byteBuffer, false);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    @Override
    public void addToWorld() {
        this.getCell().addToProcessIsoObject(this);
    }

    @Override
    public void removeFromWorld() {
        if (this.emitter != null) {
            if (this.noiseStartTime > 0.0f) {
                this.emitter.stopAll();
            }
            IsoWorld.instance.returnOwnershipOfEmitter(this.emitter);
            this.emitter = null;
        }
        super.removeFromWorld();
    }

    public int getTimerBeforeExplosion() {
        return this.timerBeforeExplosion;
    }

    public void setTimerBeforeExplosion(int n) {
        this.timerBeforeExplosion = n;
    }

    public int getSensorRange() {
        return this.sensorRange;
    }

    public void setSensorRange(int n) {
        this.sensorRange = n;
    }

    public int getFireRange() {
        return this.fireRange;
    }

    public void setFireRange(int n) {
        this.fireRange = n;
    }

    public int getFirePower() {
        return this.firePower;
    }

    public void setFirePower(int n) {
        this.firePower = n;
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    public void setExplosionPower(int n) {
        this.explosionPower = n;
    }

    public int getNoiseDuration() {
        return this.noiseDuration;
    }

    public void setNoiseDuration(int n) {
        this.noiseDuration = n;
    }

    public int getNoiseRange() {
        return this.noiseRange;
    }

    public void setNoiseRange(int n) {
        this.noiseRange = n;
    }

    public int getExplosionRange() {
        return this.explosionRange;
    }

    public void setExplosionRange(int n) {
        this.explosionRange = n;
    }

    public int getSmokeRange() {
        return this.smokeRange;
    }

    public void setSmokeRange(int n) {
        this.smokeRange = n;
    }

    public float getExtraDamage() {
        return this.extraDamage;
    }

    public void setExtraDamage(float f) {
        this.extraDamage = f;
    }

    @Override
    public String getObjectName() {
        return "IsoTrap";
    }

    public int getRemoteControlID() {
        return this.remoteControlID;
    }

    public void setRemoteControlID(int n) {
        this.remoteControlID = n;
    }

    public String getCountDownSound() {
        return this.countDownSound;
    }

    public void setCountDownSound(String string) {
        this.countDownSound = string;
    }

    public String getExplosionSound() {
        return this.explosionSound;
    }

    public void setExplosionSound(String string) {
        this.explosionSound = string;
    }

    public InventoryItem getItem() {
        return this.weapon;
    }

    public static void triggerRemote(IsoPlayer isoPlayer, int n, int n2) {
        int n3 = (int)isoPlayer.getX();
        int n4 = (int)isoPlayer.getY();
        int n5 = (int)isoPlayer.getZ();
        int n6 = Math.max(n5 - n2 / 2, 0);
        int n7 = Math.min(n5 + n2 / 2, 8);
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = n6; i < n7; ++i) {
            for (int j = n4 - n2; j < n4 + n2; ++j) {
                for (int k = n3 - n2; k < n3 + n2; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(k, j, i);
                    if (isoGridSquare == null) continue;
                    for (int i2 = isoGridSquare.getObjects().size() - 1; i2 >= 0; --i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (!(isoObject instanceof IsoTrap) || ((IsoTrap)isoObject).getRemoteControlID() != n) continue;
                        ((IsoTrap)isoObject).triggerExplosion(false);
                    }
                }
            }
        }
    }

    public boolean isInstantExplosion() {
        return this.instantExplosion;
    }

    public static enum ExplosionMode {
        Explosion,
        Fire,
        Smoke,
        Sensor;

    }
}

