/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.SystemDisabler;
import zombie.WorldSoundManager;
import zombie.ai.states.ThumpState;
import zombie.characters.BaseCharacterSoundEmitter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.core.Translator;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.properties.PropertyContainer;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.HandWeapon;
import zombie.iso.BrokenFences;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.objects.RenderEffectType;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.util.Type;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;
import zombie.world.WorldDictionary;

public class IsoThumpable
extends IsoObject
implements BarricadeAble,
Thumpable {
    private KahluaTable table;
    private KahluaTable modData;
    public Boolean isDoor = false;
    public Boolean isDoorFrame = false;
    public String breakSound = "BreakObject";
    private boolean isCorner = false;
    private boolean isFloor = false;
    private boolean blockAllTheSquare = false;
    public boolean Locked = false;
    public int MaxHealth = 500;
    public int Health = 500;
    public int PushedMaxStrength = 0;
    public int PushedStrength = 0;
    IsoSprite closedSprite;
    public boolean north = false;
    private int thumpDmg = 8;
    private float crossSpeed = 1.0f;
    public boolean open = false;
    IsoSprite openSprite;
    private boolean destroyed = false;
    private boolean canBarricade = false;
    public boolean canPassThrough = false;
    private boolean isStairs = false;
    private boolean isContainer = false;
    private boolean dismantable = false;
    private boolean canBePlastered = false;
    private boolean paintable = false;
    private boolean isThumpable = true;
    private boolean isHoppable = false;
    private int lightSourceRadius = -1;
    private int lightSourceLife = -1;
    private int lightSourceXOffset = 0;
    private int lightSourceYOffset = 0;
    private boolean lightSourceOn = false;
    private IsoLightSource lightSource = null;
    private String lightSourceFuel = null;
    private float lifeLeft = -1.0f;
    private float lifeDelta = 0.0f;
    private boolean haveFuel = false;
    private float updateAccumulator = 0.0f;
    private float lastUpdateHours = -1.0f;
    public int keyId = -1;
    private boolean lockedByKey = false;
    public boolean lockedByPadlock = false;
    private boolean canBeLockByPadlock = false;
    public int lockedByCode = 0;
    public int OldNumPlanks = 0;
    public String thumpSound = "ZombieThumpGeneric";
    public static final Vector2 tempo = new Vector2();

    @Override
    public KahluaTable getModData() {
        if (this.modData == null) {
            this.modData = LuaManager.platform.newTable();
        }
        return this.modData;
    }

    public void setModData(KahluaTable kahluaTable) {
        this.modData = kahluaTable;
    }

    @Override
    public boolean hasModData() {
        return this.modData != null && !this.modData.isEmpty();
    }

    public boolean isCanPassThrough() {
        return this.canPassThrough;
    }

    public void setCanPassThrough(boolean bl) {
        this.canPassThrough = bl;
    }

    public boolean isBlockAllTheSquare() {
        return this.blockAllTheSquare;
    }

    public void setBlockAllTheSquare(boolean bl) {
        this.blockAllTheSquare = bl;
    }

    public void setIsDismantable(boolean bl) {
        this.dismantable = bl;
    }

    public boolean isDismantable() {
        return this.dismantable;
    }

    public float getCrossSpeed() {
        return this.crossSpeed;
    }

    public void setCrossSpeed(float f) {
        this.crossSpeed = f;
    }

    public void setIsFloor(boolean bl) {
        this.isFloor = bl;
    }

    public boolean isCorner() {
        return this.isCorner;
    }

    @Override
    public boolean isFloor() {
        return this.isFloor;
    }

    public void setIsContainer(boolean bl) {
        this.isContainer = bl;
        if (bl) {
            this.container = new ItemContainer("crate", this.square, this);
            if (this.sprite.getProperties().Is("ContainerCapacity")) {
                this.container.Capacity = Integer.parseInt(this.sprite.getProperties().Val("ContainerCapacity"));
            }
            this.container.setExplored(true);
        }
    }

    public void setIsStairs(boolean bl) {
        this.isStairs = bl;
    }

    public boolean isStairs() {
        return this.isStairs;
    }

    public boolean isWindow() {
        return this.sprite != null && (this.sprite.getProperties().Is(IsoFlagType.WindowN) || this.sprite.getProperties().Is(IsoFlagType.WindowW));
    }

    @Override
    public String getObjectName() {
        return "Thumpable";
    }

    public IsoThumpable(IsoCell isoCell) {
        super(isoCell);
    }

    public void setCorner(boolean bl) {
        this.isCorner = bl;
    }

    public void setCanBarricade(boolean bl) {
        this.canBarricade = bl;
    }

    public boolean getCanBarricade() {
        return this.canBarricade;
    }

    public void setHealth(int n) {
        this.Health = n;
    }

    public int getHealth() {
        return this.Health;
    }

    public void setMaxHealth(int n) {
        this.MaxHealth = n;
    }

    public int getMaxHealth() {
        return this.MaxHealth;
    }

    public void setThumpDmg(Integer n) {
        this.thumpDmg = n;
    }

    public int getThumpDmg() {
        return this.thumpDmg;
    }

    public void setBreakSound(String string) {
        this.breakSound = string;
    }

    public String getBreakSound() {
        return this.breakSound;
    }

    public boolean isDoor() {
        return this.isDoor;
    }

    @Override
    public boolean getNorth() {
        return this.north;
    }

    @Override
    public Vector2 getFacingPosition(Vector2 vector22) {
        if (this.square == null) {
            return vector22.set(0.0f, 0.0f);
        }
        if (this.isDoor.booleanValue() || this.isDoorFrame.booleanValue() || this.isWindow() || this.isHoppable || this.getProperties() != null && (this.getProperties().Is(IsoFlagType.collideN) || this.getProperties().Is(IsoFlagType.collideW))) {
            if (this.north) {
                return vector22.set(this.getX() + 0.5f, this.getY());
            }
            return vector22.set(this.getX(), this.getY() + 0.5f);
        }
        return vector22.set(this.getX() + 0.5f, this.getY() + 0.5f);
    }

    public boolean isDoorFrame() {
        return this.isDoorFrame;
    }

    public void setIsDoor(boolean bl) {
        this.isDoor = bl;
    }

    public void setIsDoorFrame(boolean bl) {
        this.isDoorFrame = bl;
    }

    @Override
    public void setSprite(String string) {
        this.sprite = this.closedSprite = IsoSpriteManager.instance.getSprite(string);
    }

    @Override
    public void setSpriteFromName(String string) {
        this.sprite = IsoSpriteManager.instance.getSprite(string);
    }

    public void setClosedSprite(IsoSprite isoSprite) {
        this.sprite = this.closedSprite = isoSprite;
    }

    public void setOpenSprite(IsoSprite isoSprite) {
        this.openSprite = isoSprite;
    }

    public IsoThumpable(IsoCell isoCell, IsoGridSquare isoGridSquare, String string, String string2, boolean bl, KahluaTable kahluaTable) {
        this.OutlineOnMouseover = true;
        this.PushedStrength = 2500;
        this.PushedMaxStrength = 2500;
        this.openSprite = IsoSpriteManager.instance.getSprite(string2);
        this.closedSprite = IsoSpriteManager.instance.getSprite(string);
        this.table = kahluaTable;
        this.sprite = this.closedSprite;
        this.square = isoGridSquare;
        this.north = bl;
    }

    public IsoThumpable(IsoCell isoCell, IsoGridSquare isoGridSquare, String string, boolean bl, KahluaTable kahluaTable) {
        this.OutlineOnMouseover = true;
        this.PushedStrength = 2500;
        this.PushedMaxStrength = 2500;
        this.closedSprite = IsoSpriteManager.instance.getSprite(string);
        this.table = kahluaTable;
        this.sprite = this.closedSprite;
        this.square = isoGridSquare;
        this.north = bl;
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        BitHeaderRead bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Long, byteBuffer);
        this.OutlineOnMouseover = true;
        this.PushedStrength = 2500;
        this.PushedMaxStrength = 2500;
        if (!bitHeaderRead.equals(0)) {
            this.open = bitHeaderRead.hasFlags(1);
            this.Locked = bitHeaderRead.hasFlags(2);
            this.north = bitHeaderRead.hasFlags(4);
            if (bitHeaderRead.hasFlags(8)) {
                this.MaxHealth = byteBuffer.getInt();
            }
            this.Health = bitHeaderRead.hasFlags(16) ? byteBuffer.getInt() : this.MaxHealth;
            if (bitHeaderRead.hasFlags(32)) {
                this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(64)) {
                this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(128)) {
                this.thumpDmg = byteBuffer.getInt();
            }
            this.isDoor = bitHeaderRead.hasFlags(512);
            this.isDoorFrame = bitHeaderRead.hasFlags(1024);
            this.isCorner = bitHeaderRead.hasFlags(2048);
            this.isStairs = bitHeaderRead.hasFlags(4096);
            this.isContainer = bitHeaderRead.hasFlags(8192);
            this.isFloor = bitHeaderRead.hasFlags(16384);
            this.canBarricade = bitHeaderRead.hasFlags(32768);
            this.canPassThrough = bitHeaderRead.hasFlags(65536);
            this.dismantable = bitHeaderRead.hasFlags(131072);
            this.canBePlastered = bitHeaderRead.hasFlags(262144);
            this.paintable = bitHeaderRead.hasFlags(524288);
            if (bitHeaderRead.hasFlags(0x100000)) {
                this.crossSpeed = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(0x200000)) {
                if (this.table == null) {
                    this.table = LuaManager.platform.newTable();
                }
                this.table.load(byteBuffer, n);
            }
            if (bitHeaderRead.hasFlags(0x400000)) {
                if (this.modData == null) {
                    this.modData = LuaManager.platform.newTable();
                }
                this.modData.load(byteBuffer, n);
            }
            this.blockAllTheSquare = bitHeaderRead.hasFlags(0x800000);
            this.isThumpable = bitHeaderRead.hasFlags(0x1000000);
            this.isHoppable = bitHeaderRead.hasFlags(0x2000000);
            if (bitHeaderRead.hasFlags(0x4000000)) {
                this.setLightSourceLife(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(0x8000000)) {
                this.setLightSourceRadius(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(0x10000000)) {
                this.setLightSourceXOffset(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(0x20000000)) {
                this.setLightSourceYOffset(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(0x40000000)) {
                this.setLightSourceFuel(WorldDictionary.getItemTypeFromID(byteBuffer.getShort()));
            }
            if (bitHeaderRead.hasFlags(0x80000000L)) {
                this.setLifeDelta(byteBuffer.getFloat());
            }
            if (bitHeaderRead.hasFlags(0x100000000L)) {
                this.setLifeLeft(byteBuffer.getFloat());
            }
            if (bitHeaderRead.hasFlags(0x200000000L)) {
                this.keyId = byteBuffer.getInt();
            }
            this.lockedByKey = bitHeaderRead.hasFlags(0x400000000L);
            this.lockedByPadlock = bitHeaderRead.hasFlags(0x800000000L);
            this.canBeLockByPadlock = bitHeaderRead.hasFlags(0x1000000000L);
            if (bitHeaderRead.hasFlags(0x2000000000L)) {
                this.lockedByCode = byteBuffer.getInt();
            }
            if (bitHeaderRead.hasFlags(0x4000000000L)) {
                this.thumpSound = GameWindow.ReadString(byteBuffer);
                if ("thumpa2".equals(this.thumpSound)) {
                    this.thumpSound = "ZombieThumpGeneric";
                }
                if ("metalthump".equals(this.thumpSound)) {
                    this.thumpSound = "ZombieThumpMetal";
                }
            }
            if (bitHeaderRead.hasFlags(0x8000000000L)) {
                this.lastUpdateHours = byteBuffer.getFloat();
            }
            if (n >= 183) {
                if (bitHeaderRead.hasFlags(0x10000000000L)) {
                    this.haveFuel = true;
                }
                if (bitHeaderRead.hasFlags(0x20000000000L)) {
                    this.lightSourceOn = true;
                }
            }
        }
        bitHeaderRead.release();
        if (this.getLightSourceFuel() != null) {
            boolean bl2 = this.isLightSourceOn();
            this.createLightSource(this.getLightSourceRadius(), this.getLightSourceXOffset(), this.getLightSourceYOffset(), 0, this.getLightSourceLife(), this.getLightSourceFuel(), null, null);
            if (this.lightSource != null) {
                this.getLightSource().setActive(bl2);
            }
            this.setLightSourceOn(bl2);
        }
        if (SystemDisabler.doObjectStateSyncEnable && GameClient.bClient) {
            GameClient.instance.objectSyncReq.putRequestLoad(this.square);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Long, byteBuffer);
        if (this.open) {
            bitHeaderWrite.addFlags(1);
        }
        if (this.Locked) {
            bitHeaderWrite.addFlags(2);
        }
        if (this.north) {
            bitHeaderWrite.addFlags(4);
        }
        if (this.MaxHealth != 500) {
            bitHeaderWrite.addFlags(8);
            byteBuffer.putInt(this.MaxHealth);
        }
        if (this.Health != this.MaxHealth) {
            bitHeaderWrite.addFlags(16);
            byteBuffer.putInt(this.Health);
        }
        if (this.closedSprite != null) {
            bitHeaderWrite.addFlags(32);
            byteBuffer.putInt(this.closedSprite.ID);
        }
        if (this.openSprite != null) {
            bitHeaderWrite.addFlags(64);
            byteBuffer.putInt(this.openSprite.ID);
        }
        if (this.thumpDmg != 8) {
            bitHeaderWrite.addFlags(128);
            byteBuffer.putInt(this.thumpDmg);
        }
        if (this.isDoor.booleanValue()) {
            bitHeaderWrite.addFlags(512);
        }
        if (this.isDoorFrame.booleanValue()) {
            bitHeaderWrite.addFlags(1024);
        }
        if (this.isCorner) {
            bitHeaderWrite.addFlags(2048);
        }
        if (this.isStairs) {
            bitHeaderWrite.addFlags(4096);
        }
        if (this.isContainer) {
            bitHeaderWrite.addFlags(8192);
        }
        if (this.isFloor) {
            bitHeaderWrite.addFlags(16384);
        }
        if (this.canBarricade) {
            bitHeaderWrite.addFlags(32768);
        }
        if (this.canPassThrough) {
            bitHeaderWrite.addFlags(65536);
        }
        if (this.dismantable) {
            bitHeaderWrite.addFlags(131072);
        }
        if (this.canBePlastered) {
            bitHeaderWrite.addFlags(262144);
        }
        if (this.paintable) {
            bitHeaderWrite.addFlags(524288);
        }
        if (this.crossSpeed != 1.0f) {
            bitHeaderWrite.addFlags(0x100000);
            byteBuffer.putFloat(this.crossSpeed);
        }
        if (this.table != null && !this.table.isEmpty()) {
            bitHeaderWrite.addFlags(0x200000);
            this.table.save(byteBuffer);
        }
        if (this.modData != null && !this.modData.isEmpty()) {
            bitHeaderWrite.addFlags(0x400000);
            this.modData.save(byteBuffer);
        }
        if (this.blockAllTheSquare) {
            bitHeaderWrite.addFlags(0x800000);
        }
        if (this.isThumpable) {
            bitHeaderWrite.addFlags(0x1000000);
        }
        if (this.isHoppable) {
            bitHeaderWrite.addFlags(0x2000000);
        }
        if (this.getLightSourceLife() != -1) {
            bitHeaderWrite.addFlags(0x4000000);
            byteBuffer.putInt(this.getLightSourceLife());
        }
        if (this.getLightSourceRadius() != -1) {
            bitHeaderWrite.addFlags(0x8000000);
            byteBuffer.putInt(this.getLightSourceRadius());
        }
        if (this.getLightSourceXOffset() != 0) {
            bitHeaderWrite.addFlags(0x10000000);
            byteBuffer.putInt(this.getLightSourceXOffset());
        }
        if (this.getLightSourceYOffset() != 0) {
            bitHeaderWrite.addFlags(0x20000000);
            byteBuffer.putInt(this.getLightSourceYOffset());
        }
        if (this.getLightSourceFuel() != null) {
            bitHeaderWrite.addFlags(0x40000000);
            byteBuffer.putShort(WorldDictionary.getItemRegistryID(this.getLightSourceFuel()));
        }
        if (this.getLifeDelta() != 0.0f) {
            bitHeaderWrite.addFlags(0x80000000L);
            byteBuffer.putFloat(this.getLifeDelta());
        }
        if (this.getLifeLeft() != -1.0f) {
            bitHeaderWrite.addFlags(0x100000000L);
            byteBuffer.putFloat(this.getLifeLeft());
        }
        if (this.keyId != -1) {
            bitHeaderWrite.addFlags(0x200000000L);
            byteBuffer.putInt(this.keyId);
        }
        if (this.isLockedByKey()) {
            bitHeaderWrite.addFlags(0x400000000L);
        }
        if (this.isLockedByPadlock()) {
            bitHeaderWrite.addFlags(0x800000000L);
        }
        if (this.canBeLockByPadlock()) {
            bitHeaderWrite.addFlags(0x1000000000L);
        }
        if (this.getLockedByCode() != 0) {
            bitHeaderWrite.addFlags(0x2000000000L);
            byteBuffer.putInt(this.getLockedByCode());
        }
        if (!this.thumpSound.equals("ZombieThumbGeneric")) {
            bitHeaderWrite.addFlags(0x4000000000L);
            GameWindow.WriteString(byteBuffer, this.thumpSound);
        }
        if (this.lastUpdateHours != -1.0f) {
            bitHeaderWrite.addFlags(0x8000000000L);
            byteBuffer.putFloat(this.lastUpdateHours);
        }
        if (this.haveFuel) {
            bitHeaderWrite.addFlags(0x10000000000L);
        }
        if (this.lightSourceOn) {
            bitHeaderWrite.addFlags(0x20000000000L);
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean IsOpen() {
        return this.open;
    }

    public boolean IsStrengthenedByPushedItems() {
        return false;
    }

    @Override
    public boolean onMouseLeftClick(int n, int n2) {
        return false;
    }

    @Override
    public boolean TestPathfindCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        boolean bl = this.north;
        if (isoMovingObject instanceof IsoSurvivor && ((IsoSurvivor)isoMovingObject).getInventory().contains("Hammer")) {
            return false;
        }
        if (this.open) {
            return false;
        }
        if (isoGridSquare == this.square) {
            if (bl && isoGridSquare2.getY() < isoGridSquare.getY()) {
                return true;
            }
            if (!bl && isoGridSquare2.getX() < isoGridSquare.getX()) {
                return true;
            }
        } else {
            if (bl && isoGridSquare2.getY() > isoGridSquare.getY()) {
                return true;
            }
            if (!bl && isoGridSquare2.getX() > isoGridSquare.getX()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean TestCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        if (isoMovingObject instanceof IsoPlayer && ((IsoPlayer)isoMovingObject).isNoClip()) {
            return false;
        }
        boolean bl = this.north;
        if (this.open) {
            return false;
        }
        if (this.blockAllTheSquare) {
            if (isoGridSquare != this.square) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
            return false;
        }
        if (isoGridSquare == this.square) {
            if (bl && isoGridSquare2.getY() < isoGridSquare.getY()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                if (!(this.canPassThrough || this.isStairs || this.isCorner)) {
                    return true;
                }
            }
            if (!bl && isoGridSquare2.getX() < isoGridSquare.getX()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                if (!(this.canPassThrough || this.isStairs || this.isCorner)) {
                    return true;
                }
            }
        } else {
            if (bl && isoGridSquare2.getY() > isoGridSquare.getY()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                if (!(this.canPassThrough || this.isStairs || this.isCorner)) {
                    return true;
                }
            }
            if (!bl && isoGridSquare2.getX() > isoGridSquare.getX()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                if (!(this.canPassThrough || this.isStairs || this.isCorner)) {
                    return true;
                }
            }
        }
        if (this.isCorner) {
            if (isoGridSquare2.getY() < isoGridSquare.getY() && isoGridSquare2.getX() < isoGridSquare.getX()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                if (!this.canPassThrough) {
                    return true;
                }
            }
            if (isoGridSquare2.getY() > isoGridSquare.getY() && isoGridSquare2.getX() > isoGridSquare.getX()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                if (!this.canPassThrough) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IsoObject.VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        boolean bl;
        if (this.canPassThrough) {
            return IsoObject.VisionResult.NoEffect;
        }
        boolean bl2 = this.north;
        if (this.open) {
            boolean bl3 = bl2 = !bl2;
        }
        if (isoGridSquare2.getZ() != isoGridSquare.getZ()) {
            return IsoObject.VisionResult.NoEffect;
        }
        boolean bl4 = bl = this.sprite != null && this.sprite.getProperties().Is("doorTrans");
        if (isoGridSquare == this.square) {
            if (bl2 && isoGridSquare2.getY() < isoGridSquare.getY()) {
                if (bl) {
                    return IsoObject.VisionResult.Unblocked;
                }
                if (this.isWindow()) {
                    return IsoObject.VisionResult.Unblocked;
                }
                return IsoObject.VisionResult.Blocked;
            }
            if (!bl2 && isoGridSquare2.getX() < isoGridSquare.getX()) {
                if (bl) {
                    return IsoObject.VisionResult.Unblocked;
                }
                if (this.isWindow()) {
                    return IsoObject.VisionResult.Unblocked;
                }
                return IsoObject.VisionResult.Blocked;
            }
        } else {
            if (bl2 && isoGridSquare2.getY() > isoGridSquare.getY()) {
                if (bl) {
                    return IsoObject.VisionResult.Unblocked;
                }
                if (this.isWindow()) {
                    return IsoObject.VisionResult.Unblocked;
                }
                return IsoObject.VisionResult.Blocked;
            }
            if (!bl2 && isoGridSquare2.getX() > isoGridSquare.getX()) {
                if (bl) {
                    return IsoObject.VisionResult.Unblocked;
                }
                if (this.isWindow()) {
                    return IsoObject.VisionResult.Unblocked;
                }
                return IsoObject.VisionResult.Blocked;
            }
        }
        return IsoObject.VisionResult.NoEffect;
    }

    @Override
    public void Thump(IsoMovingObject isoMovingObject) {
        if (!SandboxOptions.instance.Lore.ThumpOnConstruction.getValue()) {
            return;
        }
        if (isoMovingObject instanceof IsoGameCharacter) {
            Thumpable thumpable = this.getThumpableFor((IsoGameCharacter)isoMovingObject);
            if (thumpable == null) {
                return;
            }
            if (thumpable != this) {
                thumpable.Thump(isoMovingObject);
                return;
            }
        }
        boolean bl = BrokenFences.getInstance().isBreakableObject(this);
        if (isoMovingObject instanceof IsoZombie) {
            int n;
            if (((IsoZombie)isoMovingObject).cognition == 1 && this.isDoor() && !this.IsOpen() && !this.isLocked()) {
                this.ToggleDoor((IsoGameCharacter)isoMovingObject);
                return;
            }
            int n2 = isoMovingObject.getCurrentSquare().getMovingObjects().size();
            if (isoMovingObject.getCurrentSquare().getW() != null) {
                n2 += isoMovingObject.getCurrentSquare().getW().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getE() != null) {
                n2 += isoMovingObject.getCurrentSquare().getE().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getS() != null) {
                n2 += isoMovingObject.getCurrentSquare().getS().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getN() != null) {
                n2 += isoMovingObject.getCurrentSquare().getN().getMovingObjects().size();
            }
            if (n2 >= (n = this.thumpDmg)) {
                int n3 = 1 * ThumpState.getFastForwardDamageMultiplier();
                this.Health -= n3;
            } else {
                this.partialThumpDmg += (float)n2 / (float)n * (float)ThumpState.getFastForwardDamageMultiplier();
                if ((int)this.partialThumpDmg > 0) {
                    int n4 = (int)this.partialThumpDmg;
                    this.Health -= n4;
                    this.partialThumpDmg -= (float)n4;
                }
            }
            WorldSoundManager.instance.addSound(isoMovingObject, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, true, 4.0f, 15.0f);
            if (this.isDoor()) {
                this.setRenderEffect(RenderEffectType.Hit_Door, true);
            }
        }
        if (this.Health <= 0) {
            ((IsoGameCharacter)isoMovingObject).getEmitter().playSound(this.breakSound, this);
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer((IsoGameCharacter)isoMovingObject, this.breakSound, false, isoMovingObject.getCurrentSquare(), 0.2f, 20.0f, 1.1f, true);
            }
            WorldSoundManager.instance.addSound(null, this.square.getX(), this.square.getY(), this.square.getZ(), 10, 20, true, 4.0f, 15.0f);
            isoMovingObject.setThumpTarget(null);
            if (IsoDoor.destroyDoubleDoor(this)) {
                return;
            }
            if (IsoDoor.destroyGarageDoor(this)) {
                return;
            }
            if (bl) {
                PropertyContainer propertyContainer = this.getProperties();
                IsoDirections isoDirections = propertyContainer.Is(IsoFlagType.collideN) && propertyContainer.Is(IsoFlagType.collideW) ? (isoMovingObject.getY() >= this.getY() ? IsoDirections.N : IsoDirections.S) : (propertyContainer.Is(IsoFlagType.collideN) ? (isoMovingObject.getY() >= this.getY() ? IsoDirections.N : IsoDirections.S) : (isoMovingObject.getX() >= this.getX() ? IsoDirections.W : IsoDirections.E));
                BrokenFences.getInstance().destroyFence(this, isoDirections);
                return;
            }
            this.destroy();
        }
    }

    @Override
    public Thumpable getThumpableFor(IsoGameCharacter isoGameCharacter) {
        boolean bl;
        if (this.isDoor() || this.isWindow()) {
            IsoBarricade isoBarricade = this.getBarricadeForCharacter(isoGameCharacter);
            if (isoBarricade != null) {
                return isoBarricade;
            }
            isoBarricade = this.getBarricadeOppositeCharacter(isoGameCharacter);
            if (isoBarricade != null) {
                return isoBarricade;
            }
        }
        boolean bl2 = this.isThumpable;
        boolean bl3 = bl = isoGameCharacter instanceof IsoZombie && ((IsoZombie)isoGameCharacter).isCrawling();
        if (!bl2 && bl && BrokenFences.getInstance().isBreakableObject(this)) {
            bl2 = true;
        }
        if (!bl2 && bl && this.isHoppable()) {
            bl2 = true;
        }
        if (!bl2 || this.isDestroyed()) {
            return null;
        }
        if (this.isDoor() && this.IsOpen() || this.isWindow()) {
            return null;
        }
        if (!bl && this.isHoppable()) {
            return null;
        }
        return this;
    }

    @Override
    public float getThumpCondition() {
        return (float)PZMath.clamp(this.Health, 0, this.MaxHealth) / (float)this.MaxHealth;
    }

    @Override
    public void WeaponHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (GameClient.bClient) {
            if (isoPlayer != null) {
                GameClient.instance.sendWeaponHit(isoPlayer, handWeapon, this);
            }
            if (this.isDoor()) {
                this.setRenderEffect(RenderEffectType.Hit_Door, true);
            }
            return;
        }
        Thumpable thumpable = this.getThumpableFor(isoGameCharacter);
        if (thumpable == null) {
            return;
        }
        if (thumpable instanceof IsoBarricade) {
            ((IsoBarricade)thumpable).WeaponHit(isoGameCharacter, handWeapon);
            return;
        }
        LuaEventManager.triggerEvent("OnWeaponHitThumpable", isoGameCharacter, handWeapon, this);
        this.Damage(handWeapon.getDoorDamage());
        if (handWeapon.getDoorHitSound() != null) {
            if (isoPlayer != null) {
                isoPlayer.setMeleeHitSurface(this.getSoundPrefix());
            }
            isoGameCharacter.getEmitter().playSound(handWeapon.getDoorHitSound(), this);
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer(isoGameCharacter, handWeapon.getDoorHitSound(), false, this.getSquare(), 0.2f, 20.0f, 1.0f, false);
            }
        }
        WorldSoundManager.instance.addSound(isoGameCharacter, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, false, 0.0f, 15.0f);
        if (this.isDoor()) {
            this.setRenderEffect(RenderEffectType.Hit_Door, true);
        }
        if (!this.IsStrengthenedByPushedItems() && this.Health <= 0 || this.IsStrengthenedByPushedItems() && this.Health <= -this.PushedMaxStrength) {
            isoGameCharacter.getEmitter().playSound(this.breakSound, this);
            WorldSoundManager.instance.addSound(isoGameCharacter, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, false, 0.0f, 15.0f);
            if (GameClient.bClient) {
                GameClient.instance.sendClientCommandV(null, "object", "OnDestroyIsoThumpable", "x", (int)this.getX(), "y", (int)this.getY(), "z", (int)this.getZ(), "index", this.getObjectIndex());
            }
            LuaEventManager.triggerEvent("OnDestroyIsoThumpable", this, null);
            if (IsoDoor.destroyDoubleDoor(this)) {
                return;
            }
            if (IsoDoor.destroyGarageDoor(this)) {
                return;
            }
            this.destroyed = true;
            if (this.getObjectIndex() != -1) {
                this.square.transmitRemoveItemFromSquare(this);
            }
        }
    }

    public IsoGridSquare getOtherSideOfDoor(IsoGameCharacter isoGameCharacter) {
        if (this.north) {
            if (isoGameCharacter.getCurrentSquare().getRoom() == this.square.getRoom()) {
                return IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX(), this.square.getY() - 1, this.square.getZ());
            }
            return IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX(), this.square.getY(), this.square.getZ());
        }
        if (isoGameCharacter.getCurrentSquare().getRoom() == this.square.getRoom()) {
            return IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX() - 1, this.square.getY(), this.square.getZ());
        }
        return IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX(), this.square.getY(), this.square.getZ());
    }

    public void ToggleDoorActual(IsoGameCharacter isoGameCharacter) {
        int n;
        if (this.isBarricaded()) {
            if (isoGameCharacter != null) {
                this.playDoorSound(isoGameCharacter.getEmitter(), "Blocked");
                isoGameCharacter.setHaloNote(Translator.getText("IGUI_PlayerText_DoorBarricaded"), 255, 255, 255, 256.0f);
                this.setRenderEffect(RenderEffectType.Hit_Door, true);
            }
            return;
        }
        if (this.isLockedByKey() && isoGameCharacter instanceof IsoPlayer && isoGameCharacter.getCurrentSquare().Is(IsoFlagType.exterior) && isoGameCharacter.getInventory().haveThisKeyId(this.getKeyId()) == null) {
            this.playDoorSound(isoGameCharacter.getEmitter(), "Locked");
            this.setRenderEffect(RenderEffectType.Hit_Door, true);
            return;
        }
        if (this.isLockedByKey() && isoGameCharacter instanceof IsoPlayer && isoGameCharacter.getInventory().haveThisKeyId(this.getKeyId()) != null) {
            this.playDoorSound(isoGameCharacter.getEmitter(), "Unlock");
            this.setIsLocked(false);
            this.setLockedByKey(false);
        }
        this.DirtySlice();
        this.square.InvalidateSpecialObjectPaths();
        if (this.Locked && isoGameCharacter instanceof IsoPlayer && isoGameCharacter.getCurrentSquare().Is(IsoFlagType.exterior) && !this.open) {
            this.playDoorSound(isoGameCharacter.getEmitter(), "Locked");
            this.setRenderEffect(RenderEffectType.Hit_Door, true);
            return;
        }
        if (isoGameCharacter instanceof IsoPlayer) {
            // empty if block
        }
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            LosUtil.cachecleared[n] = true;
        }
        IsoGridSquare.setRecalcLightTime(-1);
        GameTime.instance.lightSourceUpdate = 100.0f;
        if (this.getSprite().getProperties().Is("DoubleDoor")) {
            if (IsoDoor.isDoubleDoorObstructed(this)) {
                if (isoGameCharacter != null) {
                    this.playDoorSound(isoGameCharacter.getEmitter(), "Blocked");
                    isoGameCharacter.setHaloNote(Translator.getText("IGUI_PlayerText_DoorBlocked"), 255, 255, 255, 256.0f);
                }
                return;
            }
            n = this.open ? 1 : 0;
            IsoDoor.toggleDoubleDoor(this, true);
            if (n != this.open) {
                this.playDoorSound(isoGameCharacter.getEmitter(), this.open ? "Open" : "Close");
            }
            return;
        }
        if (this.isObstructed()) {
            if (isoGameCharacter != null) {
                this.playDoorSound(isoGameCharacter.getEmitter(), "Blocked");
                isoGameCharacter.setHaloNote(Translator.getText("IGUI_PlayerText_DoorBlocked"), 255, 255, 255, 256.0f);
            }
            return;
        }
        this.sprite = this.closedSprite;
        this.open = !this.open;
        this.setLockedByKey(false);
        if (this.open) {
            this.playDoorSound(isoGameCharacter.getEmitter(), "Open");
            this.sprite = this.openSprite;
        } else {
            this.playDoorSound(isoGameCharacter.getEmitter(), "Close");
        }
        this.square.RecalcProperties();
        this.syncIsoObject(false, this.open ? (byte)1 : 0, null, null);
        LuaEventManager.triggerEvent("OnContainerUpdate");
    }

    public void ToggleDoor(IsoGameCharacter isoGameCharacter) {
        this.ToggleDoorActual(isoGameCharacter);
    }

    public void ToggleDoorSilent() {
        if (this.isBarricaded()) {
            return;
        }
        this.square.InvalidateSpecialObjectPaths();
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            LosUtil.cachecleared[i] = true;
        }
        IsoGridSquare.setRecalcLightTime(-1);
        this.open = !this.open;
        this.sprite = this.closedSprite;
        if (this.open) {
            this.sprite = this.openSprite;
        }
    }

    public boolean isObstructed() {
        return IsoDoor.isDoorObstructed(this);
    }

    @Override
    public boolean haveSheetRope() {
        return IsoWindow.isTopOfSheetRopeHere(this.square, this.north);
    }

    @Override
    public int countAddSheetRope() {
        if (this.isHoppable() || this.isWindow()) {
            return IsoWindow.countAddSheetRope(this.square, this.north);
        }
        return 0;
    }

    @Override
    public boolean canAddSheetRope() {
        if (this.isHoppable() || this.isWindow()) {
            return IsoWindow.canAddSheetRope(this.square, this.north);
        }
        return false;
    }

    @Override
    public boolean addSheetRope(IsoPlayer isoPlayer, String string) {
        if (!this.canAddSheetRope()) {
            return false;
        }
        return IsoWindow.addSheetRope(isoPlayer, this.square, this.north, string);
    }

    @Override
    public boolean removeSheetRope(IsoPlayer isoPlayer) {
        if (this.haveSheetRope()) {
            return IsoWindow.removeSheetRope(isoPlayer, this.square, this.north);
        }
        return false;
    }

    public void createLightSource(int n, int n2, int n3, int n4, int n5, String string, InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter) {
        this.setLightSourceXOffset(n2);
        this.setLightSourceYOffset(n3);
        this.setLightSourceRadius(n);
        this.setLightSourceFuel(string);
        if (inventoryItem != null) {
            if (inventoryItem instanceof DrainableComboItem) {
                this.setLifeLeft(((DrainableComboItem)inventoryItem).getUsedDelta());
                this.setLifeDelta(((DrainableComboItem)inventoryItem).getUseDelta());
                this.setHaveFuel(!"Base.Torch".equals(inventoryItem.getFullType()) || ((DrainableComboItem)inventoryItem).getUsedDelta() > 0.0f);
            } else {
                this.setLifeLeft(1.0f);
                this.setHaveFuel(true);
            }
            isoGameCharacter.removeFromHands(inventoryItem);
            IsoWorldInventoryObject isoWorldInventoryObject = inventoryItem.getWorldItem();
            if (isoWorldInventoryObject != null) {
                if (isoWorldInventoryObject.getSquare() != null) {
                    isoWorldInventoryObject.getSquare().transmitRemoveItemFromSquare(isoWorldInventoryObject);
                    LuaEventManager.triggerEvent("OnContainerUpdate");
                }
            } else if (inventoryItem.getContainer() != null) {
                inventoryItem.getContainer().Remove(inventoryItem);
            }
        }
        this.setLightSourceOn(this.haveFuel);
        if (this.lightSource != null) {
            this.lightSource.setActive(this.isLightSourceOn());
        }
    }

    public InventoryItem insertNewFuel(InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter) {
        if (inventoryItem != null) {
            InventoryItem inventoryItem2 = this.removeCurrentFuel(isoGameCharacter);
            if (isoGameCharacter != null) {
                isoGameCharacter.removeFromHands(inventoryItem);
                isoGameCharacter.getInventory().Remove(inventoryItem);
            }
            if (inventoryItem instanceof DrainableComboItem) {
                this.setLifeLeft(((DrainableComboItem)inventoryItem).getUsedDelta());
                this.setLifeDelta(((DrainableComboItem)inventoryItem).getUseDelta());
            } else {
                this.setLifeLeft(1.0f);
            }
            this.setHaveFuel(true);
            this.toggleLightSource(true);
            return inventoryItem2;
        }
        return null;
    }

    public InventoryItem removeCurrentFuel(IsoGameCharacter isoGameCharacter) {
        if (this.haveFuel()) {
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(this.getLightSourceFuel());
            if (inventoryItem instanceof DrainableComboItem) {
                ((DrainableComboItem)inventoryItem).setUsedDelta(this.getLifeLeft());
            }
            if (isoGameCharacter != null) {
                isoGameCharacter.getInventory().AddItem(inventoryItem);
            }
            this.setLifeLeft(0.0f);
            this.setLifeDelta(-1.0f);
            this.toggleLightSource(false);
            this.setHaveFuel(false);
            return inventoryItem;
        }
        return null;
    }

    private int calcLightSourceX() {
        int n = (int)this.getX();
        int n2 = (int)this.getY();
        if (this.lightSourceXOffset != 0) {
            for (int i = 1; i <= Math.abs(this.lightSourceXOffset); ++i) {
                int n3 = this.lightSourceXOffset > 0 ? 1 : -1;
                LosUtil.TestResults testResults = LosUtil.lineClear(this.getCell(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), n + n3, n2, (int)this.getZ(), false);
                if (testResults == LosUtil.TestResults.Blocked || testResults == LosUtil.TestResults.ClearThroughWindow) break;
                n += n3;
            }
        }
        return n;
    }

    private int calcLightSourceY() {
        int n = (int)this.getX();
        int n2 = (int)this.getY();
        if (this.lightSourceYOffset != 0) {
            for (int i = 1; i <= Math.abs(this.lightSourceYOffset); ++i) {
                int n3 = this.lightSourceYOffset > 0 ? 1 : -1;
                LosUtil.TestResults testResults = LosUtil.lineClear(this.getCell(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), n, n2 + n3, (int)this.getZ(), false);
                if (testResults == LosUtil.TestResults.Blocked || testResults == LosUtil.TestResults.ClearThroughWindow) break;
                n2 += n3;
            }
        }
        return n2;
    }

    @Override
    public void update() {
        int n;
        if (this.getObjectIndex() == -1) {
            return;
        }
        if (!GameServer.bServer) {
            int n2;
            int n3;
            int n4;
            if (this.lightSource != null && !this.lightSource.isInBounds()) {
                this.lightSource = null;
            }
            if (this.lightSourceFuel != null && !this.lightSourceFuel.isEmpty() && this.lightSource == null && this.square != null) {
                n4 = 0;
                n3 = this.calcLightSourceX();
                if (IsoWorld.instance.CurrentCell.isInChunkMap(n3, n = this.calcLightSourceY())) {
                    n2 = this.getLightSourceLife();
                    this.setLightSource(new IsoLightSource(n3, n, (int)this.getZ() + n4, 1.0f, 1.0f, 1.0f, this.lightSourceRadius, n2 > 0 ? n2 : -1));
                    this.lightSource.setActive(this.isLightSourceOn());
                    IsoWorld.instance.getCell().getLamppostPositions().add(this.getLightSource());
                }
            }
            if (this.lightSource != null && this.lightSource.isActive()) {
                n4 = 0;
                n3 = this.calcLightSourceX();
                n = this.calcLightSourceY();
                if (n3 != this.lightSource.x || n != this.lightSource.y) {
                    this.getCell().removeLamppost(this.lightSource);
                    n2 = this.getLightSourceLife();
                    this.setLightSource(new IsoLightSource(n3, n, (int)this.getZ() + n4, 1.0f, 1.0f, 1.0f, this.lightSourceRadius, n2 > 0 ? n2 : -1));
                    this.lightSource.setActive(this.isLightSourceOn());
                    IsoWorld.instance.getCell().getLamppostPositions().add(this.getLightSource());
                }
            }
        }
        if (this.getLifeLeft() > -1.0f) {
            float f = (float)GameTime.getInstance().getWorldAgeHours();
            if (this.lastUpdateHours == -1.0f) {
                this.lastUpdateHours = f;
            } else if (this.lastUpdateHours > f) {
                this.lastUpdateHours = f;
            }
            float f2 = f - this.lastUpdateHours;
            this.lastUpdateHours = f;
            if (this.isLightSourceOn()) {
                this.updateAccumulator += f2;
                n = (int)Math.floor(this.updateAccumulator / 0.004166667f);
                if (n > 0) {
                    this.updateAccumulator -= 0.004166667f * (float)n;
                    this.setLifeLeft(this.getLifeLeft() - this.getLifeDelta() * (float)n);
                    if (this.getLifeLeft() <= 0.0f) {
                        this.setLifeLeft(0.0f);
                        this.toggleLightSource(false);
                    }
                }
            } else {
                this.updateAccumulator = 0.0f;
            }
        }
    }

    void Damage(int n) {
        if (!this.isThumpable()) {
            return;
        }
        this.DirtySlice();
        this.Health -= n;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        if (this.getObjectIndex() == -1) {
            return;
        }
        if (GameClient.bClient) {
            GameClient.instance.sendClientCommandV(null, "object", "OnDestroyIsoThumpable", "x", this.square.getX(), "y", this.square.getY(), "z", this.square.getZ(), "index", this.getObjectIndex());
        }
        LuaEventManager.triggerEvent("OnDestroyIsoThumpable", this, null);
        this.Health = 0;
        this.destroyed = true;
        if (this.getObjectIndex() != -1) {
            this.square.transmitRemoveItemFromSquare(this);
        }
    }

    @Override
    public IsoBarricade getBarricadeOnSameSquare() {
        return IsoBarricade.GetBarricadeOnSquare(this.square, this.north ? IsoDirections.N : IsoDirections.W);
    }

    @Override
    public IsoBarricade getBarricadeOnOppositeSquare() {
        return IsoBarricade.GetBarricadeOnSquare(this.getOppositeSquare(), this.north ? IsoDirections.S : IsoDirections.E);
    }

    @Override
    public boolean isBarricaded() {
        IsoBarricade isoBarricade = this.getBarricadeOnSameSquare();
        if (isoBarricade == null) {
            isoBarricade = this.getBarricadeOnOppositeSquare();
        }
        return isoBarricade != null;
    }

    @Override
    public boolean isBarricadeAllowed() {
        return this.canBarricade;
    }

    @Override
    public IsoBarricade getBarricadeForCharacter(IsoGameCharacter isoGameCharacter) {
        return IsoBarricade.GetBarricadeForCharacter(this, isoGameCharacter);
    }

    @Override
    public IsoBarricade getBarricadeOppositeCharacter(IsoGameCharacter isoGameCharacter) {
        return IsoBarricade.GetBarricadeOppositeCharacter(this, isoGameCharacter);
    }

    public void setIsDoor(Boolean bl) {
        this.isDoor = bl;
    }

    @Override
    public KahluaTable getTable() {
        return this.table;
    }

    @Override
    public void setTable(KahluaTable kahluaTable) {
        this.table = kahluaTable;
    }

    public boolean canBePlastered() {
        return this.canBePlastered;
    }

    public void setCanBePlastered(boolean bl) {
        this.canBePlastered = bl;
    }

    public boolean isPaintable() {
        return this.paintable;
    }

    public void setPaintable(boolean bl) {
        this.paintable = bl;
    }

    public boolean isLocked() {
        return this.Locked;
    }

    public void setIsLocked(boolean bl) {
        this.Locked = bl;
    }

    public boolean isThumpable() {
        if (this.isBarricaded()) {
            return true;
        }
        return this.isThumpable;
    }

    public void setIsThumpable(boolean bl) {
        this.isThumpable = bl;
    }

    public void setIsHoppable(boolean bl) {
        this.setHoppable(bl);
    }

    public IsoSprite getOpenSprite() {
        return this.openSprite;
    }

    @Override
    public boolean isHoppable() {
        if (this.isDoor() && !this.IsOpen() && this.closedSprite != null) {
            PropertyContainer propertyContainer = this.closedSprite.getProperties();
            return propertyContainer.Is(IsoFlagType.HoppableN) || propertyContainer.Is(IsoFlagType.HoppableW);
        }
        if (this.sprite != null && (this.sprite.getProperties().Is(IsoFlagType.HoppableN) || this.sprite.getProperties().Is(IsoFlagType.HoppableW))) {
            return true;
        }
        return this.isHoppable;
    }

    public void setHoppable(boolean bl) {
        this.isHoppable = bl;
    }

    public int getLightSourceRadius() {
        return this.lightSourceRadius;
    }

    public void setLightSourceRadius(int n) {
        this.lightSourceRadius = n;
    }

    public int getLightSourceXOffset() {
        return this.lightSourceXOffset;
    }

    public void setLightSourceXOffset(int n) {
        this.lightSourceXOffset = n;
    }

    public int getLightSourceYOffset() {
        return this.lightSourceYOffset;
    }

    public void setLightSourceYOffset(int n) {
        this.lightSourceYOffset = n;
    }

    public int getLightSourceLife() {
        return this.lightSourceLife;
    }

    public void setLightSourceLife(int n) {
        this.lightSourceLife = n;
    }

    public boolean isLightSourceOn() {
        return this.lightSourceOn;
    }

    public void setLightSourceOn(boolean bl) {
        this.lightSourceOn = bl;
    }

    public IsoLightSource getLightSource() {
        return this.lightSource;
    }

    public void setLightSource(IsoLightSource isoLightSource) {
        this.lightSource = isoLightSource;
    }

    public void toggleLightSource(boolean bl) {
        this.setLightSourceOn(bl);
        if (this.lightSource == null) {
            return;
        }
        this.getLightSource().setActive(bl);
        IsoGridSquare.setRecalcLightTime(-1);
        GameTime.instance.lightSourceUpdate = 100.0f;
    }

    public String getLightSourceFuel() {
        return this.lightSourceFuel;
    }

    public void setLightSourceFuel(String string) {
        if (string != null && string.isEmpty()) {
            string = null;
        }
        this.lightSourceFuel = string;
    }

    public float getLifeLeft() {
        return this.lifeLeft;
    }

    public void setLifeLeft(float f) {
        this.lifeLeft = f;
    }

    public float getLifeDelta() {
        return this.lifeDelta;
    }

    public void setLifeDelta(float f) {
        this.lifeDelta = f;
    }

    public boolean haveFuel() {
        return this.haveFuel;
    }

    public void setHaveFuel(boolean bl) {
        this.haveFuel = bl;
    }

    @Override
    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byte by = (byte)this.square.getObjects().indexOf(this);
        byteBufferWriter.putByte(by);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putByte((byte)0);
        byteBufferWriter.putBoolean(this.open);
        byteBufferWriter.putBoolean(this.Locked);
        byteBufferWriter.putBoolean(this.lockedByKey);
    }

    @Override
    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        if (this.square == null) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " square is null");
            return;
        }
        if (this.getObjectIndex() == -1) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " not found on square " + this.square.getX() + "," + this.square.getY() + "," + this.square.getZ());
            return;
        }
        if (!this.isDoor()) {
            return;
        }
        boolean bl2 = byteBuffer != null && byteBuffer.get() == 1;
        boolean bl3 = byteBuffer != null && byteBuffer.get() == 1;
        boolean bl4 = byteBuffer != null && byteBuffer.get() == 1;
        short s = -1;
        if ((GameServer.bServer || GameClient.bClient) && byteBuffer != null) {
            s = byteBuffer.getShort();
        }
        if (GameClient.bClient && !bl) {
            s = IsoPlayer.getInstance().getOnlineID();
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
            this.syncIsoObjectSend(byteBufferWriter);
            byteBufferWriter.putShort(s);
            PacketTypes.PacketType.SyncIsoObject.send(GameClient.connection);
        } else if (GameServer.bServer && !bl) {
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                this.syncIsoObjectSend(byteBufferWriter);
                byteBufferWriter.putShort(s);
                PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
            }
        } else if (bl) {
            Object object;
            if (GameClient.bClient && s != -1 && (object = GameClient.IDToPlayerMap.get(s)) != null) {
                ((IsoPlayer)object).networkAI.setNoCollision(1000L);
            }
            if (IsoDoor.getDoubleDoorIndex(this) != -1) {
                if (bl2 != this.open) {
                    IsoDoor.toggleDoubleDoor(this, false);
                }
            } else if (bl2) {
                this.open = true;
                this.sprite = this.openSprite;
            } else {
                this.open = false;
                this.sprite = this.closedSprite;
            }
            this.Locked = bl3;
            this.lockedByKey = bl4;
            if (GameServer.bServer) {
                for (UdpConnection udpConnection3 : GameServer.udpEngine.connections) {
                    if (udpConnection == null || udpConnection3.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection3.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    byteBufferWriter.putShort(s);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection3);
                }
            }
            this.square.InvalidateSpecialObjectPaths();
            this.square.RecalcProperties();
            this.square.RecalcAllWithNeighbours(true);
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                LosUtil.cachecleared[i] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
            LuaEventManager.triggerEvent("OnContainerUpdate");
        }
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.getCell().addToProcessIsoObject(this);
    }

    @Override
    public void removeFromWorld() {
        if (this.lightSource != null) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.lightSource);
        }
        super.removeFromWorld();
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        super.saveChange(string, kahluaTable, byteBuffer);
        if ("lightSource".equals(string)) {
            byteBuffer.put(this.lightSourceOn ? (byte)1 : 0);
            byteBuffer.put(this.haveFuel ? (byte)1 : 0);
            byteBuffer.putFloat(this.lifeLeft);
            byteBuffer.putFloat(this.lifeDelta);
        } else if ("paintable".equals(string)) {
            byteBuffer.put(this.isPaintable() ? (byte)1 : 0);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        super.loadChange(string, byteBuffer);
        if ("lightSource".equals(string)) {
            boolean bl = byteBuffer.get() == 1;
            this.haveFuel = byteBuffer.get() == 1;
            this.lifeLeft = byteBuffer.getFloat();
            this.lifeDelta = byteBuffer.getFloat();
            if (bl != this.lightSourceOn) {
                this.toggleLightSource(bl);
            }
        } else if ("paintable".equals(string)) {
            this.setPaintable(byteBuffer.get() == 1);
        }
    }

    public IsoCurtain HasCurtains() {
        IsoCurtain isoCurtain;
        IsoGridSquare isoGridSquare = this.getOppositeSquare();
        if (isoGridSquare != null && (isoCurtain = isoGridSquare.getCurtain(this.getNorth() ? IsoObjectType.curtainS : IsoObjectType.curtainE)) != null) {
            return isoCurtain;
        }
        return this.getSquare().getCurtain(this.getNorth() ? IsoObjectType.curtainN : IsoObjectType.curtainW);
    }

    public IsoGridSquare getInsideSquare() {
        if (this.north) {
            return this.square.getCell().getGridSquare(this.square.getX(), this.square.getY() - 1, this.square.getZ());
        }
        return this.square.getCell().getGridSquare(this.square.getX() - 1, this.square.getY(), this.square.getZ());
    }

    @Override
    public IsoGridSquare getOppositeSquare() {
        return this.getInsideSquare();
    }

    public boolean isAdjacentToSquare(IsoGridSquare isoGridSquare) {
        IsoGridSquare isoGridSquare2 = this.getSquare();
        if (isoGridSquare2 == null || isoGridSquare == null) {
            return false;
        }
        boolean bl = !this.IsOpen();
        IsoGridSquare isoGridSquare3 = isoGridSquare2.getAdjacentSquare(IsoDirections.NW);
        IsoGridSquare isoGridSquare4 = isoGridSquare2.getAdjacentSquare(IsoDirections.N);
        IsoGridSquare isoGridSquare5 = isoGridSquare2.getAdjacentSquare(IsoDirections.NE);
        IsoGridSquare isoGridSquare6 = isoGridSquare2.getAdjacentSquare(IsoDirections.W);
        IsoGridSquare isoGridSquare7 = isoGridSquare2.getAdjacentSquare(IsoDirections.E);
        IsoGridSquare isoGridSquare8 = isoGridSquare2.getAdjacentSquare(IsoDirections.SW);
        IsoGridSquare isoGridSquare9 = isoGridSquare2.getAdjacentSquare(IsoDirections.S);
        IsoGridSquare isoGridSquare10 = isoGridSquare2.getAdjacentSquare(IsoDirections.SE);
        switch (this.getSpriteEdge(false)) {
            case N: {
                if (isoGridSquare == isoGridSquare3) {
                    if (isoGridSquare3.isWallTo(isoGridSquare4) || isoGridSquare3.isWindowTo(isoGridSquare4) || isoGridSquare3.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare4.hasDoorOnEdge(IsoDirections.W, false)) {
                        return false;
                    }
                    if (isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare == isoGridSquare4) {
                    if (isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare == isoGridSquare5) {
                    if (isoGridSquare5.isWallTo(isoGridSquare4) || isoGridSquare5.isWindowTo(isoGridSquare4) || isoGridSquare5.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare4.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    if (isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare == isoGridSquare6) {
                    if (isoGridSquare6.isWallTo(isoGridSquare2) || isoGridSquare6.isWindowTo(isoGridSquare2) || isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.W, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare == isoGridSquare2) {
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare != isoGridSquare7) break;
                if (isoGridSquare7.isWallTo(isoGridSquare2) || isoGridSquare7.isWindowTo(isoGridSquare2) || isoGridSquare7.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.E, false)) {
                    return false;
                }
                return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.N);
            }
            case S: {
                if (isoGridSquare == isoGridSquare6) {
                    if (isoGridSquare6.isWallTo(isoGridSquare2) || isoGridSquare6.isWindowTo(isoGridSquare2) || isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.W, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.S);
                }
                if (isoGridSquare == isoGridSquare2) {
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.S);
                }
                if (isoGridSquare == isoGridSquare7) {
                    if (isoGridSquare7.isWallTo(isoGridSquare2) || isoGridSquare7.isWindowTo(isoGridSquare2) || isoGridSquare7.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.S);
                }
                if (isoGridSquare == isoGridSquare8) {
                    if (isoGridSquare8.isWallTo(isoGridSquare9) || isoGridSquare8.isWindowTo(isoGridSquare9) || isoGridSquare8.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare9.hasDoorOnEdge(IsoDirections.W, false)) {
                        return false;
                    }
                    return !isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false);
                }
                if (isoGridSquare == isoGridSquare9) {
                    return !isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false);
                }
                if (isoGridSquare != isoGridSquare10) break;
                if (isoGridSquare10.isWallTo(isoGridSquare9) || isoGridSquare10.isWindowTo(isoGridSquare9) || isoGridSquare10.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare9.hasDoorOnEdge(IsoDirections.E, false)) {
                    return false;
                }
                return !isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false);
            }
            case W: {
                if (isoGridSquare == isoGridSquare3) {
                    if (isoGridSquare3.isWallTo(isoGridSquare6) || isoGridSquare3.isWindowTo(isoGridSquare6) || isoGridSquare3.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare6.hasDoorOnEdge(IsoDirections.N, false)) {
                        return false;
                    }
                    if (bl && isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare == isoGridSquare6) {
                    if (bl && isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare == isoGridSquare8) {
                    if (isoGridSquare8.isWallTo(isoGridSquare6) || isoGridSquare8.isWindowTo(isoGridSquare6) || isoGridSquare8.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare6.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    if (bl && isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare == isoGridSquare4) {
                    if (isoGridSquare4.isWallTo(isoGridSquare2) || isoGridSquare4.isWindowTo(isoGridSquare2) || isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.N, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare == isoGridSquare2) {
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare != isoGridSquare9) break;
                if (isoGridSquare9.isWallTo(isoGridSquare2) || isoGridSquare9.isWindowTo(isoGridSquare2) || isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.S, false)) {
                    return false;
                }
                return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.W);
            }
            case E: {
                if (isoGridSquare == isoGridSquare4) {
                    if (isoGridSquare4.isWallTo(isoGridSquare2) || isoGridSquare4.isWindowTo(isoGridSquare2) || isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.N, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.E);
                }
                if (isoGridSquare == isoGridSquare2) {
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.E);
                }
                if (isoGridSquare == isoGridSquare9) {
                    if (isoGridSquare9.isWallTo(isoGridSquare2) || isoGridSquare9.isWindowTo(isoGridSquare2) || isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.E);
                }
                if (isoGridSquare == isoGridSquare5) {
                    if (isoGridSquare5.isWallTo(isoGridSquare7) || isoGridSquare5.isWindowTo(isoGridSquare7) || isoGridSquare5.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare6.hasDoorOnEdge(IsoDirections.N, false)) {
                        return false;
                    }
                    return !isoGridSquare7.hasDoorOnEdge(IsoDirections.W, false);
                }
                if (isoGridSquare == isoGridSquare7) {
                    return !isoGridSquare7.hasDoorOnEdge(IsoDirections.W, false);
                }
                if (isoGridSquare != isoGridSquare10) break;
                if (isoGridSquare10.isWallTo(isoGridSquare7) || isoGridSquare10.isWindowTo(isoGridSquare7) || isoGridSquare10.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare7.hasDoorOnEdge(IsoDirections.S, false)) {
                    return false;
                }
                return !isoGridSquare7.hasDoorOnEdge(IsoDirections.E, false);
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public IsoGridSquare getAddSheetSquare(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null || isoGameCharacter.getCurrentSquare() == null) {
            return null;
        }
        IsoGridSquare isoGridSquare = isoGameCharacter.getCurrentSquare();
        IsoGridSquare isoGridSquare2 = this.getSquare();
        if (this.north) {
            if (isoGridSquare.getY() < isoGridSquare2.getY()) {
                return this.getCell().getGridSquare(isoGridSquare2.x, isoGridSquare2.y - 1, isoGridSquare2.z);
            }
            return isoGridSquare2;
        }
        if (isoGridSquare.getX() < isoGridSquare2.getX()) {
            return this.getCell().getGridSquare(isoGridSquare2.x - 1, isoGridSquare2.y, isoGridSquare2.z);
        }
        return isoGridSquare2;
    }

    public void addSheet(IsoGameCharacter isoGameCharacter) {
        IsoObjectType isoObjectType;
        IsoGridSquare isoGridSquare = this.getIndoorSquare();
        if (this.north) {
            isoObjectType = IsoObjectType.curtainN;
            if (isoGridSquare != this.square) {
                isoObjectType = IsoObjectType.curtainS;
            }
        } else {
            isoObjectType = IsoObjectType.curtainW;
            if (isoGridSquare != this.square) {
                isoObjectType = IsoObjectType.curtainE;
            }
        }
        if (isoGameCharacter != null) {
            if (this.north) {
                if (isoGameCharacter.getY() < this.getY()) {
                    isoGridSquare = this.getCell().getGridSquare(this.getX(), this.getY() - 1.0f, this.getZ());
                    isoObjectType = IsoObjectType.curtainS;
                } else {
                    isoGridSquare = this.getSquare();
                    isoObjectType = IsoObjectType.curtainN;
                }
            } else if (isoGameCharacter.getX() < this.getX()) {
                isoGridSquare = this.getCell().getGridSquare(this.getX() - 1.0f, this.getY(), this.getZ());
                isoObjectType = IsoObjectType.curtainE;
            } else {
                isoGridSquare = this.getSquare();
                isoObjectType = IsoObjectType.curtainW;
            }
        }
        if (isoGridSquare == null) {
            return;
        }
        if (isoGridSquare.getCurtain(isoObjectType) != null) {
            return;
        }
        if (isoGridSquare != null) {
            int n = 16;
            if (isoObjectType == IsoObjectType.curtainE) {
                ++n;
            }
            if (isoObjectType == IsoObjectType.curtainS) {
                n += 3;
            }
            if (isoObjectType == IsoObjectType.curtainN) {
                n += 2;
            }
            IsoCurtain isoCurtain = new IsoCurtain(this.getCell(), isoGridSquare, "fixtures_windows_curtains_01_" + (n += 4), this.north);
            isoGridSquare.AddSpecialTileObject(isoCurtain);
            if (GameServer.bServer) {
                isoCurtain.transmitCompleteItemToClients();
                isoGameCharacter.sendObjectChange("removeOneOf", "type", "Sheet");
            } else {
                isoGameCharacter.getInventory().RemoveOneOf("Sheet");
            }
        }
    }

    public IsoGridSquare getIndoorSquare() {
        if (this.square.getRoom() != null) {
            return this.square;
        }
        IsoGridSquare isoGridSquare = this.north ? IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX(), this.square.getY() - 1, this.square.getZ()) : IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX() - 1, this.square.getY(), this.square.getZ());
        if (isoGridSquare == null || isoGridSquare.getFloor() == null) {
            return this.square;
        }
        if (isoGridSquare.getRoom() != null) {
            return isoGridSquare;
        }
        if (this.square.getFloor() == null) {
            return isoGridSquare;
        }
        String string = isoGridSquare.getFloor().getSprite().getName();
        if (string != null && string.startsWith("carpentry_02_")) {
            return isoGridSquare;
        }
        return this.square;
    }

    @Override
    public int getKeyId() {
        return this.keyId;
    }

    public void setKeyId(int n, boolean bl) {
        if (bl && this.keyId != n && GameClient.bClient) {
            this.keyId = n;
            this.syncIsoThumpable();
        } else {
            this.keyId = n;
        }
    }

    @Override
    public void setKeyId(int n) {
        this.setKeyId(n, true);
    }

    public boolean isLockedByKey() {
        return this.lockedByKey;
    }

    public void setLockedByKey(boolean bl) {
        boolean bl2 = bl != this.lockedByKey;
        this.lockedByKey = bl;
        this.setIsLocked(bl);
        if (!GameServer.bServer && bl2) {
            if (bl) {
                this.syncIsoObject(false, (byte)3, null, null);
            } else {
                this.syncIsoObject(false, (byte)4, null, null);
            }
        }
    }

    public boolean isLockedByPadlock() {
        return this.lockedByPadlock;
    }

    public void syncIsoThumpable() {
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.SyncThumpable.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byte by = (byte)this.square.getObjects().indexOf(this);
        if (by == -1) {
            System.out.println("ERROR: Thumpable door not found on square " + this.square.getX() + ", " + this.square.getY() + ", " + this.square.getZ());
            GameClient.connection.cancelPacket();
            return;
        }
        byteBufferWriter.putByte(by);
        byteBufferWriter.putInt(this.getLockedByCode());
        byteBufferWriter.putByte(this.lockedByPadlock ? (byte)1 : 0);
        byteBufferWriter.putInt(this.getKeyId());
        PacketTypes.PacketType.SyncThumpable.send(GameClient.connection);
    }

    public void setLockedByPadlock(boolean bl) {
        if (this.lockedByPadlock != bl && GameClient.bClient) {
            this.lockedByPadlock = bl;
            this.syncIsoThumpable();
        } else {
            this.lockedByPadlock = bl;
        }
    }

    public boolean canBeLockByPadlock() {
        return this.canBeLockByPadlock;
    }

    public void setCanBeLockByPadlock(boolean bl) {
        this.canBeLockByPadlock = bl;
    }

    public int getLockedByCode() {
        return this.lockedByCode;
    }

    public void setLockedByCode(int n) {
        if (this.lockedByCode != n && GameClient.bClient) {
            this.lockedByCode = n;
            this.syncIsoThumpable();
        } else {
            this.lockedByCode = n;
        }
    }

    public boolean isLockedToCharacter(IsoGameCharacter isoGameCharacter) {
        if (GameClient.bClient && isoGameCharacter instanceof IsoPlayer && !((IsoPlayer)isoGameCharacter).accessLevel.equals("")) {
            return false;
        }
        if (this.getLockedByCode() > 0) {
            return true;
        }
        return this.isLockedByPadlock() && (isoGameCharacter.getInventory() == null || isoGameCharacter.getInventory().haveThisKeyId(this.getKeyId()) == null);
    }

    public boolean canClimbOver(IsoGameCharacter isoGameCharacter) {
        if (this.square == null) {
            return false;
        }
        if (!this.isHoppable()) {
            return false;
        }
        return isoGameCharacter == null || IsoWindow.canClimbThroughHelper(isoGameCharacter, this.getSquare(), this.getOppositeSquare(), this.north);
    }

    public boolean canClimbThrough(IsoGameCharacter isoGameCharacter) {
        if (this.square == null) {
            return false;
        }
        if (!this.isWindow()) {
            return false;
        }
        if (this.isBarricaded()) {
            return false;
        }
        return isoGameCharacter == null || IsoWindow.canClimbThroughHelper(isoGameCharacter, this.getSquare(), this.getOppositeSquare(), this.north);
    }

    public String getThumpSound() {
        return this.thumpSound;
    }

    public void setThumpSound(String string) {
        this.thumpSound = string;
    }

    @Override
    public IsoObject getRenderEffectMaster() {
        int n = IsoDoor.getDoubleDoorIndex(this);
        if (n != -1) {
            IsoObject isoObject = null;
            if (n == 2) {
                isoObject = IsoDoor.getDoubleDoorObject(this, 1);
            } else if (n == 3) {
                isoObject = IsoDoor.getDoubleDoorObject(this, 4);
            }
            if (isoObject != null) {
                return isoObject;
            }
        } else {
            IsoObject isoObject = IsoDoor.getGarageDoorFirst(this);
            if (isoObject != null) {
                return isoObject;
            }
        }
        return this;
    }

    public IsoDirections getSpriteEdge(boolean bl) {
        if (!this.isDoor() && !this.isWindow()) {
            return null;
        }
        if (!this.open || bl) {
            return this.north ? IsoDirections.N : IsoDirections.W;
        }
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null && propertyContainer.Is(IsoFlagType.attachedE)) {
            return IsoDirections.E;
        }
        if (propertyContainer != null && propertyContainer.Is(IsoFlagType.attachedS)) {
            return IsoDirections.S;
        }
        return this.north ? IsoDirections.W : IsoDirections.N;
    }

    private String getSoundPrefix() {
        if (this.closedSprite == null) {
            return "WoodDoor";
        }
        PropertyContainer propertyContainer = this.closedSprite.getProperties();
        if (propertyContainer.Is("DoorSound")) {
            return propertyContainer.Val("DoorSound");
        }
        return "WoodDoor";
    }

    private void playDoorSound(BaseCharacterSoundEmitter baseCharacterSoundEmitter, String string) {
        baseCharacterSoundEmitter.playSound(this.getSoundPrefix() + string, this);
    }
}

