/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Rand;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.iso.objects.IsoWaveSignal;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.radio.ZomboidRadio;

public class IsoTelevision
extends IsoWaveSignal {
    protected ArrayList<IsoSprite> screenSprites = new ArrayList();
    protected boolean defaultToNoise = false;
    private IsoSprite cacheObjectSprite;
    protected IsoDirections facing = IsoDirections.Max;
    private boolean hasSetupScreens = false;
    private boolean tickIsLightUpdate = false;
    private Screens currentScreen = Screens.OFFSCREEN;
    private int spriteIndex = 0;

    @Override
    public String getObjectName() {
        return "Television";
    }

    public IsoTelevision(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoTelevision(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
    }

    @Override
    protected void init(boolean bl) {
        super.init(bl);
    }

    private void setupDefaultScreens() {
        this.hasSetupScreens = true;
        this.cacheObjectSprite = this.sprite;
        if (this.screenSprites.size() == 0) {
            for (int i = 16; i <= 64; i += 16) {
                Object object = IsoSprite.getSprite(IsoSpriteManager.instance, this.sprite.getName(), i);
                if (object == null) continue;
                this.addTvScreenSprite((IsoSprite)object);
            }
        }
        this.facing = IsoDirections.Max;
        if (this.sprite != null && this.sprite.getProperties().Is("Facing")) {
            String string = this.sprite.getProperties().Val("Facing");
            switch (string) {
                case "N": {
                    this.facing = IsoDirections.N;
                    break;
                }
                case "S": {
                    this.facing = IsoDirections.S;
                    break;
                }
                case "W": {
                    this.facing = IsoDirections.W;
                    break;
                }
                case "E": {
                    this.facing = IsoDirections.E;
                }
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.cacheObjectSprite != null && this.cacheObjectSprite != this.sprite) {
            this.hasSetupScreens = false;
            this.screenSprites.clear();
            this.currentScreen = Screens.OFFSCREEN;
            this.nextLightUpdate = 0.0f;
        }
        if (!this.hasSetupScreens) {
            this.setupDefaultScreens();
        }
        this.updateTvScreen();
    }

    @Override
    protected void updateLightSource() {
        this.tickIsLightUpdate = false;
        if (this.lightSource == null) {
            this.lightSource = new IsoLightSource(this.square.getX(), this.square.getY(), this.square.getZ(), 0.0f, 0.0f, 1.0f, this.lightSourceRadius);
            this.lightWasRemoved = true;
        }
        if (this.lightWasRemoved) {
            IsoWorld.instance.CurrentCell.addLamppost(this.lightSource);
            IsoGridSquare.RecalcLightTime = -1;
            GameTime.instance.lightSourceUpdate = 100.0f;
            this.lightWasRemoved = false;
        }
        this.lightUpdateCnt += GameTime.getInstance().getMultiplier();
        if (this.lightUpdateCnt >= this.nextLightUpdate) {
            float f = 300.0f;
            float f2 = 0.0f;
            if (!this.hasChatToDisplay()) {
                f2 = 0.6f;
                f = Rand.Next(200, 400);
            } else {
                f = Rand.Next(15, 300);
            }
            float f3 = Rand.Next(f2, 1.0f);
            this.tickIsLightUpdate = true;
            float f4 = 0.58f + 0.25f * f3;
            float f5 = Rand.Next(0.65f, 0.85f);
            int n = 1 + (int)((float)(this.lightSourceRadius - 1) * f3);
            IsoGridSquare.RecalcLightTime = -1;
            GameTime.instance.lightSourceUpdate = 100.0f;
            this.lightSource.setRadius(n);
            this.lightSource.setR(f4);
            this.lightSource.setG(f5);
            this.lightSource.setB(f5);
            if (LightingJNI.init && this.lightSource.ID != 0) {
                LightingJNI.setLightColor(this.lightSource.ID, this.lightSource.getR(), this.lightSource.getG(), this.lightSource.getB());
            }
            this.lightUpdateCnt = 0.0f;
            this.nextLightUpdate = f;
        }
    }

    private void setScreen(Screens screens) {
        if (screens == Screens.OFFSCREEN) {
            this.currentScreen = Screens.OFFSCREEN;
            if (this.overlaySprite != null) {
                this.overlaySprite = null;
            }
            return;
        }
        if (this.currentScreen != screens || screens == Screens.ALTERNATESCREEN) {
            this.currentScreen = screens;
            IsoSprite isoSprite = null;
            switch (screens) {
                case TESTSCREEN: {
                    if (this.screenSprites.size() <= 0) break;
                    isoSprite = this.screenSprites.get(0);
                    break;
                }
                case DEFAULTSCREEN: {
                    if (this.screenSprites.size() <= 1) break;
                    isoSprite = this.screenSprites.get(1);
                    break;
                }
                case ALTERNATESCREEN: {
                    if (this.screenSprites.size() < 2) break;
                    if (this.screenSprites.size() == 2) {
                        isoSprite = this.screenSprites.get(1);
                        break;
                    }
                    if (this.screenSprites.size() <= 2) break;
                    ++this.spriteIndex;
                    if (this.spriteIndex < 1) {
                        this.spriteIndex = 1;
                    }
                    if (this.spriteIndex > this.screenSprites.size() - 1) {
                        this.spriteIndex = 1;
                    }
                    isoSprite = this.screenSprites.get(this.spriteIndex);
                }
            }
            this.overlaySprite = isoSprite;
        }
    }

    protected void updateTvScreen() {
        if (this.deviceData != null && this.deviceData.getIsTurnedOn() && this.screenSprites.size() > 0) {
            if (this.deviceData.isReceivingSignal() || this.deviceData.isPlayingMedia()) {
                if (this.tickIsLightUpdate || this.currentScreen != Screens.ALTERNATESCREEN) {
                    this.setScreen(Screens.ALTERNATESCREEN);
                }
            } else if (ZomboidRadio.POST_RADIO_SILENCE) {
                this.setScreen(Screens.TESTSCREEN);
            } else {
                this.setScreen(Screens.DEFAULTSCREEN);
            }
        } else if (this.currentScreen != Screens.OFFSCREEN) {
            this.setScreen(Screens.OFFSCREEN);
        }
    }

    public void addTvScreenSprite(IsoSprite isoSprite) {
        this.screenSprites.add(isoSprite);
    }

    public void clearTvScreenSprites() {
        this.screenSprites.clear();
    }

    public void removeTvScreenSprite(IsoSprite isoSprite) {
        this.screenSprites.remove(isoSprite);
    }

    @Override
    public void renderlast() {
        super.renderlast();
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.overlaySprite = null;
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
    }

    public boolean isFacing(IsoPlayer isoPlayer) {
        if (isoPlayer == null || !isoPlayer.isLocalPlayer()) {
            return false;
        }
        if (this.getObjectIndex() == -1) {
            return false;
        }
        if (!this.square.isCanSee(isoPlayer.PlayerIndex)) {
            return false;
        }
        if (this.facing == IsoDirections.Max) {
            return false;
        }
        switch (this.facing) {
            case N: {
                if (isoPlayer.y >= (float)this.square.y) {
                    return false;
                }
                return isoPlayer.dir == IsoDirections.SW || isoPlayer.dir == IsoDirections.S || isoPlayer.dir == IsoDirections.SE;
            }
            case S: {
                if (isoPlayer.y < (float)(this.square.y + 1)) {
                    return false;
                }
                return isoPlayer.dir == IsoDirections.NW || isoPlayer.dir == IsoDirections.N || isoPlayer.dir == IsoDirections.NE;
            }
            case W: {
                if (isoPlayer.x >= (float)this.square.x) {
                    return false;
                }
                return isoPlayer.dir == IsoDirections.SE || isoPlayer.dir == IsoDirections.E || isoPlayer.dir == IsoDirections.NE;
            }
            case E: {
                if (isoPlayer.x < (float)(this.square.x + 1)) {
                    return false;
                }
                return isoPlayer.dir == IsoDirections.SW || isoPlayer.dir == IsoDirections.W || isoPlayer.dir == IsoDirections.NW;
            }
        }
        return false;
    }

    private static enum Screens {
        OFFSCREEN,
        TESTSCREEN,
        DEFAULTSCREEN,
        ALTERNATESCREEN;

    }
}

