/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameTime;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.audio.BaseSoundEmitter;
import zombie.core.Rand;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.InventoryItem;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.interfaces.Activatable;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteGrid;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.util.Type;

public class IsoStove
extends IsoObject
implements Activatable {
    private static final ArrayList<IsoObject> s_tempObjects = new ArrayList();
    boolean activated = false;
    long soundInstance = -1L;
    private float maxTemperature = 0.0f;
    private double stopTime;
    private double startTime;
    private float currentTemperature = 0.0f;
    private int secondsTimer = -1;
    private boolean firstTurnOn = true;
    private boolean broken = false;
    private boolean hasMetal = false;

    public IsoStove(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
    }

    @Override
    public String getObjectName() {
        return "Stove";
    }

    public IsoStove(IsoCell isoCell) {
        super(isoCell);
    }

    @Override
    public boolean Activated() {
        return this.activated;
    }

    @Override
    public void update() {
        boolean bl;
        if (this.Activated() && (this.container == null || !this.container.isPowered())) {
            this.setActivated(false);
            if (this.container != null) {
                this.container.addItemsToProcessItems();
            }
        }
        if (this.Activated() && this.isMicrowave() && this.stopTime > 0.0 && this.stopTime < GameTime.instance.getWorldAgeHours()) {
            this.setActivated(false);
        }
        boolean bl2 = bl = GameServer.bServer || !GameClient.bClient && !GameServer.bServer;
        if (bl && this.Activated() && this.hasMetal && Rand.Next(Rand.AdjustForFramerate(200)) == 100) {
            IsoFireManager.StartFire(this.container.SourceGrid.getCell(), this.container.SourceGrid, true, 10000);
            this.setBroken(true);
            this.activated = false;
            this.stopTime = 0.0;
            this.startTime = 0.0;
            this.secondsTimer = -1;
        }
        if (GameServer.bServer) {
            return;
        }
        if (this.Activated()) {
            if (this.stopTime > 0.0 && this.stopTime < GameTime.instance.getWorldAgeHours()) {
                if (!this.isMicrowave() && "stove".equals(this.container.getType()) && this.isSpriteGridOriginObject()) {
                    BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, (int)this.getZ());
                    baseSoundEmitter.playSoundImpl("StoveTimerExpired", this);
                }
                this.stopTime = 0.0;
                this.startTime = 0.0;
                this.secondsTimer = -1;
            }
            if (this.getMaxTemperature() > 0.0f && this.currentTemperature < this.getMaxTemperature()) {
                float f = (this.getMaxTemperature() - this.currentTemperature) / 700.0f;
                if (f < 0.05f) {
                    f = 0.05f;
                }
                this.currentTemperature += f * GameTime.instance.getMultiplier();
                if (this.currentTemperature > this.getMaxTemperature()) {
                    this.currentTemperature = this.getMaxTemperature();
                }
            } else if (this.currentTemperature > this.getMaxTemperature()) {
                this.currentTemperature -= (this.currentTemperature - this.getMaxTemperature()) / 1000.0f * GameTime.instance.getMultiplier();
                if (this.currentTemperature < 0.0f) {
                    this.currentTemperature = 0.0f;
                }
            }
        } else if (this.currentTemperature > 0.0f) {
            this.currentTemperature -= 0.1f * GameTime.instance.getMultiplier();
            this.currentTemperature = Math.max(this.currentTemperature, 0.0f);
        }
        if (this.container != null && this.isMicrowave()) {
            this.currentTemperature = this.Activated() ? this.getMaxTemperature() : 0.0f;
        }
        if (this.isSpriteGridOriginObject() && this.emitter != null) {
            if (this.Activated() && this.secondsTimer > 0) {
                if (!this.emitter.isPlaying("StoveTimer")) {
                    this.emitter.playSoundImpl("StoveTimer", this);
                }
            } else if (this.emitter.isPlaying("StoveTimer")) {
                this.emitter.stopSoundByName("StoveTimer");
            }
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        if (n >= 28) {
            boolean bl2 = this.activated = byteBuffer.get() == 1;
        }
        if (n >= 106) {
            this.secondsTimer = byteBuffer.getInt();
            this.maxTemperature = byteBuffer.getFloat();
            this.firstTurnOn = byteBuffer.get() == 1;
            boolean bl3 = this.broken = byteBuffer.get() == 1;
        }
        if (SystemDisabler.doObjectStateSyncEnable && GameClient.bClient) {
            GameClient.instance.objectSyncReq.putRequestLoad(this.square);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.activated ? (byte)1 : 0);
        byteBuffer.putInt(this.secondsTimer);
        byteBuffer.putFloat(this.maxTemperature);
        byteBuffer.put(this.firstTurnOn ? (byte)1 : 0);
        byteBuffer.put(this.broken ? (byte)1 : 0);
    }

    @Override
    public void addToWorld() {
        if (this.container == null) {
            return;
        }
        IsoCell isoCell = this.getCell();
        isoCell.addToProcessIsoObject(this);
        this.container.addItemsToProcessItems();
        this.setActivated(this.activated);
    }

    @Override
    public void Toggle() {
        SoundManager.instance.PlayWorldSound(this.isMicrowave() ? "ToggleMicrowave" : "ToggleStove", this.getSquare(), 1.0f, 1.0f, 1.0f, false);
        this.setActivated(!this.activated);
        this.container.addItemsToProcessItems();
        IsoGenerator.updateGenerator(this.square);
        this.syncIsoObject(false, this.activated ? (byte)1 : 0, null, null);
        this.syncSpriteGridObjects(true, true);
    }

    public void sync() {
        this.syncIsoObject(false, this.activated ? (byte)1 : 0, null, null);
    }

    private void doSound() {
        if (GameServer.bServer) {
            this.hasMetal();
            return;
        }
        if (!this.isSpriteGridOriginObject()) {
            return;
        }
        if (this.isMicrowave()) {
            if (this.activated) {
                if (this.emitter != null) {
                    if (this.soundInstance != -1L) {
                        this.emitter.stopSound(this.soundInstance);
                    }
                    this.emitter.stopSoundByName("StoveTimer");
                }
                this.emitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, (int)this.getZ());
                IsoWorld.instance.setEmitterOwner(this.emitter, this);
                this.soundInstance = this.hasMetal() ? this.emitter.playSoundLoopedImpl("MicrowaveCookingMetal") : this.emitter.playSoundLoopedImpl("MicrowaveRunning");
            } else if (this.soundInstance != -1L) {
                if (this.emitter != null) {
                    this.emitter.stopSound(this.soundInstance);
                    this.emitter.stopSoundByName("StoveTimer");
                    this.emitter = null;
                }
                this.soundInstance = -1L;
                if (this.container != null && this.container.isPowered()) {
                    BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, (int)this.getZ());
                    baseSoundEmitter.playSoundImpl("MicrowaveTimerExpired", this);
                }
            }
        } else if (this.getContainer() != null && "stove".equals(this.container.getType())) {
            if (this.Activated()) {
                if (this.emitter == null) {
                    this.emitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, (int)this.getZ());
                    IsoWorld.instance.setEmitterOwner(this.emitter, this);
                    this.soundInstance = this.emitter.playSoundLoopedImpl("StoveRunning");
                } else if (!this.emitter.isPlaying("StoveRunning")) {
                    this.soundInstance = this.emitter.playSoundLoopedImpl("StoveRunning");
                }
            } else if (this.soundInstance != -1L) {
                if (this.emitter != null) {
                    this.emitter.stopSound(this.soundInstance);
                    this.emitter.stopSoundByName("StoveTimer");
                    this.emitter = null;
                }
                this.soundInstance = -1L;
            }
        }
    }

    private boolean hasMetal() {
        int n = this.getContainer().getItems().size();
        for (int i = 0; i < n; ++i) {
            InventoryItem inventoryItem = this.getContainer().getItems().get(i);
            if (!(inventoryItem.getMetalValue() > 0.0f) && !inventoryItem.hasTag("HasMetal")) continue;
            this.hasMetal = true;
            return true;
        }
        this.hasMetal = false;
        return false;
    }

    @Override
    public String getActivatableType() {
        return "stove";
    }

    @Override
    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byte by = (byte)this.square.getObjects().indexOf(this);
        byteBufferWriter.putByte(by);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putByte(this.activated ? (byte)1 : 0);
        byteBufferWriter.putInt(this.secondsTimer);
        byteBufferWriter.putFloat(this.maxTemperature);
    }

    @Override
    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        if (this.square == null) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " square is null");
            return;
        }
        if (this.getObjectIndex() == -1) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " not found on square " + this.square.getX() + "," + this.square.getY() + "," + this.square.getZ());
            return;
        }
        if (GameClient.bClient && !bl) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
            this.syncIsoObjectSend(byteBufferWriter);
            PacketTypes.PacketType.SyncIsoObject.send(GameClient.connection);
        } else if (bl) {
            boolean bl2 = by == 1;
            this.secondsTimer = byteBuffer.getInt();
            this.maxTemperature = byteBuffer.getFloat();
            this.setActivated(bl2);
            this.container.addItemsToProcessItems();
            if (GameServer.bServer) {
                for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                    if (udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
                }
            }
        }
    }

    public void setActivated(boolean bl) {
        if (this.isBroken()) {
            return;
        }
        this.activated = bl;
        if (this.firstTurnOn && this.getMaxTemperature() == 0.0f) {
            if (this.isMicrowave() && this.secondsTimer < 0) {
                this.maxTemperature = 100.0f;
            }
            if ("stove".equals(this.getContainer().getType()) && this.secondsTimer < 0) {
                this.maxTemperature = 200.0f;
            }
        }
        if (this.firstTurnOn) {
            this.firstTurnOn = false;
        }
        if (this.activated) {
            if (this.isMicrowave() && this.secondsTimer < 0) {
                this.secondsTimer = 3600;
            }
            if (this.secondsTimer > 0) {
                this.startTime = GameTime.instance.getWorldAgeHours();
                this.stopTime = this.startTime + (double)this.secondsTimer / 3600.0;
            }
        } else {
            this.stopTime = 0.0;
            this.startTime = 0.0;
            this.hasMetal = false;
        }
        this.doSound();
        this.doOverlay();
    }

    private void doOverlay() {
        if (this.Activated() && this.getOverlaySprite() == null) {
            String[] stringArray = this.getSprite().getName().split("_");
            String string = stringArray[0] + "_" + stringArray[1] + "_ON_" + stringArray[2] + "_" + stringArray[3];
            this.setOverlaySprite(string);
        } else if (!this.Activated()) {
            this.setOverlaySprite(null);
        }
    }

    public void setTimer(int n) {
        this.secondsTimer = n;
        if (this.activated && this.secondsTimer > 0) {
            this.startTime = GameTime.instance.getWorldAgeHours();
            this.stopTime = this.startTime + (double)this.secondsTimer / 3600.0;
        }
    }

    public int getTimer() {
        return this.secondsTimer;
    }

    public float getMaxTemperature() {
        return this.maxTemperature;
    }

    public void setMaxTemperature(float f) {
        this.maxTemperature = f;
    }

    public boolean isMicrowave() {
        return this.getContainer() != null && this.getContainer().isMicrowave();
    }

    public int isRunningFor() {
        if (this.startTime == 0.0) {
            return 0;
        }
        return (int)((GameTime.instance.getWorldAgeHours() - this.startTime) * 3600.0);
    }

    public float getCurrentTemperature() {
        return this.currentTemperature + 100.0f;
    }

    public boolean isTemperatureChanging() {
        return this.currentTemperature != (this.activated ? this.maxTemperature : 0.0f);
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean bl) {
        this.broken = bl;
    }

    private boolean isSpriteGridOriginObject() {
        IsoSprite isoSprite = this.getSprite();
        if (isoSprite == null) {
            return false;
        }
        IsoSpriteGrid isoSpriteGrid = isoSprite.getSpriteGrid();
        if (isoSpriteGrid == null) {
            return true;
        }
        int n = isoSpriteGrid.getSpriteGridPosX(isoSprite);
        int n2 = isoSpriteGrid.getSpriteGridPosY(isoSprite);
        return n == 0 && n2 == 0;
    }

    public void syncSpriteGridObjects(boolean bl, boolean bl2) {
        this.getSpriteGridObjects(s_tempObjects);
        for (int i = s_tempObjects.size() - 1; i >= 0; --i) {
            IsoStove isoStove = Type.tryCastTo(s_tempObjects.get(i), IsoStove.class);
            if (isoStove == null || isoStove == this) continue;
            isoStove.activated = this.activated;
            isoStove.maxTemperature = this.maxTemperature;
            isoStove.firstTurnOn = this.firstTurnOn;
            isoStove.secondsTimer = this.secondsTimer;
            isoStove.startTime = this.startTime;
            isoStove.stopTime = this.stopTime;
            isoStove.hasMetal = this.hasMetal;
            isoStove.doOverlay();
            isoStove.doSound();
            if (bl) {
                if (isoStove.container != null) {
                    isoStove.container.addItemsToProcessItems();
                }
                IsoGenerator.updateGenerator(isoStove.square);
            }
            if (!bl2) continue;
            isoStove.sync();
        }
    }
}

