/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.core.math.PZMath;
import zombie.core.properties.PropertyContainer;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.objects.ClothingDryerLogic;
import zombie.iso.objects.ClothingWasherLogic;
import zombie.iso.sprite.IsoSprite;

public class IsoStackedWasherDryer
extends IsoObject {
    private final ClothingWasherLogic m_washer = new ClothingWasherLogic(this);
    private final ClothingDryerLogic m_dryer = new ClothingDryerLogic(this);

    public IsoStackedWasherDryer(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoStackedWasherDryer(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
    }

    @Override
    public String getObjectName() {
        return "StackedWasherDryer";
    }

    @Override
    public void createContainersFromSpriteProperties() {
        ItemContainer itemContainer;
        super.createContainersFromSpriteProperties();
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer == null) {
            return;
        }
        if (this.getContainerByType("clothingwasher") == null) {
            itemContainer = new ItemContainer("clothingwasher", this.getSquare(), this);
            if (propertyContainer.Is("ContainerCapacity")) {
                itemContainer.Capacity = PZMath.tryParseInt(propertyContainer.Val("ContainerCapacity"), 20);
            }
            if (this.getContainer() == null) {
                this.setContainer(itemContainer);
            } else {
                this.addSecondaryContainer(itemContainer);
            }
        }
        if (this.getContainerByType("clothingdryer") == null) {
            itemContainer = new ItemContainer("clothingdryer", this.getSquare(), this);
            if (propertyContainer.Is("ContainerCapacity")) {
                itemContainer.Capacity = PZMath.tryParseInt(propertyContainer.Val("ContainerCapacity"), 20);
            }
            if (this.getContainer() == null) {
                this.setContainer(itemContainer);
            } else {
                this.addSecondaryContainer(itemContainer);
            }
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.m_washer.load(byteBuffer, n, bl);
        this.m_dryer.load(byteBuffer, n, bl);
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        this.m_washer.save(byteBuffer, bl);
        this.m_dryer.save(byteBuffer, bl);
    }

    @Override
    public void update() {
        this.m_washer.update();
        this.m_dryer.update();
    }

    @Override
    public void addToWorld() {
        IsoCell isoCell = this.getCell();
        isoCell.addToProcessIsoObject(this);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        this.m_washer.saveChange(string, kahluaTable, byteBuffer);
        this.m_dryer.saveChange(string, kahluaTable, byteBuffer);
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        this.m_washer.loadChange(string, byteBuffer);
        this.m_dryer.loadChange(string, byteBuffer);
    }

    @Override
    public boolean isItemAllowedInContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        return this.m_washer.isItemAllowedInContainer(itemContainer, inventoryItem) || this.m_dryer.isItemAllowedInContainer(itemContainer, inventoryItem);
    }

    @Override
    public boolean isRemoveItemAllowedFromContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        return this.m_washer.isRemoveItemAllowedFromContainer(itemContainer, inventoryItem) || this.m_dryer.isRemoveItemAllowedFromContainer(itemContainer, inventoryItem);
    }

    public boolean isWasherActivated() {
        return this.m_washer.isActivated();
    }

    public void setWasherActivated(boolean bl) {
        this.m_washer.setActivated(bl);
    }

    public boolean isDryerActivated() {
        return this.m_dryer.isActivated();
    }

    public void setDryerActivated(boolean bl) {
        this.m_dryer.setActivated(bl);
    }
}

