/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.RainManager;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;

public class IsoRaindrop
extends IsoObject {
    public int AnimSpriteIndex;
    public float GravMod;
    public int Life;
    public float SplashY;
    public float OffsetY;
    public float Vel_Y;

    @Override
    public boolean Serialize() {
        return false;
    }

    public IsoRaindrop(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl) {
        if (!bl) {
            return;
        }
        if (isoGridSquare == null) {
            return;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.HasRaindrop)) {
            return;
        }
        this.Life = 0;
        this.square = isoGridSquare;
        int n = 1 * Core.TileScale;
        int n2 = 64 * Core.TileScale;
        float f = Rand.Next(0.1f, 0.9f);
        float f2 = Rand.Next(0.1f, 0.9f);
        short s = (short)(IsoUtils.XToScreen(f, f2, 0.0f, 0) - (float)(n / 2));
        short s2 = (short)(IsoUtils.YToScreen(f, f2, 0.0f, 0) - (float)n2);
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.OffsetY = RainManager.RaindropStartDistance;
        this.SplashY = s2;
        this.AttachAnim("Rain", "00", 1, 0.0f, -s, -s2, true, 0, false, 0.7f, RainManager.RaindropTintMod);
        this.AnimSpriteIndex = this.AttachedAnimSprite != null ? this.AttachedAnimSprite.size() - 1 : 0;
        ((IsoSpriteInstance)this.AttachedAnimSprite.get(this.AnimSpriteIndex)).setScale(Core.TileScale, Core.TileScale);
        isoGridSquare.getProperties().Set(IsoFlagType.HasRaindrop);
        this.Vel_Y = 0.0f;
        float f3 = 1000000.0f / (float)Rand.Next(1000000) + 1.0E-5f;
        this.GravMod = -(RainManager.GravModMin + (RainManager.GravModMax - RainManager.GravModMin) * f3);
        RainManager.AddRaindrop(this);
    }

    @Override
    public boolean HasTooltip() {
        return false;
    }

    @Override
    public String getObjectName() {
        return "RainDrops";
    }

    public boolean TestCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare) {
        return this.square == isoGridSquare;
    }

    @Override
    public IsoObject.VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        return IsoObject.VisionResult.NoEffect;
    }

    public void ChangeTintMod(ColorInfo colorInfo) {
    }

    @Override
    public void update() {
        int n;
        this.sy = 0.0f;
        this.sx = 0.0f;
        ++this.Life;
        for (n = 0; n < this.AttachedAnimSprite.size(); ++n) {
            IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)this.AttachedAnimSprite.get(n);
            isoSpriteInstance.update();
            isoSpriteInstance.Frame += isoSpriteInstance.AnimFrameIncrease * (GameTime.instance.getMultipliedSecondsSinceLastUpdate() * 60.0f);
            IsoSprite isoSprite = isoSpriteInstance.parentSprite;
            if ((int)isoSpriteInstance.Frame < isoSprite.CurrentAnim.Frames.size() || !isoSprite.Loop || !isoSpriteInstance.Looped) continue;
            isoSpriteInstance.Frame = 0.0f;
        }
        this.Vel_Y += this.GravMod * (GameTime.instance.getMultipliedSecondsSinceLastUpdate() * 60.0f);
        this.OffsetY += this.Vel_Y;
        if (this.AttachedAnimSprite != null && this.AttachedAnimSprite.size() > this.AnimSpriteIndex && this.AnimSpriteIndex >= 0) {
            ((IsoSpriteInstance)this.AttachedAnimSprite.get((int)this.AnimSpriteIndex)).parentSprite.soffY = (short)(this.SplashY + (float)((int)this.OffsetY));
        }
        if (this.OffsetY < 0.0f) {
            this.OffsetY = RainManager.RaindropStartDistance;
            this.Vel_Y = 0.0f;
            float f = 1000000.0f / (float)Rand.Next(1000000) + 1.0E-5f;
            this.GravMod = -(RainManager.GravModMin + (RainManager.GravModMax - RainManager.GravModMin) * f);
        }
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null) {
                this.setAlphaAndTarget(n, 0.55f);
                continue;
            }
            this.setAlphaAndTarget(n, 1.0f);
        }
    }

    void Reset(IsoGridSquare isoGridSquare, boolean bl) {
        if (!bl) {
            return;
        }
        if (isoGridSquare == null) {
            return;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.HasRaindrop)) {
            return;
        }
        this.Life = 0;
        this.square = isoGridSquare;
        this.OffsetY = RainManager.RaindropStartDistance;
        this.AnimSpriteIndex = this.AttachedAnimSprite != null ? this.AttachedAnimSprite.size() - 1 : 0;
        isoGridSquare.getProperties().Set(IsoFlagType.HasRaindrop);
        this.Vel_Y = 0.0f;
        float f = 1000000.0f / (float)Rand.Next(1000000) + 1.0E-5f;
        this.GravMod = -(RainManager.GravModMin + (RainManager.GravModMax - RainManager.GravModMin) * f);
        RainManager.AddRaindrop(this);
    }
}

