/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import fmod.fmod.Audio;
import zombie.SoundManager;
import zombie.WorldSoundManager;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;

public class IsoJukebox
extends IsoObject {
    private Audio JukeboxTrack = null;
    private boolean IsPlaying = false;
    private float MusicRadius = 30.0f;
    private boolean Activated = false;
    private int WorldSoundPulseRate = 150;
    private int WorldSoundPulseDelay = 0;

    public IsoJukebox(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
    }

    @Override
    public String getObjectName() {
        return "Jukebox";
    }

    public IsoJukebox(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoJukebox(IsoCell isoCell, IsoGridSquare isoGridSquare, String string) {
        super(isoCell, isoGridSquare, string);
        this.JukeboxTrack = null;
        this.IsPlaying = false;
        this.Activated = false;
        this.WorldSoundPulseDelay = 0;
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.getCell().addToStaticUpdaterObjectList(this);
    }

    public void SetPlaying(boolean bl) {
        if (this.IsPlaying == bl) {
            return;
        }
        this.IsPlaying = bl;
        if (this.IsPlaying && this.JukeboxTrack == null) {
            String string = null;
            switch (Rand.Next(4)) {
                case 0: {
                    string = "paws1";
                    break;
                }
                case 1: {
                    string = "paws2";
                    break;
                }
                case 2: {
                    string = "paws3";
                    break;
                }
                case 3: {
                    string = "paws4";
                }
            }
            this.JukeboxTrack = SoundManager.instance.PlaySound(string, false, 0.0f);
        }
    }

    @Override
    public boolean onMouseLeftClick(int n, int n2) {
        IsoPlayer isoPlayer = IsoPlayer.getInstance();
        if (isoPlayer == null || isoPlayer.isDead()) {
            return false;
        }
        if (IsoPlayer.getInstance().getCurrentSquare() == null) {
            return false;
        }
        float f = 0.0f;
        int n3 = Math.abs(this.square.getX() - IsoPlayer.getInstance().getCurrentSquare().getX()) + Math.abs(this.square.getY() - IsoPlayer.getInstance().getCurrentSquare().getY() + Math.abs(this.square.getZ() - IsoPlayer.getInstance().getCurrentSquare().getZ()));
        if (n3 < 4) {
            if (!this.Activated) {
                if (Core.NumJukeBoxesActive < Core.MaxJukeBoxesActive) {
                    this.WorldSoundPulseDelay = 0;
                    this.Activated = true;
                    this.SetPlaying(true);
                    ++Core.NumJukeBoxesActive;
                }
            } else {
                this.WorldSoundPulseDelay = 0;
                this.SetPlaying(false);
                this.Activated = false;
                if (this.JukeboxTrack != null) {
                    SoundManager.instance.StopSound(this.JukeboxTrack);
                    this.JukeboxTrack.stop();
                    this.JukeboxTrack = null;
                }
                --Core.NumJukeBoxesActive;
            }
        }
        return true;
    }

    @Override
    public void update() {
        if (IsoPlayer.getInstance() == null) {
            return;
        }
        if (IsoPlayer.getInstance().getCurrentSquare() == null) {
            return;
        }
        if (this.Activated) {
            float f = 0.0f;
            int n = Math.abs(this.square.getX() - IsoPlayer.getInstance().getCurrentSquare().getX()) + Math.abs(this.square.getY() - IsoPlayer.getInstance().getCurrentSquare().getY() + Math.abs(this.square.getZ() - IsoPlayer.getInstance().getCurrentSquare().getZ()));
            if ((float)n < this.MusicRadius) {
                this.SetPlaying(true);
                f = (this.MusicRadius - (float)n) / this.MusicRadius;
            }
            if (this.JukeboxTrack != null) {
                float f2 = f + 0.2f;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                SoundManager.instance.BlendVolume(this.JukeboxTrack, f);
                if (this.WorldSoundPulseDelay > 0) {
                    --this.WorldSoundPulseDelay;
                }
                if (this.WorldSoundPulseDelay == 0) {
                    WorldSoundManager.instance.addSound(IsoPlayer.getInstance(), this.square.getX(), this.square.getY(), this.square.getZ(), 70, 70, true);
                    this.WorldSoundPulseDelay = this.WorldSoundPulseRate;
                }
                if (!this.JukeboxTrack.isPlaying()) {
                    this.WorldSoundPulseDelay = 0;
                    this.SetPlaying(false);
                    this.Activated = false;
                    if (this.JukeboxTrack != null) {
                        SoundManager.instance.StopSound(this.JukeboxTrack);
                        this.JukeboxTrack.stop();
                        this.JukeboxTrack = null;
                    }
                    --Core.NumJukeBoxesActive;
                }
            }
        }
    }
}

