/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.GameTime;
import zombie.SandboxOptions;
import zombie.WorldSoundManager;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.properties.PropertyContainer;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Food;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.IsoClothingDryer;
import zombie.iso.objects.IsoClothingWasher;
import zombie.iso.objects.IsoCombinationWasherDryer;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoRadio;
import zombie.iso.objects.IsoStackedWasherDryer;
import zombie.iso.objects.IsoStove;
import zombie.iso.objects.IsoTelevision;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;

public class IsoGenerator
extends IsoObject {
    public float fuel = 0.0f;
    public boolean activated = false;
    public int condition = 0;
    private int lastHour = -1;
    public boolean connected = false;
    private int numberOfElectricalItems = 0;
    private boolean updateSurrounding = false;
    private final HashMap<String, String> itemsPowered = new HashMap();
    private float totalPowerUsing = 0.0f;
    private static final ArrayList<IsoGenerator> AllGenerators = new ArrayList();
    private static final int GENERATOR_RADIUS = 20;

    public IsoGenerator(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoGenerator(InventoryItem inventoryItem, IsoCell isoCell, IsoGridSquare isoGridSquare) {
        super(isoCell, isoGridSquare, IsoSpriteManager.instance.getSprite("appliances_misc_01_0"));
        if (inventoryItem != null) {
            this.setInfoFromItem(inventoryItem);
        }
        this.sprite = IsoSpriteManager.instance.getSprite("appliances_misc_01_0");
        this.square = isoGridSquare;
        isoGridSquare.AddSpecialObject(this);
        if (GameClient.bClient) {
            this.transmitCompleteItemToServer();
        }
    }

    public IsoGenerator(InventoryItem inventoryItem, IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl) {
        super(isoCell, isoGridSquare, IsoSpriteManager.instance.getSprite("appliances_misc_01_0"));
        if (inventoryItem != null) {
            this.setInfoFromItem(inventoryItem);
        }
        this.sprite = IsoSpriteManager.instance.getSprite("appliances_misc_01_0");
        this.square = isoGridSquare;
        isoGridSquare.AddSpecialObject(this);
        if (GameClient.bClient && !bl) {
            this.transmitCompleteItemToServer();
        }
    }

    public void setInfoFromItem(InventoryItem inventoryItem) {
        this.condition = inventoryItem.getCondition();
        if (inventoryItem.getModData().rawget((Object)"fuel") instanceof Double) {
            this.fuel = ((Double)inventoryItem.getModData().rawget((Object)"fuel")).floatValue();
        }
    }

    @Override
    public void update() {
        if (this.updateSurrounding && this.getSquare() != null) {
            this.setSurroundingElectricity();
            this.updateSurrounding = false;
        }
        if (this.isActivated()) {
            if (!(GameServer.bServer || this.emitter != null && this.emitter.isPlaying("GeneratorLoop"))) {
                if (this.emitter == null) {
                    this.emitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, (int)this.getZ());
                    IsoWorld.instance.takeOwnershipOfEmitter(this.emitter);
                }
                this.emitter.playSoundLoopedImpl("GeneratorLoop");
            }
            if (GameClient.bClient) {
                this.emitter.tick();
                return;
            }
            WorldSoundManager.instance.addSoundRepeating(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), 20, 1, false);
            if ((int)GameTime.getInstance().getWorldAgeHours() != this.lastHour) {
                if (!this.getSquare().getProperties().Is(IsoFlagType.exterior) && this.getSquare().getBuilding() != null) {
                    this.getSquare().getBuilding().setToxic(false);
                    this.getSquare().getBuilding().setToxic(this.isActivated());
                }
                int n = (int)GameTime.getInstance().getWorldAgeHours() - this.lastHour;
                float f = 0.0f;
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    float f2 = this.totalPowerUsing;
                    f2 = (float)((double)f2 * SandboxOptions.instance.GeneratorFuelConsumption.getValue());
                    f += f2;
                    if (Rand.Next(30) == 0) {
                        n2 += Rand.Next(2) + 1;
                    }
                    if (this.fuel - f <= 0.0f || this.condition - n2 <= 0) break;
                }
                this.fuel -= f;
                if (this.fuel <= 0.0f) {
                    this.setActivated(false);
                    this.fuel = 0.0f;
                }
                this.condition -= n2;
                if (this.condition <= 0) {
                    this.setActivated(false);
                    this.condition = 0;
                }
                if (this.condition <= 20) {
                    if (Rand.Next(10) == 0) {
                        IsoFireManager.StartFire(this.getCell(), this.square, true, 1000);
                        this.condition = 0;
                        this.setActivated(false);
                    } else if (Rand.Next(20) == 0) {
                        this.square.explode();
                        this.condition = 0;
                        this.setActivated(false);
                    }
                }
                this.lastHour = (int)GameTime.getInstance().getWorldAgeHours();
                if (GameServer.bServer) {
                    this.syncIsoObject(false, (byte)0, null, null);
                }
            }
        }
        if (this.emitter != null) {
            this.emitter.tick();
        }
    }

    public void setSurroundingElectricity() {
        int n;
        int n2;
        this.itemsPowered.clear();
        this.totalPowerUsing = 0.02f;
        this.numberOfElectricalItems = 1;
        if (this.square == null || this.square.chunk == null) {
            return;
        }
        int n3 = this.square.chunk.wx;
        int n4 = this.square.chunk.wy;
        for (n2 = -2; n2 <= 2; ++n2) {
            for (n = -2; n <= 2; ++n) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n3 + n, n4 + n2) : IsoWorld.instance.CurrentCell.getChunk(n3 + n, n4 + n2);
                if (isoChunk == null || !this.touchesChunk(isoChunk)) continue;
                if (this.isActivated()) {
                    isoChunk.addGeneratorPos(this.square.x, this.square.y, this.square.z);
                    continue;
                }
                isoChunk.removeGeneratorPos(this.square.x, this.square.y, this.square.z);
            }
        }
        n2 = SandboxOptions.getInstance().AllowExteriorGenerator.getValue() ? 1 : 0;
        n = this.square.getX() - 20;
        int n5 = this.square.getX() + 20;
        int n6 = this.square.getY() - 20;
        int n7 = this.square.getY() + 20;
        int n8 = Math.max(0, this.getSquare().getZ() - 3);
        int n9 = Math.min(8, this.getSquare().getZ() + 3);
        for (int i = n8; i < n9; ++i) {
            for (int j = n; j <= n5; ++j) {
                for (int k = n6; k <= n7; ++k) {
                    IsoGridSquare isoGridSquare;
                    if (IsoUtils.DistanceToSquared((float)j + 0.5f, (float)k + 0.5f, (float)this.getSquare().getX() + 0.5f, (float)this.getSquare().getY() + 0.5f) > 400.0f || (isoGridSquare = this.getCell().getGridSquare(j, k, i)) == null) continue;
                    boolean bl = this.isActivated();
                    if (n2 == 0 && isoGridSquare.Is(IsoFlagType.exterior)) {
                        bl = false;
                    }
                    isoGridSquare.setHaveElectricity(bl);
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        boolean bl2;
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (isoObject == null || isoObject instanceof IsoWorldInventoryObject) continue;
                        if (isoObject instanceof IsoClothingDryer && ((IsoClothingDryer)isoObject).isActivated()) {
                            this.addPoweredItem(isoObject, 0.09f);
                        }
                        if (isoObject instanceof IsoClothingWasher && ((IsoClothingWasher)isoObject).isActivated()) {
                            this.addPoweredItem(isoObject, 0.09f);
                        }
                        if (isoObject instanceof IsoCombinationWasherDryer && ((IsoCombinationWasherDryer)isoObject).isActivated()) {
                            this.addPoweredItem(isoObject, 0.09f);
                        }
                        if (isoObject instanceof IsoStackedWasherDryer) {
                            IsoStackedWasherDryer isoStackedWasherDryer = (IsoStackedWasherDryer)isoObject;
                            float f = 0.0f;
                            if (isoStackedWasherDryer.isDryerActivated()) {
                                f += 0.9f;
                            }
                            if (isoStackedWasherDryer.isWasherActivated()) {
                                f += 0.9f;
                            }
                            if (f > 0.0f) {
                                this.addPoweredItem(isoObject, f);
                            }
                        }
                        if (isoObject instanceof IsoTelevision && ((IsoTelevision)isoObject).getDeviceData().getIsTurnedOn()) {
                            this.addPoweredItem(isoObject, 0.03f);
                        }
                        if (isoObject instanceof IsoRadio && ((IsoRadio)isoObject).getDeviceData().getIsTurnedOn() && !((IsoRadio)isoObject).getDeviceData().getIsBatteryPowered()) {
                            this.addPoweredItem(isoObject, 0.01f);
                        }
                        if (isoObject instanceof IsoStove && ((IsoStove)isoObject).Activated()) {
                            this.addPoweredItem(isoObject, 0.09f);
                        }
                        boolean bl3 = isoObject.getContainerByType("fridge") != null;
                        boolean bl4 = bl2 = isoObject.getContainerByType("freezer") != null;
                        if (bl3 && bl2) {
                            this.addPoweredItem(isoObject, 0.13f);
                        } else if (bl3 || bl2) {
                            this.addPoweredItem(isoObject, 0.08f);
                        }
                        if (isoObject instanceof IsoLightSwitch && ((IsoLightSwitch)isoObject).Activated) {
                            this.addPoweredItem(isoObject, 0.002f);
                        }
                        isoObject.checkHaveElectricity();
                    }
                }
            }
        }
    }

    private void addPoweredItem(IsoObject isoObject, float f) {
        String string = Translator.getText("IGUI_VehiclePartCatOther");
        PropertyContainer propertyContainer = isoObject.getProperties();
        if (propertyContainer != null && propertyContainer.Is("CustomName")) {
            Object object = "Moveable Object";
            if (propertyContainer.Is("CustomName")) {
                object = propertyContainer.Is("GroupName") ? propertyContainer.Val("GroupName") + " " + propertyContainer.Val("CustomName") : propertyContainer.Val("CustomName");
            }
            string = Translator.getMoveableDisplayName((String)object);
        }
        if (isoObject instanceof IsoLightSwitch) {
            string = Translator.getText("IGUI_Lights");
        }
        this.totalPowerUsing -= f;
        int n = 1;
        for (String string2 : this.itemsPowered.keySet()) {
            if (!string2.startsWith(string)) continue;
            n = Integer.parseInt(string2.replaceAll("[\\D]", ""));
            ++n;
            this.itemsPowered.remove(string2);
            break;
        }
        this.itemsPowered.put(string + " x" + n, String.format(" (%.2f L/h)", Float.valueOf(f * (float)n)));
        this.totalPowerUsing = n == 1 ? (this.totalPowerUsing += f * (float)(n + 1)) : (this.totalPowerUsing += f * (float)n);
    }

    private void updateFridgeFreezerItems(IsoObject isoObject) {
        for (int i = 0; i < isoObject.getContainerCount(); ++i) {
            ItemContainer itemContainer = isoObject.getContainerByIndex(i);
            if (!"fridge".equals(itemContainer.getType()) && !"freezer".equals(itemContainer.getType())) continue;
            ArrayList<InventoryItem> arrayList = itemContainer.getItems();
            for (int j = 0; j < arrayList.size(); ++j) {
                InventoryItem inventoryItem = arrayList.get(j);
                if (!(inventoryItem instanceof Food)) continue;
                inventoryItem.updateAge();
            }
        }
    }

    private void updateFridgeFreezerItems(IsoGridSquare isoGridSquare) {
        int n = isoGridSquare.getObjects().size();
        IsoObject[] isoObjectArray = isoGridSquare.getObjects().getElements();
        for (int i = 0; i < n; ++i) {
            IsoObject isoObject = isoObjectArray[i];
            this.updateFridgeFreezerItems(isoObject);
        }
    }

    private void updateFridgeFreezerItems() {
        if (this.square == null) {
            return;
        }
        int n = this.square.getX() - 20;
        int n2 = this.square.getX() + 20;
        int n3 = this.square.getY() - 20;
        int n4 = this.square.getY() + 20;
        int n5 = Math.max(0, this.square.getZ() - 3);
        int n6 = Math.min(8, this.square.getZ() + 3);
        for (int i = n5; i < n6; ++i) {
            for (int j = n; j <= n2; ++j) {
                for (int k = n3; k <= n4; ++k) {
                    IsoGridSquare isoGridSquare;
                    if (!(IsoUtils.DistanceToSquared(j, k, this.square.x, this.square.y) <= 400.0f) || (isoGridSquare = this.getCell().getGridSquare(j, k, i)) == null) continue;
                    this.updateFridgeFreezerItems(isoGridSquare);
                }
            }
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.connected = byteBuffer.get() == 1;
        this.activated = byteBuffer.get() == 1;
        this.fuel = n < 138 ? (float)byteBuffer.getInt() : byteBuffer.getFloat();
        this.condition = byteBuffer.getInt();
        this.lastHour = byteBuffer.getInt();
        this.numberOfElectricalItems = byteBuffer.getInt();
        this.updateSurrounding = true;
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.isConnected() ? (byte)1 : 0);
        byteBuffer.put(this.isActivated() ? (byte)1 : 0);
        byteBuffer.putFloat(this.getFuel());
        byteBuffer.putInt(this.getCondition());
        byteBuffer.putInt(this.lastHour);
        byteBuffer.putInt(this.numberOfElectricalItems);
    }

    public void remove() {
        if (this.getSquare() == null) {
            return;
        }
        this.getSquare().transmitRemoveItemFromSquare(this);
    }

    @Override
    public void addToWorld() {
        this.getCell().addToProcessIsoObject(this);
        if (!AllGenerators.contains(this)) {
            AllGenerators.add(this);
        }
        if (GameClient.bClient) {
            GameClient.instance.objectSyncReq.putRequest(this.square, this);
        }
    }

    @Override
    public void removeFromWorld() {
        AllGenerators.remove(this);
        if (this.emitter != null) {
            this.emitter.stopAll();
            IsoWorld.instance.returnOwnershipOfEmitter(this.emitter);
            this.emitter = null;
        }
        super.removeFromWorld();
    }

    @Override
    public String getObjectName() {
        return "IsoGenerator";
    }

    public float getFuel() {
        return this.fuel;
    }

    public void setFuel(float f) {
        this.fuel = f;
        if (this.fuel > 100.0f) {
            this.fuel = 100.0f;
        }
        if (this.fuel < 0.0f) {
            this.fuel = 0.0f;
        }
        if (GameServer.bServer) {
            this.syncIsoObject(false, (byte)0, null, null);
        }
        if (GameClient.bClient) {
            this.syncIsoObject(false, (byte)0, null, null);
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean bl) {
        if (bl == this.activated) {
            return;
        }
        if (!this.getSquare().getProperties().Is(IsoFlagType.exterior) && this.getSquare().getBuilding() != null) {
            this.getSquare().getBuilding().setToxic(false);
            this.getSquare().getBuilding().setToxic(bl);
        }
        if (!GameServer.bServer && this.emitter == null) {
            this.emitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, this.getZ());
            IsoWorld.instance.takeOwnershipOfEmitter(this.emitter);
        }
        if (bl) {
            this.lastHour = (int)GameTime.getInstance().getWorldAgeHours();
            if (this.emitter != null) {
                this.emitter.playSound("GeneratorStarting");
            }
        } else if (this.emitter != null) {
            if (!this.emitter.isEmpty()) {
                this.emitter.stopAll();
            }
            this.emitter.playSound("GeneratorStopping");
        }
        try {
            this.updateFridgeFreezerItems();
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
        this.activated = bl;
        this.setSurroundingElectricity();
        if (GameClient.bClient) {
            this.syncIsoObject(false, (byte)0, null, null);
        }
        if (GameServer.bServer) {
            this.syncIsoObject(false, (byte)0, null, null);
        }
    }

    public void failToStart() {
        if (GameServer.bServer) {
            return;
        }
        if (this.emitter == null) {
            this.emitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, this.getZ());
            IsoWorld.instance.takeOwnershipOfEmitter(this.emitter);
        }
        this.emitter.playSound("GeneratorFailedToStart");
    }

    public int getCondition() {
        return this.condition;
    }

    public void setCondition(int n) {
        this.condition = n;
        if (this.condition > 100) {
            this.condition = 100;
        }
        if (this.condition < 0) {
            this.condition = 0;
        }
        if (GameServer.bServer) {
            this.syncIsoObject(false, (byte)0, null, null);
        }
        if (GameClient.bClient) {
            this.syncIsoObject(false, (byte)0, null, null);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
        if (GameClient.bClient) {
            this.syncIsoObject(false, (byte)0, null, null);
        }
    }

    @Override
    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byte by = (byte)this.getObjectIndex();
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byteBufferWriter.putByte(by);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putByte((byte)0);
        byteBufferWriter.putFloat(this.fuel);
        byteBufferWriter.putInt(this.condition);
        byteBufferWriter.putByte(this.activated ? (byte)1 : 0);
        byteBufferWriter.putByte(this.connected ? (byte)1 : 0);
    }

    @Override
    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        block6: {
            block7: {
                block5: {
                    if (this.square == null) {
                        System.out.println("ERROR: " + this.getClass().getSimpleName() + " square is null");
                        return;
                    }
                    if (this.getObjectIndex() == -1) {
                        System.out.println("ERROR: " + this.getClass().getSimpleName() + " not found on square " + this.square.getX() + "," + this.square.getY() + "," + this.square.getZ());
                        return;
                    }
                    if (!GameClient.bClient || bl) break block5;
                    ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(GameClient.connection);
                    break block6;
                }
                if (!GameServer.bServer || bl) break block7;
                for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                    ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
                }
                break block6;
            }
            if (!bl) break block6;
            float f = byteBuffer.getFloat();
            int n = byteBuffer.getInt();
            boolean bl2 = byteBuffer.get() == 1;
            boolean bl3 = byteBuffer.get() == 1;
            this.sync(f, n, bl3, bl2);
            if (GameServer.bServer) {
                for (UdpConnection udpConnection3 : GameServer.udpEngine.connections) {
                    if (udpConnection == null || udpConnection3.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection3.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection3);
                }
            }
        }
    }

    public void sync(float f, int n, boolean bl, boolean bl2) {
        this.fuel = f;
        this.condition = n;
        this.connected = bl;
        if (this.activated != bl2) {
            try {
                this.updateFridgeFreezerItems();
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
            this.activated = bl2;
            if (bl2) {
                this.lastHour = (int)GameTime.getInstance().getWorldAgeHours();
            } else if (this.emitter != null) {
                this.emitter.stopAll();
            }
            this.setSurroundingElectricity();
        }
    }

    private boolean touchesChunk(IsoChunk isoChunk) {
        IsoGridSquare isoGridSquare = this.getSquare();
        assert (isoGridSquare != null);
        if (isoGridSquare == null) {
            return false;
        }
        int n = isoChunk.wx * 10;
        int n2 = isoChunk.wy * 10;
        int n3 = n + 10 - 1;
        int n4 = n2 + 10 - 1;
        if (isoGridSquare.x - 20 > n3) {
            return false;
        }
        if (isoGridSquare.x + 20 < n) {
            return false;
        }
        if (isoGridSquare.y - 20 > n4) {
            return false;
        }
        return isoGridSquare.y + 20 >= n2;
    }

    public static void chunkLoaded(IsoChunk isoChunk) {
        int n;
        isoChunk.checkForMissingGenerators();
        for (n = -2; n <= 2; ++n) {
            for (int i = -2; i <= 2; ++i) {
                IsoChunk isoChunk2;
                if (i == 0 && n == 0) continue;
                IsoChunk isoChunk3 = isoChunk2 = GameServer.bServer ? ServerMap.instance.getChunk(isoChunk.wx + i, isoChunk.wy + n) : IsoWorld.instance.CurrentCell.getChunk(isoChunk.wx + i, isoChunk.wy + n);
                if (isoChunk2 == null) continue;
                isoChunk2.checkForMissingGenerators();
            }
        }
        for (n = 0; n < AllGenerators.size(); ++n) {
            IsoGenerator isoGenerator = AllGenerators.get(n);
            if (isoGenerator.updateSurrounding || !isoGenerator.touchesChunk(isoChunk)) continue;
            isoGenerator.updateSurrounding = true;
        }
    }

    public static void updateSurroundingNow() {
        for (int i = 0; i < AllGenerators.size(); ++i) {
            IsoGenerator isoGenerator = AllGenerators.get(i);
            if (!isoGenerator.updateSurrounding || isoGenerator.getSquare() == null) continue;
            isoGenerator.updateSurrounding = false;
            isoGenerator.setSurroundingElectricity();
        }
    }

    public static void updateGenerator(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return;
        }
        for (int i = 0; i < AllGenerators.size(); ++i) {
            float f;
            IsoGenerator isoGenerator = AllGenerators.get(i);
            if (isoGenerator.getSquare() == null || !((f = IsoUtils.DistanceToSquared((float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f, (float)isoGenerator.getSquare().getX() + 0.5f, (float)isoGenerator.getSquare().getY() + 0.5f)) <= 400.0f)) continue;
            isoGenerator.updateSurrounding = true;
        }
    }

    public static void Reset() {
        assert (AllGenerators.isEmpty());
        AllGenerators.clear();
    }

    public static boolean isPoweringSquare(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.max(0, n3 - 3);
        int n8 = Math.min(8, n3 + 3);
        if (n6 < n7 || n6 >= n8) {
            return false;
        }
        return IsoUtils.DistanceToSquared((float)n + 0.5f, (float)n2 + 0.5f, (float)n4 + 0.5f, (float)n5 + 0.5f) <= 400.0f;
    }

    public ArrayList<String> getItemsPowered() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.itemsPowered.keySet()) {
            arrayList.add(string + this.itemsPowered.get(string));
        }
        arrayList.sort(String::compareToIgnoreCase);
        return arrayList;
    }

    public float getTotalPowerUsing() {
        return this.totalPowerUsing;
    }

    public void setTotalPowerUsing(float f) {
        this.totalPowerUsing = f;
    }
}

