/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.core.Core;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoHeatSource;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class IsoFireplace
extends IsoObject {
    int FuelAmount = 0;
    boolean bLit = false;
    boolean bSmouldering = false;
    protected float LastUpdateTime = -1.0f;
    protected float MinuteAccumulator = 0.0f;
    protected int MinutesSinceExtinguished = -1;
    protected IsoSprite FuelSprite = null;
    protected int FuelSpriteIndex = -1;
    protected int FireSpriteIndex = -1;
    protected IsoLightSource LightSource = null;
    protected IsoHeatSource heatSource = null;
    private long soundInstance = 0L;
    private static int SMOULDER_MINUTES = 10;

    public IsoFireplace(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoFireplace(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
        String string = isoSprite != null && isoSprite.getProperties().Is(IsoFlagType.container) ? isoSprite.getProperties().Val("container") : "fireplace";
        this.container = new ItemContainer(string, isoGridSquare, this);
        this.container.setExplored(true);
    }

    @Override
    public String getObjectName() {
        return "Fireplace";
    }

    @Override
    public Vector2 getFacingPosition(Vector2 vector22) {
        if (this.square == null) {
            return vector22.set(0.0f, 0.0f);
        }
        if (this.getProperties() != null && this.getProperties().Is(IsoFlagType.collideN)) {
            return vector22.set(this.getX() + 0.5f, this.getY());
        }
        return vector22.set(this.getX(), this.getY() + 0.5f);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.FuelAmount = byteBuffer.getInt();
        this.bLit = byteBuffer.get() == 1;
        this.LastUpdateTime = byteBuffer.getFloat();
        this.MinutesSinceExtinguished = byteBuffer.getInt();
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.putInt(this.FuelAmount);
        byteBuffer.put(this.bLit ? (byte)1 : 0);
        byteBuffer.putFloat(this.LastUpdateTime);
        byteBuffer.putInt(this.MinutesSinceExtinguished);
    }

    public void setFuelAmount(int n) {
        int n2;
        if ((n = Math.max(0, n)) != (n2 = this.getFuelAmount())) {
            this.FuelAmount = n;
        }
    }

    public int getFuelAmount() {
        return this.FuelAmount;
    }

    public void addFuel(int n) {
        this.setFuelAmount(this.getFuelAmount() + n);
    }

    public int useFuel(int n) {
        int n2 = this.getFuelAmount();
        int n3 = 0;
        n3 = n2 >= n ? n : n2;
        this.setFuelAmount(n2 - n3);
        return n3;
    }

    public boolean hasFuel() {
        return this.getFuelAmount() > 0;
    }

    public void setLit(boolean bl) {
        this.bLit = bl;
    }

    public boolean isLit() {
        return this.bLit;
    }

    public boolean isSmouldering() {
        return this.bSmouldering;
    }

    public void extinguish() {
        if (this.isLit()) {
            this.setLit(false);
            if (this.hasFuel()) {
                this.MinutesSinceExtinguished = 0;
            }
        }
    }

    public float getTemperature() {
        if (this.isLit()) {
            return 1.8f;
        }
        return 1.0f;
    }

    private void updateFuelSprite() {
        if (this.container != null && "woodstove".equals(this.container.getType())) {
            return;
        }
        if (this.hasFuel()) {
            if (this.FuelSprite == null) {
                this.FuelSprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
                Texture texture = this.FuelSprite.LoadFrameExplicit("Item_Logs");
            }
            if (this.FuelSpriteIndex == -1) {
                DebugLog.log(DebugType.Fireplace, "fireplace: added fuel sprite");
                int n = this.FuelSpriteIndex = this.AttachedAnimSprite != null ? this.AttachedAnimSprite.size() : 0;
                if (this.getProperties() != null && this.getProperties().Is(IsoFlagType.collideW)) {
                    this.AttachExistingAnim(this.FuelSprite, -10 * Core.TileScale, -90 * Core.TileScale, false, 0, false, 0.0f);
                } else {
                    this.AttachExistingAnim(this.FuelSprite, -35 * Core.TileScale, -90 * Core.TileScale, false, 0, false, 0.0f);
                }
                if (Core.TileScale == 1) {
                    ((IsoSpriteInstance)this.AttachedAnimSprite.get(this.FuelSpriteIndex)).setScale(0.5f, 0.5f);
                }
            }
        } else if (this.FuelSpriteIndex != -1) {
            DebugLog.log(DebugType.Fireplace, "fireplace: removed fuel sprite");
            this.AttachedAnimSprite.remove(this.FuelSpriteIndex);
            if (this.FireSpriteIndex > this.FuelSpriteIndex) {
                --this.FireSpriteIndex;
            }
            this.FuelSpriteIndex = -1;
        }
    }

    private void updateFireSprite() {
        if (this.container != null && "woodstove".equals(this.container.getType())) {
            return;
        }
        if (this.isLit()) {
            if (this.FireSpriteIndex == -1) {
                DebugLog.log(DebugType.Fireplace, "fireplace: added fire sprite");
                int n = this.FireSpriteIndex = this.AttachedAnimSprite != null ? this.AttachedAnimSprite.size() : 0;
                if (this.getProperties() != null && this.getProperties().Is(IsoFlagType.collideW)) {
                    this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, -11 * Core.TileScale, -84 * Core.TileScale, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                } else {
                    this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, -35 * Core.TileScale, -84 * Core.TileScale, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                }
                if (Core.TileScale == 1) {
                    ((IsoSpriteInstance)this.AttachedAnimSprite.get(this.FireSpriteIndex)).setScale(0.5f, 0.5f);
                }
            }
        } else if (this.FireSpriteIndex != -1) {
            DebugLog.log(DebugType.Fireplace, "fireplace: removed fire sprite");
            this.AttachedAnimSprite.remove(this.FireSpriteIndex);
            if (this.FuelSpriteIndex > this.FireSpriteIndex) {
                --this.FuelSpriteIndex;
            }
            this.FireSpriteIndex = -1;
        }
    }

    private int calcLightRadius() {
        return (int)GameTime.instance.Lerp(1.0f, 8.0f, (float)Math.min(this.getFuelAmount(), 60) / 60.0f);
    }

    private void updateLightSource() {
        if (this.isLit()) {
            int n = this.calcLightRadius();
            if (this.LightSource != null && this.LightSource.getRadius() != n) {
                this.LightSource.life = 0;
                this.LightSource = null;
            }
            if (this.LightSource == null) {
                this.LightSource = new IsoLightSource(this.square.getX(), this.square.getY(), this.square.getZ(), 1.0f, 0.1f, 0.1f, n);
                IsoWorld.instance.CurrentCell.addLamppost(this.LightSource);
                IsoGridSquare.RecalcLightTime = -1;
                GameTime.instance.lightSourceUpdate = 100.0f;
            }
        } else if (this.LightSource != null) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.LightSource);
            this.LightSource = null;
        }
    }

    private void updateHeatSource() {
        if (this.isLit()) {
            int n = this.calcLightRadius();
            if (this.heatSource == null) {
                this.heatSource = new IsoHeatSource((int)this.getX(), (int)this.getY(), (int)this.getZ(), n, 35);
                IsoWorld.instance.CurrentCell.addHeatSource(this.heatSource);
            } else if (n != this.heatSource.getRadius()) {
                this.heatSource.setRadius(n);
            }
        } else if (this.heatSource != null) {
            IsoWorld.instance.CurrentCell.removeHeatSource(this.heatSource);
            this.heatSource = null;
        }
    }

    private void updateSound() {
        if (GameServer.bServer) {
            return;
        }
        if (this.isLit()) {
            String string;
            if (this.emitter == null) {
                this.emitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, (int)this.getZ());
                IsoWorld.instance.setEmitterOwner(this.emitter, this);
            }
            if (!this.emitter.isPlaying(string = "FireplaceRunning")) {
                this.soundInstance = this.emitter.playSoundLoopedImpl(string);
            }
        } else if (this.emitter != null && this.soundInstance != 0L) {
            this.emitter.stopOrTriggerSound(this.soundInstance);
            this.emitter = null;
            this.soundInstance = 0L;
        }
    }

    @Override
    public void update() {
        int n;
        int n2;
        if (!GameClient.bClient) {
            n2 = this.hasFuel();
            n = this.isLit();
            int n3 = this.calcLightRadius();
            float f = (float)GameTime.getInstance().getWorldAgeHours();
            if (this.LastUpdateTime < 0.0f) {
                this.LastUpdateTime = f;
            } else if (this.LastUpdateTime > f) {
                this.LastUpdateTime = f;
            }
            if (f > this.LastUpdateTime) {
                this.MinuteAccumulator += (f - this.LastUpdateTime) * 60.0f;
                int n4 = (int)Math.floor(this.MinuteAccumulator);
                if (n4 > 0) {
                    if (this.isLit()) {
                        DebugLog.log(DebugType.Fireplace, "IsoFireplace burned " + n4 + " minutes (" + this.getFuelAmount() + " remaining)");
                        this.useFuel(n4);
                        if (!this.hasFuel()) {
                            this.extinguish();
                        }
                    } else if (this.MinutesSinceExtinguished != -1) {
                        int n5 = Math.min(n4, SMOULDER_MINUTES - this.MinutesSinceExtinguished);
                        DebugLog.log(DebugType.Fireplace, "IsoFireplace smoldered " + n5 + " minutes (" + this.getFuelAmount() + " remaining)");
                        this.MinutesSinceExtinguished += n4;
                        this.useFuel(n5);
                        this.bSmouldering = true;
                        if (!this.hasFuel() || this.MinutesSinceExtinguished >= SMOULDER_MINUTES) {
                            this.MinutesSinceExtinguished = -1;
                            this.bSmouldering = false;
                        }
                    }
                    this.MinuteAccumulator -= (float)n4;
                }
            }
            this.LastUpdateTime = f;
            if (GameServer.bServer) {
                if (n2 != this.hasFuel() || n != this.isLit() || n3 != this.calcLightRadius()) {
                    this.sendObjectChange("state");
                }
                return;
            }
        }
        this.updateFuelSprite();
        this.updateFireSprite();
        this.updateLightSource();
        this.updateHeatSource();
        this.updateSound();
        if (this.AttachedAnimSprite != null && !this.AttachedAnimSprite.isEmpty()) {
            n2 = this.AttachedAnimSprite.size();
            for (n = 0; n < n2; ++n) {
                IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)this.AttachedAnimSprite.get(n);
                IsoSprite isoSprite = isoSpriteInstance.parentSprite;
                isoSpriteInstance.update();
                float f = GameTime.instance.getMultipliedSecondsSinceLastUpdate() * 60.0f;
                isoSpriteInstance.Frame += isoSpriteInstance.AnimFrameIncrease * f;
                if ((int)isoSpriteInstance.Frame < isoSprite.CurrentAnim.Frames.size() || !isoSprite.Loop || !isoSpriteInstance.Looped) continue;
                isoSpriteInstance.Frame = 0.0f;
            }
        }
    }

    @Override
    public void addToWorld() {
        IsoCell isoCell = this.getCell();
        isoCell.addToProcessIsoObject(this);
        this.container.addItemsToProcessItems();
    }

    @Override
    public void removeFromWorld() {
        if (this.LightSource != null) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.LightSource);
            this.LightSource = null;
        }
        if (this.heatSource != null) {
            IsoWorld.instance.CurrentCell.removeHeatSource(this.heatSource);
            this.heatSource = null;
        }
        super.removeFromWorld();
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        super.render(f, f2, f3, colorInfo, false, bl2, shader);
        if (this.AttachedAnimSprite == null) {
            return;
        }
        for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
            IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)this.AttachedAnimSprite.get(i);
            isoSpriteInstance.getParentSprite().render(isoSpriteInstance, this, f, f2, f3, this.dir, this.offsetX, this.offsetY, colorInfo, true);
        }
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("state".equals(string)) {
            byteBuffer.putInt(this.getFuelAmount());
            byteBuffer.put(this.isLit() ? (byte)1 : 0);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("state".equals(string)) {
            this.setFuelAmount(byteBuffer.getInt());
            this.setLit(byteBuffer.get() == 1);
        }
    }
}

