/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoHeatSource;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.areas.SafeHouse;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.objects.RainManager;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.ui.TutorialManager;

public class IsoFire
extends IsoObject {
    public int Age = 0;
    public int Energy = 0;
    public int Life;
    public int LifeStage;
    public int LifeStageDuration;
    public int LifeStageTimer;
    public int MaxLife = 3000;
    public int MinLife = 800;
    public int SpreadDelay;
    public int SpreadTimer;
    public int numFlameParticles;
    public boolean perm = false;
    public boolean bSmoke = false;
    public IsoLightSource LightSource = null;
    public int LightRadius = 1;
    public float LightOscillator = 0.0f;
    private IsoHeatSource heatSource;
    private float accum = 0.0f;

    public IsoFire(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoFire(IsoCell isoCell, IsoGridSquare isoGridSquare) {
        super(isoCell);
        this.square = isoGridSquare;
        this.perm = true;
    }

    @Override
    public String getObjectName() {
        return "Fire";
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        ArrayList arrayList = this.AttachedAnimSprite;
        this.AttachedAnimSprite = null;
        super.save(byteBuffer, bl);
        this.AttachedAnimSprite = arrayList;
        this.sprite = null;
        byteBuffer.putInt(this.Life);
        byteBuffer.putInt(this.SpreadDelay);
        byteBuffer.putInt(this.LifeStage - 1);
        byteBuffer.putInt(this.LifeStageTimer);
        byteBuffer.putInt(this.LifeStageDuration);
        byteBuffer.putInt(this.Energy);
        byteBuffer.putInt(this.numFlameParticles);
        byteBuffer.putInt(this.SpreadTimer);
        byteBuffer.putInt(this.Age);
        byteBuffer.put((byte)(this.perm ? 1 : 0));
        byteBuffer.put((byte)this.LightRadius);
        byteBuffer.put((byte)(this.bSmoke ? 1 : 0));
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.sprite = null;
        this.Life = byteBuffer.getInt();
        this.SpreadDelay = byteBuffer.getInt();
        this.LifeStage = byteBuffer.getInt();
        this.LifeStageTimer = byteBuffer.getInt();
        this.LifeStageDuration = byteBuffer.getInt();
        this.Energy = byteBuffer.getInt();
        this.numFlameParticles = byteBuffer.getInt();
        this.SpreadTimer = byteBuffer.getInt();
        this.Age = byteBuffer.getInt();
        this.perm = byteBuffer.get() == 1;
        this.LightRadius = byteBuffer.get() & 0xFF;
        if (n >= 89) {
            boolean bl2 = this.bSmoke = byteBuffer.get() == 1;
        }
        if (this.perm) {
            this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, -16, -78, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
            return;
        }
        if (this.numFlameParticles == 0) {
            this.numFlameParticles = 1;
        }
        switch (this.LifeStage) {
            case -1: {
                this.LifeStage = 0;
                for (int i = 0; i < this.numFlameParticles; ++i) {
                    this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, -16 + (-16 + Rand.Next(32)), -85 + (-16 + Rand.Next(32)), true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                }
                break;
            }
            case 0: {
                this.LifeStage = 1;
                this.LifeStageTimer = this.LifeStageDuration;
                this.AttachAnim("Fire", "02", 4, IsoFireManager.FireAnimDelay, -16, -72, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                break;
            }
            case 1: {
                this.LifeStage = 2;
                this.LifeStageTimer = this.LifeStageDuration;
                this.AttachAnim("Smoke", "01", 4, IsoFireManager.SmokeAnimDelay, -9, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                this.AttachAnim("Fire", "03", 4, IsoFireManager.FireAnimDelay, -9, -52, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                break;
            }
            case 2: {
                this.LifeStage = 3;
                this.LifeStageTimer = this.LifeStageDuration / 3;
                this.RemoveAttachedAnims();
                this.AttachAnim("Smoke", "02", 4, IsoFireManager.SmokeAnimDelay, 0, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                this.AttachAnim("Fire", "02", 4, IsoFireManager.FireAnimDelay, -16, -72, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                break;
            }
            case 3: {
                this.LifeStage = 4;
                this.LifeStageTimer = this.LifeStageDuration / 3;
                this.RemoveAttachedAnims();
                if (this.bSmoke) {
                    this.AttachAnim("Smoke", "03", 4, IsoFireManager.SmokeAnimDelay, 0, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                    break;
                }
                this.AttachAnim("Smoke", "03", 4, IsoFireManager.SmokeAnimDelay, 0, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, -16, -85, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                break;
            }
            case 4: {
                this.LifeStage = 5;
                this.LifeStageTimer = this.LifeStageDuration / 3;
                this.RemoveAttachedAnims();
                this.AttachAnim("Smoke", "01", 4, IsoFireManager.SmokeAnimDelay, -9, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
            }
        }
        if (this.square != null) {
            if (this.LifeStage < 4) {
                this.square.getProperties().Set(IsoFlagType.burning);
            } else {
                this.square.getProperties().Set(IsoFlagType.smoke);
            }
        }
    }

    public IsoFire(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl, int n, int n2, boolean bl2) {
        this.square = isoGridSquare;
        this.DirtySlice();
        this.square.getProperties().Set(IsoFlagType.smoke);
        this.AttachAnim("Smoke", "03", 4, IsoFireManager.SmokeAnimDelay, 0, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
        this.Life = this.MinLife + Rand.Next(this.MaxLife - this.MinLife);
        if (n2 > 0) {
            this.Life = n2;
        }
        this.LifeStage = 4;
        this.LifeStageTimer = this.LifeStageDuration = this.Life / 4;
        this.Energy = n;
        this.bSmoke = bl2;
    }

    public IsoFire(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl, int n, int n2) {
        this.square = isoGridSquare;
        this.DirtySlice();
        this.numFlameParticles = 2 + Rand.Next(2);
        for (int i = 0; i < this.numFlameParticles; ++i) {
            this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, -16 + (-16 + Rand.Next(32)), -85 + (-16 + Rand.Next(32)), true, 0, false, 0.7f, IsoFireManager.FireTintMod);
        }
        this.Life = this.MinLife + Rand.Next(this.MaxLife - this.MinLife);
        if (n2 > 0) {
            this.Life = n2;
        }
        if (this.square.getProperties() != null && !this.square.getProperties().Is(IsoFlagType.vegitation) && this.square.getFloor() != null) {
            this.Life -= this.square.getFloor().getSprite().firerequirement * 100;
            if (this.Life < 600) {
                this.Life = Rand.Next(300, 600);
            }
        }
        this.SpreadDelay = this.SpreadTimer = Rand.Next(this.Life - this.Life / 2);
        this.LifeStage = 0;
        this.LifeStageTimer = this.LifeStageDuration = this.Life / 4;
        if (TutorialManager.instance.Active) {
            this.LifeStageDuration *= 2;
            this.Life *= 2;
        }
        if (TutorialManager.instance.Active) {
            this.SpreadDelay = this.SpreadTimer /= 4;
        }
        isoGridSquare.getProperties().Set(IsoFlagType.burning);
        this.Energy = n;
        if (this.square.getProperties().Is(IsoFlagType.vegitation)) {
            this.Energy += 50;
        }
        LuaEventManager.triggerEvent("OnNewFire", this);
    }

    public IsoFire(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl, int n) {
        this(isoCell, isoGridSquare, bl, n, 0);
    }

    public static boolean CanAddSmoke(IsoGridSquare isoGridSquare, boolean bl) {
        return IsoFire.CanAddFire(isoGridSquare, bl, true);
    }

    public static boolean CanAddFire(IsoGridSquare isoGridSquare, boolean bl) {
        return IsoFire.CanAddFire(isoGridSquare, bl, false);
    }

    public static boolean CanAddFire(IsoGridSquare isoGridSquare, boolean bl, boolean bl2) {
        if (!bl2 && (GameServer.bServer || GameClient.bClient) && ServerOptions.instance.NoFire.getValue()) {
            return false;
        }
        if (isoGridSquare == null || isoGridSquare.getObjects().isEmpty()) {
            return false;
        }
        if (isoGridSquare.Is(IsoFlagType.water)) {
            return false;
        }
        if (!bl && isoGridSquare.getProperties().Is(IsoFlagType.burntOut)) {
            return false;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.burning) || isoGridSquare.getProperties().Is(IsoFlagType.smoke)) {
            return false;
        }
        if (!bl && !IsoFire.Fire_IsSquareFlamable(isoGridSquare)) {
            return false;
        }
        return bl2 || !GameServer.bServer && !GameClient.bClient || SafeHouse.getSafeHouse(isoGridSquare) == null || ServerOptions.instance.SafehouseAllowFire.getValue();
    }

    public static boolean Fire_IsSquareFlamable(IsoGridSquare isoGridSquare) {
        return !isoGridSquare.getProperties().Is(IsoFlagType.unflamable);
    }

    @Override
    public boolean HasTooltip() {
        return false;
    }

    public void Spread() {
        if (GameClient.bClient) {
            return;
        }
        if (!SandboxOptions.instance.FireSpread.getValue()) {
            return;
        }
        if (this.getCell() == null) {
            return;
        }
        if (this.square == null) {
            return;
        }
        if (this.LifeStage >= 4) {
            return;
        }
        IsoGridSquare isoGridSquare = null;
        int n = Rand.Next(3) + 1;
        if (Rand.Next(50) == 0) {
            n += 15;
        }
        if (TutorialManager.instance.Active) {
            n += 15;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = Rand.Next(13);
            switch (n3) {
                case 0: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX(), this.square.getY() - 1, this.square.getZ());
                    break;
                }
                case 1: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX() + 1, this.square.getY() - 1, this.square.getZ());
                    break;
                }
                case 2: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX() + 1, this.square.getY(), this.square.getZ());
                    break;
                }
                case 3: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX() + 1, this.square.getY() + 1, this.square.getZ());
                    break;
                }
                case 4: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX(), this.square.getY() + 1, this.square.getZ());
                    break;
                }
                case 5: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX() - 1, this.square.getY() + 1, this.square.getZ());
                    break;
                }
                case 6: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX() - 1, this.square.getY(), this.square.getZ());
                    break;
                }
                case 7: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX() - 1, this.square.getY() - 1, this.square.getZ());
                    break;
                }
                case 8: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX() - 1, this.square.getY() - 1, this.square.getZ() - 1);
                    break;
                }
                case 9: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX() - 1, this.square.getY(), this.square.getZ() - 1);
                    break;
                }
                case 10: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX(), this.square.getY() - 1, this.square.getZ() - 1);
                    break;
                }
                case 11: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX(), this.square.getY(), this.square.getZ() - 1);
                    break;
                }
                case 12: {
                    isoGridSquare = this.getCell().getGridSquare(this.square.getX(), this.square.getY(), this.square.getZ() + 1);
                }
            }
            if (!IsoFire.CanAddFire(isoGridSquare, false) || this.Energy < (n2 = this.getSquaresEnergyRequirement(isoGridSquare))) continue;
            this.Energy -= n2;
            if (GameServer.bServer) {
                this.sendObjectChange("Energy");
            }
            if (RainManager.isRaining().booleanValue()) {
                return;
            }
            int n4 = isoGridSquare.getProperties().Is(IsoFlagType.exterior) ? this.Energy : n2 * 2;
            IsoFireManager.StartFire(this.getCell(), isoGridSquare, false, n4);
        }
    }

    public boolean TestCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare) {
        return this.square == isoGridSquare;
    }

    @Override
    public IsoObject.VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        return IsoObject.VisionResult.NoEffect;
    }

    @Override
    public void update() {
        if (this.getObjectIndex() == -1) {
            return;
        }
        if (!GameServer.bServer) {
            IsoFireManager.updateSound(this);
        }
        if (this.LifeStage < 4) {
            this.square.getProperties().Set(IsoFlagType.burning);
        } else {
            this.square.getProperties().Set(IsoFlagType.smoke);
        }
        if (!this.bSmoke && this.LifeStage < 5) {
            this.square.BurnTick();
        }
        int n = this.AttachedAnimSprite.size();
        for (int i = 0; i < n; ++i) {
            IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)this.AttachedAnimSprite.get(i);
            IsoSprite isoSprite = isoSpriteInstance.parentSprite;
            isoSpriteInstance.update();
            float f = GameTime.instance.getMultipliedSecondsSinceLastUpdate() * 60.0f;
            isoSpriteInstance.Frame += isoSpriteInstance.AnimFrameIncrease * f;
            if ((int)isoSpriteInstance.Frame < isoSprite.CurrentAnim.Frames.size() || !isoSprite.Loop || !isoSpriteInstance.Looped) continue;
            isoSpriteInstance.Frame = 0.0f;
        }
        if (!this.bSmoke && !GameServer.bServer && this.LightSource == null) {
            this.LightSource = new IsoLightSource(this.square.getX(), this.square.getY(), this.square.getZ(), 0.61f, 0.165f, 0.0f, this.perm ? this.LightRadius : 5);
            IsoWorld.instance.CurrentCell.addLamppost(this.LightSource);
        }
        if (this.perm) {
            if (this.heatSource == null) {
                this.heatSource = new IsoHeatSource(this.square.x, this.square.y, this.square.z, this.LightRadius, 35);
                IsoWorld.instance.CurrentCell.addHeatSource(this.heatSource);
            } else {
                this.heatSource.setRadius(this.LightRadius);
            }
            return;
        }
        this.accum += GameTime.getInstance().getMultiplier() / 1.6f;
        while (this.accum > 1.0f) {
            this.accum -= 1.0f;
            ++this.Age;
            if (this.LifeStageTimer > 0) {
                --this.LifeStageTimer;
                if (this.LifeStageTimer <= 0) {
                    switch (this.LifeStage) {
                        case 0: {
                            this.LifeStage = 1;
                            this.LifeStageTimer = this.LifeStageDuration;
                            this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, -16, -72, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                            this.square.Burn();
                            if (this.LightSource == null) break;
                            this.setLightRadius(5);
                            break;
                        }
                        case 1: {
                            this.LifeStage = 2;
                            this.LifeStageTimer = this.LifeStageDuration;
                            this.RemoveAttachedAnims();
                            this.AttachAnim("Smoke", "02", 4, IsoFireManager.SmokeAnimDelay, -9, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                            this.AttachAnim("Fire", "02", 4, IsoFireManager.FireAnimDelay, -9, -52, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                            this.square.Burn();
                            if (this.LightSource == null) break;
                            this.setLightRadius(8);
                            break;
                        }
                        case 2: {
                            this.LifeStage = 3;
                            this.LifeStageTimer = this.LifeStageDuration / 3;
                            this.RemoveAttachedAnims();
                            this.AttachAnim("Smoke", "03", 4, IsoFireManager.SmokeAnimDelay, 0, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                            this.AttachAnim("Fire", "03", 4, IsoFireManager.FireAnimDelay, -16, -72, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                            if (this.LightSource == null) break;
                            this.setLightRadius(12);
                            break;
                        }
                        case 3: {
                            this.LifeStage = 4;
                            this.LifeStageTimer = this.LifeStageDuration / 3;
                            this.RemoveAttachedAnims();
                            this.AttachAnim("Smoke", "02", 4, IsoFireManager.SmokeAnimDelay, 0, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                            this.AttachAnim("Fire", "02", 4, IsoFireManager.FireAnimDelay, -16, -85, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                            if (this.LightSource == null) break;
                            this.setLightRadius(8);
                            break;
                        }
                        case 4: {
                            this.LifeStage = 5;
                            this.LifeStageTimer = this.LifeStageDuration / 3;
                            this.RemoveAttachedAnims();
                            this.AttachAnim("Smoke", "01", 4, IsoFireManager.SmokeAnimDelay, -9, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                            if (this.LightSource == null) break;
                            this.setLightRadius(1);
                        }
                    }
                }
            }
            if (this.Life <= 0) {
                this.extinctFire();
                break;
            }
            --this.Life;
            if (this.LifeStage > 0 && this.SpreadTimer > 0) {
                --this.SpreadTimer;
                if (this.SpreadTimer <= 0) {
                    if (this.LifeStage != 5) {
                        this.Spread();
                    }
                    this.SpreadTimer = this.SpreadDelay;
                }
            }
            if (this.Energy > 0) continue;
            this.extinctFire();
            break;
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        f += 0.5f;
        f2 += 0.5f;
        this.sx = 0.0f;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        float f4 = Core.TileScale;
        for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
            Texture texture;
            IsoSprite isoSprite = ((IsoSpriteInstance)this.AttachedAnimSprite.get((int)i)).parentSprite;
            if (isoSprite == null || isoSprite.CurrentAnim == null || isoSprite.def == null || (texture = isoSprite.CurrentAnim.Frames.get((int)((int)isoSprite.def.Frame)).directions[this.dir.index()]) == null) continue;
            isoSprite.soffX = (short)(-((float)(texture.getWidthOrig() / 2) * f4));
            isoSprite.soffY = (short)(-((float)texture.getHeightOrig() * f4));
            ((IsoSpriteInstance)this.AttachedAnimSprite.get(i)).setScale(f4, f4);
        }
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
        if (Core.bDebug) {
            // empty if block
        }
    }

    public void extinctFire() {
        this.square.getProperties().UnSet(IsoFlagType.burning);
        this.square.getProperties().UnSet(IsoFlagType.smoke);
        this.RemoveAttachedAnims();
        this.square.getObjects().remove(this);
        this.square.RemoveTileObject(this);
        this.setLife(0);
        this.removeFromWorld();
    }

    int getSquaresEnergyRequirement(IsoGridSquare isoGridSquare) {
        int n = 30;
        if (isoGridSquare.getProperties().Is(IsoFlagType.vegitation)) {
            n = -15;
        }
        if (!isoGridSquare.getProperties().Is(IsoFlagType.exterior)) {
            n = 40;
        }
        if (isoGridSquare.getFloor() != null && isoGridSquare.getFloor().getSprite() != null) {
            n = isoGridSquare.getFloor().getSprite().firerequirement;
        }
        if (TutorialManager.instance.Active) {
            return n / 4;
        }
        return n;
    }

    public void setSpreadDelay(int n) {
        this.SpreadDelay = n;
    }

    public int getSpreadDelay() {
        return this.SpreadDelay;
    }

    public void setLife(int n) {
        this.Life = n;
    }

    public int getLife() {
        return this.Life;
    }

    public int getEnergy() {
        return this.Energy;
    }

    public boolean isPermanent() {
        return this.perm;
    }

    public void setLifeStage(int n) {
        if (!this.perm) {
            return;
        }
        this.RemoveAttachedAnims();
        switch (n) {
            case 0: {
                this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, -16, -72, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                break;
            }
            case 1: {
                this.AttachAnim("Smoke", "02", 4, IsoFireManager.SmokeAnimDelay, -9, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                this.AttachAnim("Fire", "02", 4, IsoFireManager.FireAnimDelay, -9, -52, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                break;
            }
            case 2: {
                this.AttachAnim("Smoke", "03", 4, IsoFireManager.SmokeAnimDelay, 0, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                this.AttachAnim("Fire", "03", 4, IsoFireManager.FireAnimDelay, -16, -72, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                break;
            }
            case 3: {
                this.AttachAnim("Smoke", "02", 4, IsoFireManager.SmokeAnimDelay, 0, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
                this.AttachAnim("Fire", "02", 4, IsoFireManager.FireAnimDelay, -16, -85, true, 0, false, 0.7f, IsoFireManager.FireTintMod);
                break;
            }
            case 4: {
                this.AttachAnim("Smoke", "01", 4, IsoFireManager.SmokeAnimDelay, -9, 12, true, 0, false, 0.7f, IsoFireManager.SmokeTintMod);
            }
        }
    }

    public void setLightRadius(int n) {
        this.LightRadius = n;
        if (this.LightSource != null && n != this.LightSource.getRadius()) {
            this.getCell().removeLamppost(this.LightSource);
            this.LightSource = new IsoLightSource(this.square.getX(), this.square.getY(), this.square.getZ(), 0.61f, 0.165f, 0.0f, this.LightRadius);
            this.getCell().getLamppostPositions().add(this.LightSource);
            IsoGridSquare.RecalcLightTime = -1;
            GameTime.instance.lightSourceUpdate = 100.0f;
        }
    }

    public int getLightRadius() {
        return this.LightRadius;
    }

    @Override
    public void addToWorld() {
        if (this.perm) {
            this.getCell().addToStaticUpdaterObjectList(this);
        } else {
            IsoFireManager.Add(this);
        }
    }

    @Override
    public void removeFromWorld() {
        if (!this.perm) {
            IsoFireManager.Remove(this);
        }
        IsoFireManager.stopSound(this);
        if (this.LightSource != null) {
            this.getCell().removeLamppost(this.LightSource);
            this.LightSource = null;
        }
        if (this.heatSource != null) {
            this.getCell().removeHeatSource(this.heatSource);
            this.heatSource = null;
        }
        super.removeFromWorld();
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        super.saveChange(string, kahluaTable, byteBuffer);
        if ("Energy".equals(string)) {
            byteBuffer.putInt(this.Energy);
        } else if ("lightRadius".equals(string)) {
            byteBuffer.putInt(this.getLightRadius());
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        super.loadChange(string, byteBuffer);
        if ("Energy".equals(string)) {
            this.Energy = byteBuffer.getInt();
        }
        if ("lightRadius".equals(string)) {
            int n = byteBuffer.getInt();
            this.setLightRadius(n);
        }
    }

    public boolean isCampfire() {
        if (this.getSquare() == null) {
            return false;
        }
        IsoObject[] isoObjectArray = this.getSquare().getObjects().getElements();
        int n = this.getSquare().getObjects().size();
        for (int i = 1; i < n; ++i) {
            IsoObject isoObject = isoObjectArray[i];
            if (isoObject instanceof IsoWorldInventoryObject || !"Campfire".equalsIgnoreCase(isoObject.getName())) continue;
            return true;
        }
        return false;
    }
}

