/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import se.krka.kahlua.vm.KahluaTable;
import zombie.FliesSound;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.SharedDescriptors;
import zombie.SoundManager;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.AttachedItems.AttachedItem;
import zombie.characters.AttachedItems.AttachedItems;
import zombie.characters.AttachedItems.AttachedLocationGroup;
import zombie.characters.AttachedItems.AttachedLocations;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.characters.SurvivorDesc;
import zombie.characters.Talker;
import zombie.characters.WornItems.BodyLocationGroup;
import zombie.characters.WornItems.BodyLocations;
import zombie.characters.WornItems.WornItems;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.opengl.Shader;
import zombie.core.physics.Transform;
import zombie.core.skinnedmodel.DeadBodyAtlas;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.visual.BaseVisual;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.debug.LogSeverity;
import zombie.input.Mouse;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Food;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.IsoObjectID;
import zombie.network.ServerGUI;
import zombie.network.ServerLOS;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class IsoDeadBody
extends IsoMovingObject
implements Talker,
IHumanVisual {
    public static final int MAX_ROT_STAGES = 3;
    private static final int VISUAL_TYPE_HUMAN = 0;
    private static final IsoObjectID<IsoDeadBody> Bodies = new IsoObjectID<IsoDeadBody>(IsoDeadBody.class);
    private static final ArrayList<IsoDeadBody> tempBodies = new ArrayList();
    private boolean bFemale = false;
    private boolean wasZombie = false;
    private boolean bFakeDead = false;
    private boolean bCrawling = false;
    private Color SpeakColor;
    private float SpeakTime = 0.0f;
    private int m_persistentOutfitID;
    private SurvivorDesc desc;
    private BaseVisual baseVisual = null;
    private WornItems wornItems;
    private AttachedItems attachedItems;
    private float deathTime = -1.0f;
    private float reanimateTime = -1.0f;
    private IsoPlayer player;
    private boolean fallOnFront = false;
    private boolean wasSkeleton = false;
    private InventoryItem primaryHandItem = null;
    private InventoryItem secondaryHandItem = null;
    private float m_angle;
    private int m_zombieRotStageAtDeath = 1;
    private short onlineID = (short)-1;
    private short objectID = (short)-1;
    private static final ThreadLocal<IsoZombie> tempZombie = new ThreadLocal<IsoZombie>(){

        @Override
        public IsoZombie initialValue() {
            return new IsoZombie(null);
        }
    };
    private static ColorInfo inf = new ColorInfo();
    public DeadBodyAtlas.BodyTexture atlasTex;
    private static Texture DropShadow = null;
    private static final float HIT_TEST_WIDTH = 0.3f;
    private static final float HIT_TEST_HEIGHT = 0.9f;
    private static final Quaternionf _rotation = new Quaternionf();
    private static final Transform _transform = new Transform();
    private static final Vector3f _UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3f _tempVec3f_1 = new Vector3f();
    private static final Vector3f _tempVec3f_2 = new Vector3f();
    private float burnTimer = 0.0f;
    public boolean Speaking = false;
    public String sayLine = "";

    public static boolean isDead(short s) {
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        for (IsoDeadBody isoDeadBody : Bodies) {
            if (isoDeadBody.onlineID != s || !(f - isoDeadBody.deathTime < 0.1f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getObjectName() {
        return "DeadBody";
    }

    public IsoDeadBody(IsoGameCharacter isoGameCharacter) {
        this(isoGameCharacter, false);
    }

    public IsoDeadBody(IsoGameCharacter isoGameCharacter, boolean bl) {
        super(isoGameCharacter.getCell(), false);
        IsoGridSquare isoGridSquare;
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        this.setFallOnFront(isoGameCharacter.isFallOnFront());
        if (!GameClient.bClient && !GameServer.bServer && isoZombie != null && isoZombie.bCrawling) {
            if (!isoZombie.isReanimate()) {
                this.setFallOnFront(true);
            }
            this.bCrawling = true;
        }
        if ((isoGridSquare = isoGameCharacter.getCurrentSquare()) == null) {
            return;
        }
        if (isoGameCharacter.getZ() < 0.0f) {
            DebugLog.General.error("invalid z-coordinate %d,%d,%d", Float.valueOf(isoGameCharacter.x), Float.valueOf(isoGameCharacter.y), Float.valueOf(isoGameCharacter.z));
            isoGameCharacter.setZ(0.0f);
        }
        this.square = isoGridSquare;
        this.current = isoGridSquare;
        if (isoGameCharacter instanceof IsoPlayer) {
            ((IsoPlayer)isoGameCharacter).removeSaveFile();
        }
        isoGridSquare.getStaticMovingObjects().add(this);
        if (isoGameCharacter instanceof IsoSurvivor) {
            IsoWorld.instance.TotalSurvivorNights += ((IsoSurvivor)isoGameCharacter).nightsSurvived;
            ++IsoWorld.instance.TotalSurvivorsDead;
            if (IsoWorld.instance.SurvivorSurvivalRecord < ((IsoSurvivor)isoGameCharacter).nightsSurvived) {
                IsoWorld.instance.SurvivorSurvivalRecord = ((IsoSurvivor)isoGameCharacter).nightsSurvived;
            }
        }
        this.bFemale = isoGameCharacter.isFemale();
        boolean bl2 = this.wasZombie = isoZombie != null;
        if (this.wasZombie) {
            this.bFakeDead = isoZombie.isFakeDead();
            this.wasSkeleton = isoZombie.isSkeleton();
        }
        this.dir = isoGameCharacter.dir;
        this.m_angle = isoGameCharacter.getAnimAngleRadians();
        this.Collidable = false;
        this.x = isoGameCharacter.getX();
        this.y = isoGameCharacter.getY();
        this.z = isoGameCharacter.getZ();
        this.nx = this.x;
        this.ny = this.y;
        this.offsetX = isoGameCharacter.offsetX;
        this.offsetY = isoGameCharacter.offsetY;
        this.solid = false;
        this.shootable = false;
        this.onlineID = isoGameCharacter.getOnlineID();
        this.OutlineOnMouseover = true;
        this.setContainer(isoGameCharacter.getInventory());
        this.setWornItems(isoGameCharacter.getWornItems());
        this.setAttachedItems(isoGameCharacter.getAttachedItems());
        if (isoGameCharacter instanceof IHumanVisual) {
            this.baseVisual = new HumanVisual(this);
            this.baseVisual.copyFrom(((IHumanVisual)((Object)isoGameCharacter)).getHumanVisual());
            this.m_zombieRotStageAtDeath = this.getHumanVisual().zombieRotStage;
        }
        isoGameCharacter.setInventory(new ItemContainer());
        isoGameCharacter.clearWornItems();
        isoGameCharacter.clearAttachedItems();
        if (!this.container.bExplored) {
            this.container.setExplored(isoGameCharacter instanceof IsoPlayer || isoGameCharacter instanceof IsoZombie && ((IsoZombie)isoGameCharacter).isReanimatedPlayer());
        }
        boolean bl3 = isoGameCharacter.isOnFire();
        if (isoGameCharacter instanceof IsoZombie) {
            this.m_persistentOutfitID = isoGameCharacter.getPersistentOutfitID();
            if (!bl && !GameServer.bServer) {
                for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                    IsoPlayer isoPlayer = IsoPlayer.players[i];
                    if (isoPlayer == null || isoPlayer.ReanimatedCorpse != isoGameCharacter) continue;
                    isoPlayer.ReanimatedCorpse = null;
                    isoPlayer.ReanimatedCorpseID = -1;
                }
                if (!GameClient.bClient && isoGameCharacter.emitter != null) {
                    isoGameCharacter.emitter.tick();
                }
            }
        } else {
            if (isoGameCharacter instanceof IsoSurvivor) {
                this.getCell().getSurvivorList().remove(isoGameCharacter);
            }
            this.desc = new SurvivorDesc(isoGameCharacter.getDescriptor());
            if (isoGameCharacter instanceof IsoPlayer) {
                if (GameServer.bServer) {
                    this.player = (IsoPlayer)isoGameCharacter;
                } else if (!GameClient.bClient && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                    this.player = (IsoPlayer)isoGameCharacter;
                }
            }
        }
        LuaManager.copyTable(this.getModData(), isoGameCharacter.getModData());
        isoGameCharacter.removeFromWorld();
        isoGameCharacter.removeFromSquare();
        this.sayLine = isoGameCharacter.getSayLine();
        this.SpeakColor = isoGameCharacter.getSpeakColour();
        this.SpeakTime = isoGameCharacter.getSpeakTime();
        this.Speaking = isoGameCharacter.isSpeaking();
        if (bl3) {
            if (!GameClient.bClient && SandboxOptions.instance.FireSpread.getValue()) {
                IsoFireManager.StartFire(this.getCell(), this.getSquare(), true, 100, 500);
            }
            this.container.setExplored(true);
        }
        if (!bl && !GameServer.bServer) {
            LuaEventManager.triggerEvent("OnContainerUpdate", this);
        }
        if (isoGameCharacter instanceof IsoPlayer) {
            ((IsoPlayer)isoGameCharacter).bDeathFinished = true;
        }
        this.deathTime = (float)GameTime.getInstance().getWorldAgeHours();
        this.setEatingZombies(isoGameCharacter.getEatingZombies());
        if (!this.wasZombie) {
            int n;
            ArrayList<IsoMovingObject> arrayList = new ArrayList<IsoMovingObject>();
            for (n = -2; n < 2; ++n) {
                for (int i = -2; i < 2; ++i) {
                    IsoGridSquare isoGridSquare2 = isoGridSquare.getCell().getGridSquare(isoGridSquare.x + n, isoGridSquare.y + i, isoGridSquare.z);
                    if (isoGridSquare2 == null) continue;
                    for (int j = 0; j < isoGridSquare2.getMovingObjects().size(); ++j) {
                        if (!(isoGridSquare2.getMovingObjects().get(j) instanceof IsoZombie)) continue;
                        arrayList.add(isoGridSquare2.getMovingObjects().get(j));
                    }
                }
            }
            for (n = 0; n < arrayList.size(); ++n) {
                ((IsoZombie)arrayList.get(n)).pathToLocationF(this.getX() + Rand.Next(-0.3f, 0.3f), this.getY() + Rand.Next(-0.3f, 0.3f), this.getZ());
                ((IsoZombie)arrayList.get((int)n)).bodyToEat = this;
            }
        }
        if (!GameClient.bClient) {
            this.objectID = Bodies.allocateID();
        }
        Bodies.put(this.objectID, this);
        if (!GameServer.bServer) {
            FliesSound.instance.corpseAdded((int)this.getX(), (int)this.getY(), (int)this.getZ());
        }
        DebugLog.Death.noise("Corpse created %s", this.getDescription());
    }

    public IsoDeadBody(IsoCell isoCell) {
        super(isoCell, false);
        this.SpeakColor = Color.white;
        this.solid = false;
        this.shootable = false;
        BodyLocationGroup bodyLocationGroup = BodyLocations.getGroup("Human");
        this.wornItems = new WornItems(bodyLocationGroup);
        AttachedLocationGroup attachedLocationGroup = AttachedLocations.getGroup("Human");
        this.attachedItems = new AttachedItems(attachedLocationGroup);
        DebugLog.Death.noise("Corpse created on cell %s", this.getDescription());
    }

    public BaseVisual getVisual() {
        return this.baseVisual;
    }

    @Override
    public HumanVisual getHumanVisual() {
        return Type.tryCastTo(this.baseVisual, HumanVisual.class);
    }

    @Override
    public void getItemVisuals(ItemVisuals itemVisuals) {
        this.wornItems.getItemVisuals(itemVisuals);
    }

    @Override
    public boolean isFemale() {
        return this.bFemale;
    }

    @Override
    public boolean isZombie() {
        return this.wasZombie;
    }

    public boolean isCrawling() {
        return this.bCrawling;
    }

    public void setCrawling(boolean bl) {
        this.bCrawling = bl;
    }

    public boolean isFakeDead() {
        return this.bFakeDead;
    }

    public void setFakeDead(boolean bl) {
        if (bl && SandboxOptions.instance.Lore.DisableFakeDead.getValue() == 3) {
            return;
        }
        this.bFakeDead = bl;
    }

    @Override
    public boolean isSkeleton() {
        return this.wasSkeleton;
    }

    public void setWornItems(WornItems wornItems) {
        this.wornItems = new WornItems(wornItems);
    }

    public WornItems getWornItems() {
        return this.wornItems;
    }

    public void setAttachedItems(AttachedItems attachedItems) {
        if (attachedItems == null) {
            return;
        }
        this.attachedItems = new AttachedItems(attachedItems);
        for (int i = 0; i < this.attachedItems.size(); ++i) {
            AttachedItem attachedItem = this.attachedItems.get(i);
            InventoryItem inventoryItem = attachedItem.getItem();
            if (this.container.contains(inventoryItem) || GameClient.bClient || GameServer.bServer) continue;
            inventoryItem.setContainer(this.container);
            this.container.getItems().add(inventoryItem);
        }
    }

    public AttachedItems getAttachedItems() {
        return this.attachedItems;
    }

    public InventoryItem getItem() {
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem("Base.CorpseMale");
        inventoryItem.storeInByteData(this);
        return inventoryItem;
    }

    private IsoSprite loadSprite(ByteBuffer byteBuffer) {
        String string = GameWindow.ReadString(byteBuffer);
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        float f4 = byteBuffer.getFloat();
        return null;
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        boolean bl2;
        block16: {
            int n2;
            super.load(byteBuffer, n, bl);
            this.bFemale = byteBuffer.get() == 1;
            this.wasZombie = byteBuffer.get() == 1;
            this.objectID = n >= 192 ? byteBuffer.getShort() : (short)-1;
            boolean bl3 = bl2 = byteBuffer.get() == 1;
            if (n >= 171) {
                this.m_persistentOutfitID = byteBuffer.getInt();
            }
            if (bl2 && n < 171) {
                n2 = byteBuffer.getShort();
            }
            if (byteBuffer.get() == 1) {
                this.desc = new SurvivorDesc(true);
                this.desc.load(byteBuffer, n, null);
            }
            if (n >= 190) {
                n2 = byteBuffer.get();
                switch (n2) {
                    case 0: {
                        this.baseVisual = new HumanVisual(this);
                        this.baseVisual.load(byteBuffer, n);
                        break;
                    }
                    default: {
                        throw new IOException("invalid visualType for corpse");
                    }
                }
            } else {
                this.baseVisual = new HumanVisual(this);
                this.baseVisual.load(byteBuffer, n);
            }
            if (byteBuffer.get() == 1) {
                n2 = byteBuffer.getInt();
                try {
                    int n3;
                    this.setContainer(new ItemContainer());
                    this.container.ID = n2;
                    ArrayList<InventoryItem> arrayList = this.container.load(byteBuffer, n);
                    int n4 = byteBuffer.get();
                    for (n3 = 0; n3 < n4; ++n3) {
                        String string = GameWindow.ReadString(byteBuffer);
                        short s = byteBuffer.getShort();
                        if (s < 0 || s >= arrayList.size() || this.wornItems.getBodyLocationGroup().getLocation(string) == null) continue;
                        this.wornItems.setItem(string, arrayList.get(s));
                    }
                    n3 = byteBuffer.get();
                    for (int i = 0; i < n3; ++i) {
                        String string = GameWindow.ReadString(byteBuffer);
                        short s = byteBuffer.getShort();
                        if (s < 0 || s >= arrayList.size() || this.attachedItems.getGroup().getLocation(string) == null) continue;
                        this.attachedItems.setItem(string, arrayList.get(s));
                    }
                }
                catch (Exception exception) {
                    if (this.container == null) break block16;
                    DebugLog.log("Failed to stream in container ID: " + this.container.ID);
                }
            }
        }
        this.deathTime = byteBuffer.getFloat();
        this.reanimateTime = byteBuffer.getFloat();
        boolean bl4 = this.fallOnFront = byteBuffer.get() == 1;
        if (bl2 && (GameClient.bClient || GameServer.bServer && ServerGUI.isCreated())) {
            this.checkClothing(null);
        }
        this.wasSkeleton = byteBuffer.get() == 1;
        this.m_angle = n >= 159 ? byteBuffer.getFloat() : this.dir.toAngle();
        if (n >= 166) {
            this.m_zombieRotStageAtDeath = byteBuffer.get() & 0xFF;
        }
        if (n >= 168) {
            this.bCrawling = byteBuffer.get() == 1;
            this.bFakeDead = byteBuffer.get() == 1;
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.bFemale ? (byte)1 : 0);
        byteBuffer.put(this.wasZombie ? (byte)1 : 0);
        byteBuffer.putShort(this.objectID);
        if (GameServer.bServer || GameClient.bClient) {
            byteBuffer.put((byte)1);
        } else {
            byteBuffer.put((byte)0);
        }
        byteBuffer.putInt(this.m_persistentOutfitID);
        if (this.desc != null) {
            byteBuffer.put((byte)1);
            this.desc.save(byteBuffer);
        } else {
            byteBuffer.put((byte)0);
        }
        if (!(this.baseVisual instanceof HumanVisual)) {
            throw new IllegalStateException("unhandled baseVisual class");
        }
        byteBuffer.put((byte)0);
        this.baseVisual.save(byteBuffer);
        if (this.container != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.container.ID);
            ArrayList<InventoryItem> arrayList = this.container.save(byteBuffer);
            if (this.wornItems.size() > 127) {
                throw new RuntimeException("too many worn items");
            }
            byteBuffer.put((byte)this.wornItems.size());
            this.wornItems.forEach(wornItem -> {
                GameWindow.WriteString(byteBuffer, wornItem.getLocation());
                byteBuffer.putShort((short)arrayList.indexOf(wornItem.getItem()));
            });
            if (this.attachedItems == null) {
                byteBuffer.put((byte)0);
            } else {
                if (this.attachedItems.size() > 127) {
                    throw new RuntimeException("too many attached items");
                }
                byteBuffer.put((byte)this.attachedItems.size());
                this.attachedItems.forEach(attachedItem -> {
                    GameWindow.WriteString(byteBuffer, attachedItem.getLocation());
                    byteBuffer.putShort((short)arrayList.indexOf(attachedItem.getItem()));
                });
            }
        } else {
            byteBuffer.put((byte)0);
        }
        byteBuffer.putFloat(this.deathTime);
        byteBuffer.putFloat(this.reanimateTime);
        byteBuffer.put(this.fallOnFront ? (byte)1 : 0);
        byteBuffer.put(this.isSkeleton() ? (byte)1 : 0);
        byteBuffer.putFloat(this.m_angle);
        byteBuffer.put((byte)this.m_zombieRotStageAtDeath);
        byteBuffer.put(this.bCrawling ? (byte)1 : 0);
        byteBuffer.put(this.bFakeDead ? (byte)1 : 0);
    }

    @Override
    public void softReset() {
        this.square.RemoveTileObject(this);
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("becomeSkeleton".equals(string)) {
            byteBuffer.putInt(this.getHumanVisual().getSkinTextureIndex());
        } else if ("zombieRotStage".equals(string)) {
            byteBuffer.putInt(this.getHumanVisual().zombieRotStage);
        } else {
            super.saveChange(string, kahluaTable, byteBuffer);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("becomeSkeleton".equals(string)) {
            int n = byteBuffer.getInt();
            this.getHumanVisual().setBeardModel("");
            this.getHumanVisual().setHairModel("");
            this.getHumanVisual().setSkinTextureIndex(n);
            this.wasSkeleton = true;
            this.getWornItems().clear();
            this.getAttachedItems().clear();
            this.getContainer().clear();
            this.atlasTex = null;
        } else if ("zombieRotStage".equals(string)) {
            this.getHumanVisual().zombieRotStage = byteBuffer.getInt();
            this.atlasTex = null;
        } else {
            super.loadChange(string, byteBuffer);
        }
    }

    @Override
    public void renderlast() {
        if (this.Speaking) {
            float f = this.sx;
            float f2 = this.sy;
            f -= IsoCamera.getOffX();
            f2 -= IsoCamera.getOffY();
            f += 8.0f;
            f2 += 32.0f;
            if (this.sayLine != null) {
                TextManager.instance.DrawStringCentre(UIFont.Medium, f, f2, this.sayLine, this.SpeakColor.r, this.SpeakColor.g, this.SpeakColor.b, this.SpeakColor.a);
            }
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        float f4;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        boolean bl3 = this.isHighlighted();
        if (ModelManager.instance.bDebugEnableModels && ModelManager.instance.isCreated()) {
            if (this.atlasTex == null) {
                this.atlasTex = DeadBodyAtlas.instance.getBodyTexture(this);
                DeadBodyAtlas.instance.render();
            }
            if (this.atlasTex != null) {
                if (IsoSprite.globalOffsetX == -1.0f) {
                    IsoSprite.globalOffsetX = -IsoCamera.frameState.OffX;
                    IsoSprite.globalOffsetY = -IsoCamera.frameState.OffY;
                }
                float f5 = IsoUtils.XToScreen(f, f2, f3, 0);
                float f6 = IsoUtils.YToScreen(f, f2, f3, 0);
                this.sx = f5;
                this.sy = f6;
                f5 = this.sx + IsoSprite.globalOffsetX;
                f6 = this.sy + IsoSprite.globalOffsetY;
                if (Core.TileScale == 1) {
                    // empty if block
                }
                if (bl3) {
                    IsoDeadBody.inf.r = this.getHighlightColor().r;
                    IsoDeadBody.inf.g = this.getHighlightColor().g;
                    IsoDeadBody.inf.b = this.getHighlightColor().b;
                    IsoDeadBody.inf.a = this.getHighlightColor().a;
                } else {
                    IsoDeadBody.inf.r = colorInfo.r;
                    IsoDeadBody.inf.g = colorInfo.g;
                    IsoDeadBody.inf.b = colorInfo.b;
                    IsoDeadBody.inf.a = colorInfo.a;
                }
                colorInfo = inf;
                if (!bl3 && PerformanceSettings.LightingFrameSkip < 3 && this.getCurrentSquare() != null) {
                    this.getCurrentSquare().interpolateLight(colorInfo, f - (float)this.getCurrentSquare().getX(), f2 - (float)this.getCurrentSquare().getY());
                }
                if (GameServer.bServer && ServerGUI.isCreated()) {
                    inf.set(1.0f, 1.0f, 1.0f, 1.0f);
                }
                this.atlasTex.render((int)f5, (int)f6, colorInfo.r, colorInfo.g, colorInfo.b, colorInfo.a);
                if (Core.bDebug && DebugOptions.instance.DeadBodyAtlasRender.getValue()) {
                    LineDrawer.DrawIsoLine(f - 0.5f, f2, f3, f + 0.5f, f2, f3, 1.0f, 1.0f, 1.0f, 0.25f, 1);
                    LineDrawer.DrawIsoLine(f, f2 - 0.5f, f3, f, f2 + 0.5f, f3, 1.0f, 1.0f, 1.0f, 0.25f, 1);
                }
                this.sx = f5;
                this.sy = f6;
                if (IsoObjectPicker.Instance.wasDirty) {
                    this.renderObjectPicker(this.getX(), this.getY(), this.getZ(), colorInfo);
                }
            }
        }
        if (Core.bDebug && DebugOptions.instance.DeadBodyAtlasRender.getValue()) {
            _rotation.setAngleAxis((double)this.m_angle + 1.5707963267948966, 0.0, 0.0, 1.0);
            _transform.setRotation(_rotation);
            IsoDeadBody._transform.origin.set(this.x, this.y, this.z);
            Vector3f vector3f = _tempVec3f_1;
            IsoDeadBody._transform.basis.getColumn(1, vector3f);
            Vector3f vector3f2 = _tempVec3f_2;
            vector3f.cross((Vector3fc)_UNIT_Z, vector3f2);
            f4 = 0.3f;
            float f7 = 0.9f;
            vector3f.x *= f7;
            vector3f.y *= f7;
            vector3f2.x *= f4;
            vector3f2.y *= f4;
            float f8 = f + vector3f.x;
            float f9 = f2 + vector3f.y;
            float f10 = f - vector3f.x;
            float f11 = f2 - vector3f.y;
            float f12 = f8 - vector3f2.x;
            float f13 = f8 + vector3f2.x;
            float f14 = f10 - vector3f2.x;
            float f15 = f10 + vector3f2.x;
            float f16 = f11 - vector3f2.y;
            float f17 = f11 + vector3f2.y;
            float f18 = f9 - vector3f2.y;
            float f19 = f9 + vector3f2.y;
            float f20 = 1.0f;
            float f21 = 1.0f;
            float f22 = 1.0f;
            if (this.isMouseOver(Mouse.getX(), Mouse.getY())) {
                f22 = 0.0f;
                f20 = 0.0f;
            }
            LineDrawer.addLine(f12, f18, 0.0f, f13, f19, 0.0f, f20, f21, f22, null, true);
            LineDrawer.addLine(f12, f18, 0.0f, f14, f16, 0.0f, f20, f21, f22, null, true);
            LineDrawer.addLine(f13, f19, 0.0f, f15, f17, 0.0f, f20, f21, f22, null, true);
            LineDrawer.addLine(f14, f16, 0.0f, f15, f17, 0.0f, f20, f21, f22, null, true);
        }
        if (this.isFakeDead() && DebugOptions.instance.ZombieRenderFakeDead.getValue()) {
            float f23 = IsoUtils.XToScreen(f, f2, f3, 0) + IsoSprite.globalOffsetX;
            float f24 = IsoUtils.YToScreen(f, f2, f3, 0) + IsoSprite.globalOffsetY - (float)(16 * Core.TileScale);
            f4 = this.getFakeDeadWakeupHours() - (float)GameTime.getInstance().getWorldAgeHours();
            f4 = Math.max(f4, 0.0f);
            TextManager.instance.DrawStringCentre(UIFont.Medium, f23, f24, String.format("FakeDead %.2f", Float.valueOf(f4)), 1.0, 1.0, 1.0, 1.0);
        }
        if (Core.bDebug && DebugOptions.instance.MultiplayerShowZombieOwner.getValue()) {
            Color color = Colors.Yellow;
            float f25 = IsoUtils.XToScreenExact(f + 0.4f, f2 + 0.4f, f3, 0);
            f4 = IsoUtils.YToScreenExact(f + 0.4f, f2 - 1.4f, f3, 0);
            TextManager.instance.DrawStringCentre(UIFont.DebugConsole, f25, f4, this.objectID + " / " + this.onlineID + " / " + (this.isFemale() ? "F" : "M"), color.r, color.g, color.b, color.a);
            TextManager.instance.DrawStringCentre(UIFont.DebugConsole, f25, f4 + 10.0f, String.format("x=%09.3f ", Float.valueOf(f)) + String.format("y=%09.3f ", Float.valueOf(f2)) + String.format("z=%d", (byte)f3), color.r, color.g, color.b, color.a);
        }
    }

    public void renderShadow() {
        _rotation.setAngleAxis((double)this.m_angle + 1.5707963267948966, 0.0, 0.0, 1.0);
        _transform.setRotation(_rotation);
        IsoDeadBody._transform.origin.set(this.x, this.y, this.z);
        Vector3f vector3f = _tempVec3f_1;
        IsoDeadBody._transform.basis.getColumn(1, vector3f);
        float f = 0.45f;
        float f2 = 1.4f;
        float f3 = 1.125f;
        int n = IsoCamera.frameState.playerIndex;
        ColorInfo colorInfo = this.square.lighting[n].lightInfo();
        IsoDeadBody.renderShadow(this.x, this.y, this.z, vector3f, f, f2, f3, colorInfo, this.getAlpha(n));
    }

    public static void renderShadow(float f, float f2, float f3, Vector3f vector3f, float f4, float f5, float f6, ColorInfo colorInfo, float f7) {
        float f8 = f7;
        f8 *= (colorInfo.r + colorInfo.g + colorInfo.b) / 3.0f;
        f8 *= 0.66f;
        vector3f.normalize();
        Vector3f vector3f2 = _tempVec3f_2;
        vector3f.cross((Vector3fc)_UNIT_Z, vector3f2);
        f4 = Math.max(0.65f, f4);
        f5 = Math.max(f5, 0.65f);
        f6 = Math.max(f6, 0.65f);
        vector3f2.x *= f4;
        vector3f2.y *= f4;
        float f9 = f + vector3f.x * f5;
        float f10 = f2 + vector3f.y * f5;
        float f11 = f - vector3f.x * f6;
        float f12 = f2 - vector3f.y * f6;
        float f13 = f9 - vector3f2.x;
        float f14 = f9 + vector3f2.x;
        float f15 = f11 - vector3f2.x;
        float f16 = f11 + vector3f2.x;
        float f17 = f12 - vector3f2.y;
        float f18 = f12 + vector3f2.y;
        float f19 = f10 - vector3f2.y;
        float f20 = f10 + vector3f2.y;
        float f21 = IsoUtils.XToScreenExact(f13, f19, f3, 0);
        float f22 = IsoUtils.YToScreenExact(f13, f19, f3, 0);
        float f23 = IsoUtils.XToScreenExact(f14, f20, f3, 0);
        float f24 = IsoUtils.YToScreenExact(f14, f20, f3, 0);
        float f25 = IsoUtils.XToScreenExact(f16, f18, f3, 0);
        float f26 = IsoUtils.YToScreenExact(f16, f18, f3, 0);
        float f27 = IsoUtils.XToScreenExact(f15, f17, f3, 0);
        float f28 = IsoUtils.YToScreenExact(f15, f17, f3, 0);
        if (DropShadow == null) {
            DropShadow = Texture.getSharedTexture("media/textures/NewShadow.png");
        }
        SpriteRenderer.instance.renderPoly(DropShadow, f21, f22, f23, f24, f25, f26, f27, f28, 0.0f, 0.0f, 0.0f, f8);
        if (DebugOptions.instance.IsoSprite.DropShadowEdges.getValue()) {
            LineDrawer.addLine(f13, f19, f3, f14, f20, f3, 1, 1, 1, null);
            LineDrawer.addLine(f14, f20, f3, f16, f18, f3, 1, 1, 1, null);
            LineDrawer.addLine(f16, f18, f3, f15, f17, f3, 1, 1, 1, null);
            LineDrawer.addLine(f15, f17, f3, f13, f19, f3, 1, 1, 1, null);
        }
    }

    @Override
    public void renderObjectPicker(float f, float f2, float f3, ColorInfo colorInfo) {
        if (this.atlasTex == null) {
            return;
        }
        this.atlasTex.renderObjectPicker(this.sx, this.sy, colorInfo, this.square, this);
    }

    public boolean isMouseOver(float f, float f2) {
        _rotation.setAngleAxis((double)this.m_angle + 1.5707963267948966, 0.0, 0.0, 1.0);
        _transform.setRotation(_rotation);
        IsoDeadBody._transform.origin.set(this.x, this.y, this.z);
        _transform.inverse();
        Vector3f vector3f = _tempVec3f_1.set(IsoUtils.XToIso(f, f2, this.z), IsoUtils.YToIso(f, f2, this.z), this.z);
        _transform.transform(vector3f);
        return vector3f.x >= -0.3f && vector3f.y >= -0.9f && vector3f.x < 0.3f && vector3f.y < 0.9f;
    }

    public void Burn() {
        if (GameClient.bClient) {
            return;
        }
        if (this.getSquare() != null && this.getSquare().getProperties().Is(IsoFlagType.burning)) {
            this.burnTimer += GameTime.instance.getMultipliedSecondsSinceLastUpdate();
        } else {
            return;
        }
        if (this.burnTimer >= 10.0f) {
            boolean bl = true;
            for (int i = 0; i < this.getSquare().getObjects().size(); ++i) {
                IsoObject isoObject = this.getSquare().getObjects().get(i);
                if (isoObject.getName() == null || !"burnedCorpse".equals(isoObject.getName())) continue;
                bl = false;
                break;
            }
            if (bl) {
                IsoObject isoObject = new IsoObject(this.getSquare(), "floors_burnt_01_" + Rand.Next(1, 3), "burnedCorpse");
                this.getSquare().getObjects().add(isoObject);
                isoObject.transmitCompleteItemToClients();
            }
            if (GameServer.bServer) {
                GameServer.sendRemoveCorpseFromMap(this);
            }
            this.getSquare().removeCorpse(this, true);
        }
    }

    @Override
    public void setContainer(ItemContainer itemContainer) {
        super.setContainer(itemContainer);
        itemContainer.type = this.bFemale ? "inventoryfemale" : "inventorymale";
        itemContainer.Capacity = 8;
        itemContainer.SourceGrid = this.square;
    }

    public void checkClothing(InventoryItem inventoryItem) {
        InventoryItem inventoryItem2;
        int n;
        for (n = 0; n < this.wornItems.size(); ++n) {
            inventoryItem2 = this.wornItems.getItemByIndex(n);
            if (this.container != null && this.container.getItems().indexOf(inventoryItem2) != -1) continue;
            this.wornItems.remove(inventoryItem2);
            this.atlasTex = null;
            --n;
        }
        if (inventoryItem == this.getPrimaryHandItem()) {
            this.setPrimaryHandItem(null);
            this.atlasTex = null;
        }
        if (inventoryItem == this.getSecondaryHandItem()) {
            this.setSecondaryHandItem(null);
            this.atlasTex = null;
        }
        for (n = 0; n < this.attachedItems.size(); ++n) {
            inventoryItem2 = this.attachedItems.getItemByIndex(n);
            if (this.container != null && this.container.getItems().indexOf(inventoryItem2) != -1) continue;
            this.attachedItems.remove(inventoryItem2);
            this.atlasTex = null;
            --n;
        }
    }

    @Override
    public boolean IsSpeaking() {
        return this.Speaking;
    }

    @Override
    public void Say(String string) {
        this.SpeakTime = string.length() * 4;
        if (this.SpeakTime < 60.0f) {
            this.SpeakTime = 60.0f;
        }
        this.sayLine = string;
        this.Speaking = true;
    }

    @Override
    public String getSayLine() {
        return this.sayLine;
    }

    @Override
    public String getTalkerType() {
        return "Talker";
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        if (!GameServer.bServer) {
            FliesSound.instance.corpseAdded((int)this.getX(), (int)this.getY(), (int)this.getZ());
        }
        if (!GameClient.bClient && this.objectID == -1) {
            this.objectID = Bodies.allocateID();
        }
        Bodies.put(this.objectID, this);
        if (GameClient.bClient) {
            return;
        }
        if (this.reanimateTime > 0.0f) {
            this.getCell().addToStaticUpdaterObjectList(this);
            if (Core.bDebug) {
                DebugLog.log("reanimate: addToWorld reanimateTime=" + this.reanimateTime + this);
            }
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        if (this.deathTime < 0.0f) {
            this.deathTime = f;
        }
        if (this.deathTime > f) {
            this.deathTime = f;
        }
    }

    @Override
    public void removeFromWorld() {
        if (!GameServer.bServer) {
            FliesSound.instance.corpseRemoved((int)this.getX(), (int)this.getY(), (int)this.getZ());
        }
        Bodies.remove(this.objectID);
        super.removeFromWorld();
    }

    public static void updateBodies() {
        if (GameClient.bClient) {
            return;
        }
        if (Core.bDebug) {
            // empty if block
        }
        boolean bl = false;
        float f = (float)SandboxOptions.instance.HoursForCorpseRemoval.getValue();
        if (f <= 0.0f) {
            return;
        }
        float f2 = f / 3.0f;
        float f3 = (float)GameTime.getInstance().getWorldAgeHours();
        tempBodies.clear();
        Bodies.getObjects(tempBodies);
        for (IsoDeadBody isoDeadBody : tempBodies) {
            if (isoDeadBody.getHumanVisual() == null) continue;
            if (isoDeadBody.deathTime > f3) {
                isoDeadBody.deathTime = f3;
                isoDeadBody.getHumanVisual().zombieRotStage = isoDeadBody.m_zombieRotStageAtDeath;
            }
            if (isoDeadBody.updateFakeDead() || !ServerOptions.instance.RemovePlayerCorpsesOnCorpseRemoval.getValue() && !isoDeadBody.wasZombie) continue;
            int n = isoDeadBody.getHumanVisual().zombieRotStage;
            isoDeadBody.updateRotting(f3, f2, bl);
            if (isoDeadBody.isFakeDead()) {
                // empty if block
            }
            int n2 = isoDeadBody.getHumanVisual().zombieRotStage;
            float f4 = f3 - isoDeadBody.deathTime;
            if (f4 < f + (isoDeadBody.isSkeleton() ? f2 : 0.0f)) continue;
            if (bl) {
                int n3 = (int)(f4 / f2);
                DebugLog.General.debugln("%s REMOVE %d -> %d age=%.2f stages=%d", isoDeadBody, n, n2, Float.valueOf(f4), n3);
            }
            if (GameServer.bServer) {
                GameServer.sendRemoveCorpseFromMap(isoDeadBody);
            }
            isoDeadBody.removeFromWorld();
            isoDeadBody.removeFromSquare();
        }
    }

    private void updateRotting(float f, float f2, boolean bl) {
        if (this.isSkeleton()) {
            return;
        }
        float f3 = f - this.deathTime;
        int n = (int)(f3 / f2);
        int n2 = this.m_zombieRotStageAtDeath + n;
        if (n < 3) {
            n2 = PZMath.clamp(n2, 1, 3);
        }
        if (n2 <= 3 && n2 != this.getHumanVisual().zombieRotStage) {
            int n3 = n2 - this.getHumanVisual().zombieRotStage;
            if (bl) {
                DebugLog.General.debugln("%s zombieRotStage %d -> %d age=%.2f stages=%d", this, this.getHumanVisual().zombieRotStage, n2, Float.valueOf(f3), n);
            }
            this.getHumanVisual().zombieRotStage = n2;
            this.atlasTex = null;
            if (GameServer.bServer) {
                this.sendObjectChange("zombieRotStage");
            }
            if (Rand.Next(100) == 0 && this.wasZombie && SandboxOptions.instance.Lore.DisableFakeDead.getValue() == 2) {
                this.setFakeDead(true);
                if (Rand.Next(5) == 0) {
                    this.setCrawling(true);
                }
            }
            String string = ClimateManager.getInstance().getSeasonName();
            if (n3 < 1 || string == "Winter") {
                return;
            }
            if (SandboxOptions.instance.MaggotSpawn.getValue() == 3) {
                return;
            }
            int n4 = 5;
            if (string == "Summer") {
                n4 = 3;
            }
            for (int i = 0; i < n3; ++i) {
                InventoryItem inventoryItem;
                if (this.wasZombie) {
                    if (Rand.Next(n4) == 0 && (inventoryItem = InventoryItemFactory.CreateItem("Maggots")) != null && this.getContainer() != null) {
                        this.getContainer().addItem(inventoryItem);
                        if (inventoryItem instanceof Food) {
                            ((Food)inventoryItem).setPoisonPower(5);
                        }
                    }
                    if (Rand.Next(n4 * 2) != 0 || SandboxOptions.instance.MaggotSpawn.getValue() == 2 || (inventoryItem = InventoryItemFactory.CreateItem("Maggots")) == null || this.getSquare() == null) continue;
                    this.getSquare().AddWorldInventoryItem(inventoryItem, (float)(Rand.Next(10) / 10), (float)(Rand.Next(10) / 10), 0.0f);
                    if (!(inventoryItem instanceof Food)) continue;
                    ((Food)inventoryItem).setPoisonPower(5);
                    continue;
                }
                if (Rand.Next(n4) == 0 && (inventoryItem = InventoryItemFactory.CreateItem("Maggots")) != null && this.getContainer() != null) {
                    this.getContainer().addItem(inventoryItem);
                }
                if (Rand.Next(n4 * 2) != 0 || SandboxOptions.instance.MaggotSpawn.getValue() == 2 || (inventoryItem = InventoryItemFactory.CreateItem("Maggots")) == null || this.getSquare() == null) continue;
                this.getSquare().AddWorldInventoryItem(inventoryItem, (float)(Rand.Next(10) / 10), (float)(Rand.Next(10) / 10), 0.0f);
            }
            return;
        }
        if (n == 3 && Rand.NextBool(7)) {
            if (bl) {
                DebugLog.General.debugln("%s zombieRotStage %d -> x age=%.2f stages=%d", this, this.getHumanVisual().zombieRotStage, Float.valueOf(f3), n);
            }
            this.getHumanVisual().setBeardModel("");
            this.getHumanVisual().setHairModel("");
            this.getHumanVisual().setSkinTextureIndex(Rand.Next(1, 3));
            this.wasSkeleton = true;
            this.getWornItems().clear();
            this.getAttachedItems().clear();
            this.getContainer().clear();
            this.atlasTex = null;
            if (GameServer.bServer) {
                this.sendObjectChange("becomeSkeleton");
            }
        }
    }

    private boolean updateFakeDead() {
        if (!this.isFakeDead()) {
            return false;
        }
        if (this.isSkeleton()) {
            return false;
        }
        if ((double)this.getFakeDeadWakeupHours() > GameTime.getInstance().getWorldAgeHours()) {
            return false;
        }
        if (!this.isPlayerNearby()) {
            return false;
        }
        if (SandboxOptions.instance.Lore.DisableFakeDead.getValue() == 3) {
            return false;
        }
        this.reanimateNow();
        return true;
    }

    private float getFakeDeadWakeupHours() {
        return this.deathTime + 0.5f;
    }

    private boolean isPlayerNearby() {
        if (GameServer.bServer) {
            for (int i = 0; i < GameServer.Players.size(); ++i) {
                boolean bl;
                IsoPlayer isoPlayer = GameServer.Players.get(i);
                boolean bl2 = bl = this.square != null && ServerLOS.instance.isCouldSee(isoPlayer, this.square);
                if (!this.isPlayerNearby(isoPlayer, bl)) continue;
                return true;
            }
        } else {
            IsoGridSquare isoGridSquare = this.getSquare();
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                boolean bl;
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                boolean bl3 = bl = isoGridSquare != null && isoGridSquare.isCanSee(i);
                if (!this.isPlayerNearby(isoPlayer, bl)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPlayerNearby(IsoPlayer isoPlayer, boolean bl) {
        if (!bl) {
            return false;
        }
        if (isoPlayer == null || isoPlayer.isDead()) {
            return false;
        }
        if (isoPlayer.isGhostMode() || isoPlayer.isInvisible()) {
            return false;
        }
        if (isoPlayer.getVehicle() != null) {
            return false;
        }
        float f = isoPlayer.DistToSquared(this);
        return !(f < 4.0f) && !(f > 16.0f);
    }

    public float getReanimateTime() {
        return this.reanimateTime;
    }

    public void setReanimateTime(float f) {
        this.reanimateTime = f;
        if (GameClient.bClient) {
            return;
        }
        ArrayList<IsoObject> arrayList = IsoWorld.instance.CurrentCell.getStaticUpdaterObjectList();
        if (this.reanimateTime > 0.0f && !arrayList.contains(this)) {
            arrayList.add(this);
        } else if (this.reanimateTime <= 0.0f && arrayList.contains(this)) {
            arrayList.remove(this);
        }
    }

    private float getReanimateDelay() {
        float f = 0.0f;
        float f2 = 0.0f;
        switch (SandboxOptions.instance.Lore.Reanimate.getValue()) {
            case 1: {
                break;
            }
            case 2: {
                f2 = 0.008333334f;
                break;
            }
            case 3: {
                f2 = 0.016666668f;
                break;
            }
            case 4: {
                f2 = 12.0f;
                break;
            }
            case 5: {
                f = 48.0f;
                f2 = 72.0f;
                break;
            }
            case 6: {
                f = 168.0f;
                f2 = 336.0f;
            }
        }
        if (Core.bTutorial) {
            f2 = 0.25f;
        }
        if (f == f2) {
            return f;
        }
        return Rand.Next(f, f2);
    }

    public void reanimateLater() {
        this.setReanimateTime((float)GameTime.getInstance().getWorldAgeHours() + this.getReanimateDelay());
    }

    public void reanimateNow() {
        this.setReanimateTime((float)GameTime.getInstance().getWorldAgeHours());
    }

    @Override
    public void update() {
        float f;
        if (this.current == null) {
            this.current = IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y, this.z);
        }
        if (GameClient.bClient) {
            return;
        }
        if (this.reanimateTime > 0.0f && this.reanimateTime <= (f = (float)GameTime.getInstance().getWorldAgeHours())) {
            this.reanimate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reanimate() {
        int n = -1;
        if (GameServer.bServer && (n = (int)ServerMap.instance.getUniqueZombieId()) == -1) {
            return;
        }
        SurvivorDesc survivorDesc = new SurvivorDesc();
        survivorDesc.setFemale(this.isFemale());
        IsoZombie isoZombie = new IsoZombie(IsoWorld.instance.CurrentCell, survivorDesc, -1);
        isoZombie.setPersistentOutfitID(this.m_persistentOutfitID);
        if (this.container == null) {
            this.container = new ItemContainer();
        }
        isoZombie.setInventory(this.container);
        this.container = null;
        isoZombie.getHumanVisual().copyFrom(this.getHumanVisual());
        isoZombie.getWornItems().copyFrom(this.wornItems);
        this.wornItems.clear();
        isoZombie.getAttachedItems().copyFrom(this.attachedItems);
        this.attachedItems.clear();
        isoZombie.setX(this.getX());
        isoZombie.setY(this.getY());
        isoZombie.setZ(this.getZ());
        isoZombie.setCurrent(this.getCurrentSquare());
        isoZombie.setMovingSquareNow();
        isoZombie.setDir(this.dir);
        LuaManager.copyTable(isoZombie.getModData(), this.getModData());
        isoZombie.getAnimationPlayer().setTargetAngle(this.m_angle);
        isoZombie.getAnimationPlayer().setAngleToTarget();
        isoZombie.setForwardDirection(Vector2.fromLengthDirection(1.0f, this.m_angle));
        isoZombie.setAlphaAndTarget(1.0f);
        Arrays.fill(isoZombie.IsVisibleToPlayer, true);
        isoZombie.setOnFloor(true);
        isoZombie.setCrawler(this.bCrawling);
        isoZombie.setCanWalk(!this.bCrawling);
        isoZombie.walkVariant = "ZombieWalk";
        isoZombie.DoZombieStats();
        isoZombie.setFallOnFront(this.isFallOnFront());
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 1) {
            isoZombie.setHealth(3.5f + Rand.Next(0.0f, 0.3f));
        }
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 2) {
            isoZombie.setHealth(1.8f + Rand.Next(0.0f, 0.3f));
        }
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 3) {
            isoZombie.setHealth(0.5f + Rand.Next(0.0f, 0.3f));
        }
        if (GameServer.bServer) {
            isoZombie.OnlineID = (short)n;
            ServerMap.instance.ZombieMap.put(isoZombie.OnlineID, isoZombie);
        }
        if (this.isFakeDead()) {
            isoZombie.setWasFakeDead(true);
        } else {
            isoZombie.setReanimatedPlayer(true);
            isoZombie.getDescriptor().setID(0);
            SharedDescriptors.createPlayerZombieDescriptor(isoZombie);
        }
        isoZombie.setReanimate(this.bCrawling);
        if (!IsoWorld.instance.CurrentCell.getZombieList().contains(isoZombie)) {
            IsoWorld.instance.CurrentCell.getZombieList().add(isoZombie);
        }
        if (!IsoWorld.instance.CurrentCell.getObjectList().contains(isoZombie) && !IsoWorld.instance.CurrentCell.getAddList().contains(isoZombie)) {
            IsoWorld.instance.CurrentCell.getAddList().add(isoZombie);
        }
        if (GameServer.bServer) {
            if (this.player != null) {
                this.player.ReanimatedCorpse = isoZombie;
                this.player.ReanimatedCorpseID = isoZombie.OnlineID;
            }
            isoZombie.networkAI.reanimatedBodyID = this.objectID;
        }
        if (GameServer.bServer) {
            GameServer.sendRemoveCorpseFromMap(this);
        }
        this.removeFromWorld();
        this.removeFromSquare();
        LuaEventManager.triggerEvent("OnContainerUpdate");
        isoZombie.setReanimateTimer(0.0f);
        isoZombie.onWornItemsChanged();
        if (this.player != null) {
            if (GameServer.bServer) {
                GameServer.sendReanimatedZombieID(this.player, isoZombie);
            } else if (!GameClient.bClient && this.player.isLocalPlayer()) {
                this.player.ReanimatedCorpse = isoZombie;
            }
            this.player.setLeaveBodyTimedown(3601.0f);
        }
        isoZombie.actionContext.update();
        float f = GameTime.getInstance().FPSMultiplier;
        GameTime.getInstance().FPSMultiplier = 100.0f;
        try {
            isoZombie.advancedAnimator.update();
        }
        finally {
            GameTime.getInstance().FPSMultiplier = f;
        }
        if (this.isFakeDead() && SoundManager.instance.isListenerInRange(this.x, this.y, 20.0f) && !GameServer.bServer) {
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Reanimate);
        }
        if (Core.bDebug) {
            DebugLog.Multiplayer.debugln("Reanimate: corpse=%d/%d zombie=%d delay=%f", this.getObjectID(), this.getOnlineID(), isoZombie.getOnlineID(), GameTime.getInstance().getWorldAgeHours() - (double)this.reanimateTime);
        }
    }

    public static void Reset() {
        Bodies.clear();
    }

    @Override
    public void Collision(Vector2 vector22, IsoObject isoObject) {
        if (isoObject instanceof BaseVehicle) {
            BaseVehicle baseVehicle = (BaseVehicle)isoObject;
            float f = 15.0f;
            Vector3f vector3f = (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc();
            Vector3f vector3f2 = (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc();
            baseVehicle.getLinearVelocity(vector3f);
            vector3f.y = 0.0f;
            vector3f2.set(baseVehicle.x - this.x, 0.0f, baseVehicle.z - this.z);
            vector3f2.normalize();
            vector3f.mul((Vector3fc)vector3f2);
            BaseVehicle.TL_vector3f_pool.get().release(vector3f2);
            float f2 = vector3f.length();
            BaseVehicle.TL_vector3f_pool.get().release(vector3f);
            f2 = Math.min(f2, f);
            if (f2 < 0.05f) {
                return;
            }
            if (Math.abs(baseVehicle.getCurrentSpeedKmHour()) > 20.0f) {
                baseVehicle.doChrHitImpulse(this);
            }
        }
    }

    public boolean isFallOnFront() {
        return this.fallOnFront;
    }

    public void setFallOnFront(boolean bl) {
        this.fallOnFront = bl;
    }

    public InventoryItem getPrimaryHandItem() {
        return this.primaryHandItem;
    }

    public void setPrimaryHandItem(InventoryItem inventoryItem) {
        this.primaryHandItem = inventoryItem;
        this.updateContainerWithHandItems();
    }

    private void updateContainerWithHandItems() {
        if (this.getContainer() != null) {
            if (this.getPrimaryHandItem() != null) {
                this.getContainer().AddItem(this.getPrimaryHandItem());
            }
            if (this.getSecondaryHandItem() != null) {
                this.getContainer().AddItem(this.getSecondaryHandItem());
            }
        }
    }

    public InventoryItem getSecondaryHandItem() {
        return this.secondaryHandItem;
    }

    public void setSecondaryHandItem(InventoryItem inventoryItem) {
        this.secondaryHandItem = inventoryItem;
        this.updateContainerWithHandItems();
    }

    public float getAngle() {
        return this.m_angle;
    }

    public String getOutfitName() {
        if (this.getHumanVisual().getOutfit() != null) {
            return this.getHumanVisual().getOutfit().m_Name;
        }
        return null;
    }

    private String getDescription() {
        return String.format("object-id=%d online-id=%d bFakeDead=%b bCrawling=%b isFallOnFront=%b (x=%f,y=%f,z=%f;a=%f) outfit=%d", this.objectID, this.onlineID, this.bFakeDead, this.bCrawling, this.fallOnFront, Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.m_angle), this.m_persistentOutfitID);
    }

    public String readInventory(ByteBuffer byteBuffer) {
        boolean bl;
        String string = GameWindow.ReadString(byteBuffer);
        if (this.getContainer() == null || this.getWornItems() == null || this.getAttachedItems() == null) {
            return string;
        }
        this.getContainer().clear();
        this.getWornItems().clear();
        this.getAttachedItems().clear();
        boolean bl2 = bl = byteBuffer.get() == 1;
        if (bl) {
            try {
                int n;
                ArrayList<InventoryItem> arrayList = this.getContainer().load(byteBuffer, IsoWorld.getWorldVersion());
                this.getContainer().Capacity = 8;
                int n2 = byteBuffer.get();
                for (n = 0; n < n2; ++n) {
                    String string2 = GameWindow.ReadStringUTF(byteBuffer);
                    short s = byteBuffer.getShort();
                    if (s < 0 || s >= arrayList.size() || this.getWornItems().getBodyLocationGroup().getLocation(string2) == null) continue;
                    this.getWornItems().setItem(string2, arrayList.get(s));
                }
                n = byteBuffer.get();
                for (int i = 0; i < n; ++i) {
                    String string3 = GameWindow.ReadStringUTF(byteBuffer);
                    short s = byteBuffer.getShort();
                    if (s < 0 || s >= arrayList.size() || this.getAttachedItems().getGroup().getLocation(string3) == null) continue;
                    this.getAttachedItems().setItem(string3, arrayList.get(s));
                }
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "ReadDeadBodyInventory error for dead body " + this.getOnlineID(), LogSeverity.Error);
            }
        }
        return string;
    }

    public short getObjectID() {
        return this.objectID;
    }

    public void setObjectID(short s) {
        this.objectID = s;
    }

    public short getOnlineID() {
        return this.onlineID;
    }

    public void setOnlineID(short s) {
        this.onlineID = s;
    }

    public boolean isPlayer() {
        return this.player != null;
    }

    public static IsoDeadBody getDeadBody(short s) {
        return Bodies.get(s);
    }

    public static void addDeadBodyID(short s, IsoDeadBody isoDeadBody) {
        Bodies.put(s, isoDeadBody);
    }

    public static void removeDeadBody(short s) {
        IsoDeadBody isoDeadBody = Bodies.get(s);
        if (isoDeadBody != null) {
            Bodies.remove(s);
            if (isoDeadBody.getSquare() != null) {
                isoDeadBody.getSquare().removeCorpse(isoDeadBody, true);
            }
        }
    }
}

