/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.SystemDisabler;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.opengl.Shader;
import zombie.core.properties.PropertyContainer;
import zombie.core.raknet.UdpConnection;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.util.Type;
import zombie.util.list.PZArrayList;

public class IsoCurtain
extends IsoObject {
    public boolean Barricaded = false;
    public Integer BarricideMaxStrength = 0;
    public Integer BarricideStrength = 0;
    public Integer Health = 1000;
    public boolean Locked = false;
    public Integer MaxHealth = 1000;
    public Integer PushedMaxStrength = 0;
    public Integer PushedStrength = 0;
    IsoSprite closedSprite;
    public boolean north = false;
    public boolean open = false;
    IsoSprite openSprite;
    private boolean destroyed = false;

    public void removeSheet(IsoGameCharacter isoGameCharacter) {
        this.square.transmitRemoveItemFromSquare(this);
        if (GameServer.bServer) {
            isoGameCharacter.sendObjectChange("addItemOfType", "type", "Base.Sheet");
        } else {
            isoGameCharacter.getInventory().AddItem("Base.Sheet");
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            LosUtil.cachecleared[i] = true;
        }
        GameTime.instance.lightSourceUpdate = 100.0f;
        IsoGridSquare.setRecalcLightTime(-1);
    }

    public IsoCurtain(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite, boolean bl, boolean bl2) {
        this.OutlineOnMouseover = true;
        this.PushedMaxStrength = this.PushedStrength = Integer.valueOf(2500);
        if (bl2) {
            this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, 4);
            this.closedSprite = isoSprite;
        } else {
            this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, -4);
            this.openSprite = isoSprite;
        }
        this.open = true;
        this.sprite = this.openSprite;
        this.square = isoGridSquare;
        this.north = bl;
        this.DirtySlice();
    }

    public IsoCurtain(IsoCell isoCell, IsoGridSquare isoGridSquare, String string, boolean bl) {
        this.OutlineOnMouseover = true;
        this.PushedMaxStrength = this.PushedStrength = Integer.valueOf(2500);
        this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, -4);
        this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 0);
        this.open = true;
        this.sprite = this.openSprite;
        this.square = isoGridSquare;
        this.north = bl;
        this.DirtySlice();
    }

    public IsoCurtain(IsoCell isoCell) {
        super(isoCell);
    }

    @Override
    public String getObjectName() {
        return "Curtain";
    }

    @Override
    public Vector2 getFacingPosition(Vector2 vector22) {
        if (this.square == null) {
            return vector22.set(0.0f, 0.0f);
        }
        if (this.getType() == IsoObjectType.curtainS) {
            return vector22.set(this.getX() + 0.5f, this.getY() + 1.0f);
        }
        if (this.getType() == IsoObjectType.curtainE) {
            return vector22.set(this.getX() + 1.0f, this.getY() + 0.5f);
        }
        if (this.north) {
            return vector22.set(this.getX() + 0.5f, this.getY());
        }
        return vector22.set(this.getX(), this.getY() + 0.5f);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.open = byteBuffer.get() == 1;
        this.north = byteBuffer.get() == 1;
        this.Health = byteBuffer.getInt();
        this.BarricideStrength = byteBuffer.getInt();
        if (this.open) {
            this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            this.openSprite = this.sprite;
        } else {
            this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            this.closedSprite = this.sprite;
        }
        if (SystemDisabler.doObjectStateSyncEnable && GameClient.bClient) {
            GameClient.instance.objectSyncReq.putRequestLoad(this.square);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.open ? (byte)1 : 0);
        byteBuffer.put(this.north ? (byte)1 : 0);
        byteBuffer.putInt(this.Health);
        byteBuffer.putInt(this.BarricideStrength);
        if (this.open) {
            byteBuffer.putInt(this.closedSprite.ID);
        } else {
            byteBuffer.putInt(this.openSprite.ID);
        }
    }

    public boolean getNorth() {
        return this.north;
    }

    public boolean IsOpen() {
        return this.open;
    }

    @Override
    public boolean onMouseLeftClick(int n, int n2) {
        return false;
    }

    public boolean canInteractWith(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null || isoGameCharacter.getCurrentSquare() == null) {
            return false;
        }
        IsoGridSquare isoGridSquare = isoGameCharacter.getCurrentSquare();
        return (this.isAdjacentToSquare(isoGridSquare) || isoGridSquare == this.getOppositeSquare()) && !this.getSquare().isBlockedTo(isoGridSquare);
    }

    public IsoGridSquare getOppositeSquare() {
        if (this.getType() == IsoObjectType.curtainN) {
            return this.getCell().getGridSquare(this.getX(), this.getY() - 1.0f, this.getZ());
        }
        if (this.getType() == IsoObjectType.curtainS) {
            return this.getCell().getGridSquare(this.getX(), this.getY() + 1.0f, this.getZ());
        }
        if (this.getType() == IsoObjectType.curtainW) {
            return this.getCell().getGridSquare(this.getX() - 1.0f, this.getY(), this.getZ());
        }
        if (this.getType() == IsoObjectType.curtainE) {
            return this.getCell().getGridSquare(this.getX() + 1.0f, this.getY(), this.getZ());
        }
        return null;
    }

    public boolean isAdjacentToSquare(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        if (isoGridSquare == null || isoGridSquare2 == null) {
            return false;
        }
        if (this.getType() == IsoObjectType.curtainN || this.getType() == IsoObjectType.curtainS) {
            return isoGridSquare.y == isoGridSquare2.y && Math.abs(isoGridSquare.x - isoGridSquare2.x) <= 1;
        }
        return isoGridSquare.x == isoGridSquare2.x && Math.abs(isoGridSquare.y - isoGridSquare2.y) <= 1;
    }

    public boolean isAdjacentToSquare(IsoGridSquare isoGridSquare) {
        return this.isAdjacentToSquare(this.getSquare(), isoGridSquare);
    }

    @Override
    public IsoObject.VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        if (isoGridSquare2.getZ() != isoGridSquare.getZ()) {
            return IsoObject.VisionResult.NoEffect;
        }
        if (isoGridSquare == this.square && (this.getType() == IsoObjectType.curtainW || this.getType() == IsoObjectType.curtainN) || isoGridSquare != this.square && (this.getType() == IsoObjectType.curtainE || this.getType() == IsoObjectType.curtainS)) {
            if (this.north && isoGridSquare2.getY() < isoGridSquare.getY() && !this.open) {
                return IsoObject.VisionResult.Blocked;
            }
            if (!this.north && isoGridSquare2.getX() < isoGridSquare.getX() && !this.open) {
                return IsoObject.VisionResult.Blocked;
            }
        } else {
            if (this.north && isoGridSquare2.getY() > isoGridSquare.getY() && !this.open) {
                return IsoObject.VisionResult.Blocked;
            }
            if (!this.north && isoGridSquare2.getX() > isoGridSquare.getX() && !this.open) {
                return IsoObject.VisionResult.Blocked;
            }
        }
        return IsoObject.VisionResult.NoEffect;
    }

    public void ToggleDoor(IsoGameCharacter isoGameCharacter) {
        if (this.Barricaded) {
            return;
        }
        this.DirtySlice();
        if (this.Locked && isoGameCharacter != null && isoGameCharacter.getCurrentSquare().getRoom() == null && !this.open) {
            return;
        }
        this.open = !this.open;
        this.sprite = this.closedSprite;
        if (this.open) {
            this.sprite = this.openSprite;
            if (isoGameCharacter != null) {
                isoGameCharacter.playSound(this.getSoundPrefix() + "Open");
            }
        } else if (isoGameCharacter != null) {
            isoGameCharacter.playSound(this.getSoundPrefix() + "Close");
        }
        this.syncIsoObject(false, this.open ? (byte)1 : 0, null);
    }

    public void ToggleDoorSilent() {
        if (this.Barricaded) {
            return;
        }
        this.DirtySlice();
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            LosUtil.cachecleared[i] = true;
        }
        GameTime.instance.lightSourceUpdate = 100.0f;
        IsoGridSquare.setRecalcLightTime(-1);
        this.open = !this.open;
        this.sprite = this.closedSprite;
        if (this.open) {
            this.sprite = this.openSprite;
        }
        this.syncIsoObject(false, this.open ? (byte)1 : 0, null);
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        int n = IsoCamera.frameState.playerIndex;
        IsoObject isoObject = this.getObjectAttachedTo();
        if (isoObject != null && this.getSquare().getTargetDarkMulti(n) <= isoObject.getSquare().getTargetDarkMulti(n)) {
            colorInfo = isoObject.getSquare().lighting[n].lightInfo();
            this.setTargetAlpha(n, isoObject.getTargetAlpha(n));
        }
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
    }

    @Override
    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byte by = (byte)this.square.getObjects().indexOf(this);
        byteBufferWriter.putByte(by);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putByte(this.open ? (byte)1 : 0);
    }

    @Override
    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        this.syncIsoObject(bl, by, udpConnection);
    }

    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection) {
        if (this.square == null) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " square is null");
            return;
        }
        if (this.getObjectIndex() == -1) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " not found on square " + this.square.getX() + "," + this.square.getY() + "," + this.square.getZ());
            return;
        }
        if (GameClient.bClient && !bl) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
            this.syncIsoObjectSend(byteBufferWriter);
            PacketTypes.PacketType.SyncIsoObject.send(GameClient.connection);
        } else if (bl) {
            if (by == 1) {
                this.open = true;
                this.sprite = this.openSprite;
            } else {
                this.open = false;
                this.sprite = this.closedSprite;
            }
            if (GameServer.bServer) {
                for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                    if (udpConnection == null || udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
                }
            }
        }
        this.square.RecalcProperties();
        this.square.RecalcAllWithNeighbours(true);
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            LosUtil.cachecleared[i] = true;
        }
        IsoGridSquare.setRecalcLightTime(-1);
        GameTime.instance.lightSourceUpdate = 100.0f;
        LuaEventManager.triggerEvent("OnContainerUpdate");
        if (this.square != null) {
            this.square.RecalcProperties();
        }
    }

    public IsoObject getObjectAttachedTo() {
        block4: {
            IsoGridSquare isoGridSquare;
            PZArrayList<IsoObject> pZArrayList;
            block3: {
                int n = this.getObjectIndex();
                if (n == -1) {
                    return null;
                }
                pZArrayList = this.getSquare().getObjects();
                if (this.getType() != IsoObjectType.curtainW && this.getType() != IsoObjectType.curtainN) break block3;
                boolean bl = this.getType() == IsoObjectType.curtainN;
                for (int i = n - 1; i >= 0; --i) {
                    BarricadeAble barricadeAble = Type.tryCastTo(pZArrayList.get(i), BarricadeAble.class);
                    if (barricadeAble == null || bl != barricadeAble.getNorth()) continue;
                    return pZArrayList.get(i);
                }
                break block4;
            }
            if (this.getType() != IsoObjectType.curtainE && this.getType() != IsoObjectType.curtainS || (isoGridSquare = this.getOppositeSquare()) == null) break block4;
            boolean bl = this.getType() == IsoObjectType.curtainS;
            pZArrayList = isoGridSquare.getObjects();
            for (int i = pZArrayList.size() - 1; i >= 0; --i) {
                BarricadeAble barricadeAble = Type.tryCastTo(pZArrayList.get(i), BarricadeAble.class);
                if (barricadeAble == null || bl != barricadeAble.getNorth()) continue;
                return pZArrayList.get(i);
            }
        }
        return null;
    }

    public String getSoundPrefix() {
        if (this.closedSprite == null) {
            return "CurtainShort";
        }
        PropertyContainer propertyContainer = this.closedSprite.getProperties();
        if (propertyContainer.Is("CurtainSound")) {
            return "Curtain" + propertyContainer.Val("CurtainSound");
        }
        return "CurtainShort";
    }

    public static boolean isSheet(IsoObject isoObject) {
        if (isoObject instanceof IsoDoor) {
            isoObject = ((IsoDoor)isoObject).HasCurtains();
        }
        if (isoObject instanceof IsoThumpable) {
            isoObject = ((IsoThumpable)isoObject).HasCurtains();
        }
        if (isoObject instanceof IsoWindow) {
            isoObject = ((IsoWindow)isoObject).HasCurtains();
        }
        if (isoObject == null || isoObject.getSprite() == null) {
            return false;
        }
        IsoSprite isoSprite = isoObject.getSprite();
        if (isoSprite.getProperties().Is("CurtainSound")) {
            return "Sheet".equals(isoSprite.getProperties().Val("CurtainSound"));
        }
        return false;
    }
}

