/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.SandboxOptions;
import zombie.characters.IsoGameCharacter;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Food;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class IsoCompost
extends IsoObject {
    private float compost = 0.0f;
    private float LastUpdated = -1.0f;

    public IsoCompost(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoCompost(IsoCell isoCell, IsoGridSquare isoGridSquare) {
        super(isoCell, isoGridSquare, IsoSpriteManager.instance.getSprite("camping_01_19"));
        this.sprite = IsoSpriteManager.instance.getSprite("camping_01_19");
        this.square = isoGridSquare;
        this.container = new ItemContainer();
        this.container.setType("composter");
        this.container.setParent(this);
        this.container.bExplored = true;
    }

    @Override
    public void update() {
        if (GameClient.bClient || this.container == null) {
            return;
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        if (this.LastUpdated < 0.0f) {
            this.LastUpdated = f;
        } else if (this.LastUpdated > f) {
            this.LastUpdated = f;
        }
        float f2 = f - this.LastUpdated;
        if (f2 <= 0.0f) {
            return;
        }
        this.LastUpdated = f;
        int n = SandboxOptions.instance.getCompostHours();
        for (int i = 0; i < this.container.getItems().size(); ++i) {
            InventoryItem inventoryItem = this.container.getItems().get(i);
            if (!(inventoryItem instanceof Food)) continue;
            Food food = (Food)inventoryItem;
            if (GameServer.bServer) {
                food.updateAge();
            }
            if (!food.isRotten()) continue;
            if (this.getCompost() < 100.0f) {
                food.setRottenTime(0.0f);
                food.setCompostTime(food.getCompostTime() + f2);
            }
            if (!(food.getCompostTime() >= (float)n)) continue;
            this.setCompost(this.getCompost() + Math.abs(food.getHungChange()) * 2.0f);
            if (this.getCompost() > 100.0f) {
                this.setCompost(100.0f);
            }
            if (GameServer.bServer) {
                GameServer.sendCompost(this, null);
                GameServer.sendRemoveItemFromContainer(this.container, inventoryItem);
            }
            if (Rand.Next(10) == 0) {
                InventoryItem inventoryItem2 = this.container.AddItem("Base.Worm");
                if (GameServer.bServer && inventoryItem2 != null) {
                    GameServer.sendAddItemToContainer(this.container, inventoryItem2);
                }
            }
            inventoryItem.Use();
            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(inventoryItem);
        }
        this.updateSprite();
    }

    public void updateSprite() {
        if (this.getCompost() >= 10.0f && this.sprite.getName().equals("camping_01_19")) {
            this.sprite = IsoSpriteManager.instance.getSprite("camping_01_20");
            this.transmitUpdatedSpriteToClients();
        } else if (this.getCompost() < 10.0f && this.sprite.getName().equals("camping_01_20")) {
            this.sprite = IsoSpriteManager.instance.getSprite("camping_01_19");
            this.transmitUpdatedSpriteToClients();
        }
    }

    public void syncCompost() {
        if (GameClient.bClient) {
            GameClient.sendCompost(this);
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        if (this.container != null) {
            this.container.setType("composter");
        }
        this.compost = byteBuffer.getFloat();
        if (n >= 130) {
            this.LastUpdated = byteBuffer.getFloat();
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.putFloat(this.compost);
        byteBuffer.putFloat(this.LastUpdated);
    }

    @Override
    public String getObjectName() {
        return "IsoCompost";
    }

    public float getCompost() {
        return this.compost;
    }

    public void setCompost(float f) {
        this.compost = PZMath.clamp(f, 0.0f, 100.0f);
    }

    public void remove() {
        if (this.getSquare() == null) {
            return;
        }
        this.getSquare().transmitRemoveItemFromSquare(this);
    }

    @Override
    public void addToWorld() {
        this.getCell().addToProcessIsoObject(this);
    }

    @Override
    public Thumpable getThumpableFor(IsoGameCharacter isoGameCharacter) {
        if (this.isDestroyed()) {
            return null;
        }
        return this;
    }
}

