/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaEventManager;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.objects.ClothingDryerLogic;
import zombie.iso.objects.ClothingWasherLogic;
import zombie.iso.objects.interfaces.IClothingWasherDryerLogic;
import zombie.iso.sprite.IsoSprite;

public class IsoCombinationWasherDryer
extends IsoObject {
    private final ClothingWasherLogic m_washer = new ClothingWasherLogic(this);
    private final ClothingDryerLogic m_dryer = new ClothingDryerLogic(this);
    private IClothingWasherDryerLogic m_logic = this.m_washer;

    public IsoCombinationWasherDryer(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoCombinationWasherDryer(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
    }

    @Override
    public String getObjectName() {
        return "CombinationWasherDryer";
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.m_logic = byteBuffer.get() == 0 ? this.m_washer : this.m_dryer;
        this.m_washer.load(byteBuffer, n, bl);
        this.m_dryer.load(byteBuffer, n, bl);
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put((byte)(this.m_logic != this.m_washer ? 1 : 0));
        this.m_washer.save(byteBuffer, bl);
        this.m_dryer.save(byteBuffer, bl);
    }

    @Override
    public void update() {
        this.m_logic.update();
    }

    @Override
    public void addToWorld() {
        IsoCell isoCell = this.getCell();
        isoCell.addToProcessIsoObject(this);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("mode".equals(string)) {
            byteBuffer.put((byte)(!this.isModeWasher() ? 1 : 0));
        } else {
            this.m_logic.saveChange(string, kahluaTable, byteBuffer);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("mode".equals(string)) {
            if (byteBuffer.get() == 0) {
                this.setModeWasher();
            } else {
                this.setModeDryer();
            }
        } else {
            this.m_logic.loadChange(string, byteBuffer);
        }
    }

    @Override
    public boolean isItemAllowedInContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        return this.m_logic.isItemAllowedInContainer(itemContainer, inventoryItem);
    }

    @Override
    public boolean isRemoveItemAllowedFromContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        return this.m_logic.isRemoveItemAllowedFromContainer(itemContainer, inventoryItem);
    }

    public boolean isActivated() {
        return this.m_logic.isActivated();
    }

    public void setActivated(boolean bl) {
        this.m_logic.setActivated(bl);
    }

    public void setModeWasher() {
        if (this.isModeWasher()) {
            return;
        }
        this.m_dryer.switchModeOff();
        this.m_logic = this.m_washer;
        this.getContainer().setType("clothingwasher");
        this.m_washer.switchModeOn();
        LuaEventManager.triggerEvent("OnContainerUpdate");
    }

    public void setModeDryer() {
        if (this.isModeDryer()) {
            return;
        }
        this.m_washer.switchModeOff();
        this.m_logic = this.m_dryer;
        this.getContainer().setType("clothingdryer");
        this.m_dryer.switchModeOn();
        LuaEventManager.triggerEvent("OnContainerUpdate");
    }

    public boolean isModeWasher() {
        return this.m_logic == this.m_washer;
    }

    public boolean isModeDryer() {
        return this.m_logic == this.m_dryer;
    }
}

