/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.core.Core;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.DrainableComboItem;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoHeatSource;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class IsoBarbecue
extends IsoObject {
    boolean bHasPropaneTank = false;
    int FuelAmount = 0;
    boolean bLit = false;
    boolean bIsSmouldering = false;
    protected float LastUpdateTime = -1.0f;
    protected float MinuteAccumulator = 0.0f;
    protected int MinutesSinceExtinguished = -1;
    IsoSprite normalSprite = null;
    IsoSprite noTankSprite = null;
    private IsoHeatSource heatSource;
    private long soundInstance = 0L;
    private static int SMOULDER_MINUTES = 10;

    public IsoBarbecue(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoBarbecue(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
        this.container = new ItemContainer("barbecue", isoGridSquare, this);
        this.container.setExplored(true);
        if (IsoBarbecue.isSpriteWithPropaneTank(this.sprite)) {
            this.bHasPropaneTank = true;
            this.FuelAmount = 1200;
            int n = 8;
            this.normalSprite = this.sprite;
            this.noTankSprite = IsoSprite.getSprite(IsoSpriteManager.instance, this.sprite, n);
        } else if (IsoBarbecue.isSpriteWithoutPropaneTank(this.sprite)) {
            int n = -8;
            this.normalSprite = IsoSprite.getSprite(IsoSpriteManager.instance, this.sprite, n);
            this.noTankSprite = this.sprite;
        }
    }

    @Override
    public String getObjectName() {
        return "Barbecue";
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.bHasPropaneTank = byteBuffer.get() == 1;
        this.FuelAmount = byteBuffer.getInt();
        this.bLit = byteBuffer.get() == 1;
        this.LastUpdateTime = byteBuffer.getFloat();
        this.MinutesSinceExtinguished = byteBuffer.getInt();
        if (byteBuffer.get() == 1) {
            this.normalSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
        }
        if (byteBuffer.get() == 1) {
            this.noTankSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.bHasPropaneTank ? (byte)1 : 0);
        byteBuffer.putInt(this.FuelAmount);
        byteBuffer.put(this.bLit ? (byte)1 : 0);
        byteBuffer.putFloat(this.LastUpdateTime);
        byteBuffer.putInt(this.MinutesSinceExtinguished);
        if (this.normalSprite != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.normalSprite.ID);
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.noTankSprite != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.noTankSprite.ID);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public void setFuelAmount(int n) {
        int n2;
        if ((n = Math.max(0, n)) != (n2 = this.getFuelAmount())) {
            this.FuelAmount = n;
        }
    }

    public int getFuelAmount() {
        return this.FuelAmount;
    }

    public void addFuel(int n) {
        this.setFuelAmount(this.getFuelAmount() + n);
    }

    public int useFuel(int n) {
        int n2 = this.getFuelAmount();
        int n3 = 0;
        n3 = n2 >= n ? n : n2;
        this.setFuelAmount(n2 - n3);
        return n3;
    }

    public boolean hasFuel() {
        return this.getFuelAmount() > 0;
    }

    public boolean hasPropaneTank() {
        return this.isPropaneBBQ() && this.bHasPropaneTank;
    }

    public boolean isPropaneBBQ() {
        return this.getSprite() != null && this.getProperties().Is("propaneTank");
    }

    public static boolean isSpriteWithPropaneTank(IsoSprite isoSprite) {
        if (isoSprite == null || !isoSprite.getProperties().Is("propaneTank")) {
            return false;
        }
        int n = 8;
        IsoSprite isoSprite2 = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, n);
        return isoSprite2 != null && isoSprite2.getProperties().Is("propaneTank");
    }

    public static boolean isSpriteWithoutPropaneTank(IsoSprite isoSprite) {
        if (isoSprite == null || !isoSprite.getProperties().Is("propaneTank")) {
            return false;
        }
        int n = -8;
        IsoSprite isoSprite2 = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, n);
        return isoSprite2 != null && isoSprite2.getProperties().Is("propaneTank");
    }

    public void setPropaneTank(InventoryItem inventoryItem) {
        if (inventoryItem.getFullType().equals("Base.PropaneTank")) {
            this.bHasPropaneTank = true;
            this.FuelAmount = 1200;
            if (inventoryItem instanceof DrainableComboItem) {
                this.FuelAmount = (int)((float)this.FuelAmount * ((DrainableComboItem)inventoryItem).getUsedDelta());
            }
        }
    }

    public InventoryItem removePropaneTank() {
        if (!this.bHasPropaneTank) {
            return null;
        }
        this.bHasPropaneTank = false;
        this.bLit = false;
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem("Base.PropaneTank");
        if (inventoryItem instanceof DrainableComboItem) {
            ((DrainableComboItem)inventoryItem).setUsedDelta((float)this.getFuelAmount() / 1200.0f);
        }
        this.FuelAmount = 0;
        return inventoryItem;
    }

    public void setLit(boolean bl) {
        this.bLit = bl;
    }

    public boolean isLit() {
        return this.bLit;
    }

    public boolean isSmouldering() {
        return this.bIsSmouldering;
    }

    public void turnOn() {
        if (!this.isLit()) {
            this.setLit(true);
        }
    }

    public void turnOff() {
        if (this.isLit()) {
            this.setLit(false);
        }
    }

    public void toggle() {
        this.setLit(!this.isLit());
    }

    public void extinguish() {
        if (this.isLit()) {
            this.setLit(false);
            if (this.hasFuel() && !this.isPropaneBBQ()) {
                this.MinutesSinceExtinguished = 0;
            }
        }
    }

    public float getTemperature() {
        if (this.isLit()) {
            return 1.8f;
        }
        return 1.0f;
    }

    private void updateSprite() {
        if (this.isPropaneBBQ()) {
            this.sprite = this.hasPropaneTank() ? this.normalSprite : this.noTankSprite;
        }
    }

    private void updateHeatSource() {
        if (this.isLit()) {
            if (this.heatSource == null) {
                this.heatSource = new IsoHeatSource((int)this.getX(), (int)this.getY(), (int)this.getZ(), 3, 25);
                IsoWorld.instance.CurrentCell.addHeatSource(this.heatSource);
            }
        } else if (this.heatSource != null) {
            IsoWorld.instance.CurrentCell.removeHeatSource(this.heatSource);
            this.heatSource = null;
        }
    }

    private void updateSound() {
        if (GameServer.bServer) {
            return;
        }
        if (this.isLit()) {
            String string;
            if (this.emitter == null) {
                this.emitter = IsoWorld.instance.getFreeEmitter(this.getX() + 0.5f, this.getY() + 0.5f, (int)this.getZ());
                IsoWorld.instance.setEmitterOwner(this.emitter, this);
            }
            String string2 = string = this.isPropaneBBQ() ? "BBQPropaneRunning" : "BBQRegularRunning";
            if (!this.emitter.isPlaying(string)) {
                this.soundInstance = this.emitter.playSoundLoopedImpl(string);
            }
        } else if (this.emitter != null && this.soundInstance != 0L) {
            this.emitter.stopOrTriggerSound(this.soundInstance);
            this.emitter = null;
            this.soundInstance = 0L;
        }
    }

    @Override
    public void update() {
        int n;
        if (!GameClient.bClient) {
            boolean bl = this.hasFuel();
            n = this.isLit();
            float f = (float)GameTime.getInstance().getWorldAgeHours();
            if (this.LastUpdateTime < 0.0f) {
                this.LastUpdateTime = f;
            } else if (this.LastUpdateTime > f) {
                this.LastUpdateTime = f;
            }
            if (f > this.LastUpdateTime) {
                this.MinuteAccumulator += (f - this.LastUpdateTime) * 60.0f;
                int n2 = (int)Math.floor(this.MinuteAccumulator);
                if (n2 > 0) {
                    if (this.isLit()) {
                        DebugLog.log(DebugType.Fireplace, "IsoBarbecue burned " + n2 + " minutes (" + this.getFuelAmount() + " remaining)");
                        this.useFuel(n2);
                        if (!this.hasFuel()) {
                            this.extinguish();
                        }
                    } else if (this.MinutesSinceExtinguished != -1) {
                        int n3 = Math.min(n2, SMOULDER_MINUTES - this.MinutesSinceExtinguished);
                        DebugLog.log(DebugType.Fireplace, "IsoBarbecue smoldered " + n3 + " minutes (" + this.getFuelAmount() + " remaining)");
                        this.MinutesSinceExtinguished += n2;
                        this.bIsSmouldering = true;
                        this.useFuel(n3);
                        if (!this.hasFuel() || this.MinutesSinceExtinguished >= SMOULDER_MINUTES) {
                            this.MinutesSinceExtinguished = -1;
                            this.bIsSmouldering = false;
                        }
                    }
                    this.MinuteAccumulator -= (float)n2;
                }
            }
            this.LastUpdateTime = f;
            if (GameServer.bServer) {
                if (bl != this.hasFuel() || n != this.isLit()) {
                    this.sendObjectChange("state");
                }
                return;
            }
        }
        this.updateSprite();
        this.updateHeatSource();
        if (this.isLit() && (this.AttachedAnimSprite == null || this.AttachedAnimSprite.isEmpty())) {
            ColorInfo colorInfo = new ColorInfo(0.95f, 0.95f, 0.85f, 1.0f);
            this.AttachAnim("Smoke", "01", 4, IsoFireManager.SmokeAnimDelay, -14, 58, true, 0, false, 0.7f, colorInfo);
            ((IsoSpriteInstance)this.AttachedAnimSprite.get((int)0)).targetAlpha = 0.55f;
            ((IsoSpriteInstance)this.AttachedAnimSprite.get((int)0)).alpha = 0.55f;
            ((IsoSpriteInstance)this.AttachedAnimSprite.get((int)0)).bCopyTargetAlpha = false;
        } else if (!this.isLit() && this.AttachedAnimSprite != null && !this.AttachedAnimSprite.isEmpty()) {
            this.RemoveAttachedAnims();
        }
        if (this.AttachedAnimSprite != null && !this.AttachedAnimSprite.isEmpty()) {
            int n4 = this.AttachedAnimSprite.size();
            for (n = 0; n < n4; ++n) {
                IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)this.AttachedAnimSprite.get(n);
                IsoSprite isoSprite = isoSpriteInstance.parentSprite;
                isoSpriteInstance.update();
                float f = GameTime.instance.getMultipliedSecondsSinceLastUpdate() * 60.0f;
                isoSpriteInstance.Frame += isoSpriteInstance.AnimFrameIncrease * f;
                if ((int)isoSpriteInstance.Frame < isoSprite.CurrentAnim.Frames.size() || !isoSprite.Loop || !isoSpriteInstance.Looped) continue;
                isoSpriteInstance.Frame = 0.0f;
            }
        }
        this.updateSound();
    }

    @Override
    public void setSprite(IsoSprite isoSprite) {
        if (IsoBarbecue.isSpriteWithPropaneTank(isoSprite)) {
            int n = 8;
            this.normalSprite = isoSprite;
            this.noTankSprite = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, n);
        } else if (IsoBarbecue.isSpriteWithoutPropaneTank(isoSprite)) {
            int n = -8;
            this.normalSprite = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, n);
            this.noTankSprite = isoSprite;
        }
    }

    @Override
    public void addToWorld() {
        IsoCell isoCell = this.getCell();
        this.getCell().addToProcessIsoObject(this);
        this.container.addItemsToProcessItems();
    }

    @Override
    public void removeFromWorld() {
        if (this.heatSource != null) {
            IsoWorld.instance.CurrentCell.removeHeatSource(this.heatSource);
            this.heatSource = null;
        }
        super.removeFromWorld();
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.AttachedAnimSprite != null) {
            int n = Core.TileScale;
            for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
                IsoSprite isoSprite = ((IsoSpriteInstance)this.AttachedAnimSprite.get((int)i)).parentSprite;
                isoSprite.soffX = (short)(14 * n);
                isoSprite.soffY = (short)(-58 * n);
                ((IsoSpriteInstance)this.AttachedAnimSprite.get(i)).setScale(n, n);
            }
        }
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("state".equals(string)) {
            byteBuffer.putInt(this.getFuelAmount());
            byteBuffer.put(this.isLit() ? (byte)1 : 0);
            byteBuffer.put(this.hasPropaneTank() ? (byte)1 : 0);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("state".equals(string)) {
            this.setFuelAmount(byteBuffer.getInt());
            this.setLit(byteBuffer.get() == 1);
            this.bHasPropaneTank = byteBuffer.get() == 1;
        }
    }
}

