/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.WorldSoundManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoCell;
import zombie.iso.IsoPhysicsObject;
import zombie.network.GameClient;

public class IsoBall
extends IsoPhysicsObject {
    private HandWeapon weapon = null;
    private IsoGameCharacter character = null;
    private int lastCheckX = 0;
    private int lastCheckY = 0;

    @Override
    public String getObjectName() {
        return "MolotovCocktail";
    }

    public IsoBall(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoBall(IsoCell isoCell, float f, float f2, float f3, float f4, float f5, HandWeapon handWeapon, IsoGameCharacter isoGameCharacter) {
        super(isoCell);
        this.weapon = handWeapon;
        this.character = isoGameCharacter;
        this.velX = f4;
        this.velY = f5;
        float f6 = (float)Rand.Next(4000) / 10000.0f;
        float f7 = (float)Rand.Next(4000) / 10000.0f;
        this.velX += (f6 -= 0.2f);
        this.velY += (f7 -= 0.2f);
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.nx = f;
        this.ny = f2;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.terminalVelocity = -0.02f;
        Texture texture = this.sprite.LoadFrameExplicit(handWeapon.getTex().getName());
        if (texture != null) {
            this.sprite.Animate = false;
            int n = Core.TileScale;
            this.sprite.def.scaleAspect(texture.getWidthOrig(), texture.getHeightOrig(), 16 * n, 16 * n);
        }
        this.speedMod = 0.6f;
    }

    @Override
    public void collideGround() {
        this.Fall();
    }

    @Override
    public void collideWall() {
        this.Fall();
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
        if (Core.bDebug) {
            // empty if block
        }
    }

    void Fall() {
        this.getCurrentSquare().getMovingObjects().remove(this);
        this.getCell().Remove(this);
        if (!GameClient.bClient) {
            WorldSoundManager.instance.addSound(this, (int)this.x, (int)this.y, 0, 600, 600);
        }
        if (this.character instanceof IsoPlayer) {
            if (((IsoPlayer)this.character).isLocalPlayer()) {
                this.square.AddWorldInventoryItem(this.weapon, Rand.Next(0.2f, 0.8f), Rand.Next(0.2f, 0.8f), 0.0f, true);
            }
        } else {
            DebugLog.General.error("IsoBall: character isn't instance of IsoPlayer");
        }
    }
}

