/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.WorldSoundManager;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.BloodClothingType;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Clothing;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.interfaces.IClothingWasherDryerLogic;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class ClothingWasherLogic
implements IClothingWasherDryerLogic {
    private final IsoObject m_object;
    private boolean bActivated;
    private long soundInstance = -1L;
    private float lastUpdate = -1.0f;
    private boolean cycleFinished = false;
    private float startTime = 0.0f;
    private float cycleLengthMinutes = 90.0f;
    private boolean alreadyExecuted = false;

    public ClothingWasherLogic(IsoObject isoObject) {
        this.m_object = isoObject;
    }

    public IsoObject getObject() {
        return this.m_object;
    }

    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        this.bActivated = byteBuffer.get() == 1;
        this.lastUpdate = byteBuffer.getFloat();
    }

    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        byteBuffer.put(this.isActivated() ? (byte)1 : 0);
        byteBuffer.putFloat(this.lastUpdate);
    }

    @Override
    public void update() {
        if (this.getObject().getObjectIndex() == -1) {
            return;
        }
        if (!this.getContainer().isPowered()) {
            this.setActivated(false);
        }
        this.updateSound();
        this.cycleFinished();
        if (GameClient.bClient) {
            // empty if block
        }
        if (this.getObject().getWaterAmount() <= 0) {
            this.setActivated(false);
        }
        if (!this.isActivated()) {
            this.lastUpdate = -1.0f;
            return;
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        if (this.lastUpdate < 0.0f) {
            this.lastUpdate = f;
        } else if (this.lastUpdate > f) {
            this.lastUpdate = f;
        }
        float f2 = f - this.lastUpdate;
        int n = (int)(f2 * 60.0f);
        if (n < 1) {
            return;
        }
        this.lastUpdate = f;
        this.getObject().useWater(1 * n);
        for (int i = 0; i < this.getContainer().getItems().size(); ++i) {
            float f3;
            InventoryItem inventoryItem = this.getContainer().getItems().get(i);
            if (!(inventoryItem instanceof Clothing)) continue;
            Clothing clothing = (Clothing)inventoryItem;
            float f4 = clothing.getBloodlevel();
            if (f4 > 0.0f) {
                this.removeBlood(clothing, n * 2);
            }
            if ((f3 = clothing.getDirtyness()) > 0.0f) {
                this.removeDirt(clothing, n * 2);
            }
            clothing.setWetness(100.0f);
        }
    }

    private void removeBlood(Clothing clothing, float f) {
        ItemVisual itemVisual = clothing.getVisual();
        if (itemVisual == null) {
            return;
        }
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(i);
            float f2 = itemVisual.getBlood(bloodBodyPartType);
            if (!(f2 > 0.0f)) continue;
            itemVisual.setBlood(bloodBodyPartType, f2 - f / 100.0f);
        }
        BloodClothingType.calcTotalBloodLevel(clothing);
    }

    private void removeDirt(Clothing clothing, float f) {
        ItemVisual itemVisual = clothing.getVisual();
        if (itemVisual == null) {
            return;
        }
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(i);
            float f2 = itemVisual.getDirt(bloodBodyPartType);
            if (!(f2 > 0.0f)) continue;
            itemVisual.setDirt(bloodBodyPartType, f2 - f / 100.0f);
        }
        BloodClothingType.calcTotalDirtLevel(clothing);
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("washer.state".equals(string)) {
            byteBuffer.put(this.isActivated() ? (byte)1 : 0);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("washer.state".equals(string)) {
            this.setActivated(byteBuffer.get() == 1);
        }
    }

    @Override
    public ItemContainer getContainer() {
        return this.getObject().getContainerByType("clothingwasher");
    }

    private void updateSound() {
        if (this.isActivated()) {
            if (!GameServer.bServer) {
                if (this.getObject().emitter != null && this.getObject().emitter.isPlaying("ClothingWasherFinished")) {
                    this.getObject().emitter.stopOrTriggerSoundByName("ClothingWasherFinished");
                }
                if (this.soundInstance == -1L) {
                    this.getObject().emitter = IsoWorld.instance.getFreeEmitter(this.getObject().getX() + 0.5f, this.getObject().getY() + 0.5f, (int)this.getObject().getZ());
                    IsoWorld.instance.setEmitterOwner(this.getObject().emitter, this.getObject());
                    this.soundInstance = this.getObject().emitter.playSoundLoopedImpl("ClothingWasherRunning");
                }
            }
            if (!GameClient.bClient) {
                WorldSoundManager.instance.addSoundRepeating(this, this.getObject().square.x, this.getObject().square.y, this.getObject().square.z, 10, 10, false);
            }
        } else if (this.soundInstance != -1L) {
            this.getObject().emitter.stopOrTriggerSound(this.soundInstance);
            this.soundInstance = -1L;
            if (this.cycleFinished) {
                this.cycleFinished = false;
                this.getObject().emitter.playSoundImpl("ClothingWasherFinished", this.getObject());
            }
        }
    }

    @Override
    public boolean isItemAllowedInContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        if (itemContainer != this.getContainer()) {
            return false;
        }
        return !this.isActivated();
    }

    @Override
    public boolean isRemoveItemAllowedFromContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        if (itemContainer != this.getContainer()) {
            return false;
        }
        return itemContainer.isEmpty() || !this.isActivated();
    }

    private boolean cycleFinished() {
        if (this.isActivated()) {
            float f;
            int n;
            if (!this.alreadyExecuted) {
                this.startTime = (float)GameTime.getInstance().getWorldAgeHours();
                this.alreadyExecuted = true;
            }
            if ((float)(n = (int)((f = (float)GameTime.getInstance().getWorldAgeHours() - this.startTime) * 60.0f)) < this.cycleLengthMinutes) {
                return false;
            }
            this.cycleFinished = true;
            this.setActivated(false);
        }
        return true;
    }

    @Override
    public boolean isActivated() {
        return this.bActivated;
    }

    @Override
    public void setActivated(boolean bl) {
        Thread thread;
        boolean bl2 = bl != this.bActivated;
        this.bActivated = bl;
        this.alreadyExecuted = false;
        if (bl2 && ((thread = Thread.currentThread()) == GameWindow.GameThread || thread == GameServer.MainThread)) {
            IsoGenerator.updateGenerator(this.getObject().getSquare());
        }
    }

    @Override
    public void switchModeOn() {
    }

    @Override
    public void switchModeOff() {
        this.setActivated(false);
        this.updateSound();
        this.cycleFinished = false;
    }
}

