/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.skills.PerkFactory;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.DrainableComboItem;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class BSFurnace
extends IsoObject {
    public float heat = 0.0f;
    public float heatDecrease = 0.005f;
    public float heatIncrease = 0.001f;
    public float fuelAmount = 0.0f;
    public float fuelDecrease = 0.001f;
    public boolean fireStarted = false;
    private IsoLightSource LightSource;
    public String sSprite;
    public String sLitSprite;

    public BSFurnace(IsoCell isoCell) {
        super(isoCell);
    }

    public BSFurnace(IsoCell isoCell, IsoGridSquare isoGridSquare, String string, String string2) {
        super(isoCell, isoGridSquare, IsoSpriteManager.instance.getSprite(string));
        this.sSprite = string;
        this.sLitSprite = string2;
        this.sprite = IsoSpriteManager.instance.getSprite(string);
        this.square = isoGridSquare;
        this.container = new ItemContainer();
        this.container.setType("stonefurnace");
        this.container.setParent(this);
        isoGridSquare.AddSpecialObject(this);
    }

    @Override
    public void update() {
        Object object;
        int n;
        this.updateHeat();
        if (GameClient.bClient) {
            return;
        }
        DrainableComboItem drainableComboItem = null;
        Object object2 = null;
        for (n = 0; n < this.getContainer().getItems().size(); ++n) {
            object = this.getContainer().getItems().get(n);
            if (((InventoryItem)object).getType().equals("IronIngot") && ((DrainableComboItem)object).getUsedDelta() < 1.0f) {
                drainableComboItem = (DrainableComboItem)object;
            }
            if (!(((InventoryItem)object).getMetalValue() > 0.0f)) continue;
            if (this.getHeat() > 15.0f) {
                if (((InventoryItem)object).getItemHeat() < 2.0f) {
                    ((InventoryItem)object).setItemHeat(((InventoryItem)object).getItemHeat() + 0.001f * (this.getHeat() / 100.0f) * GameTime.instance.getMultiplier());
                } else {
                    ((InventoryItem)object).setMeltingTime(((InventoryItem)object).getMeltingTime() + 0.1f * (this.getHeat() / 100.0f) * (1.0f + (float)(this.getMeltingSkill((InventoryItem)object) * 3) / 100.0f) * GameTime.instance.getMultiplier());
                }
                if (((InventoryItem)object).getMeltingTime() != 100.0f) continue;
                object2 = object;
                continue;
            }
            ((InventoryItem)object).setItemHeat(((InventoryItem)object).getItemHeat() - 0.001f * (this.getHeat() / 100.0f) * GameTime.instance.getMultiplier());
            ((InventoryItem)object).setMeltingTime(((InventoryItem)object).getMeltingTime() - 0.1f * (this.getHeat() / 100.0f) * GameTime.instance.getMultiplier());
        }
        if (object2 != null) {
            if (((InventoryItem)object2).getWorker() != null && !((InventoryItem)object2).getWorker().isEmpty()) {
                for (n = 0; n < IsoPlayer.numPlayers && ((object = IsoPlayer.players[n]) == null || ((IsoGameCharacter)object).isDead() || !((InventoryItem)object2).getWorker().equals(((IsoGameCharacter)object).getFullName())); ++n) {
                }
            }
            float f = ((InventoryItem)object2).getMetalValue() + (((InventoryItem)object2).getMetalValue() * (1.0f + (float)(this.getMeltingSkill((InventoryItem)object2) * 3) / 100.0f) - ((InventoryItem)object2).getMetalValue());
            if (drainableComboItem != null) {
                if (f + drainableComboItem.getUsedDelta() / drainableComboItem.getUseDelta() > 1.0f / drainableComboItem.getUseDelta()) {
                    f -= 1.0f / drainableComboItem.getUseDelta() - drainableComboItem.getUsedDelta() / drainableComboItem.getUseDelta();
                    drainableComboItem.setUsedDelta(1.0f);
                    drainableComboItem = (DrainableComboItem)InventoryItemFactory.CreateItem("Base.IronIngot");
                    drainableComboItem.setUsedDelta(0.0f);
                    this.getContainer().addItem(drainableComboItem);
                }
            } else {
                drainableComboItem = (DrainableComboItem)InventoryItemFactory.CreateItem("Base.IronIngot");
                drainableComboItem.setUsedDelta(0.0f);
                this.getContainer().addItem(drainableComboItem);
            }
            float f2 = 0.0f;
            float f3 = f;
            while (f2 < f3) {
                if (drainableComboItem.getUsedDelta() + f * drainableComboItem.getUseDelta() <= 1.0f) {
                    drainableComboItem.setUsedDelta(drainableComboItem.getUsedDelta() + f * drainableComboItem.getUseDelta());
                    f2 += f;
                    continue;
                }
                f -= 1.0f / drainableComboItem.getUseDelta();
                f2 += 1.0f / drainableComboItem.getUseDelta();
                drainableComboItem.setUsedDelta(1.0f);
                drainableComboItem = (DrainableComboItem)InventoryItemFactory.CreateItem("Base.IronIngot");
                drainableComboItem.setUsedDelta(0.0f);
                this.getContainer().addItem(drainableComboItem);
            }
            this.getContainer().Remove((InventoryItem)object2);
        }
    }

    private void updateHeat() {
        if (!this.isFireStarted()) {
            this.heat -= this.heatDecrease * GameTime.instance.getMultiplier();
        } else if (this.getFuelAmount() == 0.0f) {
            this.setFireStarted(false);
        } else {
            this.fuelAmount -= this.fuelDecrease * (0.2f + this.heatIncrease / 80.0f) * GameTime.instance.getMultiplier();
            if (this.getHeat() < 20.0f) {
                this.heat += this.heatIncrease * GameTime.instance.getMultiplier();
            }
            this.heat -= this.heatDecrease * 0.05f * GameTime.instance.getMultiplier();
        }
        if (this.heat < 0.0f) {
            this.heat = 0.0f;
        }
        if (this.fuelAmount < 0.0f) {
            this.fuelAmount = 0.0f;
        }
    }

    public int getMeltingSkill(InventoryItem inventoryItem) {
        if (inventoryItem.getWorker() != null && !inventoryItem.getWorker().isEmpty()) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.isDead() || !inventoryItem.getWorker().equals(isoPlayer.getFullName())) continue;
                return isoPlayer.getPerkLevel(PerkFactory.Perks.Melting);
            }
        }
        return 0;
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.fireStarted = byteBuffer.get() == 1;
        this.heat = byteBuffer.getFloat();
        this.fuelAmount = byteBuffer.getFloat();
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.isFireStarted() ? (byte)1 : 0);
        byteBuffer.putFloat(this.getHeat());
        byteBuffer.putFloat(this.getFuelAmount());
    }

    @Override
    public String getObjectName() {
        return "StoneFurnace";
    }

    public float getHeat() {
        return this.heat;
    }

    public void setHeat(float f) {
        if (f > 100.0f) {
            f = 100.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.heat = f;
    }

    public boolean isFireStarted() {
        return this.fireStarted;
    }

    public void updateLight() {
        if (this.fireStarted && this.LightSource == null) {
            this.LightSource = new IsoLightSource(this.square.getX(), this.square.getY(), this.square.getZ(), 0.61f, 0.165f, 0.0f, 7);
            IsoWorld.instance.CurrentCell.addLamppost(this.LightSource);
        } else if (this.LightSource != null) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.LightSource);
            this.LightSource = null;
        }
    }

    public void setFireStarted(boolean bl) {
        this.fireStarted = bl;
        this.updateLight();
        this.syncFurnace();
    }

    public void syncFurnace() {
        if (GameServer.bServer) {
            GameServer.sendFuranceChange(this, null);
        } else if (GameClient.bClient) {
            GameClient.sendFurnaceChange(this);
        }
    }

    public float getFuelAmount() {
        return this.fuelAmount;
    }

    public void setFuelAmount(float f) {
        if (f > 100.0f) {
            f = 100.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.fuelAmount = f;
    }

    public void addFuel(float f) {
        this.setFuelAmount(this.getFuelAmount() + f);
    }

    @Override
    public void addToWorld() {
        IsoWorld.instance.getCell().addToProcessIsoObject(this);
    }

    @Override
    public void removeFromWorld() {
        if (this.emitter != null) {
            this.emitter.stopAll();
            IsoWorld.instance.returnOwnershipOfEmitter(this.emitter);
            this.emitter = null;
        }
        super.removeFromWorld();
    }

    public float getFuelDecrease() {
        return this.fuelDecrease;
    }

    public void setFuelDecrease(float f) {
        this.fuelDecrease = f;
    }

    public float getHeatDecrease() {
        return this.heatDecrease;
    }

    public void setHeatDecrease(float f) {
        this.heatDecrease = f;
    }

    public float getHeatIncrease() {
        return this.heatIncrease;
    }

    public void setHeatIncrease(float f) {
        this.heatIncrease = f;
    }
}

