/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion.regions;

import java.util.ArrayList;
import zombie.core.Color;
import zombie.core.Core;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.regions.IWorldRegion;
import zombie.iso.areas.isoregion.regions.IsoChunkRegion;
import zombie.iso.areas.isoregion.regions.IsoRegionManager;

public final class IsoWorldRegion
implements IWorldRegion {
    private final IsoRegionManager manager;
    private boolean isInPool = false;
    private int ID;
    private Color color;
    private boolean enclosed = true;
    private ArrayList<IsoChunkRegion> isoChunkRegions = new ArrayList();
    private int squareSize = 0;
    private int roofCnt = 0;
    private boolean isDirtyEnclosed = false;
    private boolean isDirtyRoofed = false;
    private ArrayList<IsoWorldRegion> neighbors = new ArrayList();

    public int getID() {
        return this.ID;
    }

    public Color getColor() {
        return this.color;
    }

    public int size() {
        return this.isoChunkRegions.size();
    }

    @Override
    public int getSquareSize() {
        return this.squareSize;
    }

    protected boolean isInPool() {
        return this.isInPool;
    }

    protected IsoWorldRegion(IsoRegionManager isoRegionManager) {
        this.manager = isoRegionManager;
    }

    protected void init(int n) {
        this.isInPool = false;
        this.ID = n;
        if (this.color == null) {
            this.color = this.manager.getColor();
        }
        this.squareSize = 0;
        this.roofCnt = 0;
        this.enclosed = true;
        this.isDirtyEnclosed = false;
        this.isDirtyRoofed = false;
    }

    protected IsoWorldRegion reset() {
        this.isInPool = true;
        this.ID = -1;
        this.squareSize = 0;
        this.roofCnt = 0;
        this.enclosed = true;
        this.isDirtyRoofed = false;
        this.isDirtyEnclosed = false;
        this.unlinkNeighbors();
        if (this.isoChunkRegions.size() > 0) {
            if (Core.bDebug) {
                throw new RuntimeException("MasterRegion.reset Resetting master region which still has chunk regions");
            }
            IsoRegions.warn("MasterRegion.reset Resetting master region which still has chunk regions");
            for (int i = 0; i < this.isoChunkRegions.size(); ++i) {
                IsoChunkRegion isoChunkRegion = this.isoChunkRegions.get(i);
                isoChunkRegion.setIsoWorldRegion(null);
            }
            this.isoChunkRegions.clear();
        }
        return this;
    }

    public void unlinkNeighbors() {
        for (int i = 0; i < this.neighbors.size(); ++i) {
            IsoWorldRegion isoWorldRegion = this.neighbors.get(i);
            isoWorldRegion.removeNeighbor(this);
        }
        this.neighbors.clear();
    }

    public void linkNeighbors() {
        for (int i = 0; i < this.isoChunkRegions.size(); ++i) {
            IsoChunkRegion isoChunkRegion = this.isoChunkRegions.get(i);
            for (int j = 0; j < isoChunkRegion.getAllNeighbors().size(); ++j) {
                IsoChunkRegion isoChunkRegion2 = isoChunkRegion.getAllNeighbors().get(j);
                if (isoChunkRegion2.getIsoWorldRegion() == null || isoChunkRegion2.getIsoWorldRegion() == this) continue;
                this.addNeighbor(isoChunkRegion2.getIsoWorldRegion());
                isoChunkRegion2.getIsoWorldRegion().addNeighbor(this);
            }
        }
    }

    private void addNeighbor(IsoWorldRegion isoWorldRegion) {
        if (!this.neighbors.contains(isoWorldRegion)) {
            this.neighbors.add(isoWorldRegion);
        }
    }

    private void removeNeighbor(IsoWorldRegion isoWorldRegion) {
        this.neighbors.remove(isoWorldRegion);
    }

    @Override
    public ArrayList<IsoWorldRegion> getNeighbors() {
        return this.neighbors;
    }

    @Override
    public ArrayList<IsoWorldRegion> getDebugConnectedNeighborCopy() {
        ArrayList<IsoWorldRegion> arrayList = new ArrayList<IsoWorldRegion>();
        if (this.neighbors.size() == 0) {
            return arrayList;
        }
        arrayList.addAll(this.neighbors);
        return arrayList;
    }

    @Override
    public boolean isFogMask() {
        return this.isEnclosed() && this.isFullyRoofed();
    }

    @Override
    public boolean isPlayerRoom() {
        return this.isFogMask();
    }

    @Override
    public boolean isFullyRoofed() {
        return this.roofCnt == this.squareSize;
    }

    public float getRoofedPercentage() {
        if (this.squareSize == 0) {
            return 0.0f;
        }
        return (float)this.roofCnt / (float)this.squareSize;
    }

    @Override
    public int getRoofCnt() {
        return this.roofCnt;
    }

    protected void addRoof() {
        ++this.roofCnt;
        if (this.roofCnt > this.squareSize) {
            IsoRegions.warn("WorldRegion.addRoof roofCount exceed squareSize.");
            this.roofCnt = this.squareSize;
        }
    }

    protected void removeRoofs(int n) {
        if (n <= 0) {
            return;
        }
        this.roofCnt -= n;
        if (this.roofCnt < 0) {
            IsoRegions.warn("MasterRegion.removeRoofs Roofcount managed to get below zero.");
            this.roofCnt = 0;
        }
    }

    public void addIsoChunkRegion(IsoChunkRegion isoChunkRegion) {
        if (!this.isoChunkRegions.contains(isoChunkRegion)) {
            this.squareSize += isoChunkRegion.getSquareSize();
            this.roofCnt += isoChunkRegion.getRoofCnt();
            this.isDirtyEnclosed = true;
            this.isoChunkRegions.add(isoChunkRegion);
            isoChunkRegion.setIsoWorldRegion(this);
        }
    }

    protected void removeIsoChunkRegion(IsoChunkRegion isoChunkRegion) {
        if (this.isoChunkRegions.remove(isoChunkRegion)) {
            this.squareSize -= isoChunkRegion.getSquareSize();
            this.roofCnt -= isoChunkRegion.getRoofCnt();
            this.isDirtyEnclosed = true;
            isoChunkRegion.setIsoWorldRegion(null);
        }
    }

    public boolean containsIsoChunkRegion(IsoChunkRegion isoChunkRegion) {
        return this.isoChunkRegions.contains(isoChunkRegion);
    }

    public ArrayList<IsoChunkRegion> swapIsoChunkRegions(ArrayList<IsoChunkRegion> arrayList) {
        ArrayList<IsoChunkRegion> arrayList2 = this.isoChunkRegions;
        this.isoChunkRegions = arrayList;
        return arrayList2;
    }

    protected void resetSquareSize() {
        this.squareSize = 0;
    }

    protected void setDirtyEnclosed() {
        this.isDirtyEnclosed = true;
    }

    public boolean isEnclosed() {
        if (this.isDirtyEnclosed) {
            this.recalcEnclosed();
        }
        return this.enclosed;
    }

    private void recalcEnclosed() {
        this.isDirtyEnclosed = false;
        this.enclosed = true;
        for (int i = 0; i < this.isoChunkRegions.size(); ++i) {
            IsoChunkRegion isoChunkRegion = this.isoChunkRegions.get(i);
            if (isoChunkRegion.getIsEnclosed()) continue;
            this.enclosed = false;
        }
    }

    public void merge(IsoWorldRegion isoWorldRegion) {
        Object object;
        int n;
        if (isoWorldRegion.isoChunkRegions.size() > 0) {
            for (n = isoWorldRegion.isoChunkRegions.size() - 1; n >= 0; --n) {
                object = isoWorldRegion.isoChunkRegions.get(n);
                isoWorldRegion.removeIsoChunkRegion((IsoChunkRegion)object);
                this.addIsoChunkRegion((IsoChunkRegion)object);
            }
            this.isDirtyEnclosed = true;
            isoWorldRegion.isoChunkRegions.clear();
        }
        if (isoWorldRegion.neighbors.size() > 0) {
            for (n = 0; n < isoWorldRegion.neighbors.size(); ++n) {
                object = isoWorldRegion.neighbors.get(n);
                ((IsoWorldRegion)object).removeNeighbor(isoWorldRegion);
                this.addNeighbor((IsoWorldRegion)object);
            }
            isoWorldRegion.neighbors.clear();
        }
        this.manager.releaseIsoWorldRegion(isoWorldRegion);
    }

    @Override
    public ArrayList<IsoChunkRegion> getDebugIsoChunkRegionCopy() {
        ArrayList<IsoChunkRegion> arrayList = new ArrayList<IsoChunkRegion>();
        arrayList.addAll(this.isoChunkRegions);
        return arrayList;
    }
}

