/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion.regions;

import java.util.ArrayDeque;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.data.DataRoot;
import zombie.iso.areas.isoregion.regions.IsoChunkRegion;
import zombie.iso.areas.isoregion.regions.IsoWorldRegion;

public final class IsoRegionManager {
    private final ArrayDeque<IsoWorldRegion> poolIsoWorldRegion = new ArrayDeque();
    private final ArrayDeque<IsoChunkRegion> poolIsoChunkRegion = new ArrayDeque();
    private final DataRoot dataRoot;
    private final ArrayDeque<Integer> regionIdStack = new ArrayDeque();
    private int nextID = 0;
    private int colorIndex = 0;
    private int worldRegionCount = 0;
    private int chunkRegionCount = 0;

    public IsoRegionManager(DataRoot dataRoot) {
        this.dataRoot = dataRoot;
    }

    public IsoWorldRegion allocIsoWorldRegion() {
        int n;
        IsoWorldRegion isoWorldRegion;
        IsoWorldRegion isoWorldRegion2 = isoWorldRegion = !this.poolIsoWorldRegion.isEmpty() ? this.poolIsoWorldRegion.pop() : new IsoWorldRegion(this);
        if (this.regionIdStack.isEmpty()) {
            int n2 = this.nextID;
            n = n2;
            this.nextID = n2 + 1;
        } else {
            n = this.regionIdStack.pop();
        }
        int n3 = n;
        isoWorldRegion.init(n3);
        ++this.worldRegionCount;
        return isoWorldRegion;
    }

    public void releaseIsoWorldRegion(IsoWorldRegion isoWorldRegion) {
        this.dataRoot.DequeueDirtyIsoWorldRegion(isoWorldRegion);
        if (!isoWorldRegion.isInPool()) {
            this.regionIdStack.push(isoWorldRegion.getID());
            isoWorldRegion.reset();
            this.poolIsoWorldRegion.push(isoWorldRegion);
            --this.worldRegionCount;
        } else {
            IsoRegions.warn("IsoRegionManager -> Trying to release a MasterRegion twice.");
        }
    }

    public IsoChunkRegion allocIsoChunkRegion(int n) {
        int n2;
        IsoChunkRegion isoChunkRegion;
        IsoChunkRegion isoChunkRegion2 = isoChunkRegion = !this.poolIsoChunkRegion.isEmpty() ? this.poolIsoChunkRegion.pop() : new IsoChunkRegion(this);
        if (this.regionIdStack.isEmpty()) {
            int n3 = this.nextID;
            n2 = n3;
            this.nextID = n3 + 1;
        } else {
            n2 = this.regionIdStack.pop();
        }
        int n4 = n2;
        isoChunkRegion.init(n4, n);
        ++this.chunkRegionCount;
        return isoChunkRegion;
    }

    public void releaseIsoChunkRegion(IsoChunkRegion isoChunkRegion) {
        if (!isoChunkRegion.isInPool()) {
            this.regionIdStack.push(isoChunkRegion.getID());
            isoChunkRegion.reset();
            this.poolIsoChunkRegion.push(isoChunkRegion);
            --this.chunkRegionCount;
        } else {
            IsoRegions.warn("IsoRegionManager -> Trying to release a ChunkRegion twice.");
        }
    }

    public Color getColor() {
        Color color = Colors.GetColorFromIndex(this.colorIndex++);
        if (this.colorIndex >= Colors.GetColorsCount()) {
            this.colorIndex = 0;
        }
        return color;
    }

    public int getWorldRegionCount() {
        return this.worldRegionCount;
    }

    public int getChunkRegionCount() {
        return this.chunkRegionCount;
    }
}

