/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion.regions;

import java.util.ArrayList;
import zombie.core.Color;
import zombie.core.Core;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.regions.IChunkRegion;
import zombie.iso.areas.isoregion.regions.IsoRegionManager;
import zombie.iso.areas.isoregion.regions.IsoWorldRegion;

public final class IsoChunkRegion
implements IChunkRegion {
    private final IsoRegionManager manager;
    private boolean isInPool = false;
    private Color color;
    private int ID;
    private byte zLayer;
    private byte squareSize = 0;
    private byte roofCnt = 0;
    private byte chunkBorderSquaresCnt = 0;
    private final boolean[] enclosed = new boolean[4];
    private boolean enclosedCache = true;
    private final ArrayList<IsoChunkRegion> connectedNeighbors = new ArrayList();
    private final ArrayList<IsoChunkRegion> allNeighbors = new ArrayList();
    private boolean isDirtyEnclosed = false;
    private IsoWorldRegion isoWorldRegion;

    public int getID() {
        return this.ID;
    }

    public int getSquareSize() {
        return this.squareSize;
    }

    public Color getColor() {
        return this.color;
    }

    public int getzLayer() {
        return this.zLayer;
    }

    public IsoWorldRegion getIsoWorldRegion() {
        return this.isoWorldRegion;
    }

    public void setIsoWorldRegion(IsoWorldRegion isoWorldRegion) {
        this.isoWorldRegion = isoWorldRegion;
    }

    protected boolean isInPool() {
        return this.isInPool;
    }

    protected IsoChunkRegion(IsoRegionManager isoRegionManager) {
        this.manager = isoRegionManager;
    }

    protected void init(int n, int n2) {
        this.isInPool = false;
        this.ID = n;
        this.zLayer = (byte)n2;
        this.resetChunkBorderSquaresCnt();
        if (this.color == null) {
            this.color = this.manager.getColor();
        }
        this.squareSize = 0;
        this.roofCnt = 0;
        this.resetEnclosed();
    }

    protected IsoChunkRegion reset() {
        this.isInPool = true;
        this.unlinkNeighbors();
        IsoWorldRegion isoWorldRegion = this.unlinkFromIsoWorldRegion();
        if (isoWorldRegion != null && isoWorldRegion.size() <= 0) {
            if (Core.bDebug) {
                throw new RuntimeException("ChunkRegion.reset IsoChunkRegion has IsoWorldRegion with 0 members.");
            }
            this.manager.releaseIsoWorldRegion(isoWorldRegion);
            IsoRegions.warn("ChunkRegion.reset IsoChunkRegion has IsoWorldRegion with 0 members.");
        }
        this.resetChunkBorderSquaresCnt();
        this.ID = -1;
        this.squareSize = 0;
        this.roofCnt = 0;
        this.resetEnclosed();
        return this;
    }

    public IsoWorldRegion unlinkFromIsoWorldRegion() {
        if (this.isoWorldRegion != null) {
            IsoWorldRegion isoWorldRegion = this.isoWorldRegion;
            this.isoWorldRegion.removeIsoChunkRegion(this);
            this.isoWorldRegion = null;
            return isoWorldRegion;
        }
        return null;
    }

    public int getRoofCnt() {
        return this.roofCnt;
    }

    public void addRoof() {
        this.roofCnt = (byte)(this.roofCnt + 1);
        if (this.roofCnt > this.squareSize) {
            IsoRegions.warn("ChunkRegion.addRoof roofCount exceed squareSize.");
            this.roofCnt = this.squareSize;
            return;
        }
        if (this.isoWorldRegion != null) {
            this.isoWorldRegion.addRoof();
        }
    }

    public void resetRoofCnt() {
        if (this.isoWorldRegion != null) {
            this.isoWorldRegion.removeRoofs(this.roofCnt);
        }
        this.roofCnt = 0;
    }

    public void addSquareCount() {
        this.squareSize = (byte)(this.squareSize + 1);
    }

    public int getChunkBorderSquaresCnt() {
        return this.chunkBorderSquaresCnt;
    }

    public void addChunkBorderSquaresCnt() {
        this.chunkBorderSquaresCnt = (byte)(this.chunkBorderSquaresCnt + 1);
    }

    protected void removeChunkBorderSquaresCnt() {
        this.chunkBorderSquaresCnt = (byte)(this.chunkBorderSquaresCnt - 1);
        if (this.chunkBorderSquaresCnt < 0) {
            this.chunkBorderSquaresCnt = 0;
        }
    }

    protected void resetChunkBorderSquaresCnt() {
        this.chunkBorderSquaresCnt = 0;
    }

    private void resetEnclosed() {
        for (int n = 0; n < 4; n = (int)((byte)(n + 1))) {
            this.enclosed[n] = true;
        }
        this.isDirtyEnclosed = false;
        this.enclosedCache = true;
    }

    public void setEnclosed(byte by, boolean bl) {
        this.isDirtyEnclosed = true;
        this.enclosed[by] = bl;
    }

    protected void setDirtyEnclosed() {
        this.isDirtyEnclosed = true;
        if (this.isoWorldRegion != null) {
            this.isoWorldRegion.setDirtyEnclosed();
        }
    }

    public boolean getIsEnclosed() {
        if (!this.isDirtyEnclosed) {
            return this.enclosedCache;
        }
        this.isDirtyEnclosed = false;
        this.enclosedCache = true;
        for (int n = 0; n < 4; n = (int)((byte)(n + 1))) {
            if (this.enclosed[n]) continue;
            this.enclosedCache = false;
        }
        if (this.isoWorldRegion != null) {
            this.isoWorldRegion.setDirtyEnclosed();
        }
        return this.enclosedCache;
    }

    public ArrayList<IsoChunkRegion> getConnectedNeighbors() {
        return this.connectedNeighbors;
    }

    public void addConnectedNeighbor(IsoChunkRegion isoChunkRegion) {
        if (isoChunkRegion == null) {
            return;
        }
        if (!this.connectedNeighbors.contains(isoChunkRegion)) {
            this.connectedNeighbors.add(isoChunkRegion);
        }
    }

    protected void removeConnectedNeighbor(IsoChunkRegion isoChunkRegion) {
        this.connectedNeighbors.remove(isoChunkRegion);
    }

    public int getNeighborCount() {
        return this.allNeighbors.size();
    }

    protected ArrayList<IsoChunkRegion> getAllNeighbors() {
        return this.allNeighbors;
    }

    public void addNeighbor(IsoChunkRegion isoChunkRegion) {
        if (isoChunkRegion == null) {
            return;
        }
        if (!this.allNeighbors.contains(isoChunkRegion)) {
            this.allNeighbors.add(isoChunkRegion);
        }
    }

    protected void removeNeighbor(IsoChunkRegion isoChunkRegion) {
        this.allNeighbors.remove(isoChunkRegion);
    }

    protected void unlinkNeighbors() {
        IsoChunkRegion isoChunkRegion;
        int n;
        for (n = 0; n < this.connectedNeighbors.size(); ++n) {
            isoChunkRegion = this.connectedNeighbors.get(n);
            isoChunkRegion.removeConnectedNeighbor(this);
        }
        this.connectedNeighbors.clear();
        for (n = 0; n < this.allNeighbors.size(); ++n) {
            isoChunkRegion = this.allNeighbors.get(n);
            isoChunkRegion.removeNeighbor(this);
        }
        this.allNeighbors.clear();
    }

    public ArrayList<IsoChunkRegion> getDebugConnectedNeighborCopy() {
        ArrayList<IsoChunkRegion> arrayList = new ArrayList<IsoChunkRegion>();
        if (this.connectedNeighbors.size() == 0) {
            return arrayList;
        }
        arrayList.addAll(this.connectedNeighbors);
        return arrayList;
    }

    public boolean containsConnectedNeighbor(IsoChunkRegion isoChunkRegion) {
        return this.connectedNeighbors.contains(isoChunkRegion);
    }

    public boolean containsConnectedNeighborID(int n) {
        if (this.connectedNeighbors.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.connectedNeighbors.size(); ++i) {
            IsoChunkRegion isoChunkRegion = this.connectedNeighbors.get(i);
            if (isoChunkRegion.getID() != n) continue;
            return true;
        }
        return false;
    }

    public IsoChunkRegion getConnectedNeighborWithLargestIsoWorldRegion() {
        if (this.connectedNeighbors.size() == 0) {
            return null;
        }
        IsoWorldRegion isoWorldRegion = null;
        IsoChunkRegion isoChunkRegion = null;
        for (int i = 0; i < this.connectedNeighbors.size(); ++i) {
            IsoChunkRegion isoChunkRegion2 = this.connectedNeighbors.get(i);
            IsoWorldRegion isoWorldRegion2 = isoChunkRegion2.getIsoWorldRegion();
            if (isoWorldRegion2 == null || isoWorldRegion != null && isoWorldRegion2.getSquareSize() <= isoWorldRegion.getSquareSize()) continue;
            isoWorldRegion = isoWorldRegion2;
            isoChunkRegion = isoChunkRegion2;
        }
        return isoChunkRegion;
    }

    protected IsoChunkRegion getFirstNeighborWithIsoWorldRegion() {
        if (this.connectedNeighbors.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.connectedNeighbors.size(); ++i) {
            IsoChunkRegion isoChunkRegion = this.connectedNeighbors.get(i);
            IsoWorldRegion isoWorldRegion = isoChunkRegion.getIsoWorldRegion();
            if (isoWorldRegion == null) continue;
            return isoChunkRegion;
        }
        return null;
    }
}

