/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion.jobs;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import zombie.core.Core;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.iso.IsoChunk;
import zombie.iso.areas.isoregion.ChunkUpdate;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.data.DataChunk;
import zombie.iso.areas.isoregion.data.DataRoot;
import zombie.iso.areas.isoregion.jobs.RegionJob;
import zombie.iso.areas.isoregion.jobs.RegionJobType;
import zombie.network.GameClient;

public class JobChunkUpdate
extends RegionJob {
    private ByteBuffer buffer = ByteBuffer.allocate(65536);
    private int chunkCount = 0;
    private int bufferMaxBytes = 0;
    private long netTimeStamp = -1L;
    private UdpConnection targetConn;

    protected JobChunkUpdate() {
        super(RegionJobType.ChunkUpdate);
    }

    @Override
    protected void reset() {
        this.chunkCount = 0;
        this.bufferMaxBytes = 0;
        this.netTimeStamp = -1L;
        this.targetConn = null;
        this.buffer.clear();
    }

    public UdpConnection getTargetConn() {
        return this.targetConn;
    }

    public void setTargetConn(UdpConnection udpConnection) {
        this.targetConn = udpConnection;
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getNetTimeStamp() {
        return this.netTimeStamp;
    }

    public void setNetTimeStamp(long l) {
        this.netTimeStamp = l;
    }

    public boolean readChunksPacket(DataRoot dataRoot, List<Integer> list) {
        this.buffer.position(0);
        int n = this.buffer.getInt();
        int n2 = this.buffer.getInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.buffer.getInt();
            int n4 = this.buffer.getInt();
            int n5 = this.buffer.getInt();
            int n6 = this.buffer.getInt();
            dataRoot.select.reset(n5 * 10, n6 * 10, 0, true, false);
            if (GameClient.bClient) {
                if (this.netTimeStamp != -1L && this.netTimeStamp < dataRoot.select.chunk.getLastUpdateStamp()) {
                    var10_10 = this.buffer.position();
                    int n7 = this.buffer.getInt();
                    this.buffer.position(var10_10 + n7);
                    continue;
                }
                dataRoot.select.chunk.setLastUpdateStamp(this.netTimeStamp);
            } else {
                var10_10 = IsoRegions.hash(n5, n6);
                if (!list.contains(var10_10)) {
                    list.add(var10_10);
                }
            }
            dataRoot.select.chunk.load(this.buffer, n4, true);
            dataRoot.select.chunk.setDirtyAllActive();
        }
        return true;
    }

    public boolean saveChunksToDisk() {
        if (Core.getInstance().isNoSave()) {
            return true;
        }
        if (this.chunkCount > 0) {
            this.buffer.position(0);
            int n = this.buffer.getInt();
            int n2 = this.buffer.getInt();
            for (int i = 0; i < n2; ++i) {
                this.buffer.mark();
                int n3 = this.buffer.getInt();
                int n4 = this.buffer.getInt();
                int n5 = this.buffer.getInt();
                int n6 = this.buffer.getInt();
                this.buffer.reset();
                File file = IsoRegions.getChunkFile(n5, n6);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.getChannel().truncate(0L);
                    fileOutputStream.write(this.buffer.array(), this.buffer.position(), n3);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    DebugLog.log(exception.getMessage());
                    exception.printStackTrace();
                }
                this.buffer.position(this.buffer.position() + n3);
            }
            return true;
        }
        return false;
    }

    public boolean saveChunksToNetBuffer(ByteBuffer byteBuffer) {
        IsoRegions.log("Server max bytes buffer = " + this.bufferMaxBytes + ", chunks = " + this.chunkCount);
        byteBuffer.put(this.buffer.array(), 0, this.bufferMaxBytes);
        return true;
    }

    public boolean readChunksFromNetBuffer(ByteBuffer byteBuffer, long l) {
        this.netTimeStamp = l;
        byteBuffer.mark();
        this.bufferMaxBytes = byteBuffer.getInt();
        this.chunkCount = byteBuffer.getInt();
        byteBuffer.reset();
        IsoRegions.log("Client max bytes buffer = " + this.bufferMaxBytes + ", chunks = " + this.chunkCount);
        this.buffer.position(0);
        this.buffer.put(byteBuffer.array(), byteBuffer.position(), this.bufferMaxBytes);
        return true;
    }

    public boolean canAddChunk() {
        return this.buffer.position() + 1024 < this.buffer.capacity();
    }

    private int startBufferBlock() {
        if (this.chunkCount == 0) {
            this.buffer.position(0);
            this.buffer.putInt(0);
            this.buffer.putInt(0);
        }
        int n = this.buffer.position();
        this.buffer.putInt(0);
        return n;
    }

    private void endBufferBlock(int n) {
        this.bufferMaxBytes = this.buffer.position();
        this.buffer.position(n);
        this.buffer.putInt(this.bufferMaxBytes - n);
        ++this.chunkCount;
        this.buffer.position(0);
        this.buffer.putInt(this.bufferMaxBytes);
        this.buffer.putInt(this.chunkCount);
        this.buffer.position(this.bufferMaxBytes);
    }

    public boolean addChunkFromDataChunk(DataChunk dataChunk) {
        if (this.buffer.position() + 1024 >= this.buffer.capacity()) {
            return false;
        }
        int n = this.startBufferBlock();
        this.buffer.putInt(195);
        this.buffer.putInt(dataChunk.getChunkX());
        this.buffer.putInt(dataChunk.getChunkY());
        dataChunk.save(this.buffer);
        this.endBufferBlock(n);
        return true;
    }

    public boolean addChunkFromIsoChunk(IsoChunk isoChunk) {
        if (this.buffer.position() + 1024 >= this.buffer.capacity()) {
            return false;
        }
        int n = this.startBufferBlock();
        this.buffer.putInt(195);
        this.buffer.putInt(isoChunk.wx);
        this.buffer.putInt(isoChunk.wy);
        ChunkUpdate.writeIsoChunkIntoBuffer(isoChunk, this.buffer);
        this.endBufferBlock(n);
        return true;
    }

    public boolean addChunkFromFile(ByteBuffer byteBuffer) {
        if (this.buffer.position() + byteBuffer.limit() >= this.buffer.capacity()) {
            return false;
        }
        byteBuffer.getInt();
        int n = this.startBufferBlock();
        this.buffer.putInt(byteBuffer.getInt());
        this.buffer.putInt(byteBuffer.getInt());
        this.buffer.putInt(byteBuffer.getInt());
        byteBuffer.mark();
        int n2 = byteBuffer.getInt();
        byteBuffer.reset();
        this.buffer.put(byteBuffer.array(), byteBuffer.position(), n2);
        this.endBufferBlock(n);
        return true;
    }
}

