/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.core.Color;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.iso.areas.isoregion.IsoRegionLogType;

public class IsoRegionsLogger {
    private final ConcurrentLinkedQueue<IsoRegionLog> pool = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<IsoRegionLog> loggerQueue = new ConcurrentLinkedQueue();
    private final boolean consolePrint;
    private final ArrayList<IsoRegionLog> logs = new ArrayList();
    private final int maxLogs = 100;
    private boolean isDirtyUI = false;

    public IsoRegionsLogger(boolean bl) {
        this.consolePrint = bl;
    }

    public ArrayList<IsoRegionLog> getLogs() {
        return this.logs;
    }

    public boolean isDirtyUI() {
        return this.isDirtyUI;
    }

    public void unsetDirtyUI() {
        this.isDirtyUI = false;
    }

    private IsoRegionLog getLog() {
        IsoRegionLog isoRegionLog = this.pool.poll();
        if (isoRegionLog == null) {
            isoRegionLog = new IsoRegionLog();
        }
        return isoRegionLog;
    }

    protected void log(String string) {
        this.log(string, null);
    }

    protected void log(String string, Color color) {
        if (Core.bDebug) {
            if (this.consolePrint) {
                DebugLog.IsoRegion.println(string);
            }
            IsoRegionLog isoRegionLog = this.getLog();
            isoRegionLog.str = string;
            isoRegionLog.type = IsoRegionLogType.Normal;
            isoRegionLog.col = color;
            this.loggerQueue.offer(isoRegionLog);
        }
    }

    protected void warn(String string) {
        DebugLog.IsoRegion.warn(string);
        if (Core.bDebug) {
            IsoRegionLog isoRegionLog = this.getLog();
            isoRegionLog.str = string;
            isoRegionLog.type = IsoRegionLogType.Warn;
            this.loggerQueue.offer(isoRegionLog);
        }
    }

    protected void update() {
        if (!Core.bDebug) {
            return;
        }
        IsoRegionLog isoRegionLog = this.loggerQueue.poll();
        while (isoRegionLog != null) {
            if (this.logs.size() >= 100) {
                IsoRegionLog isoRegionLog2 = this.logs.remove(0);
                isoRegionLog2.col = null;
                this.pool.offer(isoRegionLog2);
            }
            this.logs.add(isoRegionLog);
            this.isDirtyUI = true;
            isoRegionLog = this.loggerQueue.poll();
        }
    }

    public static class IsoRegionLog {
        private String str;
        private IsoRegionLogType type;
        private Color col;

        public String getStr() {
            return this.str;
        }

        public IsoRegionLogType getType() {
            return this.type;
        }

        public Color getColor() {
            if (this.col != null) {
                return this.col;
            }
            if (this.type == IsoRegionLogType.Warn) {
                return Color.red;
            }
            return Color.white;
        }
    }
}

