/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.Core;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.areas.isoregion.IsoRegionWorker;
import zombie.iso.areas.isoregion.IsoRegionsLogger;
import zombie.iso.areas.isoregion.data.DataChunk;
import zombie.iso.areas.isoregion.data.DataRoot;
import zombie.iso.areas.isoregion.data.DataSquarePos;
import zombie.iso.areas.isoregion.regions.IChunkRegion;
import zombie.iso.areas.isoregion.regions.IWorldRegion;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class IsoRegions {
    public static final int SINGLE_CHUNK_PACKET_SIZE = 1024;
    public static final int CHUNKS_DATA_PACKET_SIZE = 65536;
    public static boolean PRINT_D = false;
    public static final int CELL_DIM = 300;
    public static final int CELL_CHUNK_DIM = 30;
    public static final int CHUNK_DIM = 10;
    public static final int CHUNK_MAX_Z = 8;
    public static final byte BIT_EMPTY = 0;
    public static final byte BIT_WALL_N = 1;
    public static final byte BIT_WALL_W = 2;
    public static final byte BIT_PATH_WALL_N = 4;
    public static final byte BIT_PATH_WALL_W = 8;
    public static final byte BIT_HAS_FLOOR = 16;
    public static final byte BIT_STAIRCASE = 32;
    public static final byte BIT_HAS_ROOF = 64;
    public static final byte DIR_NONE = -1;
    public static final byte DIR_N = 0;
    public static final byte DIR_W = 1;
    public static final byte DIR_2D_NW = 2;
    public static final byte DIR_S = 2;
    public static final byte DIR_E = 3;
    public static final byte DIR_2D_MAX = 4;
    public static final byte DIR_TOP = 4;
    public static final byte DIR_BOT = 5;
    public static final byte DIR_MAX = 6;
    protected static final int CHUNK_LOAD_DIMENSIONS = 7;
    protected static boolean DEBUG_LOAD_ALL_CHUNKS = false;
    public static final String FILE_PRE = "datachunk_";
    public static final String FILE_SEP = "_";
    public static final String FILE_EXT = ".bin";
    public static final String FILE_DIR = "isoregiondata";
    private static final int SQUARE_CHANGE_WARN_THRESHOLD = 20;
    private static int SQUARE_CHANGE_PER_TICK = 0;
    private static String cacheDir;
    private static File cacheDirFile;
    private static File headDataFile;
    private static final Map<Integer, File> chunkFileNames;
    private static IsoRegionWorker regionWorker;
    private static DataRoot dataRoot;
    private static IsoRegionsLogger logger;
    protected static int lastChunkX;
    protected static int lastChunkY;
    private static byte previousFlags;

    public static File getHeaderFile() {
        return headDataFile;
    }

    public static File getDirectory() {
        return cacheDirFile;
    }

    public static File getChunkFile(int n, int n2) {
        Object object;
        int n3 = IsoRegions.hash(n, n2);
        if (chunkFileNames.containsKey(n3) && (object = chunkFileNames.get(n3)) != null) {
            return chunkFileNames.get(n3);
        }
        object = cacheDir + FILE_PRE + n + FILE_SEP + n2 + FILE_EXT;
        File file = new File((String)object);
        chunkFileNames.put(n3, file);
        return file;
    }

    public static byte GetOppositeDir(byte by) {
        if (by == 0) {
            return 2;
        }
        if (by == 1) {
            return 3;
        }
        if (by == 2) {
            return 0;
        }
        if (by == 3) {
            return 1;
        }
        if (by == 4) {
            return 5;
        }
        if (by == 5) {
            return 4;
        }
        return -1;
    }

    public static void setDebugLoadAllChunks(boolean bl) {
        DEBUG_LOAD_ALL_CHUNKS = bl;
    }

    public static boolean isDebugLoadAllChunks() {
        return DEBUG_LOAD_ALL_CHUNKS;
    }

    public static int hash(int n, int n2) {
        return n2 << 16 ^ n;
    }

    protected static DataRoot getDataRoot() {
        return dataRoot;
    }

    public static void init() {
        if (!Core.bDebug) {
            PRINT_D = false;
            DataSquarePos.DEBUG_POOL = false;
        }
        logger = new IsoRegionsLogger(PRINT_D);
        chunkFileNames.clear();
        cacheDir = ZomboidFileSystem.instance.getFileNameInCurrentSave(FILE_DIR) + File.separator;
        cacheDirFile = new File(cacheDir);
        if (!cacheDirFile.exists()) {
            cacheDirFile.mkdir();
        }
        String string = cacheDir + "RegionHeader.bin";
        headDataFile = new File(string);
        previousFlags = 0;
        dataRoot = new DataRoot();
        regionWorker = new IsoRegionWorker();
        regionWorker.create();
        regionWorker.load();
    }

    public static IsoRegionsLogger getLogger() {
        return logger;
    }

    public static void log(String string) {
        logger.log(string);
    }

    public static void log(String string, Color color) {
        logger.log(string, color);
    }

    public static void warn(String string) {
        logger.warn(string);
    }

    public static void reset() {
        previousFlags = 0;
        regionWorker.stop();
        regionWorker = null;
        dataRoot = null;
        chunkFileNames.clear();
    }

    public static void receiveServerUpdatePacket(ByteBuffer byteBuffer) {
        if (regionWorker == null) {
            logger.warn("IsoRegion cannot receive server packet, regionWorker == null.");
            return;
        }
        if (GameClient.bClient) {
            regionWorker.readServerUpdatePacket(byteBuffer);
        }
    }

    public static void receiveClientRequestFullDataChunks(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        if (regionWorker == null) {
            logger.warn("IsoRegion cannot receive client packet, regionWorker == null.");
            return;
        }
        if (GameServer.bServer) {
            regionWorker.readClientRequestFullUpdatePacket(byteBuffer, udpConnection);
        }
    }

    public static void update() {
        if (Core.bDebug && SQUARE_CHANGE_PER_TICK > 20) {
            logger.warn("IsoRegion Warning -> " + SQUARE_CHANGE_PER_TICK + " squares have been changed in one tick.");
        }
        SQUARE_CHANGE_PER_TICK = 0;
        if (IsoRegionWorker.isRequestingBufferSwap.get()) {
            logger.log("IsoRegion Swapping DataRoot");
            DataRoot dataRoot = IsoRegions.dataRoot;
            IsoRegions.dataRoot = regionWorker.getRootBuffer();
            regionWorker.setRootBuffer(dataRoot);
            IsoRegionWorker.isRequestingBufferSwap.set(false);
            if (!GameServer.bServer) {
                IsoRegions.clientResetCachedRegionReferences();
            }
        }
        if (!GameClient.bClient && !GameServer.bServer && DEBUG_LOAD_ALL_CHUNKS && Core.bDebug) {
            int n = (int)IsoPlayer.getInstance().getX() / 10;
            int n2 = (int)IsoPlayer.getInstance().getY() / 10;
            if (lastChunkX != n || lastChunkY != n2) {
                lastChunkX = n;
                lastChunkY = n2;
                regionWorker.readSurroundingChunks(n, n2, IsoChunkMap.ChunkGridWidth - 2, true);
            }
        }
        regionWorker.update();
        logger.update();
    }

    protected static void forceRecalcSurroundingChunks() {
        if (!Core.bDebug || GameClient.bClient) {
            return;
        }
        logger.log("[DEBUG] Forcing a full load/recalculate of chunks surrounding player.", Colors.Gold);
        int n = (int)IsoPlayer.getInstance().getX() / 10;
        int n2 = (int)IsoPlayer.getInstance().getY() / 10;
        regionWorker.readSurroundingChunks(n, n2, IsoChunkMap.ChunkGridWidth - 2, true, true);
    }

    public static byte getSquareFlags(int n, int n2, int n3) {
        return dataRoot.getSquareFlags(n, n2, n3);
    }

    public static IWorldRegion getIsoWorldRegion(int n, int n2, int n3) {
        return dataRoot.getIsoWorldRegion(n, n2, n3);
    }

    public static DataChunk getDataChunk(int n, int n2) {
        return dataRoot.getDataChunk(n, n2);
    }

    public static IChunkRegion getChunkRegion(int n, int n2, int n3) {
        return dataRoot.getIsoChunkRegion(n, n2, n3);
    }

    public static void ResetAllDataDebug() {
        if (!Core.bDebug) {
            return;
        }
        if (GameServer.bServer || GameClient.bClient) {
            return;
        }
        regionWorker.addDebugResetJob();
    }

    private static void clientResetCachedRegionReferences() {
        if (GameServer.bServer) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = IsoChunkMap.ChunkGridWidth;
        int n4 = IsoChunkMap.ChunkGridWidth;
        IsoChunkMap isoChunkMap = IsoWorld.instance.getCell().getChunkMap(IsoPlayer.getPlayerIndex());
        if (isoChunkMap == null) {
            return;
        }
        for (int i = n; i < n3; ++i) {
            for (int j = n2; j < n4; ++j) {
                IsoChunk isoChunk = isoChunkMap.getChunk(i, j);
                if (isoChunk == null) continue;
                for (int k = 0; k <= isoChunk.maxLevel; ++k) {
                    for (int i2 = 0; i2 < isoChunk.squares[0].length; ++i2) {
                        IsoGridSquare isoGridSquare = isoChunk.squares[k][i2];
                        if (isoGridSquare == null) continue;
                        isoGridSquare.setIsoWorldRegion(null);
                    }
                }
            }
        }
    }

    public static void setPreviousFlags(IsoGridSquare isoGridSquare) {
        previousFlags = IsoRegions.calculateSquareFlags(isoGridSquare);
    }

    public static void squareChanged(IsoGridSquare isoGridSquare) {
        IsoRegions.squareChanged(isoGridSquare, false);
    }

    public static void squareChanged(IsoGridSquare isoGridSquare, boolean bl) {
        if (GameClient.bClient) {
            return;
        }
        if (isoGridSquare == null) {
            return;
        }
        byte by = IsoRegions.calculateSquareFlags(isoGridSquare);
        if (by == previousFlags) {
            return;
        }
        regionWorker.addSquareChangedJob(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), bl, by);
        ++SQUARE_CHANGE_PER_TICK;
        previousFlags = 0;
    }

    protected static byte calculateSquareFlags(IsoGridSquare isoGridSquare) {
        int n = 0;
        if (isoGridSquare != null) {
            if (isoGridSquare.Is(IsoFlagType.solidfloor)) {
                n |= 0x10;
            }
            if (isoGridSquare.Is(IsoFlagType.cutN) || isoGridSquare.Has(IsoObjectType.doorFrN)) {
                n |= 1;
                if (isoGridSquare.Is(IsoFlagType.WindowN) || isoGridSquare.Is(IsoFlagType.windowN) || isoGridSquare.Is(IsoFlagType.DoorWallN)) {
                    n |= 4;
                }
            }
            if (!isoGridSquare.Is(IsoFlagType.WallSE) && (isoGridSquare.Is(IsoFlagType.cutW) || isoGridSquare.Has(IsoObjectType.doorFrW))) {
                n |= 2;
                if (isoGridSquare.Is(IsoFlagType.WindowW) || isoGridSquare.Is(IsoFlagType.windowW) || isoGridSquare.Is(IsoFlagType.DoorWallW)) {
                    n |= 8;
                }
            }
            if (isoGridSquare.HasStairsNorth() || isoGridSquare.HasStairsWest()) {
                n |= 0x20;
            }
        }
        return (byte)n;
    }

    protected static IsoRegionWorker getRegionWorker() {
        return regionWorker;
    }

    static {
        chunkFileNames = new HashMap<Integer, File>();
        lastChunkX = -1;
        lastChunkY = -1;
        previousFlags = 0;
    }
}

