/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import zombie.VirtualZombieManager;
import zombie.core.Rand;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoRoomLight;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.areas.IsoRoomExit;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoWindow;
import zombie.network.GameServer;

public final class IsoRoom {
    private static final ArrayList<IsoGridSquare> tempSquares = new ArrayList();
    public final Vector<IsoGridSquare> Beds = new Vector();
    public Rectangle bounds;
    public IsoBuilding building = null;
    public final ArrayList<ItemContainer> Containers = new ArrayList();
    public final ArrayList<IsoWindow> Windows = new ArrayList();
    public final Vector<IsoRoomExit> Exits = new Vector();
    public int layer;
    public String RoomDef = "none";
    public final Vector<IsoGridSquare> TileList = new Vector();
    public int transparentWalls = 0;
    public final ArrayList<IsoLightSwitch> lightSwitches = new ArrayList();
    public final ArrayList<IsoRoomLight> roomLights = new ArrayList();
    public final ArrayList<IsoObject> WaterSources = new ArrayList();
    public int seen = 1000000000;
    public int visited = 1000000000;
    public RoomDef def;
    public final ArrayList<RoomDef.RoomRect> rects = new ArrayList(1);
    public final ArrayList<IsoGridSquare> Squares = new ArrayList();

    public IsoBuilding getBuilding() {
        return this.building;
    }

    public String getName() {
        return this.RoomDef;
    }

    public IsoBuilding CreateBuilding(IsoCell isoCell) {
        IsoBuilding isoBuilding = new IsoBuilding(isoCell);
        this.AddToBuilding(isoBuilding);
        return isoBuilding;
    }

    public boolean isInside(int n, int n2, int n3) {
        for (int i = 0; i < this.rects.size(); ++i) {
            int n4 = this.rects.get((int)i).x;
            int n5 = this.rects.get((int)i).y;
            int n6 = this.rects.get(i).getX2();
            int n7 = this.rects.get(i).getY2();
            if (n < n4 || n2 < n5 || n >= n6 || n2 >= n7 || n3 != this.layer) continue;
            return true;
        }
        return false;
    }

    public IsoGridSquare getFreeTile() {
        boolean bl = false;
        IsoGridSquare isoGridSquare = null;
        int n = 100;
        while (!bl && n > 0) {
            --n;
            bl = true;
            if (this.TileList.isEmpty()) {
                return null;
            }
            isoGridSquare = this.TileList.get(Rand.Next(this.TileList.size()));
            for (int i = 0; i < this.Exits.size(); ++i) {
                if (isoGridSquare.getX() != this.Exits.get((int)i).x || isoGridSquare.getY() != this.Exits.get((int)i).y) continue;
                bl = false;
            }
            if (!bl || isoGridSquare.isFree(true)) continue;
            bl = false;
        }
        if (n < 0) {
            return null;
        }
        return isoGridSquare;
    }

    void AddToBuilding(IsoBuilding isoBuilding) {
        this.building = isoBuilding;
        isoBuilding.AddRoom(this);
        for (IsoRoomExit isoRoomExit : this.Exits) {
            if (isoRoomExit.To.From == null || isoRoomExit.To.From.building != null) continue;
            isoRoomExit.To.From.AddToBuilding(isoBuilding);
        }
    }

    public ArrayList<IsoObject> getWaterSources() {
        return this.WaterSources;
    }

    public void setWaterSources(ArrayList<IsoObject> arrayList) {
        this.WaterSources.clear();
        this.WaterSources.addAll(arrayList);
    }

    public boolean hasWater() {
        if (this.WaterSources.isEmpty()) {
            return false;
        }
        Iterator<IsoObject> iterator = this.WaterSources.iterator();
        while (iterator != null && iterator.hasNext()) {
            IsoObject isoObject = iterator.next();
            if (!isoObject.hasWater()) continue;
            return true;
        }
        return false;
    }

    public void useWater() {
        if (this.WaterSources.isEmpty()) {
            return;
        }
        Iterator<IsoObject> iterator = this.WaterSources.iterator();
        while (iterator != null && iterator.hasNext()) {
            IsoObject isoObject = iterator.next();
            if (!isoObject.hasWater()) continue;
            isoObject.useWater(1);
            break;
        }
    }

    public ArrayList<IsoWindow> getWindows() {
        return this.Windows;
    }

    public void addSquare(IsoGridSquare isoGridSquare) {
        if (this.Squares.contains(isoGridSquare)) {
            return;
        }
        this.Squares.add(isoGridSquare);
    }

    public void refreshSquares() {
        this.Windows.clear();
        this.Containers.clear();
        this.WaterSources.clear();
        this.Exits.clear();
        tempSquares.clear();
        tempSquares.addAll(this.Squares);
        this.Squares.clear();
        for (int i = 0; i < tempSquares.size(); ++i) {
            this.addSquare(tempSquares.get(i));
        }
    }

    private void addExitTo(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        IsoRoom isoRoom = null;
        IsoRoom isoRoom2 = null;
        if (isoGridSquare != null) {
            isoRoom = isoGridSquare.getRoom();
        }
        if (isoGridSquare2 != null) {
            isoRoom2 = isoGridSquare2.getRoom();
        }
        if (isoRoom == null && isoRoom2 == null) {
            return;
        }
        IsoRoom isoRoom3 = isoRoom;
        if (isoRoom == null) {
            isoRoom3 = isoRoom2;
        }
        IsoRoomExit isoRoomExit = new IsoRoomExit(isoRoom3, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
        isoRoomExit.type = IsoRoomExit.ExitType.Door;
        if (isoRoom3 == isoRoom) {
            if (isoRoom2 != null) {
                IsoRoomExit isoRoomExit2 = isoRoom2.getExitAt(isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ());
                if (isoRoomExit2 == null) {
                    isoRoomExit2 = new IsoRoomExit(isoRoom2, isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ());
                    isoRoom2.Exits.add(isoRoomExit2);
                }
                isoRoomExit.To = isoRoomExit2;
            } else {
                isoRoom.building.Exits.add(isoRoomExit);
                if (isoGridSquare2 != null) {
                    isoRoomExit.To = new IsoRoomExit(isoRoomExit, isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ());
                }
            }
            isoRoom.Exits.add(isoRoomExit);
        } else {
            isoRoom2.building.Exits.add(isoRoomExit);
            if (isoGridSquare2 != null) {
                isoRoomExit.To = new IsoRoomExit(isoRoomExit, isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ());
            }
            isoRoom2.Exits.add(isoRoomExit);
        }
    }

    private IsoRoomExit getExitAt(int n, int n2, int n3) {
        for (int i = 0; i < this.Exits.size(); ++i) {
            IsoRoomExit isoRoomExit = this.Exits.get(i);
            if (isoRoomExit.x != n || isoRoomExit.y != n2 || isoRoomExit.layer != n3) continue;
            return isoRoomExit;
        }
        return null;
    }

    public void removeSquare(IsoGridSquare isoGridSquare) {
        this.Squares.remove(isoGridSquare);
        IsoRoomExit isoRoomExit = this.getExitAt(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
        if (isoRoomExit != null) {
            this.Exits.remove(isoRoomExit);
            if (isoRoomExit.To != null) {
                isoRoomExit.From = null;
            }
            if (this.building.Exits.contains(isoRoomExit)) {
                this.building.Exits.remove(isoRoomExit);
            }
        }
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (!(isoObject instanceof IsoLightSwitch)) continue;
            this.lightSwitches.remove(isoObject);
        }
    }

    public void spawnZombies() {
        VirtualZombieManager.instance.addZombiesToMap(1, this.def, false);
    }

    public void onSee() {
        for (int i = 0; i < this.getBuilding().Rooms.size(); ++i) {
            IsoRoom isoRoom = this.getBuilding().Rooms.elementAt(i);
            if (isoRoom != null && !isoRoom.def.bExplored) {
                isoRoom.def.bExplored = true;
            }
            IsoWorld.instance.getCell().roomSpotted(isoRoom);
        }
    }

    public Vector<IsoGridSquare> getTileList() {
        return this.TileList;
    }

    public ArrayList<IsoGridSquare> getSquares() {
        return this.Squares;
    }

    public ArrayList<ItemContainer> getContainer() {
        return this.Containers;
    }

    public IsoGridSquare getRandomSquare() {
        if (this.Squares.isEmpty()) {
            return null;
        }
        return this.Squares.get(Rand.Next(this.Squares.size()));
    }

    public IsoGridSquare getRandomFreeSquare() {
        int n;
        IsoGridSquare isoGridSquare = null;
        if (GameServer.bServer) {
            for (n = 100; n > 0; --n) {
                isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.def.getX() + Rand.Next(this.def.getW()), this.def.getY() + Rand.Next(this.def.getH()), this.def.level);
                if (isoGridSquare == null || isoGridSquare.getRoom() != this || !isoGridSquare.isFree(true)) continue;
                return isoGridSquare;
            }
            return null;
        }
        if (this.Squares.isEmpty()) {
            return null;
        }
        while (n > 0) {
            isoGridSquare = this.Squares.get(Rand.Next(this.Squares.size()));
            if (isoGridSquare.isFree(true)) {
                return isoGridSquare;
            }
            --n;
        }
        return null;
    }

    public boolean hasLightSwitches() {
        if (!this.lightSwitches.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.def.objects.size(); ++i) {
            if (this.def.objects.get(i).getType() != 7) continue;
            return true;
        }
        return false;
    }

    public void createLights(boolean bl) {
        if (!this.roomLights.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.def.rects.size(); ++i) {
            RoomDef.RoomRect roomRect = this.def.rects.get(i);
            IsoRoomLight isoRoomLight = new IsoRoomLight(this, roomRect.x, roomRect.y, this.def.level, roomRect.w, roomRect.h);
            this.roomLights.add(isoRoomLight);
        }
    }

    public RoomDef getRoomDef() {
        return this.def;
    }

    public ArrayList<IsoLightSwitch> getLightSwitches() {
        return this.lightSwitches;
    }
}

