/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.GameWindow;
import zombie.core.Core;
import zombie.core.ThreadGroups;
import zombie.debug.DebugLog;
import zombie.iso.CellLoader;
import zombie.iso.ChunkSaveWorker;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.objects.IsoTree;
import zombie.network.MPStatistic;

public final class WorldReuserThread {
    public static final WorldReuserThread instance = new WorldReuserThread();
    private final ArrayList<IsoObject> objectsToReuse = new ArrayList();
    private final ArrayList<IsoTree> treesToReuse = new ArrayList();
    public boolean finished;
    private Thread worldReuser;
    private final ConcurrentLinkedQueue<IsoChunk> reuseGridSquares = new ConcurrentLinkedQueue();

    public void run() {
        this.worldReuser = new Thread(ThreadGroups.Workers, () -> {
            while (!this.finished) {
                MPStatistic.getInstance().WorldReuser.Start();
                this.testReuseChunk();
                this.reconcileReuseObjects();
                MPStatistic.getInstance().WorldReuser.End();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
        this.worldReuser.setName("WorldReuser");
        this.worldReuser.setDaemon(true);
        this.worldReuser.setUncaughtExceptionHandler(GameWindow::uncaughtException);
        this.worldReuser.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileReuseObjects() {
        ArrayDeque<IsoObject> arrayDeque;
        ArrayList<IsoObject> arrayList = this.objectsToReuse;
        synchronized (arrayList) {
            if (!this.objectsToReuse.isEmpty()) {
                arrayDeque = CellLoader.isoObjectCache;
                synchronized (arrayDeque) {
                    if (CellLoader.isoObjectCache.size() < 320000) {
                        CellLoader.isoObjectCache.addAll(this.objectsToReuse);
                    }
                }
                this.objectsToReuse.clear();
            }
        }
        arrayList = this.treesToReuse;
        synchronized (arrayList) {
            if (!this.treesToReuse.isEmpty()) {
                arrayDeque = CellLoader.isoTreeCache;
                synchronized (arrayDeque) {
                    if (CellLoader.isoTreeCache.size() < 40000) {
                        CellLoader.isoTreeCache.addAll(this.treesToReuse);
                    }
                }
                this.treesToReuse.clear();
            }
        }
    }

    public void testReuseChunk() {
        IsoChunk isoChunk = this.reuseGridSquares.poll();
        while (isoChunk != null) {
            if (Core.bDebug) {
                if (ChunkSaveWorker.instance.toSaveQueue.contains(isoChunk)) {
                    DebugLog.log("ERROR: reusing chunk that needs to be saved");
                }
                if (IsoChunkMap.chunkStore.contains(isoChunk)) {
                    DebugLog.log("ERROR: reusing chunk in chunkStore");
                }
                if (!isoChunk.refs.isEmpty()) {
                    DebugLog.log("ERROR: reusing chunk with refs");
                }
            }
            if (Core.bDebug) {
                // empty if block
            }
            this.reuseGridSquares(isoChunk);
            if (this.treesToReuse.size() > 1000 || this.objectsToReuse.size() > 5000) {
                this.reconcileReuseObjects();
            }
            isoChunk = this.reuseGridSquares.poll();
        }
    }

    public void addReuseChunk(IsoChunk isoChunk) {
        this.reuseGridSquares.add(isoChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reuseGridSquares(IsoChunk isoChunk) {
        int n = 100;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < n; ++j) {
                IsoGridSquare isoGridSquare = isoChunk.squares[i][j];
                if (isoGridSquare == null) continue;
                for (int k = 0; k < isoGridSquare.getObjects().size(); ++k) {
                    ArrayList<IsoObject> arrayList;
                    IsoObject isoObject = isoGridSquare.getObjects().get(k);
                    if (isoObject instanceof IsoTree) {
                        isoObject.reset();
                        arrayList = this.treesToReuse;
                        synchronized (arrayList) {
                            this.treesToReuse.add((IsoTree)isoObject);
                            continue;
                        }
                    }
                    if (isoObject.getClass() == IsoObject.class) {
                        isoObject.reset();
                        arrayList = this.objectsToReuse;
                        synchronized (arrayList) {
                            this.objectsToReuse.add(isoObject);
                            continue;
                        }
                    }
                    isoObject.reuseGridSquare();
                }
                isoGridSquare.discard();
                isoChunk.squares[i][j] = null;
            }
        }
        isoChunk.resetForStore();
        IsoChunkMap.chunkStore.add(isoChunk);
    }
}

