/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoChunk;
import zombie.network.GameClient;
import zombie.network.PacketTypes;

public final class WorldObjectsSyncRequests {
    public final ArrayList<SyncData> requests = new ArrayList();
    public long timeout = 1000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRequest(IsoChunk isoChunk) {
        SyncData syncData = new SyncData();
        syncData.x = isoChunk.wx;
        syncData.y = isoChunk.wy;
        syncData.hashCodeWorldObjects = isoChunk.getHashCodeObjects();
        syncData.reqTime = 0L;
        syncData.reqCount = 0;
        ArrayList<SyncData> arrayList = this.requests;
        synchronized (arrayList) {
            this.requests.add(syncData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequests(UdpConnection udpConnection) {
        if (this.requests.size() == 0) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncWorldObjectsReq.doPacket(byteBufferWriter);
        ByteBuffer byteBuffer = byteBufferWriter.bb;
        int n = byteBuffer.position();
        byteBufferWriter.putShort((short)0);
        int n2 = 0;
        ArrayList<SyncData> arrayList = this.requests;
        synchronized (arrayList) {
            for (int i = 0; i < this.requests.size(); ++i) {
                SyncData syncData = this.requests.get(i);
                if (syncData.reqCount > 2) {
                    this.requests.remove(i);
                    --i;
                    continue;
                }
                if (syncData.reqTime == 0L) {
                    syncData.reqTime = System.currentTimeMillis();
                    ++n2;
                    byteBuffer.putInt(syncData.x);
                    byteBuffer.putInt(syncData.y);
                    byteBuffer.putLong(syncData.hashCodeWorldObjects);
                    ++syncData.reqCount;
                }
                if (System.currentTimeMillis() - syncData.reqTime >= this.timeout) {
                    syncData.reqTime = System.currentTimeMillis();
                    ++n2;
                    byteBuffer.putInt(syncData.x);
                    byteBuffer.putInt(syncData.y);
                    byteBuffer.putLong(syncData.hashCodeWorldObjects);
                    ++syncData.reqCount;
                }
                if (n2 >= 50) break;
            }
        }
        if (n2 == 0) {
            GameClient.connection.cancelPacket();
            return;
        }
        int n3 = byteBuffer.position();
        byteBuffer.position(n);
        byteBuffer.putShort((short)n2);
        byteBuffer.position(n3);
        PacketTypes.PacketType.SyncWorldObjectsReq.send(GameClient.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveIsoSync(int n, int n2) {
        ArrayList<SyncData> arrayList = this.requests;
        synchronized (arrayList) {
            for (int i = 0; i < this.requests.size(); ++i) {
                SyncData syncData = this.requests.get(i);
                if (syncData.x != n || syncData.y != n2) continue;
                this.requests.remove(i);
            }
        }
    }

    private class SyncData {
        int x;
        int y;
        long hashCodeWorldObjects;
        long reqTime;
        int reqCount;

        private SyncData() {
        }
    }
}

