/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.List;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.PlayerCamera;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameServer;

public final class WorldMarkers {
    private static final float CIRCLE_TEXTURE_SCALE = 1.5f;
    public static final WorldMarkers instance = new WorldMarkers();
    private static int NextGridSquareMarkerID = 0;
    private static int NextHomingPointID = 0;
    private final List<GridSquareMarker> gridSquareMarkers = new ArrayList<GridSquareMarker>();
    private final PlayerHomingPointList[] homingPoints = new PlayerHomingPointList[4];
    private final DirectionArrowList[] directionArrows = new DirectionArrowList[4];
    private static final ColorInfo stCol = new ColorInfo();
    private final PlayerScreen playerScreen = new PlayerScreen();
    private Point intersectPoint = new Point(0.0f, 0.0f);
    private Point arrowStart = new Point(0.0f, 0.0f);
    private Point arrowEnd = new Point(0.0f, 0.0f);
    private Line arrowLine = new Line(this.arrowStart, this.arrowEnd);

    private WorldMarkers() {
    }

    public void init() {
        int n;
        if (GameServer.bServer) {
            return;
        }
        for (n = 0; n < this.homingPoints.length; ++n) {
            this.homingPoints[n] = new PlayerHomingPointList();
        }
        for (n = 0; n < this.directionArrows.length; ++n) {
            this.directionArrows[n] = new DirectionArrowList();
        }
    }

    public void reset() {
        int n;
        for (n = 0; n < this.homingPoints.length; ++n) {
            this.homingPoints[n].clear();
        }
        for (n = 0; n < this.directionArrows.length; ++n) {
            this.directionArrows[n].clear();
        }
        this.gridSquareMarkers.clear();
    }

    private int GetDistance(int n, int n2, int n3, int n4) {
        return (int)Math.sqrt(Math.pow(n - n3, 2.0) + Math.pow(n2 - n4, 2.0));
    }

    private float getAngle(int n, int n2, int n3, int n4) {
        float f = (float)Math.toDegrees(Math.atan2(n4 - n2, n3 - n));
        if (f < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    private float angleDegrees(float f) {
        if (f < 0.0f) {
            f += 360.0f;
        }
        if (f > 360.0f) {
            f -= 360.0f;
        }
        return f;
    }

    public PlayerHomingPoint getHomingPoint(int n) {
        for (int i = 0; i < this.homingPoints.length; ++i) {
            for (int j = this.homingPoints[i].size() - 1; j >= 0; ++j) {
                if (((PlayerHomingPoint)this.homingPoints[i].get((int)j)).ID != n) continue;
                return (PlayerHomingPoint)this.homingPoints[i].get(j);
            }
        }
        return null;
    }

    public PlayerHomingPoint addPlayerHomingPoint(IsoPlayer isoPlayer, int n, int n2) {
        return this.addPlayerHomingPoint(isoPlayer, n, n2, "arrow_triangle", 1.0f, 1.0f, 1.0f, 1.0f, true, 20);
    }

    public PlayerHomingPoint addPlayerHomingPoint(IsoPlayer isoPlayer, int n, int n2, float f, float f2, float f3, float f4) {
        return this.addPlayerHomingPoint(isoPlayer, n, n2, "arrow_triangle", f, f2, f3, f4, true, 20);
    }

    public PlayerHomingPoint addPlayerHomingPoint(IsoPlayer isoPlayer, int n, int n2, String string, float f, float f2, float f3, float f4, boolean bl, int n3) {
        if (GameServer.bServer) {
            return null;
        }
        PlayerHomingPoint playerHomingPoint = new PlayerHomingPoint(isoPlayer.PlayerIndex);
        playerHomingPoint.setActive(true);
        playerHomingPoint.setTexture(string);
        playerHomingPoint.setX(n);
        playerHomingPoint.setY(n2);
        playerHomingPoint.setR(f);
        playerHomingPoint.setG(f2);
        playerHomingPoint.setB(f3);
        playerHomingPoint.setA(f4);
        playerHomingPoint.setHomeOnTargetInView(bl);
        playerHomingPoint.setHomeOnTargetDist(n3);
        this.homingPoints[isoPlayer.PlayerIndex].add(playerHomingPoint);
        return playerHomingPoint;
    }

    public boolean removeHomingPoint(PlayerHomingPoint playerHomingPoint) {
        return this.removeHomingPoint(playerHomingPoint.getID());
    }

    public boolean removeHomingPoint(int n) {
        for (int i = 0; i < this.homingPoints.length; ++i) {
            for (int j = this.homingPoints[i].size() - 1; j >= 0; --j) {
                if (((PlayerHomingPoint)this.homingPoints[i].get((int)j)).ID != n) continue;
                ((PlayerHomingPoint)this.homingPoints[i].get(j)).remove();
                this.homingPoints[i].remove(j);
                return true;
            }
        }
        return false;
    }

    public boolean removePlayerHomingPoint(IsoPlayer isoPlayer, PlayerHomingPoint playerHomingPoint) {
        return this.removePlayerHomingPoint(isoPlayer, playerHomingPoint.getID());
    }

    public boolean removePlayerHomingPoint(IsoPlayer isoPlayer, int n) {
        for (int i = this.homingPoints[isoPlayer.PlayerIndex].size() - 1; i >= 0; --i) {
            if (((PlayerHomingPoint)this.homingPoints[isoPlayer.PlayerIndex].get((int)i)).ID != n) continue;
            ((PlayerHomingPoint)this.homingPoints[isoPlayer.PlayerIndex].get(i)).remove();
            this.homingPoints[isoPlayer.PlayerIndex].remove(i);
            return true;
        }
        return false;
    }

    public void removeAllHomingPoints(IsoPlayer isoPlayer) {
        this.homingPoints[isoPlayer.PlayerIndex].clear();
    }

    public DirectionArrow getDirectionArrow(int n) {
        for (int i = 0; i < this.directionArrows.length; ++i) {
            for (int j = this.directionArrows[i].size() - 1; j >= 0; --j) {
                if (((DirectionArrow)this.directionArrows[i].get((int)j)).ID != n) continue;
                return (DirectionArrow)this.directionArrows[i].get(j);
            }
        }
        return null;
    }

    public DirectionArrow addDirectionArrow(IsoPlayer isoPlayer, int n, int n2, int n3, String string, float f, float f2, float f3, float f4) {
        if (GameServer.bServer) {
            return null;
        }
        DirectionArrow directionArrow = new DirectionArrow(isoPlayer.PlayerIndex);
        directionArrow.setActive(true);
        directionArrow.setTexture(string);
        directionArrow.setTexDown("dir_arrow_down");
        directionArrow.setTexStairsUp("dir_arrow_stairs_up");
        directionArrow.setTexStairsDown("dir_arrow_stairs_down");
        directionArrow.setX(n);
        directionArrow.setY(n2);
        directionArrow.setZ(n3);
        directionArrow.setR(f);
        directionArrow.setG(f2);
        directionArrow.setB(f3);
        directionArrow.setA(f4);
        this.directionArrows[isoPlayer.PlayerIndex].add(directionArrow);
        return directionArrow;
    }

    public boolean removeDirectionArrow(DirectionArrow directionArrow) {
        return this.removeDirectionArrow(directionArrow.getID());
    }

    public boolean removeDirectionArrow(int n) {
        for (int i = 0; i < this.directionArrows.length; ++i) {
            for (int j = this.directionArrows[i].size() - 1; j >= 0; --j) {
                if (((DirectionArrow)this.directionArrows[i].get((int)j)).ID != n) continue;
                ((DirectionArrow)this.directionArrows[i].get(j)).remove();
                this.directionArrows[i].remove(j);
                return true;
            }
        }
        return false;
    }

    public boolean removePlayerDirectionArrow(IsoPlayer isoPlayer, DirectionArrow directionArrow) {
        return this.removePlayerDirectionArrow(isoPlayer, directionArrow.getID());
    }

    public boolean removePlayerDirectionArrow(IsoPlayer isoPlayer, int n) {
        for (int i = this.directionArrows[isoPlayer.PlayerIndex].size() - 1; i >= 0; --i) {
            if (((DirectionArrow)this.directionArrows[isoPlayer.PlayerIndex].get((int)i)).ID != n) continue;
            ((DirectionArrow)this.directionArrows[isoPlayer.PlayerIndex].get(i)).remove();
            this.directionArrows[isoPlayer.PlayerIndex].remove(i);
            return true;
        }
        return false;
    }

    public void removeAllDirectionArrows(IsoPlayer isoPlayer) {
        this.directionArrows[isoPlayer.PlayerIndex].clear();
    }

    public void update() {
        if (GameServer.bServer) {
            return;
        }
        this.updateGridSquareMarkers();
        this.updateHomingPoints();
        this.updateDirectionArrows();
    }

    private void updateDirectionArrows() {
        int n = IsoCamera.frameState.playerIndex;
        for (int i = 0; i < this.directionArrows.length; ++i) {
            int n2;
            if (i != n || this.directionArrows[i].size() == 0) continue;
            for (n2 = this.directionArrows[i].size() - 1; n2 >= 0; --n2) {
                if (!((DirectionArrow)this.directionArrows[i].get(n2)).isRemoved()) continue;
                this.directionArrows[i].remove(n2);
            }
            this.playerScreen.update(i);
            for (n2 = 0; n2 < this.directionArrows[i].size(); ++n2) {
                IsoPlayer isoPlayer;
                DirectionArrow directionArrow = (DirectionArrow)this.directionArrows[i].get(n2);
                if (!directionArrow.active || IsoPlayer.players[i] == null || (isoPlayer = IsoPlayer.players[i]).getSquare() == null) continue;
                PlayerCamera playerCamera = IsoCamera.cameras[i];
                float f = Core.getInstance().getZoom(i);
                int n3 = isoPlayer.getSquare().getX();
                int n4 = isoPlayer.getSquare().getY();
                int n5 = isoPlayer.getSquare().getZ();
                int n6 = this.GetDistance(n3, n4, directionArrow.x, directionArrow.y);
                boolean bl = false;
                boolean bl2 = false;
                float f2 = 0.0f;
                float f3 = 0.0f;
                if (n6 < 300) {
                    bl = true;
                    f2 = playerCamera.XToScreenExact(directionArrow.x, directionArrow.y, n5, 0) / f;
                    if (this.playerScreen.isWithinInner(f2, f3 = playerCamera.YToScreenExact(directionArrow.x, directionArrow.y, n5, 0) / f)) {
                        bl2 = true;
                    }
                }
                if (!bl2) {
                    directionArrow.renderWithAngle = true;
                    directionArrow.isDrawOnWorld = false;
                    directionArrow.renderTexture = directionArrow.texture;
                    directionArrow.renderSizeMod = 1.0f;
                    float f4 = this.playerScreen.centerX;
                    float f5 = this.playerScreen.centerY;
                    float f6 = 0.0f;
                    if (!bl) {
                        f6 = this.getAngle(directionArrow.x, directionArrow.y, n3, n4);
                        f6 = this.angleDegrees(180.0f - f6);
                        f6 = this.angleDegrees(f6 + 45.0f);
                    } else {
                        f6 = this.getAngle((int)f4, (int)f5, (int)f2, (int)f3);
                        f6 = this.angleDegrees(180.0f - f6);
                        f6 = this.angleDegrees(f6 - 90.0f);
                    }
                    if (f6 != directionArrow.angle) {
                        if (!directionArrow.lastWasWithinView) {
                            directionArrow.angle = PZMath.lerpAngle(PZMath.degToRad(directionArrow.angle), PZMath.degToRad(f6), directionArrow.angleLerpVal * GameTime.instance.getMultiplier());
                            directionArrow.angle = PZMath.radToDeg(directionArrow.angle);
                        } else {
                            directionArrow.angle = f6;
                        }
                    }
                    float f7 = f4 + 32000.0f * (float)Math.sin(Math.toRadians(directionArrow.angle));
                    float f8 = f5 + 32000.0f * (float)Math.cos(Math.toRadians(directionArrow.angle));
                    directionArrow.renderScreenX = f4;
                    directionArrow.renderScreenY = f5;
                    this.arrowStart.set(f4, f5);
                    this.arrowEnd.set(f7, f8);
                    Line[] lineArray = this.playerScreen.getBorders();
                    for (int j = 0; j < lineArray.length; ++j) {
                        this.intersectPoint.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
                        if (!WorldMarkers.intersectLineSegments(this.arrowLine, lineArray[j], this.intersectPoint)) continue;
                        directionArrow.renderScreenX = this.intersectPoint.x;
                        directionArrow.renderScreenY = this.intersectPoint.y;
                        break;
                    }
                    directionArrow.lastWasWithinView = false;
                    continue;
                }
                directionArrow.renderWithAngle = false;
                directionArrow.isDrawOnWorld = false;
                directionArrow.renderSizeMod = 1.0f;
                if (f > 1.0f) {
                    directionArrow.renderSizeMod /= f;
                }
                directionArrow.renderScreenX = f2;
                directionArrow.renderScreenY = f3;
                directionArrow.renderTexture = n5 == directionArrow.z ? (directionArrow.texDown != null ? directionArrow.texDown : directionArrow.texture) : (directionArrow.z > n5 ? (directionArrow.texStairsUp != null ? directionArrow.texStairsUp : directionArrow.texture) : (directionArrow.texStairsDown != null ? directionArrow.texStairsUp : directionArrow.texture));
                directionArrow.lastWasWithinView = true;
            }
        }
    }

    private void updateHomingPoints() {
        int n = IsoCamera.frameState.playerIndex;
        for (int i = 0; i < this.homingPoints.length; ++i) {
            int n2;
            if (i != n || this.homingPoints[i].size() == 0) continue;
            for (n2 = this.homingPoints[i].size() - 1; n2 >= 0; --n2) {
                if (!((PlayerHomingPoint)this.homingPoints[i].get((int)n2)).isRemoved) continue;
                this.homingPoints[i].remove(n2);
            }
            this.playerScreen.update(i);
            for (n2 = 0; n2 < this.homingPoints[i].size(); ++n2) {
                float f;
                IsoPlayer isoPlayer;
                PlayerHomingPoint playerHomingPoint = (PlayerHomingPoint)this.homingPoints[i].get(n2);
                if (!playerHomingPoint.active || IsoPlayer.players[i] == null || (isoPlayer = IsoPlayer.players[i]).getSquare() == null) continue;
                PlayerCamera playerCamera = IsoCamera.cameras[i];
                float f2 = Core.getInstance().getZoom(i);
                playerHomingPoint.renderSizeMod = 1.0f;
                if (f2 > 1.0f) {
                    playerHomingPoint.renderSizeMod /= f2;
                }
                int n3 = isoPlayer.getSquare().getX();
                int n4 = isoPlayer.getSquare().getY();
                playerHomingPoint.dist = this.GetDistance(n3, n4, playerHomingPoint.x, playerHomingPoint.y);
                playerHomingPoint.targetOnScreen = false;
                if ((float)playerHomingPoint.dist < 200.0f) {
                    playerHomingPoint.targetScreenX = playerCamera.XToScreenExact(playerHomingPoint.x, playerHomingPoint.y, 0.0f, 0) / f2;
                    playerHomingPoint.targetScreenY = playerCamera.YToScreenExact(playerHomingPoint.x, playerHomingPoint.y, 0.0f, 0) / f2;
                    playerHomingPoint.targetScreenX += playerHomingPoint.homeOnOffsetX / f2;
                    playerHomingPoint.targetScreenY += playerHomingPoint.homeOnOffsetY / f2;
                    playerHomingPoint.targetOnScreen = this.playerScreen.isOnScreen(playerHomingPoint.targetScreenX, playerHomingPoint.targetScreenY);
                }
                float f3 = this.playerScreen.centerX;
                float f4 = f3 + playerHomingPoint.renderOffsetX / f2;
                float f5 = this.playerScreen.centerY;
                float f6 = f5 + playerHomingPoint.renderOffsetY / f2;
                if (!playerHomingPoint.customTargetAngle) {
                    f = 0.0f;
                    if (!playerHomingPoint.targetOnScreen) {
                        f = this.getAngle(playerHomingPoint.x, playerHomingPoint.y, n3, n4);
                        f = this.angleDegrees(180.0f - f);
                        f = this.angleDegrees(f + 45.0f);
                    } else {
                        f = this.getAngle((int)f4, (int)f6, (int)playerHomingPoint.targetScreenX, (int)playerHomingPoint.targetScreenY);
                        f = this.angleDegrees(180.0f - f);
                        f = this.angleDegrees(f - 90.0f);
                    }
                    playerHomingPoint.targetAngle = f;
                }
                if (playerHomingPoint.targetAngle != playerHomingPoint.angle) {
                    playerHomingPoint.angle = PZMath.lerpAngle(PZMath.degToRad(playerHomingPoint.angle), PZMath.degToRad(playerHomingPoint.targetAngle), playerHomingPoint.angleLerpVal * GameTime.instance.getMultiplier());
                    playerHomingPoint.angle = PZMath.radToDeg(playerHomingPoint.angle);
                }
                f = playerHomingPoint.stickToCharDist / f2;
                playerHomingPoint.targRenderX = f4 + f * (float)Math.sin(Math.toRadians(playerHomingPoint.angle));
                playerHomingPoint.targRenderY = f6 + f * (float)Math.cos(Math.toRadians(playerHomingPoint.angle));
                float f7 = playerHomingPoint.movementLerpVal;
                if (playerHomingPoint.targetOnScreen) {
                    float f8 = this.GetDistance((int)playerHomingPoint.targRenderX, (int)playerHomingPoint.targRenderY, (int)playerHomingPoint.targetScreenX, (int)playerHomingPoint.targetScreenY);
                    float f9 = this.GetDistance((int)f4, (int)f6, (int)playerHomingPoint.targetScreenX, (int)playerHomingPoint.targetScreenY);
                    if (f9 < f8 || playerHomingPoint.homeOnTargetInView && playerHomingPoint.dist <= playerHomingPoint.homeOnTargetDist) {
                        playerHomingPoint.targRenderX = f4 + (f9 *= 0.75f) * (float)Math.sin(Math.toRadians(playerHomingPoint.targetAngle));
                        playerHomingPoint.targRenderY = f6 + f9 * (float)Math.cos(Math.toRadians(playerHomingPoint.targetAngle));
                    }
                }
                playerHomingPoint.targRenderX = this.playerScreen.clampToInnerX(playerHomingPoint.targRenderX);
                playerHomingPoint.targRenderY = this.playerScreen.clampToInnerY(playerHomingPoint.targRenderY);
                if (playerHomingPoint.targRenderX != playerHomingPoint.renderX) {
                    playerHomingPoint.renderX = PZMath.lerp(playerHomingPoint.renderX, playerHomingPoint.targRenderX, f7 * GameTime.instance.getMultiplier());
                }
                if (playerHomingPoint.targRenderY == playerHomingPoint.renderY) continue;
                playerHomingPoint.renderY = PZMath.lerp(playerHomingPoint.renderY, playerHomingPoint.targRenderY, f7 * GameTime.instance.getMultiplier());
            }
        }
    }

    private void updateGridSquareMarkers() {
        int n;
        if (IsoCamera.frameState.playerIndex != 0) {
            return;
        }
        if (this.gridSquareMarkers.size() == 0) {
            return;
        }
        for (n = this.gridSquareMarkers.size() - 1; n >= 0; --n) {
            if (!this.gridSquareMarkers.get(n).isRemoved()) continue;
            this.gridSquareMarkers.remove(n);
        }
        for (n = 0; n < this.gridSquareMarkers.size(); ++n) {
            GridSquareMarker gridSquareMarker = this.gridSquareMarkers.get(n);
            if (gridSquareMarker.alphaInc) {
                gridSquareMarker.alpha += GameTime.getInstance().getMultiplier() * gridSquareMarker.fadeSpeed;
                if (!(gridSquareMarker.alpha > gridSquareMarker.alphaMax)) continue;
                gridSquareMarker.alphaInc = false;
                gridSquareMarker.alpha = gridSquareMarker.alphaMax;
                continue;
            }
            gridSquareMarker.alpha -= GameTime.getInstance().getMultiplier() * gridSquareMarker.fadeSpeed;
            if (!(gridSquareMarker.alpha < gridSquareMarker.alphaMin)) continue;
            gridSquareMarker.alphaInc = true;
            gridSquareMarker.alpha = 0.3f;
        }
    }

    public boolean removeGridSquareMarker(GridSquareMarker gridSquareMarker) {
        return this.removeGridSquareMarker(gridSquareMarker.getID());
    }

    public boolean removeGridSquareMarker(int n) {
        for (int i = this.gridSquareMarkers.size() - 1; i >= 0; --i) {
            if (this.gridSquareMarkers.get(i).getID() != n) continue;
            this.gridSquareMarkers.get(i).remove();
            this.gridSquareMarkers.remove(i);
            return true;
        }
        return false;
    }

    public GridSquareMarker getGridSquareMarker(int n) {
        for (int i = 0; i < this.gridSquareMarkers.size(); ++i) {
            if (this.gridSquareMarkers.get(i).getID() != n) continue;
            return this.gridSquareMarkers.get(i);
        }
        return null;
    }

    public GridSquareMarker addGridSquareMarker(IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl, float f4) {
        return this.addGridSquareMarker("circle_center", "circle_only_highlight", isoGridSquare, f, f2, f3, bl, f4, 0.006f, 0.3f, 1.0f);
    }

    public GridSquareMarker addGridSquareMarker(String string, String string2, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl, float f4) {
        return this.addGridSquareMarker(string, string2, isoGridSquare, f, f2, f3, bl, f4, 0.006f, 0.3f, 1.0f);
    }

    public GridSquareMarker addGridSquareMarker(String string, String string2, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl, float f4, float f5, float f6, float f7) {
        if (GameServer.bServer) {
            return null;
        }
        GridSquareMarker gridSquareMarker = new GridSquareMarker();
        gridSquareMarker.init(string, string2, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, f4);
        gridSquareMarker.setR(f);
        gridSquareMarker.setG(f2);
        gridSquareMarker.setB(f3);
        gridSquareMarker.setA(1.0f);
        gridSquareMarker.setDoAlpha(bl);
        gridSquareMarker.setFadeSpeed(f5);
        gridSquareMarker.setAlpha(0.0f);
        gridSquareMarker.setAlphaMin(f6);
        gridSquareMarker.setAlphaMax(f7);
        this.gridSquareMarkers.add(gridSquareMarker);
        return gridSquareMarker;
    }

    public void renderGridSquareMarkers(IsoCell.PerPlayerRender perPlayerRender, int n, int n2) {
        if (GameServer.bServer || this.gridSquareMarkers.size() == 0) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n2];
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < this.gridSquareMarkers.size(); ++i) {
            GridSquareMarker gridSquareMarker = this.gridSquareMarkers.get(i);
            if (gridSquareMarker.z != (float)n || gridSquareMarker.z != isoPlayer.getZ() || !gridSquareMarker.active) continue;
            float f = 0.0f;
            float f2 = 0.0f;
            stCol.set(gridSquareMarker.r, gridSquareMarker.g, gridSquareMarker.b, gridSquareMarker.a);
            gridSquareMarker.sprite.alpha = gridSquareMarker.doBlink ? Core.blinkAlpha : (gridSquareMarker.doAlpha ? gridSquareMarker.alpha : 1.0f);
            gridSquareMarker.sprite.render(null, gridSquareMarker.x, gridSquareMarker.y, gridSquareMarker.z, IsoDirections.N, f, f2, stCol);
            if (gridSquareMarker.spriteOverlay == null) continue;
            gridSquareMarker.spriteOverlay.alpha = 1.0f;
            gridSquareMarker.spriteOverlay.render(null, gridSquareMarker.x, gridSquareMarker.y, gridSquareMarker.z, IsoDirections.N, f, f2, stCol);
        }
    }

    public void debugRender() {
    }

    public void render() {
        this.update();
        this.renderHomingPoint();
        this.renderDirectionArrow(false);
    }

    public void renderHomingPoint() {
        if (GameServer.bServer) {
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        for (int i = 0; i < this.homingPoints.length; ++i) {
            if (i != n || this.homingPoints[i].size() == 0) continue;
            for (int j = 0; j < this.homingPoints[i].size(); ++j) {
                PlayerHomingPoint playerHomingPoint = (PlayerHomingPoint)this.homingPoints[i].get(j);
                if (!playerHomingPoint.active || playerHomingPoint.texture == null) continue;
                float f = 180.0f - playerHomingPoint.angle;
                if (f < 0.0f) {
                    f += 360.0f;
                }
                float f2 = playerHomingPoint.a;
                if (ClimateManager.getInstance().getFogIntensity() > 0.0f && f2 < 1.0f) {
                    float f3 = 1.0f - f2;
                    f2 += f3 * ClimateManager.getInstance().getFogIntensity() * 2.0f;
                    f2 = PZMath.clamp_01(f2);
                }
                this.DrawTextureAngle(playerHomingPoint.texture, playerHomingPoint.renderWidth, playerHomingPoint.renderHeight, playerHomingPoint.renderX, playerHomingPoint.renderY, f, playerHomingPoint.r, playerHomingPoint.g, playerHomingPoint.b, f2, playerHomingPoint.renderSizeMod);
            }
        }
    }

    public void renderDirectionArrow(boolean bl) {
        if (GameServer.bServer) {
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        for (int i = 0; i < this.directionArrows.length; ++i) {
            if (i != n || this.directionArrows[i].size() == 0) continue;
            for (int j = 0; j < this.directionArrows[i].size(); ++j) {
                DirectionArrow directionArrow = (DirectionArrow)this.directionArrows[i].get(j);
                if (!directionArrow.active || directionArrow.renderTexture == null || directionArrow.isDrawOnWorld != bl) continue;
                float f = 0.0f;
                if (directionArrow.renderWithAngle && (f = 180.0f - directionArrow.angle) < 0.0f) {
                    f += 360.0f;
                }
                this.DrawTextureAngle(directionArrow.renderTexture, directionArrow.renderWidth, directionArrow.renderHeight, directionArrow.renderScreenX, directionArrow.renderScreenY, f, directionArrow.r, directionArrow.g, directionArrow.b, directionArrow.a, directionArrow.renderSizeMod);
            }
        }
    }

    private void DrawTextureAngle(Texture texture, float f, float f2, double d, double d2, double d3, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f * f7 / 2.0f;
        float f9 = f2 * f7 / 2.0f;
        double d4 = Math.toRadians(180.0 + d3);
        double d5 = Math.cos(d4) * (double)f8;
        double d6 = Math.sin(d4) * (double)f8;
        double d7 = Math.cos(d4) * (double)f9;
        double d8 = Math.sin(d4) * (double)f9;
        double d9 = d5 - d8;
        double d10 = d7 + d6;
        double d11 = -d5 - d8;
        double d12 = d7 - d6;
        double d13 = -d5 + d8;
        double d14 = -d7 - d6;
        double d15 = d5 + d8;
        double d16 = -d7 + d6;
        SpriteRenderer.instance.render(texture, d9 += d, d10 += d2, d11 += d, d12 += d2, d13 += d, d14 += d2, d15 += d, d16 += d2, f3, f4, f5, f6, f3, f4, f5, f6, f3, f4, f5, f6, f3, f4, f5, f6, null);
    }

    public static boolean intersectLineSegments(Line line, Line line2, Point point) {
        float f = line2.e.y;
        float f2 = line2.s.y;
        float f3 = line.e.x;
        float f4 = line.s.x;
        float f5 = line2.e.x;
        float f6 = line2.s.x;
        float f7 = line.e.y;
        float f8 = line.s.y;
        float f9 = (f - f2) * (f3 - f4) - (f5 - f6) * (f7 - f8);
        if (f9 == 0.0f) {
            return false;
        }
        float f10 = f8 - f2;
        float f11 = f4 - f6;
        float f12 = ((f5 - f6) * f10 - (f - f2) * f11) / f9;
        if (f12 < 0.0f || f12 > 1.0f) {
            return false;
        }
        float f13 = ((f3 - f4) * f10 - (f7 - f8) * f11) / f9;
        if (f13 < 0.0f || f13 > 1.0f) {
            return false;
        }
        if (point != null) {
            point.set(f4 + (f3 - f4) * f12, f8 + (f7 - f8) * f12);
        }
        return true;
    }

    public class DirectionArrow {
        public static final boolean doDebug = false;
        private DebugStuff debugStuff;
        private int ID;
        private boolean active = true;
        private boolean isRemoved = false;
        private boolean isDrawOnWorld = false;
        private Texture renderTexture;
        private Texture texture;
        private Texture texStairsUp;
        private Texture texStairsDown;
        private Texture texDown;
        private int x;
        private int y;
        private int z;
        private float r;
        private float g;
        private float b;
        private float a;
        private float renderWidth = 32.0f;
        private float renderHeight = 32.0f;
        private float angle;
        private float angleLerpVal = 0.25f;
        private boolean lastWasWithinView = true;
        private float renderScreenX;
        private float renderScreenY;
        private boolean renderWithAngle = true;
        private float renderSizeMod = 1.0f;

        public DirectionArrow(int n) {
            if (Core.bDebug) {
                // empty if block
            }
            this.ID = NextHomingPointID++;
        }

        public void setTexture(String string) {
            if (string == null) {
                string = "dir_arrow_up";
            }
            this.texture = Texture.getSharedTexture("media/textures/highlights/" + string + ".png");
        }

        public void setTexDown(String string) {
            this.texDown = Texture.getSharedTexture("media/textures/highlights/" + string + ".png");
        }

        public void setTexStairsDown(String string) {
            this.texStairsDown = Texture.getSharedTexture("media/textures/highlights/" + string + ".png");
        }

        public void setTexStairsUp(String string) {
            this.texStairsUp = Texture.getSharedTexture("media/textures/highlights/" + string + ".png");
        }

        public void remove() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public float getR() {
            return this.r;
        }

        public void setR(float f) {
            this.r = f;
        }

        public float getB() {
            return this.b;
        }

        public void setB(float f) {
            this.b = f;
        }

        public float getG() {
            return this.g;
        }

        public void setG(float f) {
            this.g = f;
        }

        public float getA() {
            return this.a;
        }

        public void setA(float f) {
            this.a = f;
        }

        public void setRGBA(float f, float f2, float f3, float f4) {
            this.r = f;
            this.g = f2;
            this.b = f3;
            this.a = f4;
        }

        public int getID() {
            return this.ID;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }

        public int getZ() {
            return this.z;
        }

        public void setZ(int n) {
            this.z = n;
        }

        public float getRenderWidth() {
            return this.renderWidth;
        }

        public void setRenderWidth(float f) {
            this.renderWidth = f;
        }

        public float getRenderHeight() {
            return this.renderHeight;
        }

        public void setRenderHeight(float f) {
            this.renderHeight = f;
        }

        private class DebugStuff {
            private float centerX;
            private float centerY;
            private float endX;
            private float endY;

            private DebugStuff() {
            }
        }
    }

    class PlayerHomingPointList
    extends ArrayList<PlayerHomingPoint> {
        PlayerHomingPointList() {
        }
    }

    class DirectionArrowList
    extends ArrayList<DirectionArrow> {
        DirectionArrowList() {
        }
    }

    class PlayerScreen {
        private float centerX;
        private float centerY;
        private float x;
        private float y;
        private float width;
        private float height;
        private float padTop = 100.0f;
        private float padLeft = 100.0f;
        private float padBot = 100.0f;
        private float padRight = 100.0f;
        private float innerX;
        private float innerY;
        private float innerX2;
        private float innerY2;
        private Line borderTop = new Line(new Point(0.0f, 0.0f), new Point(0.0f, 0.0f));
        private Line borderRight = new Line(new Point(0.0f, 0.0f), new Point(0.0f, 0.0f));
        private Line borderBot = new Line(new Point(0.0f, 0.0f), new Point(0.0f, 0.0f));
        private Line borderLeft = new Line(new Point(0.0f, 0.0f), new Point(0.0f, 0.0f));
        private Line[] borders = new Line[4];

        PlayerScreen() {
        }

        private void update(int n) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.width = IsoCamera.getScreenWidth(n);
            this.height = IsoCamera.getScreenHeight(n);
            this.centerX = this.x + this.width / 2.0f;
            this.centerY = this.y + this.height / 2.0f;
            this.innerX = this.x + this.padLeft;
            this.innerY = this.y + this.padTop;
            float f = this.width - (this.padLeft + this.padRight);
            float f2 = this.height - (this.padTop + this.padBot);
            this.innerX2 = this.innerX + f;
            this.innerY2 = this.innerY + f2;
        }

        private Line[] getBorders() {
            this.borders[0] = this.getBorderTop();
            this.borders[1] = this.getBorderRight();
            this.borders[2] = this.getBorderBot();
            this.borders[3] = this.getBorderLeft();
            return this.borders;
        }

        private Line getBorderTop() {
            this.borderTop.s.set(this.innerX, this.innerY);
            this.borderTop.e.set(this.innerX2, this.innerY);
            return this.borderTop;
        }

        private Line getBorderRight() {
            this.borderRight.s.set(this.innerX2, this.innerY);
            this.borderRight.e.set(this.innerX2, this.innerY2);
            return this.borderRight;
        }

        private Line getBorderBot() {
            this.borderBot.s.set(this.innerX, this.innerY2);
            this.borderBot.e.set(this.innerX2, this.innerY2);
            return this.borderBot;
        }

        private Line getBorderLeft() {
            this.borderLeft.s.set(this.innerX, this.innerY);
            this.borderLeft.e.set(this.innerX, this.innerY2);
            return this.borderLeft;
        }

        private float clampToInnerX(float f) {
            return PZMath.clamp(f, this.innerX, this.innerX2);
        }

        private float clampToInnerY(float f) {
            return PZMath.clamp(f, this.innerY, this.innerY2);
        }

        private boolean isOnScreen(float f, float f2) {
            return f >= this.x && f < this.x + this.width && f2 >= this.y && f2 < this.y + this.height;
        }

        private boolean isWithinInner(float f, float f2) {
            return f >= this.innerX && f < this.innerX2 && f2 >= this.innerY && f2 < this.innerY2;
        }
    }

    private static class Point {
        float x;
        float y;

        Point(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public Point set(float f, float f2) {
            this.x = f;
            this.y = f2;
            return this;
        }

        public boolean notInfinite() {
            return !Float.isInfinite(this.x) && !Float.isInfinite(this.y);
        }

        public String toString() {
            return String.format("{%f, %f}", Float.valueOf(this.x), Float.valueOf(this.y));
        }
    }

    private static class Line {
        Point s;
        Point e;

        Line(Point point, Point point2) {
            this.s = point;
            this.e = point2;
        }

        public String toString() {
            return String.format("{s: %s, e: %s}", this.s.toString(), this.e.toString());
        }
    }

    public static class PlayerHomingPoint {
        private int ID;
        private Texture texture;
        private int x;
        private int y;
        private float r;
        private float g;
        private float b;
        private float a;
        private float angle = 0.0f;
        private float targetAngle = 0.0f;
        private boolean customTargetAngle = false;
        private float angleLerpVal = 0.25f;
        private float movementLerpVal = 0.25f;
        private int dist = 0;
        private float targRenderX = (float)Core.getInstance().getScreenWidth() / 2.0f;
        private float targRenderY = (float)Core.getInstance().getScreenHeight() / 2.0f;
        private float renderX = this.targRenderX;
        private float renderY = this.targRenderY;
        private float renderOffsetX = 0.0f;
        private float renderOffsetY = 50.0f;
        private float renderWidth = 32.0f;
        private float renderHeight = 32.0f;
        private float renderSizeMod = 1.0f;
        private float targetScreenX;
        private float targetScreenY;
        private boolean targetOnScreen = false;
        private float stickToCharDist = 130.0f;
        private boolean active;
        private boolean homeOnTargetInView = true;
        private int homeOnTargetDist = 20;
        private float homeOnOffsetX = 0.0f;
        private float homeOnOffsetY = 0.0f;
        private boolean isRemoved = false;

        public PlayerHomingPoint(int n) {
            this.ID = NextHomingPointID++;
            float f = IsoCamera.getScreenLeft(n);
            float f2 = IsoCamera.getScreenTop(n);
            float f3 = IsoCamera.getScreenWidth(n);
            float f4 = IsoCamera.getScreenHeight(n);
            this.targRenderX = f + f3 / 2.0f;
            this.targRenderY = f2 + f4 / 2.0f;
        }

        public void setTexture(String string) {
            if (string == null) {
                string = "arrow_triangle";
            }
            this.texture = Texture.getSharedTexture("media/textures/highlights/" + string + ".png");
        }

        public void remove() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public float getR() {
            return this.r;
        }

        public void setR(float f) {
            this.r = f;
        }

        public float getB() {
            return this.b;
        }

        public void setB(float f) {
            this.b = f;
        }

        public float getG() {
            return this.g;
        }

        public void setG(float f) {
            this.g = f;
        }

        public float getA() {
            return this.a;
        }

        public void setA(float f) {
            this.a = f;
        }

        public int getHomeOnTargetDist() {
            return this.homeOnTargetDist;
        }

        public void setHomeOnTargetDist(int n) {
            this.homeOnTargetDist = n;
        }

        public int getID() {
            return this.ID;
        }

        public float getTargetAngle() {
            return this.targetAngle;
        }

        public void setTargetAngle(float f) {
            this.targetAngle = f;
        }

        public boolean isCustomTargetAngle() {
            return this.customTargetAngle;
        }

        public void setCustomTargetAngle(boolean bl) {
            this.customTargetAngle = bl;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }

        public float getAngleLerpVal() {
            return this.angleLerpVal;
        }

        public void setAngleLerpVal(float f) {
            this.angleLerpVal = f;
        }

        public float getMovementLerpVal() {
            return this.movementLerpVal;
        }

        public void setMovementLerpVal(float f) {
            this.movementLerpVal = f;
        }

        public boolean isHomeOnTargetInView() {
            return this.homeOnTargetInView;
        }

        public void setHomeOnTargetInView(boolean bl) {
            this.homeOnTargetInView = bl;
        }

        public float getRenderWidth() {
            return this.renderWidth;
        }

        public void setRenderWidth(float f) {
            this.renderWidth = f;
        }

        public float getRenderHeight() {
            return this.renderHeight;
        }

        public void setRenderHeight(float f) {
            this.renderHeight = f;
        }

        public float getStickToCharDist() {
            return this.stickToCharDist;
        }

        public void setStickToCharDist(float f) {
            this.stickToCharDist = f;
        }

        public float getRenderOffsetX() {
            return this.renderOffsetX;
        }

        public void setRenderOffsetX(float f) {
            this.renderOffsetX = f;
        }

        public float getRenderOffsetY() {
            return this.renderOffsetY;
        }

        public void setRenderOffsetY(float f) {
            this.renderOffsetY = f;
        }

        public float getHomeOnOffsetX() {
            return this.homeOnOffsetX;
        }

        public void setHomeOnOffsetX(float f) {
            this.homeOnOffsetX = f;
        }

        public float getHomeOnOffsetY() {
            return this.homeOnOffsetY;
        }

        public void setHomeOnOffsetY(float f) {
            this.homeOnOffsetY = f;
        }

        public void setTableSurface() {
            this.homeOnOffsetY = -30.0f * (float)Core.TileScale;
        }

        public void setHighCounter() {
            this.homeOnOffsetY = -50.0f * (float)Core.TileScale;
        }

        public void setYOffsetScaled(float f) {
            this.homeOnOffsetY = f * (float)Core.TileScale;
        }

        public void setXOffsetScaled(float f) {
            this.homeOnOffsetX = f * (float)Core.TileScale;
        }
    }

    public static final class GridSquareMarker {
        private int ID = NextGridSquareMarkerID++;
        private IsoSpriteInstance sprite;
        private IsoSpriteInstance spriteOverlay;
        private float orig_x;
        private float orig_y;
        private float orig_z;
        private float x;
        private float y;
        private float z;
        private float scaleRatio;
        private float r;
        private float g;
        private float b;
        private float a;
        private float size;
        private boolean doBlink = false;
        private boolean doAlpha;
        private boolean bScaleCircleTexture = false;
        private float fadeSpeed = 0.006f;
        private float alpha = 0.0f;
        private float alphaMax = 1.0f;
        private float alphaMin = 0.3f;
        private boolean alphaInc = true;
        private boolean active = true;
        private boolean isRemoved = false;

        public int getID() {
            return this.ID;
        }

        public void remove() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        public void init(String string, String string2, int n, int n2, int n3, float f) {
            if (string == null) {
                string = "circle_center";
            }
            Texture texture = Texture.getSharedTexture("media/textures/highlights/" + string + ".png");
            float f2 = texture.getWidth();
            float f3 = 64.0f * (float)Core.TileScale;
            this.scaleRatio = 1.0f / (f2 / f3);
            this.sprite = new IsoSpriteInstance(IsoSpriteManager.instance.getSprite("media/textures/highlights/" + string + ".png"));
            if (string2 != null) {
                this.spriteOverlay = new IsoSpriteInstance(IsoSpriteManager.instance.getSprite("media/textures/highlights/" + string2 + ".png"));
            }
            this.setPosAndSize(n, n2, n3, f);
        }

        public void setPosAndSize(int n, int n2, int n3, float f) {
            float f2 = f * (this.bScaleCircleTexture ? 1.5f : 1.0f);
            float f3 = this.scaleRatio * f2;
            this.sprite.setScale(f3, f3);
            if (this.spriteOverlay != null) {
                this.spriteOverlay.setScale(f3, f3);
            }
            this.size = f;
            this.orig_x = n;
            this.orig_y = n2;
            this.orig_z = n3;
            this.x = (float)n - (f2 - 0.5f);
            this.y = (float)n2 + 0.5f;
            this.z = n3;
        }

        public void setPos(int n, int n2, int n3) {
            float f = this.size * (this.bScaleCircleTexture ? 1.5f : 1.0f);
            this.orig_x = n;
            this.orig_y = n2;
            this.orig_z = n3;
            this.x = (float)n - (f - 0.5f);
            this.y = (float)n2 + 0.5f;
            this.z = n3;
        }

        public void setSize(float f) {
            float f2 = f * (this.bScaleCircleTexture ? 1.5f : 1.0f);
            float f3 = this.scaleRatio * f2;
            this.sprite.setScale(f3, f3);
            if (this.spriteOverlay != null) {
                this.spriteOverlay.setScale(f3, f3);
            }
            this.size = f;
            this.x = this.orig_x - (f2 - 0.5f);
            this.y = this.orig_y + 0.5f;
            this.z = this.orig_z;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public float getSize() {
            return this.size;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float getR() {
            return this.r;
        }

        public void setR(float f) {
            this.r = f;
        }

        public float getG() {
            return this.g;
        }

        public void setG(float f) {
            this.g = f;
        }

        public float getB() {
            return this.b;
        }

        public void setB(float f) {
            this.b = f;
        }

        public float getA() {
            return this.a;
        }

        public void setA(float f) {
            this.a = f;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public float getAlphaMax() {
            return this.alphaMax;
        }

        public void setAlphaMax(float f) {
            this.alphaMax = f;
        }

        public float getAlphaMin() {
            return this.alphaMin;
        }

        public void setAlphaMin(float f) {
            this.alphaMin = f;
        }

        public boolean isDoAlpha() {
            return this.doAlpha;
        }

        public void setDoAlpha(boolean bl) {
            this.doAlpha = bl;
        }

        public float getFadeSpeed() {
            return this.fadeSpeed;
        }

        public void setFadeSpeed(float f) {
            this.fadeSpeed = f;
        }

        public boolean isDoBlink() {
            return this.doBlink;
        }

        public void setDoBlink(boolean bl) {
            this.doBlink = bl;
        }

        public boolean isScaleCircleTexture() {
            return this.bScaleCircleTexture;
        }

        public void setScaleCircleTexture(boolean bl) {
            this.bScaleCircleTexture = bl;
            float f = this.size * (this.bScaleCircleTexture ? 1.5f : 1.0f);
            float f2 = this.scaleRatio * f;
            if (this.sprite != null) {
                this.sprite.setScale(f2, f2);
            }
            if (this.spriteOverlay != null) {
                this.spriteOverlay.setScale(f2, f2);
            }
            this.x = this.orig_x - (f - 0.5f);
        }
    }
}

