/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import zombie.Lua.LuaEventManager;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.erosion.ErosionRegions;
import zombie.erosion.season.ErosionIceQueen;
import zombie.gameStates.GameLoadingState;
import zombie.gameStates.IngameState;
import zombie.globalObjects.GlobalObjectLookup;
import zombie.iso.ChunkSaveWorker;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoWorld;
import zombie.iso.WorldStreamer;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.CoopSlave;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.vehicles.VehicleManager;
import zombie.world.WorldDictionary;
import zombie.world.WorldDictionaryException;

public final class WorldConverter {
    public static final WorldConverter instance = new WorldConverter();
    public static boolean converting;
    public HashMap<Integer, Integer> TilesetConversions = null;
    int oldID = 0;

    public void convert(String string, IsoSpriteManager isoSpriteManager) throws IOException {
        File file = new File(ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + string + File.separator + "map_ver.bin");
        if (file.exists()) {
            converting = true;
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n = dataInputStream.readInt();
            dataInputStream.close();
            if (n < 195) {
                if (n < 24) {
                    GameLoadingState.build23Stop = true;
                    return;
                }
                try {
                    this.convert(string, n, 195);
                }
                catch (Exception exception) {
                    IngameState.createWorld(string);
                    IngameState.copyWorld(string + "_backup", string);
                    exception.printStackTrace();
                }
            }
            converting = false;
        }
    }

    private void convert(String string, int n, int n2) {
        if (GameClient.bClient) {
            return;
        }
        GameLoadingState.convertingWorld = true;
        String string2 = Core.GameSaveWorld;
        IngameState.createWorld(string + "_backup");
        IngameState.copyWorld(string, Core.GameSaveWorld);
        Core.GameSaveWorld = string2;
        if (n2 >= 14 && n < 14) {
            try {
                this.convertchunks(string, 25, 25);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (n == 7) {
            try {
                this.convertchunks(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (n <= 4) {
            this.loadconversionmap(n, "tiledefinitions");
            this.loadconversionmap(n, "newtiledefinitions");
            try {
                this.convertchunks(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        GameLoadingState.convertingWorld = false;
    }

    private void convertchunks(String string) throws IOException {
        String[] stringArray;
        IsoCell isoCell = new IsoCell(300, 300);
        IsoChunkMap isoChunkMap = new IsoChunkMap(isoCell);
        File file = new File(ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + string + File.separator);
        if (!file.exists()) {
            file.mkdir();
        }
        for (String string2 : stringArray = file.list()) {
            if (!string2.contains(".bin") || string2.equals("map.bin") || string2.equals("map_p.bin") || string2.matches("map_p[0-9]+\\.bin") || string2.equals("map_t.bin") || string2.equals("map_c.bin") || string2.equals("map_ver.bin") || string2.equals("map_sand.bin") || string2.equals("map_mov.bin") || string2.equals("map_meta.bin") || string2.equals("map_cm.bin") || string2.equals("pc.bin") || string2.startsWith("zpop_") || string2.startsWith("chunkdata_")) continue;
            String[] stringArray2 = string2.replace(".bin", "").replace("map_", "").split("_");
            int n = Integer.parseInt(stringArray2[0]);
            int n2 = Integer.parseInt(stringArray2[1]);
            isoChunkMap.LoadChunkForLater(n, n2, 0, 0);
            isoChunkMap.SwapChunkBuffers();
            isoChunkMap.getChunk(0, 0).Save(true);
        }
    }

    private void convertchunks(String string, int n, int n2) throws IOException {
        IsoCell isoCell = new IsoCell(300, 300);
        IsoChunkMap isoChunkMap = new IsoChunkMap(isoCell);
        File file = new File(ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + string + File.separator);
        if (!file.exists()) {
            file.mkdir();
        }
        String[] stringArray = file.list();
        IsoWorld.saveoffsetx = n;
        IsoWorld.saveoffsety = n2;
        IsoWorld.instance.MetaGrid.Create();
        WorldStreamer.instance.create();
        for (String string2 : stringArray) {
            if (!string2.contains(".bin") || string2.equals("map.bin") || string2.equals("map_p.bin") || string2.matches("map_p[0-9]+\\.bin") || string2.equals("map_t.bin") || string2.equals("map_c.bin") || string2.equals("map_ver.bin") || string2.equals("map_sand.bin") || string2.equals("map_mov.bin") || string2.equals("map_meta.bin") || string2.equals("map_cm.bin") || string2.equals("pc.bin") || string2.startsWith("zpop_") || string2.startsWith("chunkdata_")) continue;
            String[] stringArray2 = string2.replace(".bin", "").replace("map_", "").split("_");
            int n3 = Integer.parseInt(stringArray2[0]);
            int n4 = Integer.parseInt(stringArray2[1]);
            IsoChunk isoChunk = new IsoChunk(isoCell);
            isoChunk.refs.add(isoCell.ChunkMap[0]);
            WorldStreamer.instance.addJobConvert(isoChunk, 0, 0, n3, n4);
            while (!isoChunk.bLoaded) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            isoChunk.wx += n * 30;
            isoChunk.wy += n2 * 30;
            isoChunk.jobType = IsoChunk.JobType.Convert;
            isoChunk.Save(true);
            File file2 = new File(ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + string + File.separator + string2);
            while (!ChunkSaveWorker.instance.toSaveQueue.isEmpty()) {
                try {
                    Thread.sleep(13L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            file2.delete();
        }
    }

    private void loadconversionmap(int n, String string) {
        String string2 = "media/" + string + "_" + n + ".tiles";
        File file = new File(string2);
        if (file.exists()) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file.getAbsolutePath(), "r");
                int n2 = IsoWorld.readInt(randomAccessFile);
                for (int i = 0; i < n2; ++i) {
                    Thread.sleep(4L);
                    String string3 = IsoWorld.readString(randomAccessFile);
                    String string4 = string3.trim();
                    IsoWorld.readString(randomAccessFile);
                    int n3 = IsoWorld.readInt(randomAccessFile);
                    int n4 = IsoWorld.readInt(randomAccessFile);
                    int n5 = IsoWorld.readInt(randomAccessFile);
                    for (int j = 0; j < n5; ++j) {
                        IsoSprite isoSprite = IsoSpriteManager.instance.NamedMap.get(string4 + "_" + j);
                        if (this.TilesetConversions == null) {
                            this.TilesetConversions = new HashMap();
                        }
                        this.TilesetConversions.put(this.oldID, isoSprite.ID);
                        ++this.oldID;
                        int n6 = IsoWorld.readInt(randomAccessFile);
                        for (int k = 0; k < n6; ++k) {
                            string3 = IsoWorld.readString(randomAccessFile);
                            String string5 = string3.trim();
                            string3 = IsoWorld.readString(randomAccessFile);
                            String string6 = string3.trim();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void softreset() throws WorldDictionaryException {
        String string;
        Core.GameSaveWorld = string = GameServer.ServerName;
        IsoCell isoCell = new IsoCell(300, 300);
        IsoChunk isoChunk = new IsoChunk(isoCell);
        File file = new File(ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + string + File.separator);
        if (!file.exists()) {
            file.mkdir();
        }
        String[] stringArray = file.list();
        if (CoopSlave.instance != null) {
            CoopSlave.instance.sendMessage("softreset-count", null, Integer.toString(stringArray.length));
        }
        IsoWorld.instance.MetaGrid.Create();
        ServerMap.instance.init(IsoWorld.instance.MetaGrid);
        new ErosionIceQueen(IsoSpriteManager.instance);
        ErosionRegions.init();
        WorldStreamer.instance.create();
        VehicleManager.instance = new VehicleManager();
        WorldDictionary.init();
        GlobalObjectLookup.init(IsoWorld.instance.getMetaGrid());
        LuaEventManager.triggerEvent("OnSGlobalObjectSystemInit");
        int n = stringArray.length;
        DebugLog.log("processing " + n + " files");
        for (String string2 : stringArray) {
            --n;
            if (string2.startsWith("zpop_")) {
                WorldConverter.deleteFile(string2);
                continue;
            }
            if (string2.equals("map_t.bin")) {
                WorldConverter.deleteFile(string2);
                continue;
            }
            if (string2.equals("map_meta.bin") || string2.equals("map_zone.bin")) {
                WorldConverter.deleteFile(string2);
                continue;
            }
            if (string2.equals("reanimated.bin")) {
                WorldConverter.deleteFile(string2);
                continue;
            }
            if (!string2.matches("map_[0-9]+_[0-9]+\\.bin")) continue;
            System.out.println("Soft clearing chunk: " + string2);
            String[] stringArray2 = string2.replace(".bin", "").replace("map_", "").split("_");
            int n2 = Integer.parseInt(stringArray2[0]);
            int n3 = Integer.parseInt(stringArray2[1]);
            isoChunk.refs.add(isoCell.ChunkMap[0]);
            isoChunk.wx = n2;
            isoChunk.wy = n3;
            ServerMap.instance.setSoftResetChunk(isoChunk);
            WorldStreamer.instance.addJobWipe(isoChunk, 0, 0, n2, n3);
            while (!isoChunk.bLoaded) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            isoChunk.jobType = IsoChunk.JobType.Convert;
            isoChunk.FloorBloodSplats.clear();
            try {
                isoChunk.Save(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ServerMap.instance.clearSoftResetChunk(isoChunk);
            isoChunk.doReuseGridsquares();
            IsoChunkMap.chunkStore.remove(isoChunk);
            if (n % 100 == 0) {
                DebugLog.log(n + " files to go");
            }
            if (CoopSlave.instance == null || n % 10 != 0) continue;
            CoopSlave.instance.sendMessage("softreset-remaining", null, Integer.toString(n));
        }
        GameServer.ResetID = Rand.Next(10000000);
        ServerOptions.instance.putSaveOption("ResetID", String.valueOf(GameServer.ResetID));
        IsoWorld.instance.CurrentCell = null;
        DebugLog.log("soft-reset complete, server terminated");
        if (CoopSlave.instance != null) {
            CoopSlave.instance.sendMessage("softreset-finished", null, "");
        }
        SteamUtils.shutdown();
        System.exit(0);
    }

    private static void deleteFile(String string) {
        File file = new File(ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator + GameServer.ServerName + File.separator + string);
        file.delete();
    }
}

