/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import org.joml.Vector4f;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.Shader;
import zombie.core.opengl.ShaderProgram;
import zombie.core.textures.TextureDraw;
import zombie.iso.IsoCamera;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoWater;
import zombie.iso.PlayerCamera;
import zombie.iso.sprite.SkyBox;

public final class WaterShader
extends Shader {
    private int WaterGroundTex;
    private int WaterTextureReflectionA;
    private int WaterTextureReflectionB;
    private int WaterTime;
    private int WaterOffset;
    private int WaterViewport;
    private int WaterReflectionParam;
    private int WaterParamWind;
    private int WaterParamWindSpeed;
    private int WaterParamRainIntensity;

    public WaterShader(String string) {
        super(string);
    }

    @Override
    protected void onCompileSuccess(ShaderProgram shaderProgram) {
        int n = shaderProgram.getShaderID();
        this.WaterGroundTex = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WaterGroundTex");
        this.WaterTextureReflectionA = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WaterTextureReflectionA");
        this.WaterTextureReflectionB = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WaterTextureReflectionB");
        this.WaterTime = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WTime");
        this.WaterOffset = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WOffset");
        this.WaterViewport = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WViewport");
        this.WaterReflectionParam = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WReflectionParam");
        this.WaterParamWind = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WParamWind");
        this.WaterParamWindSpeed = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WParamWindSpeed");
        this.WaterParamRainIntensity = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WParamRainIntensity");
        this.Start();
        if (this.WaterGroundTex != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.WaterGroundTex, (int)0);
        }
        if (this.WaterTextureReflectionA != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.WaterTextureReflectionA, (int)1);
        }
        if (this.WaterTextureReflectionB != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.WaterTextureReflectionB, (int)2);
        }
        this.End();
    }

    @Override
    public void startMainThread(TextureDraw textureDraw, int n) {
        IsoWater isoWater = IsoWater.getInstance();
        SkyBox skyBox = SkyBox.getInstance();
        textureDraw.u0 = isoWater.getWaterWindX();
        textureDraw.u1 = isoWater.getWaterWindY();
        textureDraw.u2 = isoWater.getWaterWindSpeed();
        textureDraw.u3 = IsoPuddles.getInstance().getRainIntensity();
        textureDraw.v0 = isoWater.getShaderTime();
        textureDraw.v1 = skyBox.getTextureShift();
    }

    public void updateWaterParams(TextureDraw textureDraw, int n) {
        IsoWater isoWater = IsoWater.getInstance();
        SkyBox skyBox = SkyBox.getInstance();
        PlayerCamera playerCamera = SpriteRenderer.instance.getRenderingPlayerCamera(n);
        GL13.glActiveTexture((int)33984);
        isoWater.getTextureBottom().bind();
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        GL13.glActiveTexture((int)33985);
        skyBox.getTextureCurrent().bind();
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        GL13.glActiveTexture((int)33986);
        skyBox.getTexturePrev().bind();
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        ARBShaderObjects.glUniform1fARB((int)this.WaterTime, (float)textureDraw.v0);
        Vector4f vector4f = isoWater.getShaderOffset();
        ARBShaderObjects.glUniform4fARB((int)this.WaterOffset, (float)(vector4f.x - 90000.0f), (float)(vector4f.y - 640000.0f), (float)vector4f.z, (float)vector4f.w);
        ARBShaderObjects.glUniform4fARB((int)this.WaterViewport, (float)IsoCamera.getOffscreenLeft(n), (float)IsoCamera.getOffscreenTop(n), (float)((float)playerCamera.OffscreenWidth / playerCamera.zoom), (float)((float)playerCamera.OffscreenHeight / playerCamera.zoom));
        ARBShaderObjects.glUniform1fARB((int)this.WaterReflectionParam, (float)textureDraw.v1);
        ARBShaderObjects.glUniform2fARB((int)this.WaterParamWind, (float)textureDraw.u0, (float)textureDraw.u1);
        ARBShaderObjects.glUniform1fARB((int)this.WaterParamWindSpeed, (float)textureDraw.u2);
        ARBShaderObjects.glUniform1fARB((int)this.WaterParamRainIntensity, (float)textureDraw.u3);
    }
}

