/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.awt.Dimension;
import java.awt.Point;
import zombie.iso.Vector2;

public final class Vector3
implements Cloneable {
    public float x;
    public float y;
    public float z;

    public Vector3() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public Vector3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public static Vector2 fromAwtPoint(Point point) {
        return new Vector2(point.x, point.y);
    }

    public static Vector2 fromLengthDirection(float f, float f2) {
        Vector2 vector22 = new Vector2();
        vector22.setLengthAndDirection(f2, f);
        return vector22;
    }

    public static float dot(float f, float f2, float f3, float f4) {
        return f * f3 + f2 * f4;
    }

    public void rotate(float f) {
        double d = (double)this.x * Math.cos(f) - (double)this.y * Math.sin(f);
        double d2 = (double)this.x * Math.sin(f) + (double)this.y * Math.cos(f);
        this.x = (float)d;
        this.y = (float)d2;
    }

    public void rotatey(float f) {
        double d = (double)this.x * Math.cos(f) - (double)this.z * Math.sin(f);
        double d2 = (double)this.x * Math.sin(f) + (double)this.z * Math.cos(f);
        this.x = (float)d;
        this.z = (float)d2;
    }

    public Vector2 add(Vector2 vector22) {
        return new Vector2(this.x + vector22.x, this.y + vector22.y);
    }

    public Vector3 addToThis(Vector2 vector22) {
        this.x += vector22.x;
        this.y += vector22.y;
        return this;
    }

    public Vector3 addToThis(Vector3 vector3) {
        this.x += vector3.x;
        this.y += vector3.y;
        this.z += vector3.z;
        return this;
    }

    public Vector3 div(float f) {
        this.x /= f;
        this.y /= f;
        this.z /= f;
        return this;
    }

    public Vector3 aimAt(Vector2 vector22) {
        this.setLengthAndDirection(this.angleTo(vector22), this.getLength());
        return this;
    }

    public float angleTo(Vector2 vector22) {
        return (float)Math.atan2(vector22.y - this.y, vector22.x - this.x);
    }

    public Vector3 clone() {
        return new Vector3(this);
    }

    public float distanceTo(Vector2 vector22) {
        return (float)Math.sqrt(Math.pow(vector22.x - this.x, 2.0) + Math.pow(vector22.y - this.y, 2.0));
    }

    public float dot(Vector2 vector22) {
        return this.x * vector22.x + this.y * vector22.y;
    }

    public float dot3d(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public boolean equals(Object object) {
        if (object instanceof Vector2) {
            Vector2 vector22 = (Vector2)object;
            return vector22.x == this.x && vector22.y == this.y;
        }
        return false;
    }

    public float getDirection() {
        return (float)Math.atan2(this.x, this.y);
    }

    public Vector3 setDirection(float f) {
        this.setLengthAndDirection(f, this.getLength());
        return this;
    }

    public float getLength() {
        float f = this.getLengthSq();
        return (float)Math.sqrt(f);
    }

    public float getLengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 setLength(float f) {
        this.normalize();
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public void normalize() {
        float f = this.getLength();
        if (f == 0.0f) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        } else {
            this.x /= f;
            this.y /= f;
            this.z /= f;
        }
        f = this.getLength();
    }

    public Vector3 set(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
        return this;
    }

    public Vector3 set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3 setLengthAndDirection(float f, float f2) {
        this.x = (float)(Math.cos(f) * (double)f2);
        this.y = (float)(Math.sin(f) * (double)f2);
        return this;
    }

    public Dimension toAwtDimension() {
        return new Dimension((int)this.x, (int)this.y);
    }

    public Point toAwtPoint() {
        return new Point((int)this.x, (int)this.y);
    }

    public String toString() {
        return String.format("Vector2 (X: %f, Y: %f) (L: %f, D:%f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.getLength()), Float.valueOf(this.getDirection()));
    }

    public Vector3 sub(Vector3 vector3, Vector3 vector32) {
        return Vector3.sub(this, vector3, vector32);
    }

    public static Vector3 sub(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        vector33.set(vector3.x - vector32.x, vector3.y - vector32.y, vector3.z - vector32.z);
        return vector33;
    }
}

