/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameServer;
import zombie.util.LocationRNG;
import zombie.util.StringUtils;

public class TileOverlays {
    public static final TileOverlays instance = new TileOverlays();
    private static final THashMap<String, TileOverlay> overlayMap = new THashMap();
    private static final ArrayList<TileOverlayEntry> tempEntries = new ArrayList();

    public void addOverlays(KahluaTableImpl kahluaTableImpl) {
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            String string = kahluaTableIterator.getKey().toString();
            if ("VERSION".equalsIgnoreCase(string)) continue;
            TileOverlay tileOverlay = new TileOverlay();
            tileOverlay.tile = string;
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableIterator.getValue();
            KahluaTableIterator kahluaTableIterator2 = kahluaTableImpl2.iterator();
            while (kahluaTableIterator2.advance()) {
                KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)kahluaTableIterator2.getValue();
                TileOverlayEntry tileOverlayEntry = new TileOverlayEntry();
                tileOverlayEntry.room = kahluaTableImpl3.rawgetStr((Object)"name");
                tileOverlayEntry.chance = kahluaTableImpl3.rawgetInt((Object)"chance");
                tileOverlayEntry.usage.parse(kahluaTableImpl3.rawgetStr((Object)"usage"));
                KahluaTableImpl kahluaTableImpl4 = (KahluaTableImpl)kahluaTableImpl3.rawget((Object)"tiles");
                KahluaTableIterator kahluaTableIterator3 = kahluaTableImpl4.iterator();
                while (kahluaTableIterator3.advance()) {
                    String string2 = kahluaTableIterator3.getValue().toString();
                    if (StringUtils.isNullOrWhitespace(string2) || "none".equalsIgnoreCase(string2)) {
                        string2 = "";
                    } else if (Core.bDebug && !GameServer.bServer && Texture.getSharedTexture(string2) == null) {
                        System.out.println("BLANK OVERLAY TEXTURE. Set it to \"none\".: " + string2);
                    }
                    tileOverlayEntry.tiles.add(string2);
                }
                tileOverlay.entries.add(tileOverlayEntry);
            }
            overlayMap.put((Object)tileOverlay.tile, (Object)tileOverlay);
        }
    }

    public boolean hasOverlays(IsoObject isoObject) {
        return isoObject != null && isoObject.sprite != null && isoObject.sprite.name != null && overlayMap.containsKey((Object)isoObject.sprite.name);
    }

    public void updateTileOverlaySprite(IsoObject isoObject) {
        Object object;
        Object object2;
        if (isoObject == null) {
            return;
        }
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (isoGridSquare == null) {
            return;
        }
        String string = null;
        float f = -1.0f;
        float f2 = -1.0f;
        float f3 = -1.0f;
        float f4 = -1.0f;
        if (isoObject.sprite != null && isoObject.sprite.name != null && (object2 = (TileOverlay)overlayMap.get((Object)isoObject.sprite.name)) != null) {
            TileOverlayEntry tileOverlayEntry;
            object = "other";
            if (isoGridSquare.getRoom() != null) {
                object = isoGridSquare.getRoom().getName();
            }
            if ((tileOverlayEntry = ((TileOverlay)object2).pickRandom((String)object, isoGridSquare)) == null) {
                tileOverlayEntry = ((TileOverlay)object2).pickRandom("other", isoGridSquare);
            }
            if (tileOverlayEntry != null) {
                if (tileOverlayEntry.usage.bTableTop && this.hasObjectOnTop(isoObject)) {
                    return;
                }
                string = tileOverlayEntry.pickRandom(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
                if (tileOverlayEntry.usage.alpha >= 0.0f) {
                    f3 = 1.0f;
                    f2 = 1.0f;
                    f = 1.0f;
                    f4 = tileOverlayEntry.usage.alpha;
                }
            }
        }
        if (!StringUtils.isNullOrWhitespace(string) && !GameServer.bServer && Texture.getSharedTexture(string) == null) {
            string = null;
        }
        if (!StringUtils.isNullOrWhitespace(string)) {
            if (isoObject.AttachedAnimSprite == null) {
                isoObject.AttachedAnimSprite = new ArrayList(4);
            }
            object2 = IsoSpriteManager.instance.getSprite(string);
            ((IsoSprite)object2).name = string;
            object = IsoSpriteInstance.get((IsoSprite)object2);
            if (f4 > 0.0f) {
                ((IsoSpriteInstance)object).tintr = f;
                ((IsoSpriteInstance)object).tintg = f2;
                ((IsoSpriteInstance)object).tintb = f3;
                ((IsoSpriteInstance)object).alpha = f4;
            }
            ((IsoSpriteInstance)object).bCopyTargetAlpha = false;
            ((IsoSpriteInstance)object).bMultiplyObjectAlpha = true;
            isoObject.AttachedAnimSprite.add((IsoSpriteInstance)object);
        }
    }

    private boolean hasObjectOnTop(IsoObject isoObject) {
        if (!isoObject.isTableSurface()) {
            return false;
        }
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        for (int i = isoObject.getObjectIndex() + 1; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject2 = isoGridSquare.getObjects().get(i);
            if (!isoObject2.isTableTopObject() && !isoObject2.isTableSurface()) continue;
            return true;
        }
        return false;
    }

    public void fixTableTopOverlays(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare.getObjects().isEmpty()) {
            return;
        }
        boolean bl = false;
        for (int i = isoGridSquare.getObjects().size() - 1; i >= 0; --i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (bl && isoObject.isTableSurface()) {
                this.removeTableTopOverlays(isoObject);
            }
            if (!isoObject.isTableSurface() && !isoObject.isTableTopObject()) continue;
            bl = true;
        }
    }

    private void removeTableTopOverlays(IsoObject isoObject) {
        if (isoObject == null || !isoObject.isTableSurface()) {
            return;
        }
        if (isoObject.sprite == null || isoObject.sprite.name == null) {
            return;
        }
        if (isoObject.AttachedAnimSprite == null || isoObject.AttachedAnimSprite.isEmpty()) {
            return;
        }
        TileOverlay tileOverlay = (TileOverlay)overlayMap.get((Object)isoObject.sprite.name);
        if (tileOverlay == null) {
            return;
        }
        int n = isoObject.AttachedAnimSprite.size();
        for (int i = 0; i < tileOverlay.entries.size(); ++i) {
            TileOverlayEntry tileOverlayEntry = tileOverlay.entries.get(i);
            if (!tileOverlayEntry.usage.bTableTop) continue;
            for (int j = 0; j < tileOverlayEntry.tiles.size(); ++j) {
                this.tryRemoveAttachedSprite(isoObject.AttachedAnimSprite, tileOverlayEntry.tiles.get(j));
            }
        }
        if (n != isoObject.AttachedAnimSprite.size()) {
            // empty if block
        }
    }

    private void tryRemoveAttachedSprite(ArrayList<IsoSpriteInstance> arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoSpriteInstance isoSpriteInstance = arrayList.get(i);
            if (!string.equals(isoSpriteInstance.getName())) continue;
            arrayList.remove(i--);
            IsoSpriteInstance.add(isoSpriteInstance);
        }
    }

    public void Reset() {
        overlayMap.clear();
    }

    private static final class TileOverlay {
        public String tile;
        public final ArrayList<TileOverlayEntry> entries = new ArrayList();

        private TileOverlay() {
        }

        public void getEntries(String string, IsoGridSquare isoGridSquare, ArrayList<TileOverlayEntry> arrayList) {
            arrayList.clear();
            for (int i = 0; i < this.entries.size(); ++i) {
                TileOverlayEntry tileOverlayEntry = this.entries.get(i);
                if (!tileOverlayEntry.room.equalsIgnoreCase(string) || !tileOverlayEntry.matchUsage(isoGridSquare)) continue;
                arrayList.add(tileOverlayEntry);
            }
        }

        public TileOverlayEntry pickRandom(String string, IsoGridSquare isoGridSquare) {
            this.getEntries(string, isoGridSquare, tempEntries);
            if (tempEntries.isEmpty()) {
                return null;
            }
            int n = LocationRNG.instance.nextInt(tempEntries.size(), isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
            return tempEntries.get(n);
        }
    }

    private static final class TileOverlayEntry {
        public String room;
        public int chance;
        public final ArrayList<String> tiles = new ArrayList();
        public final TileOverlayUsage usage = new TileOverlayUsage();

        private TileOverlayEntry() {
        }

        public boolean matchUsage(IsoGridSquare isoGridSquare) {
            return this.usage.match(isoGridSquare);
        }

        public String pickRandom(int n, int n2, int n3) {
            int n4 = LocationRNG.instance.nextInt(this.chance, n, n2, n3);
            if (n4 == 0 && !this.tiles.isEmpty()) {
                n4 = LocationRNG.instance.nextInt(this.tiles.size());
                return this.tiles.get(n4);
            }
            return null;
        }
    }

    private static final class TileOverlayUsage {
        String usage;
        int zOnly = -1;
        int zGreaterThan = -1;
        float alpha = -1.0f;
        boolean bTableTop = false;

        private TileOverlayUsage() {
        }

        boolean parse(String string) {
            this.usage = string.trim();
            if (StringUtils.isNullOrWhitespace(this.usage)) {
                return true;
            }
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.startsWith("z=")) {
                    this.zOnly = Integer.parseInt(string2.substring(2));
                    continue;
                }
                if (string2.startsWith("z>")) {
                    this.zGreaterThan = Integer.parseInt(string2.substring(2));
                    continue;
                }
                if (string2.startsWith("alpha=")) {
                    this.alpha = Float.parseFloat(string2.substring(6));
                    this.alpha = PZMath.clamp(this.alpha, 0.0f, 1.0f);
                    continue;
                }
                if (string2.startsWith("tabletop")) {
                    this.bTableTop = true;
                    continue;
                }
                return false;
            }
            return true;
        }

        boolean match(IsoGridSquare isoGridSquare) {
            if (this.zOnly != -1 && isoGridSquare.z != this.zOnly) {
                return false;
            }
            return this.zGreaterThan == -1 || isoGridSquare.z > this.zGreaterThan;
        }
    }
}

