/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.Lua.LuaManager;
import zombie.characters.IsoGameCharacter;
import zombie.debug.DebugLog;
import zombie.iso.BuildingDef;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.util.Type;

public final class SpawnPoints {
    public static final SpawnPoints instance = new SpawnPoints();
    private KahluaTable SpawnRegions;
    private final ArrayList<IsoGameCharacter.Location> SpawnPoints = new ArrayList();
    private final ArrayList<BuildingDef> SpawnBuildings = new ArrayList();
    private final IsoGameCharacter.Location m_tempLocation = new IsoGameCharacter.Location(-1, -1, -1);

    public void init() {
        this.SpawnRegions = LuaManager.platform.newTable();
        this.SpawnPoints.clear();
        this.SpawnBuildings.clear();
    }

    public void initServer1() {
        this.init();
        this.initSpawnRegions();
    }

    public void initServer2() {
        if (this.parseServerSpawnPoint()) {
            return;
        }
        this.parseSpawnRegions();
        this.initSpawnBuildings();
    }

    public void initSinglePlayer() {
        this.init();
        this.initSpawnRegions();
        this.parseSpawnRegions();
        this.initSpawnBuildings();
    }

    private void initSpawnRegions() {
        KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget((Object)"SpawnRegionMgr");
        if (kahluaTable == null) {
            DebugLog.General.error("SpawnRegionMgr is undefined");
            return;
        }
        Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, kahluaTable.rawget((Object)"getSpawnRegions"), new Object[0]);
        if (objectArray.length > 1 && objectArray[1] instanceof KahluaTable) {
            this.SpawnRegions = (KahluaTable)objectArray[1];
        }
    }

    private boolean parseServerSpawnPoint() {
        if (!GameServer.bServer) {
            return false;
        }
        if (ServerOptions.instance.SpawnPoint.getValue().isEmpty()) {
            return false;
        }
        String[] stringArray = ServerOptions.instance.SpawnPoint.getValue().split(",");
        if (stringArray.length == 3) {
            try {
                int n = Integer.parseInt(stringArray[0].trim());
                int n2 = Integer.parseInt(stringArray[1].trim());
                int n3 = Integer.parseInt(stringArray[2].trim());
                if (n != 0 || n2 != 0) {
                    this.SpawnPoints.add(new IsoGameCharacter.Location(n, n2, n3));
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                DebugLog.General.error("SpawnPoint must be x,y,z, got \"" + ServerOptions.instance.SpawnPoint.getValue() + "\"");
            }
        } else {
            DebugLog.General.error("SpawnPoint must be x,y,z, got \"" + ServerOptions.instance.SpawnPoint.getValue() + "\"");
        }
        return false;
    }

    private void parseSpawnRegions() {
        KahluaTableIterator kahluaTableIterator = this.SpawnRegions.iterator();
        while (kahluaTableIterator.advance()) {
            KahluaTable kahluaTable = Type.tryCastTo(kahluaTableIterator.getValue(), KahluaTable.class);
            if (kahluaTable == null) continue;
            this.parseRegion(kahluaTable);
        }
    }

    private void parseRegion(KahluaTable kahluaTable) {
        KahluaTable kahluaTable2 = Type.tryCastTo(kahluaTable.rawget((Object)"points"), KahluaTable.class);
        if (kahluaTable2 != null) {
            KahluaTableIterator kahluaTableIterator = kahluaTable2.iterator();
            while (kahluaTableIterator.advance()) {
                KahluaTable kahluaTable3 = Type.tryCastTo(kahluaTableIterator.getValue(), KahluaTable.class);
                if (kahluaTable3 == null) continue;
                this.parseProfession(kahluaTable3);
            }
        }
    }

    private void parseProfession(KahluaTable kahluaTable) {
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            KahluaTable kahluaTable2 = Type.tryCastTo(kahluaTableIterator.getValue(), KahluaTable.class);
            if (kahluaTable2 == null) continue;
            this.parsePoint(kahluaTable2);
        }
    }

    private void parsePoint(KahluaTable kahluaTable) {
        Double d = Type.tryCastTo(kahluaTable.rawget((Object)"worldX"), Double.class);
        Double d2 = Type.tryCastTo(kahluaTable.rawget((Object)"worldY"), Double.class);
        Double d3 = Type.tryCastTo(kahluaTable.rawget((Object)"posX"), Double.class);
        Double d4 = Type.tryCastTo(kahluaTable.rawget((Object)"posY"), Double.class);
        Double d5 = Type.tryCastTo(kahluaTable.rawget((Object)"posZ"), Double.class);
        if (d == null || d2 == null || d3 == null || d4 == null) {
            return;
        }
        this.m_tempLocation.x = d.intValue() * 300 + d3.intValue();
        this.m_tempLocation.y = d2.intValue() * 300 + d4.intValue();
        int n = this.m_tempLocation.z = d5 == null ? 0 : d5.intValue();
        if (!this.SpawnPoints.contains(this.m_tempLocation)) {
            IsoGameCharacter.Location location = new IsoGameCharacter.Location(this.m_tempLocation.x, this.m_tempLocation.y, this.m_tempLocation.z);
            this.SpawnPoints.add(location);
        }
    }

    private void initSpawnBuildings() {
        for (int i = 0; i < this.SpawnPoints.size(); ++i) {
            IsoGameCharacter.Location location = this.SpawnPoints.get(i);
            RoomDef roomDef = IsoWorld.instance.MetaGrid.getRoomAt(location.x, location.y, location.z);
            if (roomDef == null || roomDef.getBuilding() == null) {
                DebugLog.General.warn("initSpawnBuildings: no room or building at %d,%d,%d", location.x, location.y, location.z);
                continue;
            }
            this.SpawnBuildings.add(roomDef.getBuilding());
        }
    }

    public boolean isSpawnBuilding(BuildingDef buildingDef) {
        return this.SpawnBuildings.contains(buildingDef);
    }

    public KahluaTable getSpawnRegions() {
        return this.SpawnRegions;
    }
}

