/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.nio.FloatBuffer;
import org.joml.Vector4f;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.Shader;
import zombie.core.opengl.ShaderProgram;
import zombie.iso.IsoCamera;
import zombie.iso.IsoPuddles;
import zombie.iso.PlayerCamera;
import zombie.iso.sprite.SkyBox;

public final class PuddlesShader
extends Shader {
    private int WaterGroundTex;
    private int PuddlesHM;
    private int WaterTextureReflectionA;
    private int WaterTextureReflectionB;
    private int WaterTime;
    private int WaterOffset;
    private int WaterViewport;
    private int WaterReflectionParam;
    private int PuddlesParams;

    public PuddlesShader(String string) {
        super(string);
    }

    @Override
    protected void onCompileSuccess(ShaderProgram shaderProgram) {
        int n = shaderProgram.getShaderID();
        this.WaterGroundTex = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WaterGroundTex");
        this.WaterTextureReflectionA = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WaterTextureReflectionA");
        this.WaterTextureReflectionB = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WaterTextureReflectionB");
        this.PuddlesHM = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"PuddlesHM");
        this.WaterTime = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WTime");
        this.WaterOffset = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WOffset");
        this.WaterViewport = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WViewport");
        this.WaterReflectionParam = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"WReflectionParam");
        this.PuddlesParams = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"PuddlesParams");
        this.Start();
        if (this.WaterGroundTex != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.WaterGroundTex, (int)0);
        }
        if (this.WaterTextureReflectionA != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.WaterTextureReflectionA, (int)1);
        }
        if (this.WaterTextureReflectionB != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.WaterTextureReflectionB, (int)2);
        }
        if (this.PuddlesHM != -1) {
            ARBShaderObjects.glUniform1iARB((int)this.PuddlesHM, (int)3);
        }
        this.End();
    }

    public void updatePuddlesParams(int n, int n2) {
        IsoPuddles isoPuddles = IsoPuddles.getInstance();
        SkyBox skyBox = SkyBox.getInstance();
        PlayerCamera playerCamera = SpriteRenderer.instance.getRenderingPlayerCamera(n);
        GL13.glActiveTexture((int)33985);
        skyBox.getTextureCurrent().bind();
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        GL13.glActiveTexture((int)33986);
        skyBox.getTexturePrev().bind();
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        GL13.glActiveTexture((int)33987);
        isoPuddles.getHMTexture().bind();
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        ARBShaderObjects.glUniform1fARB((int)this.WaterTime, (float)isoPuddles.getShaderTime());
        Vector4f vector4f = isoPuddles.getShaderOffset();
        ARBShaderObjects.glUniform4fARB((int)this.WaterOffset, (float)(vector4f.x - 90000.0f), (float)(vector4f.y - 640000.0f), (float)vector4f.z, (float)vector4f.w);
        ARBShaderObjects.glUniform4fARB((int)this.WaterViewport, (float)IsoCamera.getOffscreenLeft(n), (float)IsoCamera.getOffscreenTop(n), (float)((float)playerCamera.OffscreenWidth / playerCamera.zoom), (float)((float)playerCamera.OffscreenHeight / playerCamera.zoom));
        ARBShaderObjects.glUniform1fARB((int)this.WaterReflectionParam, (float)skyBox.getTextureShift());
        ARBShaderObjects.glUniformMatrix4fvARB((int)this.PuddlesParams, (boolean)true, (FloatBuffer)isoPuddles.getPuddlesParams(n2));
    }
}

