/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL33;
import org.lwjglx.BufferUtils;
import zombie.core.Rand;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.textures.Texture;
import zombie.interfaces.ITexture;
import zombie.iso.FireShader;
import zombie.iso.IsoCamera;
import zombie.iso.Particles;
import zombie.iso.ParticlesArray;
import zombie.iso.SmokeShader;
import zombie.iso.weather.ClimateManager;

public final class ParticlesFire
extends Particles {
    int MaxParticles = 1000000;
    int MaxVortices = 4;
    int particles_data_buffer;
    ByteBuffer particule_data;
    private Texture texFireSmoke;
    private Texture texFlameFire;
    public FireShader EffectFire;
    public SmokeShader EffectSmoke;
    public Shader EffectVape;
    float windX;
    float windY;
    private static ParticlesFire instance;
    private ParticlesArray<Particle> particles;
    private ArrayList<Zone> zones;
    private int intensityFire = 0;
    private int intensitySmoke = 0;
    private int intensitySteam = 0;
    private FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);

    public static synchronized ParticlesFire getInstance() {
        if (instance == null) {
            instance = new ParticlesFire();
        }
        return instance;
    }

    public ParticlesFire() {
        this.particles = new ParticlesArray();
        this.zones = new ArrayList();
        this.particule_data = BufferUtils.createByteBuffer((int)(this.MaxParticles * 4 * 4));
        this.texFireSmoke = Texture.getSharedTexture("media/textures/FireSmokes.png");
        this.texFlameFire = Texture.getSharedTexture("media/textures/FireFlame.png");
        this.zones.clear();
        float f = (int)(IsoCamera.frameState.OffX + (float)(IsoCamera.frameState.OffscreenWidth / 2));
        float f2 = (int)(IsoCamera.frameState.OffY + (float)(IsoCamera.frameState.OffscreenHeight / 2));
        this.zones.add(new Zone(10, f - 30.0f, f2 - 10.0f, f + 30.0f, f2 + 10.0f));
        this.zones.add(new Zone(10, f - 200.0f, f2, 50.0f));
        this.zones.add(new Zone(40, f + 200.0f, f2, 100.0f));
        this.zones.add(new Zone(60, f - 150.0f, f2 - 300.0f, f + 250.0f, f2 - 300.0f, 10.0f));
        this.zones.add(new Zone(10, f - 350.0f, f2 - 200.0f, f - 350.0f, f2 - 300.0f, 10.0f));
    }

    private void ParticlesProcess() {
        for (int i = 0; i < this.zones.size(); ++i) {
            float f;
            float f2;
            Particle particle;
            int n;
            Zone zone = this.zones.get(i);
            int n2 = (int)Math.ceil((float)(zone.intensity - zone.currentParticles) * 0.1f);
            if (zone.type == ZoneType.Rectangle) {
                for (n = 0; n < n2; ++n) {
                    particle = new Particle();
                    particle.x = Rand.Next(zone.x0, zone.x1);
                    particle.y = Rand.Next(zone.y0, zone.y1);
                    particle.vx = Rand.Next(-3.0f, 3.0f);
                    particle.vy = Rand.Next(1.0f, 5.0f);
                    particle.tShift = 0.0f;
                    particle.id = Rand.Next(-1000000.0f, 1000000.0f);
                    particle.zone = zone;
                    ++zone.currentParticles;
                    this.particles.addParticle(particle);
                }
            }
            if (zone.type == ZoneType.Circle) {
                for (n = 0; n < n2; ++n) {
                    particle = new Particle();
                    f2 = Rand.Next(0.0f, (float)Math.PI * 2);
                    f = Rand.Next(0.0f, zone.r);
                    particle.x = (float)((double)zone.x0 + (double)f * Math.cos(f2));
                    particle.y = (float)((double)zone.y0 + (double)f * Math.sin(f2));
                    particle.vx = Rand.Next(-3.0f, 3.0f);
                    particle.vy = Rand.Next(1.0f, 5.0f);
                    particle.tShift = 0.0f;
                    particle.id = Rand.Next(-1000000.0f, 1000000.0f);
                    particle.zone = zone;
                    ++zone.currentParticles;
                    this.particles.addParticle(particle);
                }
            }
            if (zone.type == ZoneType.Line) {
                for (n = 0; n < n2; ++n) {
                    particle = new Particle();
                    f2 = Rand.Next(0.0f, (float)Math.PI * 2);
                    f = Rand.Next(0.0f, zone.r);
                    float f3 = Rand.Next(0.0f, 1.0f);
                    particle.x = (float)((double)(zone.x0 * f3 + zone.x1 * (1.0f - f3)) + (double)f * Math.cos(f2));
                    particle.y = (float)((double)(zone.y0 * f3 + zone.y1 * (1.0f - f3)) + (double)f * Math.sin(f2));
                    particle.vx = Rand.Next(-3.0f, 3.0f);
                    particle.vy = Rand.Next(1.0f, 5.0f);
                    particle.tShift = 0.0f;
                    particle.id = Rand.Next(-1000000.0f, 1000000.0f);
                    particle.zone = zone;
                    ++zone.currentParticles;
                    this.particles.addParticle(particle);
                }
            }
            if (n2 >= 0) continue;
            for (n = 0; n < -n2; ++n) {
                --zone.currentParticles;
                this.particles.deleteParticle(Rand.Next(0, this.particles.getCount() + 1));
            }
        }
    }

    public FloatBuffer getParametersFire() {
        this.floatBuffer.clear();
        this.floatBuffer.put(this.windX);
        this.floatBuffer.put(this.intensityFire);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(this.windY);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.flip();
        return this.floatBuffer;
    }

    public int getFireShaderID() {
        return this.EffectFire.getID();
    }

    public int getSmokeShaderID() {
        return this.EffectSmoke.getID();
    }

    public int getVapeShaderID() {
        return this.EffectVape.getID();
    }

    public ITexture getFireFlameTexture() {
        return this.texFlameFire;
    }

    public ITexture getFireSmokeTexture() {
        return this.texFireSmoke;
    }

    @Override
    public void reloadShader() {
        RenderThread.invokeOnRenderContext(() -> {
            this.EffectFire = new FireShader("fire");
            this.EffectSmoke = new SmokeShader("smoke");
            this.EffectVape = new Shader("vape");
        });
    }

    @Override
    void createParticleBuffers() {
        this.particles_data_buffer = funcs.glGenBuffers();
        funcs.glBindBuffer(34962, this.particles_data_buffer);
        funcs.glBufferData(34962, this.MaxParticles * 4 * 4, 35044);
    }

    @Override
    void destroyParticleBuffers() {
        funcs.glDeleteBuffers(this.particles_data_buffer);
    }

    @Override
    void updateParticleParams() {
        float f = ClimateManager.getInstance().getWindAngleIntensity();
        float f2 = ClimateManager.getInstance().getWindIntensity();
        this.windX = (float)Math.sin(f * 6.0f) * f2;
        this.windY = (float)Math.cos(f * 6.0f) * f2;
        this.ParticlesProcess();
        if (this.particles.getNeedToUpdate()) {
            this.particles.defragmentParticle();
            this.particule_data.clear();
            for (int i = 0; i < this.particles.size(); ++i) {
                Particle particle = (Particle)this.particles.get(i);
                if (particle == null) continue;
                this.particule_data.putFloat(particle.x);
                this.particule_data.putFloat(particle.y);
                this.particule_data.putFloat(particle.id);
                this.particule_data.putFloat((float)i / (float)this.particles.size());
            }
            this.particule_data.flip();
        }
        funcs.glBindBuffer(34962, this.particles_data_buffer);
        funcs.glBufferData(34962, this.particule_data, 35040);
        GL20.glEnableVertexAttribArray((int)1);
        funcs.glBindBuffer(34962, this.particles_data_buffer);
        GL20.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)0, (long)0L);
        GL33.glVertexAttribDivisor((int)1, (int)1);
    }

    @Override
    int getParticleCount() {
        return this.particles.getCount();
    }

    public class Zone {
        ZoneType type;
        int intensity;
        int currentParticles;
        float x0;
        float y0;
        float x1;
        float y1;
        float r;
        float fireIntensity;
        float smokeIntensity;
        float sparksIntensity;
        float vortices;
        float vorticeSpeed;
        float area;
        float temperature;
        float centerX;
        float centerY;
        float centerRp2;
        float currentVorticesCount;

        Zone(int n, float f, float f2, float f3) {
            this.type = ZoneType.Circle;
            this.intensity = n;
            this.currentParticles = 0;
            this.x0 = f;
            this.y0 = f2;
            this.r = f3;
            this.area = (float)(Math.PI * (double)f3 * (double)f3);
            this.vortices = (float)this.intensity * 0.3f;
            this.vorticeSpeed = 0.5f;
            this.temperature = 2000.0f;
            this.centerX = f;
            this.centerY = f2;
            this.centerRp2 = f3 * f3;
        }

        Zone(int n, float f, float f2, float f3, float f4) {
            this.type = ZoneType.Rectangle;
            this.intensity = n;
            this.currentParticles = 0;
            if (f < f3) {
                this.x0 = f;
                this.x1 = f3;
            } else {
                this.x1 = f;
                this.x0 = f3;
            }
            if (f2 < f4) {
                this.y0 = f2;
                this.y1 = f4;
            } else {
                this.y1 = f2;
                this.y0 = f4;
            }
            this.area = (this.x1 - this.x0) * (this.y1 - this.y0);
            this.vortices = (float)this.intensity * 0.3f;
            this.vorticeSpeed = 0.5f;
            this.temperature = 2000.0f;
            this.centerX = (this.x0 + this.x1) * 0.5f;
            this.centerY = (this.y0 + this.y1) * 0.5f;
            this.centerRp2 = (this.x1 - this.x0) * (this.x1 - this.x0);
        }

        Zone(int n, float f, float f2, float f3, float f4, float f5) {
            this.type = ZoneType.Line;
            this.intensity = n;
            this.currentParticles = 0;
            if (f < f3) {
                this.x0 = f;
                this.x1 = f3;
                this.y0 = f2;
                this.y1 = f4;
            } else {
                this.x1 = f;
                this.x0 = f3;
                this.y1 = f2;
                this.y0 = f4;
            }
            this.r = f5;
            this.area = (float)((double)this.r * Math.sqrt(Math.pow(f - f3, 2.0) + Math.pow(f2 - f4, 2.0)));
            this.vortices = (float)this.intensity * 0.3f;
            this.vorticeSpeed = 0.5f;
            this.temperature = 2000.0f;
            this.centerX = (this.x0 + this.x1) * 0.5f;
            this.centerY = (this.y0 + this.y1) * 0.5f;
            this.centerRp2 = (this.x1 - this.x0 + f5) * (this.x1 - this.x0 + f5) * 100.0f;
        }
    }

    static enum ZoneType {
        Rectangle,
        Circle,
        Line;

    }

    public class Particle {
        float id;
        float x;
        float y;
        float tShift;
        float vx;
        float vy;
        Zone zone;
    }

    public class Vortice {
        float x;
        float y;
        float z;
        float size;
        float vx;
        float vy;
        float speed;
        int life;
        int lifeTime;
        Zone zone;
    }
}

