/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import zombie.debug.DebugLog;

public final class ParticlesArray<E>
extends ArrayList<E> {
    private boolean needToUpdate = true;
    private int ParticleSystemsCount = 0;
    private int ParticleSystemsLast = 0;

    public synchronized int addParticle(E e) {
        int n;
        if (e == null) {
            return -1;
        }
        if (this.size() == this.ParticleSystemsCount) {
            this.add(e);
            ++this.ParticleSystemsCount;
            this.needToUpdate = true;
            return this.size() - 1;
        }
        for (n = this.ParticleSystemsLast; n < this.size(); ++n) {
            if (this.get(n) != null) continue;
            this.ParticleSystemsLast = n;
            this.set(n, e);
            ++this.ParticleSystemsCount;
            this.needToUpdate = true;
            return n;
        }
        for (n = 0; n < this.ParticleSystemsLast; ++n) {
            if (this.get(n) != null) continue;
            this.ParticleSystemsLast = n;
            this.set(n, e);
            ++this.ParticleSystemsCount;
            this.needToUpdate = true;
            return n;
        }
        DebugLog.log("ERROR: ParticlesArray.addParticle has unknown error");
        return -1;
    }

    public synchronized boolean deleteParticle(int n) {
        if (n >= 0 && n < this.size() && this.get(n) != null) {
            this.set(n, null);
            --this.ParticleSystemsCount;
            this.needToUpdate = true;
            return true;
        }
        return false;
    }

    public synchronized void defragmentParticle() {
        int n;
        this.needToUpdate = false;
        if (this.ParticleSystemsCount == this.size() || this.size() == 0) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.size(); ++n) {
            if (this.get(n) != null) continue;
            n2 = n;
            break;
        }
        for (n = this.size() - 1; n >= 0; --n) {
            if (this.get(n) == null) continue;
            this.set(n2, this.get(n));
            this.set(n, null);
            for (int i = n2; i < this.size(); ++i) {
                if (this.get(i) != null) continue;
                n2 = i;
                break;
            }
            if (n2 + 1 < n) continue;
            this.ParticleSystemsLast = n2;
            break;
        }
    }

    public synchronized int getCount() {
        return this.ParticleSystemsCount;
    }

    public synchronized boolean getNeedToUpdate() {
        return this.needToUpdate;
    }
}

