/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL33;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjglx.BufferUtils;
import zombie.GameTime;
import zombie.core.SpriteRenderer;
import zombie.core.VBO.GLBufferObject15;
import zombie.core.VBO.GLBufferObjectARB;
import zombie.core.VBO.IGLBufferObject;
import zombie.core.opengl.RenderThread;
import zombie.debug.DebugLog;
import zombie.iso.IsoCamera;

public abstract class Particles {
    private float ParticlesTime;
    public static int ParticleSystemsCount = 0;
    public static int ParticleSystemsLast = 0;
    public static final ArrayList<Particles> ParticleSystems = new ArrayList();
    private int id;
    int particle_vertex_buffer;
    public static IGLBufferObject funcs = null;
    private Matrix4f projectionMatrix;
    private Matrix4f mvpMatrix;
    private FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);

    public static synchronized int addParticle(Particles particles) {
        if (ParticleSystems.size() == ParticleSystemsCount) {
            ParticleSystems.add(particles);
            ++ParticleSystemsCount;
            return ParticleSystems.size() - 1;
        }
        int n = ParticleSystemsLast;
        if (n < ParticleSystems.size()) {
            if (ParticleSystems.get(n) == null) {
                ParticleSystemsLast = n;
                ParticleSystems.set(n, particles);
                ++ParticleSystemsCount;
            }
            return n;
        }
        n = 0;
        if (n < ParticleSystemsLast) {
            if (ParticleSystems.get(n) == null) {
                ParticleSystemsLast = n;
                ParticleSystems.set(n, particles);
                ++ParticleSystemsCount;
            }
            return n;
        }
        DebugLog.log("ERROR: addParticle has unknown error");
        return -1;
    }

    public static synchronized void deleteParticle(int n) {
        ParticleSystems.set(n, null);
        --ParticleSystemsCount;
    }

    public static void init() {
        if (funcs != null) {
            return;
        }
        if (!GL.getCapabilities().OpenGL33) {
            System.out.println("OpenGL 3.3 don't supported");
        }
        if (GL.getCapabilities().OpenGL15) {
            System.out.println("OpenGL 1.5 buffer objects supported");
            funcs = new GLBufferObject15();
        } else if (GL.getCapabilities().GL_ARB_vertex_buffer_object) {
            System.out.println("GL_ARB_vertex_buffer_object supported");
            funcs = new GLBufferObjectARB();
        } else {
            throw new RuntimeException("Neither OpenGL 1.5 nor GL_ARB_vertex_buffer_object supported");
        }
    }

    public void initBuffers() {
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)48);
        byteBuffer.clear();
        byteBuffer.putFloat(-1.0f);
        byteBuffer.putFloat(-1.0f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(1.0f);
        byteBuffer.putFloat(-1.0f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(-1.0f);
        byteBuffer.putFloat(1.0f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(1.0f);
        byteBuffer.putFloat(1.0f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.flip();
        this.particle_vertex_buffer = funcs.glGenBuffers();
        funcs.glBindBuffer(34962, this.particle_vertex_buffer);
        funcs.glBufferData(34962, byteBuffer, 35044);
        MemoryUtil.memFree((Buffer)byteBuffer);
        this.createParticleBuffers();
    }

    public void destroy() {
        Particles.deleteParticle(this.id);
        funcs.glDeleteBuffers(this.particle_vertex_buffer);
        this.destroyParticleBuffers();
    }

    public abstract void reloadShader();

    public Particles() {
        RenderThread.invokeOnRenderContext(() -> {
            Particles.init();
            this.initBuffers();
            this.projectionMatrix = new Matrix4f();
        });
        this.reloadShader();
        this.id = Particles.addParticle(this);
    }

    private static Matrix4f orthogonal(float f, float f2, float f3, float f4, float f5, float f6) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        matrix4f.m00 = 2.0f / (f2 - f);
        matrix4f.m11 = 2.0f / (f4 - f3);
        matrix4f.m22 = -2.0f / (f6 - f5);
        matrix4f.m32 = (-f6 - f5) / (f6 - f5);
        matrix4f.m30 = (-f2 - f) / (f2 - f);
        matrix4f.m31 = (-f4 - f3) / (f4 - f3);
        return matrix4f;
    }

    public void render() {
        int n = IsoCamera.frameState.playerIndex;
        this.ParticlesTime += 0.0166f * GameTime.getInstance().getMultiplier();
        this.updateMVPMatrix();
        SpriteRenderer.instance.drawParticles(n, 0, 0);
    }

    private void updateMVPMatrix() {
        this.mvpMatrix = this.projectionMatrix = Particles.orthogonal(IsoCamera.frameState.OffX, IsoCamera.frameState.OffX + (float)IsoCamera.frameState.OffscreenWidth, IsoCamera.frameState.OffY + (float)IsoCamera.frameState.OffscreenHeight, IsoCamera.frameState.OffY, -1.0f, 1.0f);
    }

    public FloatBuffer getMVPMatrix() {
        this.floatBuffer.clear();
        this.floatBuffer.put(this.mvpMatrix.m00);
        this.floatBuffer.put(this.mvpMatrix.m10);
        this.floatBuffer.put(this.mvpMatrix.m20);
        this.floatBuffer.put(this.mvpMatrix.m30);
        this.floatBuffer.put(this.mvpMatrix.m01);
        this.floatBuffer.put(this.mvpMatrix.m11);
        this.floatBuffer.put(this.mvpMatrix.m21);
        this.floatBuffer.put(this.mvpMatrix.m31);
        this.floatBuffer.put(this.mvpMatrix.m02);
        this.floatBuffer.put(this.mvpMatrix.m12);
        this.floatBuffer.put(this.mvpMatrix.m22);
        this.floatBuffer.put(this.mvpMatrix.m32);
        this.floatBuffer.put(this.mvpMatrix.m03);
        this.floatBuffer.put(this.mvpMatrix.m13);
        this.floatBuffer.put(this.mvpMatrix.m23);
        this.floatBuffer.put(this.mvpMatrix.m33);
        this.floatBuffer.flip();
        return this.floatBuffer;
    }

    public void getGeometry(int n) {
        this.updateParticleParams();
        GL20.glEnableVertexAttribArray((int)0);
        funcs.glBindBuffer(34962, this.particle_vertex_buffer);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL33.glVertexAttribDivisor((int)0, (int)0);
        GL31.glDrawArraysInstanced((int)5, (int)0, (int)4, (int)this.getParticleCount());
    }

    public void getGeometryFire(int n) {
        this.updateParticleParams();
        GL20.glEnableVertexAttribArray((int)0);
        funcs.glBindBuffer(34962, this.particle_vertex_buffer);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL33.glVertexAttribDivisor((int)0, (int)0);
        GL31.glDrawArraysInstanced((int)5, (int)0, (int)4, (int)this.getParticleCount());
    }

    public float getShaderTime() {
        return this.ParticlesTime;
    }

    abstract void createParticleBuffers();

    abstract void destroyParticleBuffers();

    abstract void updateParticleParams();

    abstract int getParticleCount();
}

