/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.characters.IsoGameCharacter;
import zombie.characters.skills.PerkFactory;
import zombie.core.Translator;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.DrainableComboItem;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoThumpable;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;

public final class MultiStageBuilding {
    public static final ArrayList<Stage> stages = new ArrayList();

    public static ArrayList<Stage> getStages(IsoGameCharacter isoGameCharacter, IsoObject isoObject, boolean bl) {
        ArrayList<Stage> arrayList = new ArrayList<Stage>();
        for (int i = 0; i < stages.size(); ++i) {
            Stage stage = stages.get(i);
            if (!stage.canBeDone(isoGameCharacter, isoObject, bl) || arrayList.contains(stage)) continue;
            arrayList.add(stage);
        }
        return arrayList;
    }

    public static void addStage(Stage stage) {
        for (int i = 0; i < stages.size(); ++i) {
            if (!MultiStageBuilding.stages.get((int)i).ID.equals(stage.ID)) continue;
            return;
        }
        stages.add(stage);
    }

    public class Stage {
        public String name;
        public ArrayList<String> previousStage = new ArrayList();
        public String recipeName;
        public String sprite;
        public String northSprite;
        public int timeNeeded;
        public int bonusHealth;
        public boolean bonusHealthSkill = true;
        public HashMap<String, Integer> xp = new HashMap();
        public HashMap<String, Integer> perks = new HashMap();
        public HashMap<String, Integer> items = new HashMap();
        public ArrayList<String> itemsToKeep = new ArrayList();
        public String knownRecipe;
        public String thumpSound = "ZombieThumpGeneric";
        public String wallType;
        public boolean canBePlastered;
        public String craftingSound;
        public String completionSound = "BuildWoodenStructureMedium";
        public String ID;
        public boolean canBarricade = false;

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return Translator.getMultiStageBuild(this.recipeName);
        }

        public String getSprite() {
            return this.sprite;
        }

        public String getNorthSprite() {
            return this.northSprite;
        }

        public String getThumpSound() {
            return this.thumpSound;
        }

        public String getRecipeName() {
            return this.recipeName;
        }

        public String getKnownRecipe() {
            return this.knownRecipe;
        }

        public int getTimeNeeded(IsoGameCharacter isoGameCharacter) {
            int n = this.timeNeeded;
            for (Map.Entry<String, Integer> entry : this.xp.entrySet()) {
                n -= isoGameCharacter.getPerkLevel(PerkFactory.Perks.FromString(entry.getKey())) * 10;
            }
            return n;
        }

        public ArrayList<String> getItemsToKeep() {
            return this.itemsToKeep;
        }

        public ArrayList<String> getPreviousStages() {
            return this.previousStage;
        }

        public String getCraftingSound() {
            return this.craftingSound;
        }

        public KahluaTable getItemsLua() {
            KahluaTable kahluaTable = LuaManager.platform.newTable();
            for (Map.Entry<String, Integer> entry : this.items.entrySet()) {
                kahluaTable.rawset((Object)entry.getKey(), (Object)entry.getValue().toString());
            }
            return kahluaTable;
        }

        public KahluaTable getPerksLua() {
            KahluaTable kahluaTable = LuaManager.platform.newTable();
            for (Map.Entry<String, Integer> entry : this.perks.entrySet()) {
                kahluaTable.rawset((Object)PerkFactory.Perks.FromString(entry.getKey()), (Object)entry.getValue().toString());
            }
            return kahluaTable;
        }

        public void doStage(IsoGameCharacter isoGameCharacter, IsoThumpable isoThumpable, boolean bl) {
            int n = isoThumpable.getHealth();
            int n2 = isoThumpable.getMaxHealth();
            String string = this.sprite;
            if (isoThumpable.north) {
                string = this.northSprite;
            }
            IsoThumpable isoThumpable2 = new IsoThumpable(IsoWorld.instance.getCell(), isoThumpable.square, string, isoThumpable.north, isoThumpable.getTable());
            isoThumpable2.setCanBePlastered(this.canBePlastered);
            if ("doorframe".equals(this.wallType)) {
                isoThumpable2.setIsDoorFrame(true);
                isoThumpable2.setCanPassThrough(true);
                isoThumpable2.setIsThumpable(isoThumpable.isThumpable());
            }
            int n3 = this.bonusHealth;
            switch (SandboxOptions.instance.ConstructionBonusPoints.getValue()) {
                case 1: {
                    n3 = (int)((double)n3 * 0.5);
                    break;
                }
                case 2: {
                    n3 = (int)((double)n3 * 0.7);
                    break;
                }
                case 4: {
                    n3 = (int)((double)n3 * 1.3);
                    break;
                }
                case 5: {
                    n3 = (int)((double)n3 * 1.5);
                }
            }
            Iterator<String> iterator = this.perks.keySet().iterator();
            int n4 = 20;
            switch (SandboxOptions.instance.ConstructionBonusPoints.getValue()) {
                case 1: {
                    n4 = 5;
                    break;
                }
                case 2: {
                    n4 = 10;
                    break;
                }
                case 4: {
                    n4 = 35;
                    break;
                }
                case 5: {
                    n4 = 60;
                }
            }
            int n5 = 0;
            if (this.bonusHealthSkill) {
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    n5 += isoGameCharacter.getPerkLevel(PerkFactory.Perks.FromString(string2)) * n4;
                }
            }
            isoThumpable2.setMaxHealth(n2 + n3 + n5);
            isoThumpable2.setHealth(n + n3 + n5);
            isoThumpable2.setName(this.name);
            isoThumpable2.setThumpSound(this.getThumpSound());
            isoThumpable2.setCanBarricade(this.canBarricade);
            isoThumpable2.setModData(isoThumpable.getModData());
            if (this.wallType != null) {
                isoThumpable2.getModData().rawset((Object)"wallType", (Object)this.wallType);
            }
            if (bl) {
                ItemContainer itemContainer = isoGameCharacter.getInventory();
                for (String string2 : this.items.keySet()) {
                    int n6 = this.items.get(string2);
                    Item item = ScriptManager.instance.getItem(string2);
                    if (item == null) continue;
                    if (item.getType() == Item.Type.Drainable) {
                        InventoryItem inventoryItem2 = itemContainer.getFirstRecurse(inventoryItem -> inventoryItem.getFullType().equals(item.getFullName()) && ((DrainableComboItem)inventoryItem).getDrainableUsesInt() >= n6);
                        if (inventoryItem2 == null) continue;
                        for (int i = 0; i < n6; ++i) {
                            inventoryItem2.Use();
                        }
                        continue;
                    }
                    for (int i = 0; i < n6; ++i) {
                        InventoryItem inventoryItem3 = itemContainer.getFirstTypeRecurse(string2);
                        if (inventoryItem3 == null) continue;
                        inventoryItem3.Use();
                    }
                }
            }
            for (String string3 : this.xp.keySet()) {
                isoGameCharacter.getXp().AddXP(PerkFactory.Perks.FromString(string3), (float)this.xp.get(string3).intValue());
            }
            int n7 = isoThumpable.getSquare().transmitRemoveItemFromSquare(isoThumpable);
            isoThumpable2.getSquare().AddSpecialObject(isoThumpable2, n7);
            isoThumpable2.getSquare().RecalcAllWithNeighbours(true);
            isoThumpable2.transmitCompleteItemToServer();
            if (isoGameCharacter != null && !StringUtils.isNullOrWhitespace(this.completionSound)) {
                isoGameCharacter.playSound(this.completionSound);
            }
        }

        public boolean canBeDone(IsoGameCharacter isoGameCharacter, IsoObject isoObject, boolean bl) {
            ItemContainer itemContainer = isoGameCharacter.getInventory();
            boolean bl2 = false;
            for (int i = 0; i < this.previousStage.size(); ++i) {
                if (!this.previousStage.get(i).equalsIgnoreCase(isoObject.getName())) continue;
                bl2 = true;
                break;
            }
            return bl2;
        }

        public void Load(String string, String[] stringArray) {
            this.recipeName = string;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                int n;
                String[] stringArray3;
                if (stringArray[i].trim().isEmpty() || !stringArray[i].contains(":")) continue;
                String[] stringArray4 = stringArray[i].split(":");
                String string2 = stringArray4[0].trim();
                String string3 = stringArray4[1].trim();
                if (string2.equalsIgnoreCase("Name")) {
                    this.name = string3.trim();
                }
                if (string2.equalsIgnoreCase("TimeNeeded")) {
                    this.timeNeeded = Integer.parseInt(string3.trim());
                }
                if (string2.equalsIgnoreCase("BonusHealth")) {
                    this.bonusHealth = Integer.parseInt(string3.trim());
                }
                if (string2.equalsIgnoreCase("Sprite")) {
                    this.sprite = string3.trim();
                }
                if (string2.equalsIgnoreCase("NorthSprite")) {
                    this.northSprite = string3.trim();
                }
                if (string2.equalsIgnoreCase("KnownRecipe")) {
                    this.knownRecipe = string3.trim();
                }
                if (string2.equalsIgnoreCase("ThumpSound")) {
                    this.thumpSound = string3.trim();
                }
                if (string2.equalsIgnoreCase("WallType")) {
                    this.wallType = string3.trim();
                }
                if (string2.equalsIgnoreCase("CraftingSound")) {
                    this.craftingSound = string3.trim();
                }
                if (string2.equalsIgnoreCase("CompletionSound")) {
                    this.completionSound = string3.trim();
                }
                if (string2.equalsIgnoreCase("ID")) {
                    this.ID = string3.trim();
                }
                if (string2.equalsIgnoreCase("CanBePlastered")) {
                    this.canBePlastered = Boolean.parseBoolean(string3.trim());
                }
                if (string2.equalsIgnoreCase("BonusSkill")) {
                    this.bonusHealthSkill = Boolean.parseBoolean(string3.trim());
                }
                if (string2.equalsIgnoreCase("CanBarricade")) {
                    this.canBarricade = Boolean.parseBoolean(string3.trim());
                }
                if (string2.equalsIgnoreCase("XP")) {
                    stringArray3 = string3.split(";");
                    for (n = 0; n < stringArray3.length; ++n) {
                        stringArray2 = stringArray3[n].split("=");
                        this.xp.put(stringArray2[0], Integer.parseInt(stringArray2[1]));
                    }
                }
                if (string2.equalsIgnoreCase("PreviousStage")) {
                    stringArray3 = string3.split(";");
                    for (n = 0; n < stringArray3.length; ++n) {
                        this.previousStage.add(stringArray3[n]);
                    }
                }
                if (string2.equalsIgnoreCase("SkillRequired")) {
                    stringArray3 = string3.split(";");
                    for (n = 0; n < stringArray3.length; ++n) {
                        stringArray2 = stringArray3[n].split("=");
                        this.perks.put(stringArray2[0], Integer.parseInt(stringArray2[1]));
                    }
                }
                if (string2.equalsIgnoreCase("ItemsRequired")) {
                    stringArray3 = string3.split(";");
                    for (n = 0; n < stringArray3.length; ++n) {
                        stringArray2 = stringArray3[n].split("=");
                        this.items.put(stringArray2[0], Integer.parseInt(stringArray2[1]));
                    }
                }
                if (!string2.equalsIgnoreCase("ItemsToKeep")) continue;
                stringArray3 = string3.split(";");
                for (n = 0; n < stringArray3.length; ++n) {
                    this.itemsToKeep.add(stringArray3[n]);
                }
            }
        }
    }
}

