/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import zombie.iso.BuildingDef;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.areas.IsoRoom;

public final class LotHeader {
    public int cellX;
    public int cellY;
    public int width = 0;
    public int height = 0;
    public int levels = 0;
    public int version = 0;
    public final HashMap<Integer, RoomDef> Rooms = new HashMap();
    public final TLongObjectHashMap<RoomDef> RoomByMetaID = new TLongObjectHashMap();
    public final ArrayList<RoomDef> RoomList = new ArrayList();
    public final ArrayList<BuildingDef> Buildings = new ArrayList();
    public final TLongObjectHashMap<BuildingDef> BuildingByMetaID = new TLongObjectHashMap();
    public final HashMap<Integer, IsoRoom> isoRooms = new HashMap();
    public final HashMap<Integer, IsoBuilding> isoBuildings = new HashMap();
    public boolean bFixed2x;
    protected final ArrayList<String> tilesUsed = new ArrayList();

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLevels() {
        return this.levels;
    }

    public IsoRoom getRoom(int n) {
        RoomDef roomDef = this.Rooms.get(n);
        if (!this.isoRooms.containsKey(n)) {
            IsoRoom isoRoom = new IsoRoom();
            isoRoom.rects.addAll(roomDef.rects);
            isoRoom.RoomDef = roomDef.name;
            isoRoom.def = roomDef;
            isoRoom.layer = roomDef.level;
            IsoWorld.instance.CurrentCell.getRoomList().add(isoRoom);
            if (roomDef.building == null) {
                roomDef.building = new BuildingDef();
                roomDef.building.ID = this.Buildings.size();
                roomDef.building.rooms.add(roomDef);
                roomDef.building.CalculateBounds(new ArrayList<RoomDef>());
                roomDef.building.metaID = roomDef.building.calculateMetaID(this.cellX, this.cellY);
                this.Buildings.add(roomDef.building);
            }
            int n2 = roomDef.building.ID;
            this.isoRooms.put(n, isoRoom);
            if (!this.isoBuildings.containsKey(n2)) {
                isoRoom.building = new IsoBuilding();
                isoRoom.building.def = roomDef.building;
                this.isoBuildings.put(n2, isoRoom.building);
                isoRoom.building.CreateFrom(roomDef.building, this);
            } else {
                isoRoom.building = this.isoBuildings.get(n2);
            }
            return isoRoom;
        }
        IsoRoom isoRoom = this.isoRooms.get(n);
        return isoRoom;
    }

    @Deprecated
    public int getRoomAt(int n, int n2, int n3) {
        for (Map.Entry<Integer, RoomDef> entry : this.Rooms.entrySet()) {
            RoomDef roomDef = entry.getValue();
            for (int i = 0; i < roomDef.rects.size(); ++i) {
                RoomDef.RoomRect roomRect = roomDef.rects.get(i);
                if (roomRect.x > n || roomRect.y > n2 || roomDef.level != n3 || roomRect.getX2() <= n || roomRect.getY2() <= n2) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    public void Dispose() {
        this.Rooms.clear();
        this.RoomByMetaID.clear();
        this.RoomList.clear();
        this.Buildings.clear();
        this.BuildingByMetaID.clear();
        this.isoRooms.clear();
        this.isoBuildings.clear();
        this.tilesUsed.clear();
    }
}

