/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import org.joml.Vector2f;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWaterFlow;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.popman.ObjectPool;
import zombie.util.list.PZArrayList;

public final class IsoWaterGeometry {
    private static final Vector2f tempVector2f = new Vector2f();
    boolean hasWater = false;
    boolean bShore = false;
    final float[] x = new float[4];
    final float[] y = new float[4];
    final float[] depth = new float[4];
    final float[] flow = new float[4];
    final float[] speed = new float[4];
    float IsExternal = 0.0f;
    IsoGridSquare square = null;
    int m_adjacentChunkLoadedCounter;
    public static final ObjectPool<IsoWaterGeometry> pool = new ObjectPool<IsoWaterGeometry>(IsoWaterGeometry::new);

    public IsoWaterGeometry init(IsoGridSquare isoGridSquare) throws Exception {
        String string;
        this.x[0] = IsoUtils.XToScreen(isoGridSquare.x, isoGridSquare.y, 0.0f, 0);
        this.y[0] = IsoUtils.YToScreen(isoGridSquare.x, isoGridSquare.y, 0.0f, 0);
        this.x[1] = IsoUtils.XToScreen(isoGridSquare.x, isoGridSquare.y + 1, 0.0f, 0);
        this.y[1] = IsoUtils.YToScreen(isoGridSquare.x, isoGridSquare.y + 1, 0.0f, 0);
        this.x[2] = IsoUtils.XToScreen(isoGridSquare.x + 1, isoGridSquare.y + 1, 0.0f, 0);
        this.y[2] = IsoUtils.YToScreen(isoGridSquare.x + 1, isoGridSquare.y + 1, 0.0f, 0);
        this.x[3] = IsoUtils.XToScreen(isoGridSquare.x + 1, isoGridSquare.y, 0.0f, 0);
        this.y[3] = IsoUtils.YToScreen(isoGridSquare.x + 1, isoGridSquare.y, 0.0f, 0);
        this.hasWater = false;
        this.bShore = false;
        this.square = isoGridSquare;
        this.IsExternal = isoGridSquare.getProperties().Is(IsoFlagType.exterior) ? 1.0f : 0.0f;
        int n = IsoWaterFlow.getShore(isoGridSquare.x, isoGridSquare.y);
        IsoObject isoObject = isoGridSquare.getFloor();
        String string2 = string = isoObject == null ? null : isoObject.getSprite().getName();
        if (isoGridSquare.getProperties().Is(IsoFlagType.water)) {
            this.hasWater = true;
            for (int i = 0; i < 4; ++i) {
                this.depth[i] = 1.0f;
            }
        } else if (n == 1 && string != null && string.startsWith("blends_natural")) {
            for (int i = 0; i < 4; ++i) {
                this.depth[i] = 0.0f;
            }
            IsoGridSquare isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.W);
            IsoGridSquare isoGridSquare3 = isoGridSquare.getAdjacentSquare(IsoDirections.NW);
            IsoGridSquare isoGridSquare4 = isoGridSquare.getAdjacentSquare(IsoDirections.N);
            IsoGridSquare isoGridSquare5 = isoGridSquare.getAdjacentSquare(IsoDirections.SW);
            IsoGridSquare isoGridSquare6 = isoGridSquare.getAdjacentSquare(IsoDirections.S);
            IsoGridSquare isoGridSquare7 = isoGridSquare.getAdjacentSquare(IsoDirections.SE);
            IsoGridSquare isoGridSquare8 = isoGridSquare.getAdjacentSquare(IsoDirections.E);
            IsoGridSquare isoGridSquare9 = isoGridSquare.getAdjacentSquare(IsoDirections.NE);
            if (isoGridSquare4 == null || isoGridSquare3 == null || isoGridSquare2 == null || isoGridSquare5 == null || isoGridSquare6 == null || isoGridSquare7 == null || isoGridSquare8 == null || isoGridSquare9 == null) {
                return null;
            }
            if (isoGridSquare2.getProperties().Is(IsoFlagType.water) || isoGridSquare3.getProperties().Is(IsoFlagType.water) || isoGridSquare4.getProperties().Is(IsoFlagType.water)) {
                this.bShore = true;
                this.depth[0] = 1.0f;
            }
            if (isoGridSquare2.getProperties().Is(IsoFlagType.water) || isoGridSquare5.getProperties().Is(IsoFlagType.water) || isoGridSquare6.getProperties().Is(IsoFlagType.water)) {
                this.bShore = true;
                this.depth[1] = 1.0f;
            }
            if (isoGridSquare6.getProperties().Is(IsoFlagType.water) || isoGridSquare7.getProperties().Is(IsoFlagType.water) || isoGridSquare8.getProperties().Is(IsoFlagType.water)) {
                this.bShore = true;
                this.depth[2] = 1.0f;
            }
            if (isoGridSquare8.getProperties().Is(IsoFlagType.water) || isoGridSquare9.getProperties().Is(IsoFlagType.water) || isoGridSquare4.getProperties().Is(IsoFlagType.water)) {
                this.bShore = true;
                this.depth[3] = 1.0f;
            }
        }
        Vector2f vector2f = IsoWaterFlow.getFlow(isoGridSquare, 0, 0, tempVector2f);
        this.flow[0] = vector2f.x;
        this.speed[0] = vector2f.y;
        vector2f = IsoWaterFlow.getFlow(isoGridSquare, 0, 1, vector2f);
        this.flow[1] = vector2f.x;
        this.speed[1] = vector2f.y;
        vector2f = IsoWaterFlow.getFlow(isoGridSquare, 1, 1, vector2f);
        this.flow[2] = vector2f.x;
        this.speed[2] = vector2f.y;
        vector2f = IsoWaterFlow.getFlow(isoGridSquare, 1, 0, vector2f);
        this.flow[3] = vector2f.x;
        this.speed[3] = vector2f.y;
        this.hideWaterObjects(isoGridSquare);
        return this;
    }

    private void hideWaterObjects(IsoGridSquare isoGridSquare) {
        PZArrayList<IsoObject> pZArrayList = isoGridSquare.getObjects();
        for (int i = 0; i < pZArrayList.size(); ++i) {
            String string;
            IsoObject isoObject = pZArrayList.get(i);
            if (isoObject.sprite == null || isoObject.sprite.name == null || !(string = isoObject.sprite.name).startsWith("blends_natural_02") || !string.endsWith("_0") && !string.endsWith("_1") && !string.endsWith("_2") && !string.endsWith("_3") && !string.endsWith("_4") && !string.endsWith("_5") && !string.endsWith("_6") && !string.endsWith("_7") && !string.endsWith("_8") && !string.endsWith("_9") && !string.endsWith("_10") && !string.endsWith("_11") && !string.endsWith("_12")) continue;
            isoObject.sprite.setHideForWaterRender();
        }
    }

    public boolean isShore() {
        return IsoWaterFlow.getShore(this.square.x, this.square.y) == 0;
    }

    public float getFlow() {
        IsoWaterFlow.getShore(this.square.x, this.square.y);
        Vector2f vector2f = IsoWaterFlow.getFlow(this.square, 0, 0, tempVector2f);
        System.out.println("FLOW!  " + vector2f.x + " " + vector2f.y);
        return vector2f.x;
    }
}

