/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.core.Core;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoCamera;
import zombie.iso.IsoDirections;
import zombie.iso.IsoUtils;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;

public final class IsoWallBloodSplat {
    private static final ColorInfo info = new ColorInfo();
    public float worldAge;
    public IsoSprite sprite;

    public IsoWallBloodSplat() {
    }

    public IsoWallBloodSplat(float f, IsoSprite isoSprite) {
        this.worldAge = f;
        this.sprite = isoSprite;
    }

    public void render(float f, float f2, float f3, ColorInfo colorInfo) {
        if (this.sprite == null) {
            return;
        }
        if (this.sprite.CurrentAnim == null || this.sprite.CurrentAnim.Frames.isEmpty()) {
            return;
        }
        int n = Core.TileScale;
        int n2 = 32 * n;
        int n3 = 96 * n;
        if (IsoSprite.globalOffsetX == -1.0f) {
            IsoSprite.globalOffsetX = -IsoCamera.frameState.OffX;
            IsoSprite.globalOffsetY = -IsoCamera.frameState.OffY;
        }
        float f4 = IsoUtils.XToScreen(f, f2, f3, 0);
        float f5 = IsoUtils.YToScreen(f, f2, f3, 0);
        f4 -= (float)n2;
        f5 -= (float)n3;
        f5 += IsoSprite.globalOffsetY;
        if ((f4 += IsoSprite.globalOffsetX) >= (float)IsoCamera.frameState.OffscreenWidth || f4 + (float)(64 * n) <= 0.0f) {
            return;
        }
        if (f5 >= (float)IsoCamera.frameState.OffscreenHeight || f5 + (float)(128 * n) <= 0.0f) {
            return;
        }
        IsoWallBloodSplat.info.r = 0.7f * colorInfo.r;
        IsoWallBloodSplat.info.g = 0.9f * colorInfo.g;
        IsoWallBloodSplat.info.b = 0.9f * colorInfo.b;
        IsoWallBloodSplat.info.a = 0.4f;
        float f6 = (float)GameTime.getInstance().getWorldAgeHours();
        float f7 = f6 - this.worldAge;
        if (f7 >= 0.0f && f7 < 72.0f) {
            float f8 = 1.0f - f7 / 72.0f;
            IsoWallBloodSplat.info.r *= 0.2f + f8 * 0.8f;
            IsoWallBloodSplat.info.g *= 0.2f + f8 * 0.8f;
            IsoWallBloodSplat.info.b *= 0.2f + f8 * 0.8f;
            IsoWallBloodSplat.info.a *= 0.25f + f8 * 0.75f;
        } else {
            IsoWallBloodSplat.info.r *= 0.2f;
            IsoWallBloodSplat.info.g *= 0.2f;
            IsoWallBloodSplat.info.b *= 0.2f;
            IsoWallBloodSplat.info.a *= 0.25f;
        }
        IsoWallBloodSplat.info.a = Math.max(IsoWallBloodSplat.info.a, 0.15f);
        this.sprite.CurrentAnim.Frames.get(0).render(f4, f5, IsoDirections.N, info, false, null);
    }

    public void save(ByteBuffer byteBuffer) {
        byteBuffer.putFloat(this.worldAge);
        byteBuffer.putInt(this.sprite.ID);
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.worldAge = byteBuffer.getFloat();
        int n2 = byteBuffer.getInt();
        this.sprite = IsoSprite.getSprite(IsoSpriteManager.instance, n2);
    }
}

