/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import org.joml.Vector2f;
import org.joml.Vector2fc;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.iso.IsoCamera;

public final class IsoUtils {
    public static float clamp(float f, float f2, float f3) {
        return Math.min(Math.max(f, f2), f3);
    }

    public static float lerp(float f, float f2, float f3) {
        return f3 == f2 ? f2 : (IsoUtils.clamp(f, f2, f3) - f2) / (f3 - f2);
    }

    public static float smoothstep(float f, float f2, float f3) {
        float f4 = IsoUtils.clamp((f3 - f) / (f2 - f), 0.0f, 1.0f);
        return f4 * f4 * (3.0f - 2.0f * f4);
    }

    public static float DistanceTo(float f, float f2, float f3, float f4) {
        return (float)Math.sqrt(Math.pow(f3 - f, 2.0) + Math.pow(f4 - f2, 2.0));
    }

    public static float DistanceTo2D(float f, float f2, float f3, float f4) {
        return (float)Math.sqrt(Math.pow(f3 - f, 2.0) + Math.pow(f4 - f2, 2.0));
    }

    public static float DistanceTo(float f, float f2, float f3, float f4, float f5, float f6) {
        return (float)Math.sqrt(Math.pow(f4 - f, 2.0) + Math.pow(f5 - f2, 2.0) + Math.pow(f6 - f3, 2.0));
    }

    public static float DistanceToSquared(float f, float f2, float f3, float f4, float f5, float f6) {
        return (float)(Math.pow(f4 - f, 2.0) + Math.pow(f5 - f2, 2.0) + Math.pow(f6 - f3, 2.0));
    }

    public static float DistanceToSquared(float f, float f2, float f3, float f4) {
        return (float)(Math.pow(f3 - f, 2.0) + Math.pow(f4 - f2, 2.0));
    }

    public static float DistanceManhatten(float f, float f2, float f3, float f4) {
        return Math.abs(f3 - f) + Math.abs(f4 - f2);
    }

    public static float DistanceManhatten(float f, float f2, float f3, float f4, float f5, float f6) {
        return Math.abs(f3 - f) + Math.abs(f4 - f2) + Math.abs(f6 - f5) * 2.0f;
    }

    public static float DistanceManhattenSquare(float f, float f2, float f3, float f4) {
        return Math.max(Math.abs(f3 - f), Math.abs(f4 - f2));
    }

    public static float XToIso(float f, float f2, float f3) {
        float f4 = f + IsoCamera.getOffX();
        float f5 = f2 + IsoCamera.getOffY();
        float f6 = (f4 + 2.0f * f5) / (64.0f * (float)Core.TileScale);
        float f7 = (f4 - 2.0f * f5) / (-64.0f * (float)Core.TileScale);
        f7 += 3.0f * f3;
        return f6 += 3.0f * f3;
    }

    public static float XToIsoTrue(float f, float f2, int n) {
        float f3 = f + (float)((int)IsoCamera.cameras[IsoPlayer.getPlayerIndex()].OffX);
        float f4 = f2 + (float)((int)IsoCamera.cameras[IsoPlayer.getPlayerIndex()].OffY);
        float f5 = (f3 + 2.0f * f4) / (64.0f * (float)Core.TileScale);
        float f6 = (f3 - 2.0f * f4) / (-64.0f * (float)Core.TileScale);
        f6 += (float)(3 * n);
        return f5 += (float)(3 * n);
    }

    public static float XToScreen(float f, float f2, float f3, int n) {
        float f4 = 0.0f;
        f4 += f * (float)(32 * Core.TileScale);
        return f4 -= f2 * (float)(32 * Core.TileScale);
    }

    public static float XToScreenInt(int n, int n2, int n3, int n4) {
        return IsoUtils.XToScreen(n, n2, n3, n4);
    }

    public static float YToScreenExact(float f, float f2, float f3, int n) {
        float f4 = IsoUtils.YToScreen(f, f2, f3, n);
        return f4 -= IsoCamera.getOffY();
    }

    public static float XToScreenExact(float f, float f2, float f3, int n) {
        float f4 = IsoUtils.XToScreen(f, f2, f3, n);
        return f4 -= IsoCamera.getOffX();
    }

    public static float YToIso(float f, float f2, float f3) {
        float f4 = f + IsoCamera.getOffX();
        float f5 = f2 + IsoCamera.getOffY();
        float f6 = (f4 + 2.0f * f5) / (64.0f * (float)Core.TileScale);
        float f7 = (f4 - 2.0f * f5) / (-64.0f * (float)Core.TileScale);
        f6 += 3.0f * f3;
        return f7 += 3.0f * f3;
    }

    public static float YToScreen(float f, float f2, float f3, int n) {
        float f4 = 0.0f;
        f4 += f2 * (float)(16 * Core.TileScale);
        f4 += f * (float)(16 * Core.TileScale);
        return f4 += ((float)n - f3) * (float)(96 * Core.TileScale);
    }

    public static float YToScreenInt(int n, int n2, int n3, int n4) {
        return IsoUtils.YToScreen(n, n2, n3, n4);
    }

    public static boolean isSimilarDirection(IsoGameCharacter isoGameCharacter, float f, float f2, float f3, float f4, float f5) {
        Vector2f vector2f = new Vector2f(f - isoGameCharacter.x, f2 - isoGameCharacter.y);
        vector2f.normalize();
        Vector2f vector2f2 = new Vector2f(isoGameCharacter.x - f3, isoGameCharacter.y - f4);
        vector2f2.normalize();
        vector2f.add((Vector2fc)vector2f2);
        return vector2f.length() < f5;
    }
}

