/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import zombie.characters.IsoPlayer;
import zombie.core.opengl.RenderSettings;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.areas.IsoRoom;

public final class IsoRoomLight {
    public static int NextID = 1;
    private static int SHINE_DIST = 5;
    public int ID;
    public IsoRoom room;
    public int x;
    public int y;
    public int z;
    public int width;
    public int height;
    public float r;
    public float g;
    public float b;
    public boolean bActive;
    public boolean bActiveJNI;
    public boolean bHydroPowered = true;

    public IsoRoomLight(IsoRoom isoRoom, int n, int n2, int n3, int n4, int n5) {
        this.room = isoRoom;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.width = n4;
        this.height = n5;
        this.r = 0.9f;
        this.b = 0.8f;
        this.b = 0.7f;
        this.bActive = isoRoom.def.bLightsActive;
    }

    public void addInfluence() {
        this.r = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.8f * IsoGridSquare.rmod * 0.7f;
        this.g = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.8f * IsoGridSquare.gmod * 0.7f;
        this.b = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.8f * IsoGridSquare.bmod * 0.7f;
        this.r *= 2.0f;
        this.g *= 2.0f;
        this.b *= 2.0f;
        this.shineIn(this.x - 1, this.y, this.x, this.y + this.height, SHINE_DIST, 0);
        this.shineIn(this.x, this.y - 1, this.x + this.width, this.y, 0, SHINE_DIST);
        this.shineIn(this.x + this.width, this.y, this.x + this.width + 1, this.y + this.height, -SHINE_DIST, 0);
        this.shineIn(this.x, this.y + this.height, this.x + this.width, this.y + this.height + 1, 0, -SHINE_DIST);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y, this.z);
        this.bActive = this.room.def.bLightsActive;
        if (!(!this.bHydroPowered || IsoWorld.instance.isHydroPowerOn() || isoGridSquare != null && isoGridSquare.haveElectricity())) {
            this.bActive = false;
            return;
        }
        if (!this.bActive) {
            return;
        }
        this.r = 0.9f;
        this.g = 0.8f;
        this.b = 0.7f;
        for (int i = this.y; i < this.y + this.height; ++i) {
            for (int j = this.x; j < this.x + this.width; ++j) {
                isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(j, i, this.z);
                if (isoGridSquare == null) continue;
                isoGridSquare.setLampostTotalR(isoGridSquare.getLampostTotalR() + this.r);
                isoGridSquare.setLampostTotalG(isoGridSquare.getLampostTotalG() + this.g);
                isoGridSquare.setLampostTotalB(isoGridSquare.getLampostTotalB() + this.b);
            }
        }
        this.shineOut(this.x, this.y, this.x + 1, this.y + this.height, -SHINE_DIST, 0);
        this.shineOut(this.x, this.y, this.x + this.width, this.y + 1, 0, -SHINE_DIST);
        this.shineOut(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, SHINE_DIST, 0);
        this.shineOut(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, 0, SHINE_DIST);
    }

    private void shineOut(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                this.shineOut(j, i, n5, n6);
            }
        }
    }

    private void shineOut(int n, int n2, int n3, int n4) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (n3 <= 0) break block4;
                        for (int i = 1; i <= n3; ++i) {
                            this.shineFromTo(n, n2, n + i, n2);
                        }
                        break block5;
                    }
                    if (n3 >= 0) break block6;
                    for (int i = 1; i <= -n3; ++i) {
                        this.shineFromTo(n, n2, n - i, n2);
                    }
                    break block5;
                }
                if (n4 <= 0) break block7;
                for (int i = 1; i <= n4; ++i) {
                    this.shineFromTo(n, n2, n, n2 + i);
                }
                break block5;
            }
            if (n4 >= 0) break block5;
            for (int i = 1; i <= -n4; ++i) {
                this.shineFromTo(n, n2, n, n2 - i);
            }
        }
    }

    private void shineFromTo(int n, int n2, int n3, int n4) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n3, n4, this.z);
        if (isoGridSquare == null) {
            return;
        }
        if (isoGridSquare.getRoom() == this.room) {
            return;
        }
        LosUtil.TestResults testResults = LosUtil.lineClear(IsoWorld.instance.CurrentCell, n, n2, this.z, n3, n4, this.z, false);
        if (testResults == LosUtil.TestResults.Blocked) {
            return;
        }
        float f = Math.abs(n - n3) + Math.abs(n2 - n4);
        float f2 = f / (float)SHINE_DIST;
        f2 = 1.0f - f2;
        f2 *= f2;
        float f3 = f2 * this.r * 2.0f;
        float f4 = f2 * this.g * 2.0f;
        float f5 = f2 * this.b * 2.0f;
        isoGridSquare.setLampostTotalR(isoGridSquare.getLampostTotalR() + f3);
        isoGridSquare.setLampostTotalG(isoGridSquare.getLampostTotalG() + f4);
        isoGridSquare.setLampostTotalB(isoGridSquare.getLampostTotalB() + f5);
    }

    private void shineIn(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                this.shineIn(j, i, n5, n6);
            }
        }
    }

    private void shineIn(int n, int n2, int n3, int n4) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, this.z);
                        if (isoGridSquare == null || !isoGridSquare.Is(IsoFlagType.exterior)) {
                            return;
                        }
                        if (n3 <= 0) break block5;
                        for (int i = 1; i <= n3; ++i) {
                            this.shineFromToIn(n, n2, n + i, n2);
                        }
                        break block6;
                    }
                    if (n3 >= 0) break block7;
                    for (int i = 1; i <= -n3; ++i) {
                        this.shineFromToIn(n, n2, n - i, n2);
                    }
                    break block6;
                }
                if (n4 <= 0) break block8;
                for (int i = 1; i <= n4; ++i) {
                    this.shineFromToIn(n, n2, n, n2 + i);
                }
                break block6;
            }
            if (n4 >= 0) break block6;
            for (int i = 1; i <= -n4; ++i) {
                this.shineFromToIn(n, n2, n, n2 - i);
            }
        }
    }

    private void shineFromToIn(int n, int n2, int n3, int n4) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n3, n4, this.z);
        if (isoGridSquare == null) {
            return;
        }
        LosUtil.TestResults testResults = LosUtil.lineClear(IsoWorld.instance.CurrentCell, n, n2, this.z, n3, n4, this.z, false);
        if (testResults == LosUtil.TestResults.Blocked) {
            return;
        }
        float f = Math.abs(n - n3) + Math.abs(n2 - n4);
        float f2 = f / (float)SHINE_DIST;
        f2 = 1.0f - f2;
        f2 *= f2;
        float f3 = f2 * this.r * 2.0f;
        float f4 = f2 * this.g * 2.0f;
        float f5 = f2 * this.b * 2.0f;
        isoGridSquare.setLampostTotalR(isoGridSquare.getLampostTotalR() + f3);
        isoGridSquare.setLampostTotalG(isoGridSquare.getLampostTotalG() + f4);
        isoGridSquare.setLampostTotalB(isoGridSquare.getLampostTotalB() + f5);
    }

    public void clearInfluence() {
        for (int i = this.y - SHINE_DIST; i < this.y + this.height + SHINE_DIST; ++i) {
            for (int j = this.x - SHINE_DIST; j < this.x + this.width + SHINE_DIST; ++j) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(j, i, this.z);
                if (isoGridSquare == null) continue;
                isoGridSquare.setLampostTotalR(0.0f);
                isoGridSquare.setLampostTotalG(0.0f);
                isoGridSquare.setLampostTotalB(0.0f);
            }
        }
    }

    public boolean isInBounds() {
        IsoChunkMap[] isoChunkMapArray = IsoWorld.instance.CurrentCell.ChunkMap;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            if (isoChunkMapArray[i].ignore) continue;
            int n = isoChunkMapArray[i].getWorldXMinTiles();
            int n2 = isoChunkMapArray[i].getWorldXMaxTiles();
            int n3 = isoChunkMapArray[i].getWorldYMinTiles();
            int n4 = isoChunkMapArray[i].getWorldYMaxTiles();
            if (this.x - SHINE_DIST >= n2 || this.x + this.width + SHINE_DIST <= n || this.y - SHINE_DIST >= n4 || this.y + this.height + SHINE_DIST <= n3) continue;
            return true;
        }
        return false;
    }
}

